### R code from vignette source 'DiffBind.Rnw'

###################################################
### code chunk number 1: DiffBind.Rnw:95-100
###################################################
tmp =  tempfile(as.character(Sys.getpid()))
pdf(tmp)
savewarn = options("warn")
options(warn=-1)
savewd = getwd()


###################################################
### code chunk number 2: DiffBind.Rnw:103-105
###################################################
library(DiffBind)
setwd(system.file("extra", package="DiffBind"))


###################################################
### code chunk number 3: DiffBind.Rnw:110-115 (eval = FALSE)
###################################################
## tamoxifen = dba(sampleSheet="tamoxifen.csv")
## tamoxifen = dba.count(tamoxifen)
## tamoxifen = dba.contrast(tamoxifen, categories=DBA_CONDITION)
## tamoxifen = dba.analyze(tamoxifen)
## tamoxifen.DB = dba.report(tamoxifen)


###################################################
### code chunk number 4: DiffBind.Rnw:147-148
###################################################
tamoxifen = dba(sampleSheet="tamoxifen.csv")


###################################################
### code chunk number 5: DiffBind.Rnw:153-154
###################################################
tamoxifen


###################################################
### code chunk number 6: DiffBind.Rnw:175-176 (eval = FALSE)
###################################################
## plot(tamoxifen)


###################################################
### code chunk number 7: DiffBind.Rnw:192-193 (eval = FALSE)
###################################################
## tamoxifen = dba.count(tamoxifen, minOverlap=3) 


###################################################
### code chunk number 8: DiffBind.Rnw:196-197
###################################################
data(tamoxifen_counts)


###################################################
### code chunk number 9: DiffBind.Rnw:206-207
###################################################
tamoxifen = dba.contrast(tamoxifen, categories=DBA_CONDITION)


###################################################
### code chunk number 10: DiffBind.Rnw:227-228
###################################################
tamoxifen = dba.analyze(tamoxifen) 


###################################################
### code chunk number 11: DiffBind.Rnw:234-235
###################################################
tamoxifen    


###################################################
### code chunk number 12: DiffBind.Rnw:263-264
###################################################
tamoxifen.DB = dba.report(tamoxifen)


###################################################
### code chunk number 13: DiffBind.Rnw:269-270
###################################################
tamoxifen.DB


###################################################
### code chunk number 14: DiffBind.Rnw:307-308
###################################################
dba.plotMA(tamoxifen)


###################################################
### code chunk number 15: DiffBind.Rnw:327-328
###################################################
dba.plotPCA(tamoxifen)


###################################################
### code chunk number 16: DiffBind.Rnw:347-348
###################################################
dba.plotPCA(tamoxifen, contrast=1,th=.1)


###################################################
### code chunk number 17: DiffBind.Rnw:363-365
###################################################
sum(values(tamoxifen.DB)$Fold<0)
sum(values(tamoxifen.DB)$Fold>0)


###################################################
### code chunk number 18: DiffBind.Rnw:370-371
###################################################
pvals = dba.plotBox(tamoxifen)


###################################################
### code chunk number 19: DiffBind.Rnw:385-386
###################################################
pvals


###################################################
### code chunk number 20: DiffBind.Rnw:402-403
###################################################
corvals = dba.plotHeatmap(tamoxifen)


###################################################
### code chunk number 21: DiffBind.Rnw:410-411
###################################################
corvals = dba.plotHeatmap(tamoxifen, contrast=1, correlations=FALSE)


###################################################
### code chunk number 22: DiffBind.Rnw:432-435
###################################################
data(tamoxifen_counts)
tamoxifen = dba.contrast(tamoxifen,categories=DBA_CONDITION,
                         block=tamoxifen$masks$MCF7)


###################################################
### code chunk number 23: DiffBind.Rnw:440-442
###################################################
tamoxifen = dba.analyze(tamoxifen)
tamoxifen


###################################################
### code chunk number 24: DiffBind.Rnw:447-448
###################################################
dba.plotMA(tamoxifen,method=DBA_EDGER_BLOCK)


###################################################
### code chunk number 25: DiffBind.Rnw:463-465
###################################################
dba.plotHeatmap(tamoxifen,contrast=1,method=DBA_EDGER_BLOCK,
                attributes=c(DBA_TISSUE,DBA_CONDITION,DBA_REPLICATE))


###################################################
### code chunk number 26: DiffBind.Rnw:468-470
###################################################
dba.plotPCA(tamoxifen,contrast=1,method=DBA_EDGER_BLOCK,
            attributes=c(DBA_TISSUE,DBA_CONDITION))


###################################################
### code chunk number 27: DiffBind.Rnw:490-492
###################################################
tamoxifen = dba.analyze(tamoxifen,method=DBA_DESEQ)
tamoxifen


###################################################
### code chunk number 28: DiffBind.Rnw:501-502
###################################################
data(tamoxifen_peaks)


###################################################
### code chunk number 29: DiffBind.Rnw:509-511
###################################################
olap.rate = dba.overlap(tamoxifen,mode=DBA_OLAP_RATE)
olap.rate


###################################################
### code chunk number 30: DiffBind.Rnw:519-520
###################################################
plot(olap.rate,type='b') 


###################################################
### code chunk number 31: DiffBind.Rnw:538-539
###################################################
names(tamoxifen$masks)


###################################################
### code chunk number 32: DiffBind.Rnw:548-550
###################################################
dba.overlap(tamoxifen,tamoxifen$masks$MCF7 & tamoxifen$masks$Responsive,
                       mode=DBA_OLAP_RATE)


###################################################
### code chunk number 33: DiffBind.Rnw:557-558
###################################################
dba.plotVenn(tamoxifen,tamoxifen$masks$MCF7 & tamoxifen$masks$Responsive)


###################################################
### code chunk number 34: DiffBind.Rnw:571-575
###################################################
tamoxifen = dba.peakset(tamoxifen,tamoxifen$masks$MCF7&tamoxifen$masks$Responsive,
                                             sampID="MCF7+")
tamoxifen = dba(tamoxifen,!(!tamoxifen$masks$Consensus&tamoxifen$masks$MCF7))
tamoxifen


###################################################
### code chunk number 35: DiffBind.Rnw:596-597
###################################################
data(tamoxifen_peaks)


###################################################
### code chunk number 36: DiffBind.Rnw:602-604
###################################################
dba.overlap(tamoxifen,tamoxifen$masks$Resistant,mode=DBA_OLAP_RATE)
dba.overlap(tamoxifen,tamoxifen$masks$Responsive,mode=DBA_OLAP_RATE)


###################################################
### code chunk number 37: DiffBind.Rnw:612-617
###################################################
tamoxifen = dba.peakset(tamoxifen,tamoxifen$masks$Resistant,
                        sampID="Resistant",minOverlap=2)
tamoxifen = dba.peakset(tamoxifen,tamoxifen$mask$Responsive, 
                        sampID="Responsive",minOverlap=3)
dba.plotVenn(tamoxifen,tamoxifen$masks$Consensus)


###################################################
### code chunk number 38: DiffBind.Rnw:629-630
###################################################
tamoxifen.OL = dba.overlap(tamoxifen, tamoxifen$masks$Consensus)


###################################################
### code chunk number 39: DiffBind.Rnw:635-637
###################################################
tamoxifen.OL$onlyA
tamoxifen.OL$onlyB


###################################################
### code chunk number 40: DiffBind.Rnw:695-700
###################################################
tamoxifen = dba.peakset(tamoxifen,tamoxifen$masks$Consensus, 
                        minOverlap=1,sampID="OL Consensus")
tamoxifen = dba.peakset(tamoxifen,!tamoxifen$masks$Consensus,
                        minOverlap=3,sampID="Consensus_3") 
dba.plotVenn(tamoxifen,14:15)


###################################################
### code chunk number 41: DiffBind.Rnw:715-716
###################################################
data(tamoxifen_analysis)


###################################################
### code chunk number 42: DiffBind.Rnw:721-722
###################################################
tamoxifen.rep = dba.report(tamoxifen,bCalled=T,th=1)


###################################################
### code chunk number 43: DiffBind.Rnw:727-735
###################################################
onlyResistant = values(tamoxifen.rep)$Called1>=2 & 
                             values(tamoxifen.rep)$Called2<3
sum(onlyResistant )
onlyResponsive = values(tamoxifen.rep)$Called2>=3 & 
                                  values(tamoxifen.rep)$Called1<2
sum(onlyResponsive)
bothGroups = values(tamoxifen.rep)$Called1>=2 & values(tamoxifen.rep)$Called2>=3
sum(bothGroups)


###################################################
### code chunk number 44: DiffBind.Rnw:746-753
###################################################
tamoxifen.DB = dba.report(tamoxifen,bCalled=T,th=.1)
onlyResistant = values(tamoxifen.DB)$Called1>=2 & values(tamoxifen.DB)$Called2<3
sum(onlyResistant)
onlyResponsive = values(tamoxifen.DB)$Called2>=3 & values(tamoxifen.DB)$Called1<2
sum(onlyResponsive)
bothGroups = values(tamoxifen.DB)$Called1>=2 & values(tamoxifen.DB)$Called2>=3
sum(bothGroups)


###################################################
### code chunk number 45: setup
###################################################
sessionInfo()


###################################################
### code chunk number 46: DiffBind.Rnw:843-846
###################################################
dev.off()
unlink(tmp)
setwd(savewd)


