### R code from vignette source 'DOSE.Rnw'

###################################################
### code chunk number 1: options
###################################################
options(width=60)
require(DOSE)


###################################################
### code chunk number 2: DOSE.Rnw:65-67
###################################################
library(DOSE)
help(DOSE)


###################################################
### code chunk number 3: DO Similarity
###################################################
data(DO2EG)
set.seed(123)
terms <- list(a=sample(names(DO2EG), 5),b= sample(names(DO2EG), 6))
terms
## Setting Parameters...
params <- new("DOParams", IDs=terms, type="DOID", method="Wang")
## Calculating Semantic Similarities...
sim(params)


###################################################
### code chunk number 4: DO Similarity 2
###################################################
params <- new("DOParams",
              IDs=terms,
              type="DOID",
              method="Wang",
              combine="rcmax.avg")
sim(params)


###################################################
### code chunk number 5: Gene Similarity
###################################################
geneid <- list(a=c("920", "100"),
               b= c("919", "4221", "3458"))
params <- new("DOParams",
              IDs=geneid,
              type="GeneID",
              method="Wang",
              combine="rcmax.avg")
sim(params)


###################################################
### code chunk number 6: enrichment analysis
###################################################
data(DO2ALLEG)
genes = DO2ALLEG[[1]]
genes
x <- enrichDO(genes, pvalueCutoff=0.05)
head(summary(x))
setReadable(x) <- TRUE


###################################################
### code chunk number 7: CNETPLOT
###################################################
plot(x,showCategory=5, categorySize="geneNum",output="fixed")


###################################################
### code chunk number 8: DOSE.Rnw:302-303
###################################################
sessionInfo()


