### R code from vignette source 'DECIPHERing.Rnw'

###################################################
### code chunk number 1: startup
###################################################
library(DECIPHER)


###################################################
### code chunk number 2: expr1
###################################################
# access a sequence file included in the package:
gen <- system.file("extdata", "Bacteria_175seqs.gen", package="DECIPHER")

# connect to a database:
dbConn <- dbConnect(SQLite(), ":memory:")

# import the sequences into the sequence database
Seqs2DB(gen, "GenBank", dbConn, "Bacteria")


###################################################
### code chunk number 3: expr2
###################################################
BrowseDB(dbConn)


###################################################
### code chunk number 4: expr3
###################################################
l <- IdLengths(dbConn)
head(l)
Add2DB(l, dbConn)
BrowseDB(dbConn, maxChars=20)


###################################################
### code chunk number 5: expr4
###################################################
r <- IdentifyByRank(dbConn, add2tbl=TRUE)
BrowseDB(dbConn, maxChars=20)


###################################################
### code chunk number 6: expr5
###################################################
dna <- SearchDB(dbConn, id="Firmicutes")
BrowseSequences(subseq(dna, 140, 240), colorBases=TRUE)


###################################################
### code chunk number 7: expr6
###################################################
d <- DistanceMatrix(dna, verbose=FALSE)
c <- IdClusters(d, method="complete", cutoff=.02, showPlot=TRUE, verbose=FALSE)


###################################################
### code chunk number 8: expr7
###################################################
dbDisconnect(dbConn)


###################################################
### code chunk number 9: sessinfo
###################################################
toLatex(sessionInfo(), locale=FALSE)


