### R code from vignette source 'ChemmineR.Rnw'

###################################################
### code chunk number 1: ChemmineR.Rnw:38-39
###################################################
options(width=80)


###################################################
### code chunk number 2: ChemmineR.Rnw:71-73 (eval = FALSE)
###################################################
## source("http://bioconductor.org/biocLite.R") # Sources the biocLite.R installation script.
## biocLite("ChemmineR") # Installs the package.


###################################################
### code chunk number 3: ChemmineR.Rnw:78-79
###################################################
library("ChemmineR") # Loads the package


###################################################
### code chunk number 4: ChemmineR.Rnw:81-83 (eval = FALSE)
###################################################
## library(help="ChemmineR") # Lists all functions and classes 
## vignette("ChemmineR") # Opens this PDF manual from R


###################################################
### code chunk number 5: ChemmineR.Rnw:90-95
###################################################
data(sdfsample)
sdfset <- sdfsample
sdfset # Returns summary of SDFset
sdfset[1:4] # Subsetting of object 
sdfset[[1]] # Returns summarized content of one SDF


###################################################
### code chunk number 6: ChemmineR.Rnw:96-98 (eval = FALSE)
###################################################
## view(sdfset[1:4]) # Returns summarized content of many SDFs, not printed here
## as(sdfset[1:4], "list") # Returns complete content of many SDFs, not printed here


###################################################
### code chunk number 7: ChemmineR.Rnw:102-104 (eval = FALSE)
###################################################
## sdfset <- read.SDFset("http://faculty.ucr.edu/~tgirke/Documents/
##                        R_BioCond/Samples/sdfsample.sdf")


###################################################
### code chunk number 8: ChemmineR.Rnw:108-109 (eval = FALSE)
###################################################
## header(sdfset[1:4]) # Not printed here


###################################################
### code chunk number 9: ChemmineR.Rnw:110-111
###################################################
header(sdfset[[1]])


###################################################
### code chunk number 10: ChemmineR.Rnw:112-113 (eval = FALSE)
###################################################
## atomblock(sdfset[1:4]) # Not printed here


###################################################
### code chunk number 11: ChemmineR.Rnw:114-115
###################################################
atomblock(sdfset[[1]])[1:4,]


###################################################
### code chunk number 12: ChemmineR.Rnw:116-117 (eval = FALSE)
###################################################
## bondblock(sdfset[1:4]) # Not printed here


###################################################
### code chunk number 13: ChemmineR.Rnw:118-119
###################################################
bondblock(sdfset[[1]])[1:4,] 


###################################################
### code chunk number 14: ChemmineR.Rnw:120-121 (eval = FALSE)
###################################################
## datablock(sdfset[1:4]) # Not printed here


###################################################
### code chunk number 15: ChemmineR.Rnw:122-123
###################################################
datablock(sdfset[[1]])[1:4]


###################################################
### code chunk number 16: ChemmineR.Rnw:127-131
###################################################
cid(sdfset)[1:4] # Returns IDs from SDFset object
sdfid(sdfset)[1:4] # Returns IDs from SD file header block
unique_ids <- makeUnique(sdfid(sdfset))
cid(sdfset) <- unique_ids


###################################################
### code chunk number 17: ChemmineR.Rnw:135-141
###################################################
blockmatrix <- datablock2ma(datablocklist=datablock(sdfset))
   # Converts data block to matrix   
numchar <- splitNumChar(blockmatrix=blockmatrix) 
   # Splits to numeric and character matrix
numchar[[1]][1:2,1:2] # Slice of numeric matrix
numchar[[2]][1:2,10:11] # Slice of character matrix


###################################################
### code chunk number 18: ChemmineR.Rnw:145-147
###################################################
propma <- data.frame(MF=MF(sdfset), MW=MW(sdfset), atomcountMA(sdfset))
propma[1:4, ]


###################################################
### code chunk number 19: ChemmineR.Rnw:151-153
###################################################
datablock(sdfset) <- propma
datablock(sdfset[1])


###################################################
### code chunk number 20: ChemmineR.Rnw:157-160 (eval = FALSE)
###################################################
## grepSDFset("650001", sdfset, field="datablock", mode="subset") 
##    # Returns summary view of matches. Not printed here.
## .


###################################################
### code chunk number 21: ChemmineR.Rnw:162-163
###################################################
grepSDFset("650001", sdfset, field="datablock", mode="index") 


###################################################
### code chunk number 22: ChemmineR.Rnw:167-168 (eval = FALSE)
###################################################
## write.SDF(sdfset[1:4], file="sub.sdf", sig=TRUE)


###################################################
### code chunk number 23: plotstruct
###################################################
plot(sdfset[1:4], print=FALSE) # Plots structures to R graphics device


###################################################
### code chunk number 24: ChemmineR.Rnw:176-177 (eval = FALSE)
###################################################
## sdf.visualize(sdfset[1:4]) # Compound viewing in web browser


###################################################
### code chunk number 25: ChemmineR.Rnw:187-190 (eval = FALSE)
###################################################
## apset <- sdf2ap(sdfset) 
##    # Generate atom pair descriptor database for searching
## .


###################################################
### code chunk number 26: ChemmineR.Rnw:192-198
###################################################
data(apset)
   # Load sample apset data provided by library.
cmp.search(apset, apset[1], type=3, cutoff = 0.3, quiet=TRUE) 
   # Search apset database with single compound.
cmp.cluster(db=apset, cutoff = c(0.65, 0.5), quiet=TRUE)[1:4,] 
   # Binning clustering using variable similarity cutoffs.


###################################################
### code chunk number 27: ChemmineR.Rnw:290-292 (eval = FALSE)
###################################################
## sdfset <- read.SDFset("http://faculty.ucr.edu/~tgirke/Documents/
##                        R_BioCond/Samples/sdfsample.sdf")


###################################################
### code chunk number 28: ChemmineR.Rnw:294-298
###################################################
data(sdfsample) # Loads the same SDFset provided by the library
sdfset <- sdfsample 
valid <- validSDF(sdfset) # Identifies invalid SDFs in SDFset objects
sdfset <- sdfset[valid] # Removes invalid SDFs, if there are any


###################################################
### code chunk number 29: ChemmineR.Rnw:302-304 (eval = FALSE)
###################################################
## sdfstr <- read.SDFstr("http://faculty.ucr.edu/~tgirke/Documents/
##                        R_BioCond/Samples/sdfsample.sdf")


###################################################
### code chunk number 30: ChemmineR.Rnw:307-310
###################################################
sdfstr <- as(sdfset, "SDFstr")
sdfstr
as(sdfstr, "SDFset") 


###################################################
### code chunk number 31: ChemmineR.Rnw:316-317 (eval = FALSE)
###################################################
## write.SDF(sdfset[1:4], file="sub.sdf")


###################################################
### code chunk number 32: ChemmineR.Rnw:321-322 (eval = FALSE)
###################################################
## write.SDF(sdfset[1:4], file="sub.sdf", sig=TRUE, cid=TRUE, db=NULL)


###################################################
### code chunk number 33: ChemmineR.Rnw:326-329 (eval = FALSE)
###################################################
## props <- data.frame(MF=MF(sdfset), MW=MW(sdfset), atomcountMA(sdfset))
## datablock(sdfset) <- props
## write.SDF(sdfset[1:4], file="sub.sdf", sig=TRUE, cid=TRUE)


###################################################
### code chunk number 34: ChemmineR.Rnw:333-337 (eval = FALSE)
###################################################
## sdf2str(sdf=sdfset[[1]], sig=TRUE, cid=TRUE) 
##    # Uses default components
## sdf2str(sdf=sdfset[[1]], head=letters[1:4], db=NULL) 
##    # Uses custom components for header and data block


###################################################
### code chunk number 35: ChemmineR.Rnw:341-344 (eval = FALSE)
###################################################
## write.SDF(sdfset[1:4], file="sub.sdf", sig=TRUE, cid=TRUE, db=NULL)
## write.SDF(sdfstr[1:4], file="sub.sdf")
## cat(unlist(as(sdfstr[1:4], "list")), file="sub.sdf", sep="\n")


###################################################
### code chunk number 36: ChemmineR.Rnw:351-357 (eval = FALSE)
###################################################
## view(sdfset[1:4]) # Summary view of several molecules
## length(sdfset) # Returns number of molecules
## sdfset[[1]] # Returns single molecule from SDFset as SDF object
## sdfset[[1]][[2]] # Returns atom block from first compound as matrix
## sdfset[[1]][[2]][1:4,] 
## c(sdfset[1:4], sdfset[5:8]) # Concatenation of several SDFsets


###################################################
### code chunk number 37: ChemmineR.Rnw:361-364 (eval = FALSE)
###################################################
## grepSDFset("650001", sdfset, field="datablock", mode="subset") 
##    # To return index, set mode="index")
## .


###################################################
### code chunk number 38: ChemmineR.Rnw:368-375 (eval = FALSE)
###################################################
## sdfid(sdfset[1:4])
##    # Retrieves CMP IDs from Molecule Name field in header block.
## cid(sdfset[1:4])
##    # Retrieves CMP IDs from ID slot in SDFset.
## unique_ids <- makeUnique(sdfid(sdfset)) 
##    # Creates unique IDs by appending a counter to duplicates.
## cid(sdfset) <- unique_ids # Assigns uniquified IDs to ID slot


###################################################
### code chunk number 39: ChemmineR.Rnw:379-383 (eval = FALSE)
###################################################
## view(sdfset[c("650001", "650012")])
## view(sdfset[4:1])
## mylog <- cid(sdfset) %in% c("650001", "650012")
## view(sdfset[mylog])


###################################################
### code chunk number 40: ChemmineR.Rnw:387-397 (eval = FALSE)
###################################################
## atomblock(sdf); sdf[[2]]; sdf[["atomblock"]] 
##    # All three methods return the same component
## header(sdfset[1:4])
## atomblock(sdfset[1:4])
## bondblock(sdfset[1:4])
## datablock(sdfset[1:4])
## header(sdfset[[1]])
## atomblock(sdfset[[1]])
## bondblock(sdfset[[1]])
## datablock(sdfset[[1]])


###################################################
### code chunk number 41: ChemmineR.Rnw:401-404 (eval = FALSE)
###################################################
## sdfset[[1]][[2]][1,1] <- 999
## atomblock(sdfset)[1] <- atomblock(sdfset)[2]
## datablock(sdfset)[1] <- datablock(sdfset)[2]


###################################################
### code chunk number 42: ChemmineR.Rnw:408-410 (eval = FALSE)
###################################################
## datablock(sdfset) <- as.matrix(iris[1:100,])
## view(sdfset[1:4])


###################################################
### code chunk number 43: ChemmineR.Rnw:414-417 (eval = FALSE)
###################################################
## as(sdfstr[1:2], "list") 
## as(sdfstr[[1]], "SDF")
## as(sdfstr[1:2], "SDFset")


###################################################
### code chunk number 44: ChemmineR.Rnw:421-426 (eval = FALSE)
###################################################
## sdfcomplist <- as(sdf, "list")
## sdfcomplist <- as(sdfset[1:4], "list"); as(sdfcomplist[[1]], "SDF")
## sdflist <- as(sdfset[1:4], "SDF"); as(sdflist, "SDFset")
## as(sdfset[[1]], "SDFstr")
## as(sdfset[[1]], "SDFset")


###################################################
### code chunk number 45: ChemmineR.Rnw:430-433 (eval = FALSE)
###################################################
## as(sdfset[1:4], "SDF")
## as(sdfset[1:4], "list")
## as(sdfset[1:4], "SDFstr")


###################################################
### code chunk number 46: boxplot
###################################################
propma <- atomcountMA(sdfset, addH=FALSE)
boxplot(propma, col="blue", main="Atom Frequency")


###################################################
### code chunk number 47: ChemmineR.Rnw:445-446 (eval = FALSE)
###################################################
## boxplot(rowSums(propma), main="All Atom Frequency")   


###################################################
### code chunk number 48: ChemmineR.Rnw:450-452
###################################################
data(atomprop)
atomprop[1:4,] 


###################################################
### code chunk number 49: ChemmineR.Rnw:456-458
###################################################
MW(sdfset[1:4], addH=FALSE)
MF(sdfset[1:4], addH=FALSE)


###################################################
### code chunk number 50: ChemmineR.Rnw:462-463
###################################################
groups(sdfset[1:4], groups="fctgroup", type="countMA")


###################################################
### code chunk number 51: ChemmineR.Rnw:467-473
###################################################
propma <- data.frame(MF=MF(sdfset, addH=FALSE), MW=MW(sdfset, addH=FALSE), 
                     Ncharges=sapply(bonds(sdfset, type="charge"), length), 
                     atomcountMA(sdfset, addH=FALSE), groups(sdfset, 
		     type="countMA"), rings(sdfset, upper=6, type="count", 
		     arom=TRUE))
propma[1:4,]


###################################################
### code chunk number 52: ChemmineR.Rnw:477-481 (eval = FALSE)
###################################################
## datablock(sdfset) <- propma # Works with all SDF components
## datablock(sdfset)[1:4]
## test <- apply(propma[1:4,], 1, function(x) data.frame(col=colnames(propma), value=x))
## sdf.visualize(sdfset[1:4], extra = test)


###################################################
### code chunk number 53: ChemmineR.Rnw:485-487 (eval = FALSE)
###################################################
## datablocktag(sdfset, tag="PUBCHEM_NIST_INCHI")
## datablocktag(sdfset, tag="PUBCHEM_OPENEYE_CAN_SMILES")


###################################################
### code chunk number 54: ChemmineR.Rnw:491-498 (eval = FALSE)
###################################################
## blockmatrix <- datablock2ma(datablocklist=datablock(sdfset)) 
##    # Converts data block to matrix 
## numchar <- splitNumChar(blockmatrix=blockmatrix) 
##    # Splits matrix to numeric matrix and character matrix
## numchar[[1]][1:4,]; numchar[[2]][1:4,] 
##    # Splits matrix to numeric matrix and character matrix
## .


###################################################
### code chunk number 55: contable (eval = FALSE)
###################################################
## conMA(sdfset[1:2], exclude=c("H"))
##    # Create bond matrix for first two molecules in sdfset
## conMA(sdfset[[1]], exclude=c("H"))
##    # Return bond matrix for first molecule
## plot(sdfset[1], atomnum = TRUE, noHbonds=FALSE , no_print_atoms = "", atomcex=0.8)
##    # Plot its structure with atom numbering
## rowSums(conMA(sdfset[[1]], exclude=c("H")))
##    # Return number of non-H bonds for each atom
## .


###################################################
### code chunk number 56: ChemmineR.Rnw:520-523
###################################################
bonds(sdfset[[1]], type="bonds")[1:4,]
bonds(sdfset[1:2], type="charge")
bonds(sdfset[1:2], type="addNH")


###################################################
### code chunk number 57: ChemmineR.Rnw:533-534
###################################################
rings(sdfset[1], upper=Inf, type="all", arom=FALSE, inner=FALSE)


###################################################
### code chunk number 58: ChemmineR.Rnw:537-538
###################################################
plot(sdfset[1], print=FALSE, atomnum=TRUE, no_print_atoms="H")


###################################################
### code chunk number 59: ChemmineR.Rnw:542-543
###################################################
rings(sdfset[1], upper=Inf, type="all", arom=TRUE, inner=FALSE)  


###################################################
### code chunk number 60: ChemmineR.Rnw:547-548
###################################################
rings(sdfset[1], upper=6, type="arom", arom=TRUE, inner=FALSE)


###################################################
### code chunk number 61: ChemmineR.Rnw:552-553
###################################################
rings(sdfset[1:4], upper=Inf, type="count", arom=TRUE, inner=TRUE) 


###################################################
### code chunk number 62: plotstruct2
###################################################
data(sdfsample); sdfset <- sdfsample
plot(sdfset[1:4], print=FALSE) # 'print=TRUE' returns SDF summaries


###################################################
### code chunk number 63: ChemmineR.Rnw:568-570 (eval = FALSE)
###################################################
## plot(sdfset[1:4], griddim=c(2,2), print_cid=letters[1:4], print=FALSE, 
##      noHbonds=FALSE)


###################################################
### code chunk number 64: plotstruct3
###################################################
plot(sdfset["CMP1"], atomnum = TRUE,  noHbonds=F , no_print_atoms = "", 
     atomcex=0.8, sub=paste("MW:", MW(sdfsample["CMP1"])), print=FALSE)


###################################################
### code chunk number 65: ChemmineR.Rnw:583-584 (eval = FALSE)
###################################################
## sdf.visualize(sdfset[1:4])


###################################################
### code chunk number 66: ChemmineR.Rnw:594-595 (eval = FALSE)
###################################################
## sdf.visualize(sdfset[1:4], extra=month.name[1:4])


###################################################
### code chunk number 67: ChemmineR.Rnw:599-602 (eval = FALSE)
###################################################
## extra <- apply(propma[1:4,], 1, function(x) 
##          data.frame(Property=colnames(propma), Value=x))
## sdf.visualize(sdfset[1:4], extra=extra)


###################################################
### code chunk number 68: ChemmineR.Rnw:606-607 (eval = FALSE)
###################################################
## sdf.visualize(sdfset[1:4], extra=bondblock(sdfset[1:4]))


###################################################
### code chunk number 69: ChemmineR.Rnw:617-619
###################################################
ap <- sdf2ap(sdfset[[1]]) # For single compound
ap


###################################################
### code chunk number 70: ChemmineR.Rnw:620-621 (eval = FALSE)
###################################################
## apset <- sdf2ap(sdfset) # For many compounds. 


###################################################
### code chunk number 71: ChemmineR.Rnw:622-623
###################################################
view(apset[1:4])


###################################################
### code chunk number 72: ChemmineR.Rnw:627-630 (eval = FALSE)
###################################################
## cid(apset[1:4]) # Compound IDs
## ap(apset[1:4]) # Atom pair descriptors
## db.explain(apset[1]) # Return atom pairs in human readable format


###################################################
### code chunk number 73: ChemmineR.Rnw:634-637 (eval = FALSE)
###################################################
## apset2descdb(apset) # Returns old list-style AP database
## tmp <- as(apset, "list") # Returns list
## as(tmp, "APset") # Converts list back to APset


###################################################
### code chunk number 74: ChemmineR.Rnw:644-648 (eval = FALSE)
###################################################
## save(sdfset, file = "sdfset.rda", compress = TRUE)
## load("sdfset.rda")
## save(apset, file = "apset.rda", compress = TRUE)
## load("apset.rda")


###################################################
### code chunk number 75: ChemmineR.Rnw:653-655
###################################################
cmp.similarity(apset[1], apset[2])
cmp.similarity(apset[1], apset[1])


###################################################
### code chunk number 76: ChemmineR.Rnw:662-665
###################################################
cid(sdfset) <- sdfid(sdfset)
fpset <- fp2bit(x=sdfset, type=1) 
fpset <- fp2bit(x=sdfset, type=2)


###################################################
### code chunk number 77: ChemmineR.Rnw:669-670
###################################################
fpSim(x=fpset[1,], y=fpset[2,])


###################################################
### code chunk number 78: ChemmineR.Rnw:675-676
###################################################
cmp.search(apset, apset["650065"], type=3, cutoff = 0.3, quiet=TRUE) 


###################################################
### code chunk number 79: ChemmineR.Rnw:679-681
###################################################
cmp.search(apset, apset["650065"], type=1, cutoff = 0.3, quiet=TRUE) 
cmp.search(apset, apset["650065"], type=2, cutoff = 0.3, quiet=TRUE) 


###################################################
### code chunk number 80: ChemmineR.Rnw:686-687
###################################################
fpSim(x=fpset["650065",], y=fpset)[1:6] # x is query and y is fingerprint database


###################################################
### code chunk number 81: search_result
###################################################
cid(sdfset) <- cid(apset) # Assure compound name consistency among objects.
plot(sdfset[names(cmp.search(apset, apset["650065"], type=2, cutoff=4, 
     quiet=TRUE))], print=FALSE)


###################################################
### code chunk number 82: ChemmineR.Rnw:701-703 (eval = FALSE)
###################################################
## similarities <- cmp.search(apset, apset[1], type=3, cutoff = 10)
## sdf.visualize(sdfset[similarities[,1]], extra=similarities[,3])


###################################################
### code chunk number 83: ChemmineR.Rnw:715-717
###################################################
cmp.duplicated(apset, type=1)[1:4] # Returns AP duplicates as logical vector
cmp.duplicated(apset, type=2)[1:4,] # Returns AP duplicates as data frame


###################################################
### code chunk number 84: duplicates
###################################################
plot(sdfset[c("650059","650060", "650065", "650066")], print=FALSE)


###################################################
### code chunk number 85: ChemmineR.Rnw:726-728
###################################################
apdups <- cmp.duplicated(apset, type=1)
sdfset[which(!apdups)]; apset[which(!apdups)]


###################################################
### code chunk number 86: ChemmineR.Rnw:737-741
###################################################
count <- table(datablocktag(sdfset, tag="PUBCHEM_NIST_INCHI"))
count <- table(datablocktag(sdfset, tag="PUBCHEM_OPENEYE_CAN_SMILES"))
count <- table(datablocktag(sdfset, tag="PUBCHEM_MOLECULAR_FORMULA"))
count[1:4]


###################################################
### code chunk number 87: ChemmineR.Rnw:771-773
###################################################
clusters <- cmp.cluster(db=apset, cutoff = c(0.65, 0.5, 0.4), quiet = TRUE)
clusters[1:4,]


###################################################
### code chunk number 88: ChemmineR.Rnw:777-780
###################################################
cluster.sizestat(clusters, cluster.result=1)
cluster.sizestat(clusters, cluster.result=2)
cluster.sizestat(clusters, cluster.result=3)


###################################################
### code chunk number 89: ChemmineR.Rnw:784-788 (eval = FALSE)
###################################################
## clusters <- cmp.cluster(db=apset, cutoff = c(0.65, 0.5, 0.3), 
##                         save.distances="distmat.rda") 
##    # Saves distance matrix to file "distmat.rda" in current working directory.
## load("distmat.rda") # Loads distance matrix.


###################################################
### code chunk number 90: ChemmineR.Rnw:800-803 (eval = FALSE)
###################################################
## cluster.visualize(apset, clusters, size.cutoff=2, quiet = TRUE) 
##    # Color codes clusters with at least two members.
## cluster.visualize(apset, clusters, quiet = TRUE) # Plots all items.


###################################################
### code chunk number 91: mds_scatter
###################################################
library(scatterplot3d)
coord <- cluster.visualize(apset, clusters, size.cutoff=1, dimensions=3, quiet=TRUE)
scatterplot3d(coord)


###################################################
### code chunk number 92: ChemmineR.Rnw:814-821 (eval = FALSE)
###################################################
## library(rgl)
## rgl.open(); offset <- 50; par3d(windowRect=c(offset, offset, 640+offset, 640+offset))
## rm(offset); rgl.clear(); rgl.viewpoint(theta=45, phi=30, fov=60, zoom=1)
## spheres3d(coord[,1], coord[,2], coord[,3], radius=0.03, color=coord[,4], alpha=1, 
## shininess=20); aspect3d(1, 1, 1)
## axes3d(col='black'); title3d("", "", "", "", "", col='black'); bg3d("white") 
##    # To save a snapshot of the graph, one can use the command rgl.snapshot("test.png").


###################################################
### code chunk number 93: mds_scatter
###################################################
dummy <- cmp.cluster(db=apset, cutoff=0, save.distances="distmat.rda", quiet=TRUE)
load("distmat.rda")


###################################################
### code chunk number 94: hclust
###################################################
hc <- hclust(as.dist(distmat), method="single")
hc[["labels"]] <- cid(apset) # Assign correct item labels
plot(as.dendrogram(hc), edgePar=list(col=4, lwd=2), horiz=T) 


###################################################
### code chunk number 95: fp_hclust (eval = FALSE)
###################################################
## simMA <- sapply(rownames(fpset), function(x) fpSim(x=fpset[x,], fpset)) 
## hc <- hclust(as.dist(simMA), method="single")  
## plot(as.dendrogram(hc), edgePar=list(col=4, lwd=2), horiz=TRUE)


###################################################
### code chunk number 96: heatmap
###################################################
library(gplots)
heatmap.2(1-distmat, Rowv=as.dendrogram(hc), Colv=as.dendrogram(hc), 
          col=colorpanel(40, "darkblue", "yellow", "white"), 
          density.info="none", trace="none")


###################################################
### code chunk number 97: getIds (eval = FALSE)
###################################################
## compounds <- getIds(c(111,123))
## compounds


###################################################
### code chunk number 98: getIds (eval = FALSE)
###################################################
## compounds <- searchString("CC(=O)OC1=CC=CC=C1C(=O)O")
## compounds


###################################################
### code chunk number 99: getIds (eval = FALSE)
###################################################
## data(sdfsample); sdfset <- sdfsample[1]
## compounds <- searchSim(sdfset)
## compounds


###################################################
### code chunk number 100: sdf2smiles (eval = FALSE)
###################################################
## data(sdfsample); sdfset <- sdfsample[1]
## smiles <- sdf2smiles(sdfset)
## smiles


###################################################
### code chunk number 101: smiles2sdf (eval = FALSE)
###################################################
## sdf <- smiles2sdf("CC(=O)OC1=CC=CC=C1C(=O)O\tname")
## view(sdf)


###################################################
### code chunk number 102: sessionInfo
###################################################
sessionInfo()


