### R code from vignette source 'CellNOptR-vignette.Rnw'

###################################################
### code chunk number 1: installRBGL (eval = FALSE)
###################################################
## source("http://bioconductor.org/biocLite.R")
## biocLite("RBGL")


###################################################
### code chunk number 2: installPackage (eval = FALSE)
###################################################
## install.packages("path_to_CellNOptR/CellNOptR_1.0.0.tar.gz",repos=NULL)


###################################################
### code chunk number 3: Rdummies (eval = FALSE)
###################################################
## a<-4+5


###################################################
### code chunk number 4: Ropts
###################################################
options(width=70)


###################################################
### code chunk number 5: loadLib
###################################################
library(CellNOptR)


###################################################
### code chunk number 6: newDir (eval = FALSE)
###################################################
## dir.create("CNOR_analysis")
## setwd("CNOR_analysis")


###################################################
### code chunk number 7: getData
###################################################
cpfile<-dir(system.file("ToyModel",package="CellNOptR"),full=TRUE)
file.copy(from=cpfile,to=getwd(),overwrite=TRUE)
dataToy<-readMIDAS(MIDASfile='ToyDataMMB.csv')
CNOlistToy<-makeCNOlist(dataset=dataToy,subfield=FALSE)


###################################################
### code chunk number 8: getData2
###################################################
data(CNOlistToy,package="CellNOptR")


###################################################
### code chunk number 9: showCNO
###################################################
CNOlistToy


###################################################
### code chunk number 10: plotCNO
###################################################
plotCNOlist(CNOlistToy)


###################################################
### code chunk number 11: ploCNOPDF
###################################################
plotCNOlistPDF(CNOlist=CNOlistToy,filename="ToyModelGraph.pdf")


###################################################
### code chunk number 12: getModel
###################################################
ToyModel<-readSif(sifFile="ToyPKNMMB.sif")


###################################################
### code chunk number 13: getModel2
###################################################
data(ToyModel,package="CellNOptR")


###################################################
### code chunk number 14: indices
###################################################
checkSignals(CNOlistToy,ToyModel)
indicesToy<-indexFinder(CNOlistToy,ToyModel,verbose=TRUE)


###################################################
### code chunk number 15: NONC
###################################################
ToyNCNOindices<-findNONC(ToyModel,indicesToy,verbose=TRUE)
ToyNCNOcut<-cutNONC(ToyModel,ToyNCNOindices)
indicesToyNCNOcut<-indexFinder(CNOlistToy,ToyNCNOcut)


###################################################
### code chunk number 16: compress
###################################################
ToyNCNOcutComp<-compressModel(ToyNCNOcut,indicesToyNCNOcut)
indicesToyNCNOcutComp<-indexFinder(CNOlistToy,ToyNCNOcutComp)


###################################################
### code chunk number 17: expand
###################################################
ToyNCNOcutCompExp<-expandGates(ToyNCNOcutComp, maxInputsPerGate=3)


###################################################
### code chunk number 18: expand
###################################################
results <- preprocessing(CNOlistToy, ToyModel, expansion=TRUE, compression=TRUE,
cutnonc=TRUE, verbose=FALSE)
ToyNCMOcutComp <- results$model
indicesToyNCNOcutComp <- results$indices


###################################################
### code chunk number 19: misc4Sim
###################################################
resECNOlistToy<-residualError(CNOlistToy)
ToyFields4Sim<-prep4Sim(ToyNCNOcutCompExp)
initBstring<-rep(1,length(ToyNCNOcutCompExp$reacID))


###################################################
### code chunk number 20: optim
###################################################
ToyT1opt<-gaBinaryT1(
	CNOlist=CNOlistToy,
	Model=ToyNCNOcutCompExp,
	SimList=ToyFields4Sim,
	indexList=indicesToyNCNOcutComp,
	initBstring=initBstring,
	verbose=FALSE)


###################################################
### code chunk number 21: resSim (eval = FALSE)
###################################################
## cutAndPlotResultsT1(
## 	Model=ToyNCNOcutCompExp,
## 	bString=ToyT1opt$bString,
## 	SimList=ToyFields4Sim,
## 	CNOlist=CNOlistToy,
## 	indexList=indicesToyNCNOcutComp,
## 	plotPDF=FALSE)


###################################################
### code chunk number 22: plotFit
###################################################
plotFit(OptRes=ToyT1opt)


###################################################
### code chunk number 23: simFitPDF
###################################################
cutAndPlotResultsT1(
	Model=ToyNCNOcutCompExp,
	bString=ToyT1opt$bString,
	SimList=ToyFields4Sim,
	CNOlist=CNOlistToy,
	indexList=indicesToyNCNOcutComp,
	plotPDF=TRUE)
pdf("evolFitToyT1.pdf")
plotFit(OptRes=ToyT1opt)
dev.off()


###################################################
### code chunk number 24: writeRes
###################################################
writeScaffold(
	ModelComprExpanded=ToyNCNOcutCompExp,
	optimResT1=ToyT1opt,
	optimResT2=NA,
	ModelOriginal=ToyModel,
	CNOlist=CNOlistToy)
	
writeNetwork(
	ModelOriginal=ToyModel,
	ModelComprExpanded=ToyNCNOcutCompExp,
	optimResT1=ToyT1opt,
	optimResT2=NA,
	CNOlist=CNOlistToy)
	
namesFilesToy<-list(
	dataPlot="ToyModelGraph.pdf",
	evolFit1="evolFitToyT1.pdf",
	evolFit2=NA,
	SimResults1="ToyNCNOcutCompExpSimResultsT1.pdf",
	SimResults2=NA,
	Scaffold="Scaffold.sif",
	ScaffoldDot="Scaffold.dot",
	tscaffold="TimesScaffold.EA",
	wscaffold="weightsScaffold.EA",
	PKN="PKN.sif",
	PKNdot="PKN.dot",
	wPKN="TimesPKN.EA",
	nPKN="nodesPKN.NA")
	
writeReport(
	ModelOriginal=ToyModel,
	ModelOpt=ToyNCNOcutCompExp,
	optimResT1=ToyT1opt,
	optimResT2=NA,
	CNOlist=CNOlistToy,
	directory="testToy",
	namesFiles=namesFilesToy,
	namesData=list(CNOlist="Toy",Model="ToyModel"),
	resE=resECNOlistToy)


###################################################
### code chunk number 25: eraseDir
###################################################
unlink("testToy",recursive=TRUE)


###################################################
### code chunk number 26: getToy
###################################################
dataToy<-readMIDAS(MIDASfile='ToyDataMMB.csv')
CNOlistToy<-makeCNOlist(dataset=dataToy,subfield=FALSE)
ToyModel<-readSif(sifFile="ToyPKNMMB.sif")


###################################################
### code chunk number 27: wrap1 (eval = FALSE)
###################################################
## CNORwrap(
## 	paramsList=NA,
## 	Name="Toy",
## 	NamesData=list(CNOlist="ToyData",Model="ToyModel"),
## 	Data=CNOlistToy,
## 	Model=ToyModel)


###################################################
### code chunk number 28: eraseToyDir
###################################################
unlink("Toy",recursive=TRUE)


###################################################
### code chunk number 29: wrap2
###################################################
pList<-list(	
	Data=CNOlistToy,
	Model=ToyModel,
	sizeFac = 1e-04, 
	NAFac = 1, 
	PopSize = 10, 
	Pmutation = 0.5, 
	MaxTime = 60, 
	maxGens = 5, 
	StallGenMax = 5, 
	SelPress = 1.2, 
	elitism = 5, 
	RelTol = 0.1,
	verbose=FALSE)
	
CNORwrap(
	paramsList=pList,
	Name="Toy",
	NamesData=list(CNOlist="ToyData",Model="ToyModel"),
	Data=NA,
	Model=NA)


###################################################
### code chunk number 30: eraseData
###################################################
unlink("ToyDataMMB.csv")
unlink("ToyPKNMMB.sif")
unlink("Toy",recursive=TRUE)
unlink("ToyModelMMB2.sif")


###################################################
### code chunk number 31: getDREAM (eval = FALSE)
###################################################
## #Option 1: copy the SIF and MIDAS files (followed by readMIDAS, makeCNOlist and readSif)
## cpfile<-dir(system.file("DREAMModel",package="CellNOptR"),full=TRUE)
## file.copy(from=cpfile,to=getwd(),overwrite=TRUE)
## #Option 2: load the CNOlist and model objects
## data(CNOlistDREAM,package="CellNOptR")
## data(DreamModel,package="CellNOptR")


###################################################
### code chunk number 32: t2load
###################################################
data(CNOlistToy2,package="CellNOptR")
data(ToyModel2,package="CellNOptR")


###################################################
### code chunk number 33: t2plotCNOlist (eval = FALSE)
###################################################
## plotCNOlist(CNOlistToy2)
## plotCNOlistPDF(CNOlist=CNOlistToy2,filename="ToyModelGraphT2.pdf")


###################################################
### code chunk number 34: t2Opt1
###################################################
checkSignals(CNOlistToy2,ToyModel2)
indicesToy2<-indexFinder(CNOlistToy2,ToyModel2,verbose=FALSE)
ToyNCNOindices2<-findNONC(ToyModel2,indicesToy2,verbose=FALSE)
ToyNCNOcut2<-cutNONC(ToyModel2,ToyNCNOindices2)
indicesToyNCNOcut2<-indexFinder(CNOlistToy2,ToyNCNOcut2)
ToyNCNOcutComp2<-compressModel(ToyNCNOcut2,indicesToyNCNOcut2)
indicesToyNCNOcutComp2<-indexFinder(CNOlistToy2,ToyNCNOcutComp2)
ToyNCNOcutCompExp2<-expandGates(ToyNCNOcutComp2)
resECNOlistToy2<-residualError(CNOlistToy2)
ToyFields4Sim2<-prep4Sim(ToyNCNOcutCompExp2)
initBstring2<-rep(1,length(ToyNCNOcutCompExp2$reacID))
ToyT1opt2<-gaBinaryT1(
	CNOlist=CNOlistToy2,
	Model=ToyNCNOcutCompExp2,
	SimList=ToyFields4Sim2,
	indexList=indicesToyNCNOcutComp2,
	initBstring=initBstring2,
	StallGenMax=10,
	MaxTime=60,
	verbose=FALSE)


###################################################
### code chunk number 35: t2OptT1plot (eval = FALSE)
###################################################
## cutAndPlotResultsT1(
## 	Model=ToyNCNOcutCompExp2,
## 	bString=ToyT1opt2$bString,
## 	SimList=ToyFields4Sim2,
## 	CNOlist=CNOlistToy2,
## 	indexList=indicesToyNCNOcutComp2,
## 	plotPDF=TRUE)
## pdf("evolFitToy2T1.pdf")
## plotFit(OptRes=ToyT1opt2)
## dev.off()
## plotFit(OptRes=ToyT1opt2)


###################################################
### code chunk number 36: t2OptT2
###################################################
SimToyT12<-simulateT1(
	CNOlist=CNOlistToy2,
	Model=ToyNCNOcutCompExp2,
	bStringT1=ToyT1opt2$bString,
	SimList=ToyFields4Sim2,
	indexList=indicesToyNCNOcutComp2)
	
ToyT1opt2T2<-gaBinaryT2(
	CNOlist=CNOlistToy2,
	Model=ToyNCNOcutCompExp2,
	SimList=ToyFields4Sim2,
	indexList=indicesToyNCNOcutComp2,
	bStringT1=ToyT1opt2$bString,
	SimResT1=SimToyT12,
	StallGenMax=10,
	MaxTime=60,
	verbose=FALSE)


###################################################
### code chunk number 37: resSimT2
###################################################
cutAndPlotResultsT2(
	Model=ToyNCNOcutCompExp2,
	bStringT1=ToyT1opt2$bString,
	bStringT2=ToyT1opt2T2$bString,
	SimList=ToyFields4Sim2,
	CNOlist=CNOlistToy2,
	indexList=indicesToyNCNOcutComp2,
	plotPDF=FALSE)


###################################################
### code chunk number 38: t2OptT2plot (eval = FALSE)
###################################################
## pdf("evolFitToy2T2.pdf")
## plotFit(OptRes=ToyT1opt2T2)
## dev.off()
## plotFit(OptRes=ToyT1opt2T2)
## writeScaffold(
## 	ModelComprExpanded=ToyNCNOcutCompExp2,
## 	optimResT1=ToyT1opt2,
## 	optimResT2=ToyT1opt2T2,
## 	ModelOriginal=ToyModel2,
## 	CNOlist=CNOlistToy2)
## writeNetwork(
## 	ModelOriginal=ToyModel2,
## 	ModelComprExpanded=ToyNCNOcutCompExp2,
## 	optimResT1=ToyT1opt2,
## 	optimResT2=ToyT1opt2T2,
## 	CNOlist=CNOlistToy2)
## namesFilesToy<-list(
## 	dataPlot="ToyModelGraphT2.pdf",
## 	evolFit1="evolFitToy2T1.pdf",
## 	evolFit2="evolFitToy2T2.pdf",
## 	SimResults2="ToyNCNOcutCompExp2SimResultsT1T2.pdf",
## 	SimResults1="ToyNCNOcutCompExp2SimResultsT1.pdf",
## 	Scaffold="Scaffold.sif",
## 	ScaffoldDot="Scaffold.dot",
## 	tscaffold="TimesScaffold.EA",
## 	wscaffold="weightsScaffold.EA",
## 	PKN="PKN.sif",
## 	PKNdot="PKN.dot",
## 	wPKN="TimesPKN.EA",
## 	nPKN="nodesPKN.NA")
## writeReport(
## 	ModelOriginal=ToyModel2,
## 	ModelOpt=ToyNCNOcutCompExp2,
## 	optimResT1=ToyT1opt2,
## 	optimResT2=ToyT1opt2T2,
## 	CNOlist=CNOlistToy2,
## 	directory="testToy2",
## 	namesFiles=namesFilesToy,
## 	namesData=list(CNOlist="ToyModified4T2",Model="ToyModified4T2"),
## 	resE=resECNOlistToy2)


