### Name: Mu22v3PMID2PROBE
### Title: Map between PubMed Identifiers and Manufacturer Identifiers
### Aliases: Mu22v3PMID2PROBE
### Keywords: datasets

### ** Examples

    # Convert the environment to a list
    xx <- as.list(Mu22v3PMID2PROBE)
    if(length(xx) > 0){
        # The probe identifiers for the first two elements of XX
        xx[1:2]
        # Get the first one
        xx[[1]]
        if(interactive() && require(annotate)){
            # Gets article information as XML files for a PubMed id
            xmls <- pubmed(names(xx)[1], disp = "data")
            # Views article information using a browser
            pubmed(names(xx)[1], disp = "browser")
        }
    }



