### Encoding: latin1

### Name: ppca
### Title: Probabilistic PCA Missing Value Estimator
### Aliases: ppca
### Keywords: multivariate

### ** Examples

## Load a sample metabolite dataset with 5% missing values (metaboliteData)
data(metaboliteData)

## Perform probabilistic PCA using the 3 largest components
result <- pca(metaboliteData, method="ppca", nPcs=3, center=TRUE)

## Get the estimated principal axes (loadings)
loadings <- result@loadings

## Get the estimated scores
scores <- result@scores

## Get the estimated complete observations
cObs <- result@completeObs

## Now plot the scores
plotPcs(result, type = "scores")




