### Name: relNet2TGF
### Title: Transform Relevance Network analysis in TGF output
### Aliases: relNet2TGF.maigesRelNetB relNet2TGF.maigesRelNetM relNet2TGF
### Keywords: classes

### ** Examples

## Loading the dataset
data(gastro)

## Constructing the relevance network for sample
## 'Tissue' comparing 'Neso' and 'Aeso' for the 1st gene group
## The same is also true for objects of class maigesRelNetB
gastro.net = relNetworkM(gastro.summ, sLabelID="Tissue", 
  samples = list(Neso="Neso", Aeso="Aeso"), geneGrp=11,
  type="Rpearson")

relNet2TGF(gastro.net)



