### Name: kmeansMde
### Title: Function to do k-means cluster analysis
### Aliases: kmeansMde
### Keywords: hplot

### ** Examples

## Loading the dataset
data(gastro)

## Doing bootstrap from t statistic test fot 'Type' sample label, k=1000
## specifies one thousand bootstraps
gastro.ttest = deGenes2by2Ttest(gastro.summ, sLabelID="Type")

## K-means cluster with 2 groups adjusting p-values by FDR, and showing all genes
## with p-value < 0.05
kmeansMde(gastro.ttest, sLabelID="Type", adjP="BH", nDEgenes=0.05, centers=2)

## K-means cluster with 3 groups adjusting p-values by FDR, and showing all genes
## with p-value < 0.05
kmeansMde(gastro.ttest, sLabelID="Type", adjP="BH", nDEgenes=0.05, centers=3)



