/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.gaggle.boss;

public class TileCalculator {
    int windowWidth;
    int windowHeight;
    int numberOfWindows;
    int cellWidth;
    int cellHeight;
    int rowCount;
    int columnCount;
    int TITLE_BAR_HEIGHT_ALLOWANCE = 20;
    int CELL_SIDE_GAP = 10;
    int CELL_TOP_GAP = 10;
    int X_EDGE_GAP = 5;
    int Y_EDGE_GAP = 5;
    int YGap = 10;
    int XGap = 10;

    public TileCalculator(int n, int n2, int n3) {
        this.calculateGrid(n3);
        this.windowWidth = n - (1 + this.columnCount) * this.XGap;
        this.windowHeight = n2 - (1 + this.rowCount) * this.YGap;
        this.calculateWindowSize();
    }

    public int[] getGeometry(int n) {
        int[] nArray = this.getRowAndColumn(n);
        int n2 = nArray[0];
        int n3 = nArray[1];
        int n4 = this.XGap + n3 * (this.cellWidth + this.XGap);
        int n5 = this.YGap + n2 * (this.cellHeight + this.YGap);
        int n6 = this.cellWidth - this.XGap;
        int n7 = this.cellHeight;
        int[] nArray2 = new int[]{n4, n5, n6, n7};
        return nArray2;
    }

    public int[] getRowAndColumn(int n) {
        int n2 = new Integer(n / this.columnCount);
        int n3 = n - n2 * this.columnCount;
        return new int[]{n2, n3};
    }

    public int getTitleBarHeight() {
        return this.TITLE_BAR_HEIGHT_ALLOWANCE;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public int getCellWidth() {
        return this.cellWidth;
    }

    public int getCellHeight() {
        return this.cellHeight;
    }

    protected void calculateGrid(int n) {
        int n2;
        int n3 = (int)Math.sqrt(n);
        int n4 = n3;
        if (n4 * (n2 = n3) < n) {
            ++n2;
        }
        if (n4 * n2 < n) {
            ++n4;
        }
        this.rowCount = n4;
        this.columnCount = n2;
    }

    protected void calculateWindowSize() {
        this.cellWidth = this.windowWidth / this.columnCount;
        this.cellHeight = this.windowHeight / this.rowCount;
    }
}

