/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.gaggle.boss;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.systemsbiology.gaggle.util.TextFileReader;
import org.systemsbiology.gaggle.util.TextJarReader;

public class BossConfig {
    String argSpecificationString = "p:n:";
    String[] commandLineArguments;
    String[] commandLineArgumentsCopy;
    String propsFilename;
    String nameHelperUri = null;
    File projectFileDirectoryAbsolute;
    Properties props;
    StringBuffer errorMessages = new StringBuffer();
    boolean helpRequested = false;

    public BossConfig() {
        this(new String[0]);
    }

    public BossConfig(String[] stringArray) {
        this.commandLineArguments = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.commandLineArguments, 0, stringArray.length);
        this.parseArgs();
        this.props = this.readProperties();
    }

    public Properties getProperties() {
        return this.props;
    }

    protected void parseArgs() {
        int n;
        this.helpRequested = false;
        boolean bl = false;
        if (this.commandLineArguments == null || this.commandLineArguments.length == 0) {
            return;
        }
        LongOpt[] longOptArray = new LongOpt[]{};
        Getopt getopt = new Getopt("GaggleBoss", this.commandLineArguments, this.argSpecificationString, longOptArray);
        getopt.setOpterr(false);
        block5: while ((n = getopt.getopt()) != -1) {
            switch (n) {
                case 112: {
                    this.propsFilename = getopt.getOptarg();
                    continue block5;
                }
                case 110: {
                    this.nameHelperUri = getopt.getOptarg();
                    continue block5;
                }
                case 63: {
                    int n2 = getopt.getOptopt();
                    if (n2 == 0) continue block5;
                    this.errorMessages.append("The option '" + (char)n2 + "' is not valid\n");
                    continue block5;
                }
            }
            bl = true;
        }
    }

    public String[] getPluginNames() {
        String[] stringArray = this.props.keySet().toArray(new String[0]);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!string.toLowerCase().startsWith("plugin")) continue;
            arrayList.add(this.props.get(string));
        }
        return arrayList.toArray(new String[0]);
    }

    public String getNameHelperUri() {
        return this.nameHelperUri;
    }

    public String getPropsFilename() {
        return this.propsFilename;
    }

    protected Properties readProperties() {
        if (this.propsFilename == null) {
            return new Properties();
        }
        System.out.println("BossConfig about to read from " + this.propsFilename);
        Properties properties = this.readPropertyFileAsText(this.propsFilename);
        System.out.println("props: " + properties);
        return properties;
    }

    public Properties readPropertyFileAsText(String string) {
        Object object;
        Object object2;
        String string2 = "";
        try {
            if (string.trim().startsWith("jar://")) {
                object2 = new TextJarReader(string);
                ((TextJarReader)object2).read();
                string2 = ((TextJarReader)object2).getText();
            } else {
                object2 = new File(this.absolutizeFilename(this.projectFileDirectoryAbsolute, string));
                object = new TextFileReader(((File)object2).getPath());
                ((TextFileReader)object).read();
                string2 = ((TextFileReader)object).getText();
            }
        }
        catch (Exception exception) {
            System.err.println("-- Exception while reading properties file " + string);
            exception.printStackTrace();
        }
        object2 = string2.getBytes();
        object = new ByteArrayInputStream((byte[])object2);
        Properties properties = new Properties();
        try {
            properties.load((InputStream)object);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return properties;
    }

    protected String absolutizeFilename(File file, String string) {
        if (string.trim().startsWith("/")) {
            return string;
        }
        return new File(file, string).getPath();
    }
}

