### Name: normalizePlates
### Title: Per-plate data transformation, normalization and variance
###   adjustment
### Aliases: normalizePlates plate effects
### Keywords: manip

### ** Examples

    data(KcViabSmall)
    # per-plate median scaling of intensities
    x1 <- normalizePlates(KcViabSmall, scale="multiplicative", log=FALSE, method="median", varianceAdjust="none")
    # per-plate median subtraction of log2 transformed intensities  
    x2 <- normalizePlates(KcViabSmall, scale="multiplicative", log=TRUE, method="median", varianceAdjust="none")
    ## Not run: 
##D     x3 <- normalizePlates(KcViabSmall, scale="multiplicative", log=TRUE, method="Bscore", varianceAdjust="none", save.model=TRUE)
##D     
## End(Not run)

    ## robust Z score method (plate intensities are subtracted by the per-plate median on sample wells and divided by the per-plate MAD on sample wells):
    xZ <- normalizePlates(KcViabSmall, scale="additive", log=FALSE, method="median", varianceAdjust="byPlate")

    ## an example to illustrate the use of slot 'batch':
   ## Not run: 
##D    try(xnorm <- normalizePlates(KcViabSmall, scale="multiplicative", method="median", varianceAdjust="byBatch"))
##D    
##D    # It doesn't work because we need to have slot 'batch'!
##D    # For example, we will suppose that a different lot of reagents was used for plate 1:
##D    pp <- plate(KcViabSmall)
##D    fData(KcViabSmall)$"reagent" <- "lot B"
##D    fData(KcViabSmall)$"reagent"[pp==1] <- "lot A"
##D    fvarMetadata(KcViabSmall)["reagent",] <- "Lot of reagent used"
##D 
##D    bb <- as.factor(fData(KcViabSmall)$"reagent")
##D    batch(KcViabSmall) <- array(as.integer(bb), dim=dim(Data(KcViabSmall)))
##D    ## check number of batches:
##D    nbatch(KcViabSmall)
##D    x1 <- normalizePlates(KcViabSmall, scale="multiplicative", log = FALSE, method="median", varianceAdjust="byBatch")
## End(Not run)



