### Name: deds.chooseTest
### Title: Selection of the Most Common Statistics for Differential
###   Expression
### Aliases: deds.chooseTest
### Keywords: univar

### ** Examples

X <- matrix(rnorm(1000,0,0.5), nc=10)
L <- rep(0:1,c(5,5))

# genes 1-10 are differentially expressed
X[1:10,6:10]<-X[1:10,6:10]+1

# as a default, chooses t, fc and sam
funcs <- deds.chooseTest(L)
deds.X <- deds.stat(X, L, testfun=funcs)

# chooses F statistic, SAM statistic, and moderated F statistic
L <- rep(0:2, c(3,3,4))
funcs <- deds.chooseTest(L, tests=c("f", "sam", "modf"))




