### Name: Bimap-toTable
### Title: Methods for extracting data from a Bimap object
### Aliases: Bimap-toTable toTable toTable,FlatBimap-method
###   toTable,AnnDbBimap-method head head,FlatBimap-method tail
###   tail,FlatBimap-method links links,FlatBimap-method
###   links,AnnDbBimap-method links,Go3AnnDbBimap-method nrow
###   nrow,FlatBimap-method nrow,AnnDbTable-method nrow,AnnDbBimap-method
###   nrow,Go3AnnDbBimap-method dim,Bimap-method count.links
###   count.links,Bimap-method count.links,Go3AnnDbBimap-method nhit
###   nhit,Bimap-method nhit,environment-method nhit,list-method
### Keywords: methods

### ** Examples

  library(GO.db)
  x <- GOSYNONYM
  x
  toTable(x)[1:4, ]
  toTable(x["GO:0007322"])
  links(x)[1:4, ]
  links(x["GO:0007322"])

  nrow(x)
  dim(x)
  count.links(x)

  y <- GOBPCHILDREN
  nhy <- nhit(y) # 'nhy' is a named integer vector
  identical(names(nhy), keys(y)) # TRUE
  table(nhy)
  sum(nhy == 0) # number of GO IDs with no children
  names(nhy)[nhy == max(nhy)] # the GO ID(s) with the most direct children

  ## Some sanity check
  sum(nhy) == count.links(y) # TRUE



