### Name: Bimap-colmethods
### Title: Methods for manipulating the col names of a Bimap object
### Aliases: Bimap-colmethods colnames colnames,FlatBimap-method
###   colnames,AnnDbBimap-method colmetanames colmetanames,FlatBimap-method
###   colmetanames,AnnDbBimap-method Lkeyname Lkeyname,Bimap-method
###   Lkeyname,AnnDbBimap-method Rkeyname Rkeyname,Bimap-method
###   Rkeyname,AnnDbBimap-method keyname keyname,Bimap-method tagname
###   tagname,Bimap-method tagname,AnnDbBimap-method Rattribnames
###   Rattribnames,Bimap-method Rattribnames,AnnDbBimap-method
###   Rattribnames<- Rattribnames<-,FlatBimap-method
###   Rattribnames<-,AnnDbBimap-method Rattribnames<-,Go3AnnDbBimap-method
###   ncol ncol,Bimap-method
### Keywords: methods

### ** Examples

  ## With the hgu95av2GO and hgu95av2GO2PROBE maps
  library(hgu95av2.db)
  x <- hgu95av2GO
  y <- hgu95av2GO2PROBE
  colnames(x)
  colnames(y)
  colmetanames(x)
  colmetanames(y)
  Lkeyname(x)
  Lkeyname(y)
  Rkeyname(x)
  Rkeyname(y)
  keyname(x)
  keyname(y)
  tagname(x)
  tagname(y)
  Rattribnames(x)
  Rattribnames(y)
  ncol(x)
  ncol(y)

  ## Changing the right attributes of the GOSYNONYM map
  library(GO.db)
  x <- GOSYNONYM
  class(x) # GOTermsAnnDbBimap
  as.list(x)[1:3]
  colnames(x)
  colmetanames(x)
  tagname(x) # untagged bimap
  Rattribnames(x)
  Rattribnames(x) <- Rattribnames(x)[3:1]
  colnames(x)
  class(x) # AnnDbBimap
  as.list(x)[1:3]



