### Name: removeSpots
### Title: Remove specified spots from objects
### Aliases: removeSpots
### Keywords: utilities

### ** Examples


  intensities <- array(data=runif(600),dim=c(100,2,3))
  dimnames(intensities) <- list(NULL, c("green","red"), NULL)
  arrayDataObject <- new("arrayData", intensities=intensities, spotAttr=data.frame(Name=I(rep(c("x","y","Blank","Blank","z"),20))), hybAttrList=NULL)
  res <- removeSpots(arrayDataObject, spotsToBeRemoved=c("x","z"))
  stopifnot( dim(getIntensities(res[["arrayDataObject"]]))[1] == 3*20 )

   ## Don't show: 

  indGreen=1:3
  indRed=4:6
  channels <- matrix( c(indGreen,indRed), nrow=length(indGreen), byrow=FALSE )
  colnames(channels) <- c("green","red")
  exprSetRGObject <- new("exprSetRG", exprs=matrix(data=runif(600),nrow=100,ncol=6), phenoData=new("phenoData", pData=data.frame(matrix(0,nrow=6,ncol=1)), varLabels=list(rep("varLabel1",1))), channels=channels)
  res2 <- removeSpots(arrayDataObject=arrayDataObject,exprSetRGObject=exprSetRGObject, spotsToBeRemoved=c("x","z"))
  stopifnot( dim(exprs(res2[["exprSetRGObject"]]))[1] == 3*20 )
  res3 <- removeSpots(arrayDataObject=arrayDataObject,exprSetRGObject=exprSetRGObject, spotsToBeRemoved=c("ggrrrr"))
  stopifnot( dim(exprs(res3[["exprSetRGObject"]]))[1] == 100 )
  stopifnot( dim(getIntensities(res3[["arrayDataObject"]]))[1] == 100 )

   ## End Don't show
  


