### Name: getSnpAnnotation
### Title: Retrieves SNP-level annotation
### Aliases: getSnpAnnotation getSnpAnnotation,eSet-method
### Keywords: methods manip

### ** Examples


##Default method for adding SNP-level annotation

  data(annSnpset)
  obj <- new("AnnotatedSnpCopyNumberSet",
             copyNumber=copyNumber(annSnpset)[1:50,],
             cnConfidence=cnConfidence(annSnpset)[1:50,],
             phenoData=phenoData(annSnpset), annotation=annotation(annSnpset))
  obj
## Not run: 
##D ##Requires pd.mapping50k.xba240 annotation package
##D   snp.annotation <- getSnpAnnotation(obj)
##D   snp.annotation
##D   class(snp.annotation)
##D   identical(featureNames(obj), featureNames(snp.annotation))
##D   featureData(obj) <- snp.annotation
##D   validObject(obj)
##D   varLabels(featureData(obj))
## End(Not run)

##Using NetAffx annotation (already saved as a data.frame)
## Not run: 
##D   try(load(url("http://biostat.jhsph.edu/~iruczins/publications/sm/2006.scharpf.bioinfo/mapping/mapping50kXba240.rda")))
##D   reorderRows <- match(featureNames(obj), as.character(mapping50kXba240$Probe.Set.ID))
##D   netaffx.annotation <- mapping50kXba240[reorderRows, ]
##D   fD <- as(netaffx.annotation, "AnnotatedDataFrame")
##D   featureData(obj) <- fD
##D   varLabels(featureData(obj))
##D   validObject(obj)
## End(Not run)



