### Name: sliding.quantile
### Title: Compute quantile of scores in a sliding window
### Aliases: sliding.quantile slidingquantile
### Keywords: manip

### ** Examples

  sampleSize <- 1000
  ap <- cumsum(1+round(runif(sampleSize)*10))
  as <- c(rnorm(floor(sampleSize/3)),
          rnorm(ceiling(sampleSize/3),mean=1.5),
          rnorm(floor(sampleSize/3)))
  arm <- sliding.quantile(ap, as, 20)
  arq <- sliding.quantile(ap, as, 20, prob=0.25)
  plot(ap, as, pch=20, xlab="position",ylab="level")
  points(ap, arm[,1], type="l", col="red", lwd=2)
  points(ap, arq[,1], type="l", col="green", lwd=2)
  legend(x="topleft", legend=c("median","1st quartile"),
         col=c("red","green"), lty=1, lwd=2)



