### Name: varImpStruct-class
### Title: Class "varImpStruct" - collect data on variable importance from
###   various machine learning methods
### Aliases: varImpStruct-class plot,varImpStruct-method
###   plot,varImpStruct,ANY-method show,varImpStruct-method getVarImp
###   getVarImp,classifOutput-method
### Keywords: classes

### ** Examples

library(golubEsets)
data(Golub_Merge)
library(hu6800)
smallG <- Golub_Merge[1:60,]
rf <- randomForestB( smallG, "ALL.AML", 1:40, importance=TRUE )
plot( getVarImp( rf ), n=10, resolveenv=hu6800SYMBOL )
gb <- gbmB( smallG, "ALL.AML", 1:40 , n.minobsinnode=3 , n.trees=6000)
plot( getVarImp( gb ), n=10, resolveenv=hu6800SYMBOL )



