### Name: values.Widget
### Title: Deal with Names and Values of Widget Created by widgetRender()
### Aliases: values.Widget print.Widget print.pWidget
### Keywords: manip

### ** Examples

# Create the lists and list of lists
  pW1 <- list(Name="AAA", Value="bbb",
              toText=function(x) paste(x,collapse = ","),
              fromText=NULL, canEdit=TRUE, buttonFun = fileBrowser,
              buttonText = "Browse")

  pW2 <- list(Name="BBB", Value="x,y,z", toText=function(x) paste(x, sep=","),
            fromText=NULL, canEdit=TRUE, buttonFun = ls,
           buttonText = "List")

  pW3 <- list(Name="CCC", Value="ccc",
              toText=function(x) paste(x, collapse = ","),
              fromText=NULL, canEdit=TRUE, buttonFun=NULL,
              buttonText=NULL)

  widget1 <- list(wList = list(a = pW1, b = pW2, c = pW3),
                  preFun = function() "Hi",
                  postFun = function() "Bye")

# Define the classes
class(pW1) <- c("pWidget", "textbox")
class(widget1) <- "Widget"

# Call the funcitons
print.pWidget(pW1)
print.Widget(widget1)
values.Widget(widget1)



