### Name: checkProtection
### Title: A function to protect intermediate results from being
###   overwritten
### Aliases: checkProtection
### Keywords: utilities

### ** Examples


data(benomylsetupsmall)
a <- new("goCluster")

## No error since the object has not been calculated yet
checkProtection(a@algo,"test")

execute(a) <- benomylsetupsmall

## This results in an error since the object contains calculated data
error <- try(checkProtection(a@algo,"test"), silent = TRUE)
error

## No error since no visualization method has been chosen
checkProtection(a@visu,"test")




