### Name: gcAllocator-class
### Title: Class "gcAllocator", memory allocator class for external
###   resources
### Aliases: gcAllocator-class allocate,externalResource,gcAllocator-method
###   deallocate,externalResource,gcAllocator-method
###   external.size,externalResource,gcAllocator-method
###   external.size<-,externalResource,logical,gcAllocator,numeric-method
###   reinitializePointer,externalResource,gcAllocator-method
### Keywords: classes

### ** Examples

library(externalVector)
## set a storage class
setClass("testStorage",
         representation(ptr="externalptr"),
         contains="externalResource")
setMethod("initializeResource", "testStorage",
          function(resource, ptr, size, type, ...)
       {
           resource@ptr <- ptr
           resource
       })
setMethod("allocator", "testStorage",
          function(resource)
          new("gcAllocator"))
setMethod("getPointer", "testStorage",
          function(resource)
          resource@ptr)
setMethod("allocatedSize", "testStorage",
          function(resource)
          32)
## Now create an object from the class
x <- new("testStorage")
x
external.size(x)
external.size(x) <- 64
x
external.size(x)
deallocate(x)
x
external.size(x)



