### Name: aCGH
### Title: Class aCGH
### Aliases: aCGH create.aCGH log2.ratios clones.info is.aCGH dim.aCGH
###   num.clones nrow.aCGH num.samples num.chromosomes ncol.aCGH
###   clone.names row.names.aCGH rownames.aCGH clone.names<-
###   row.names<-.aCGH rownames<-.aCGH col.names.aCGH col.names<-.aCGH
###   colnames.aCGH colnames<-.aCGH sample.names sample.names<-
###   log2.ratios.imputed log2.ratios.imputed<- hmm hmm<- hmm.merged
###   hmm.merged<- sd.samples sd.samples<- genomic.events genomic.events<-
###   phenotype phenotype<- [.aCGH print.aCGH summary.aCGH plot.aCGH minna
###   maxna corna floor.func length.num.func prop.num.func subset.hmm
###   subset.hmm.merged ex.acgh.hmm
### Keywords: classes

### ** Examples


## Creating aCGH object from log2.ratios and clone info files
## For alternative way look at aCGH.read.Sprocs help

datadir <- system.file(package = "aCGH")
datadir <- paste(datadir, "/examples", sep="")

clones.info <-
      read.table(file = file.path(datadir, "clones.info.ex.txt"),
                 header = TRUE, sep = "\t", quote="", comment.char="")
log2.ratios <-
      read.table(file = file.path(datadir, "log2.ratios.ex.txt"),
                 header = TRUE, sep = "\t", quote="", comment.char="")
pheno.type <-
      read.table(file = file.path(datadir, "pheno.type.ex.txt"),
                 header = TRUE, sep = "\t", quote="", comment.char="")
ex.acgh <- create.aCGH(log2.ratios, clones.info, pheno.type)

## Printing, summary and basic plotting for objects of class aCGH

data(colorectal)
colorectal
summary(colorectal)
sample.names(colorectal)
phenotype(colorectal)
plot(colorectal)

## Subsetting aCGH object

colorectal[1:1000, 1:30]

## Imputing the log2 ratios 

log2.ratios.imputed(ex.acgh) <- impute.lowess(ex.acgh)

## Determining hmm states of the clones
## WARNING: Calculating the states takes some time

##in the interests of time, hmm-finding function is commented out
##instead the states previosuly save are assigned
##hmm(ex.acgh) <- find.hmm.states(ex.acgh)

hmm(ex.acgh) <- ex.acgh.hmm
hmm.merged(ex.acgh) <-
   mergeHmmStates(ex.acgh, model.use = 1, minDiff = .25)

## Calculating the standard deviations for each array

sd.samples(ex.acgh) <- computeSD.Samples(ex.acgh)

## Finding the genomic events associated with each sample

genomic.events(ex.acgh) <- find.genomic.events(ex.acgh)

## Plotting and printing the hmm states

plotHmmStates(ex.acgh, 1)
pdf("hmm.states.temp.pdf")
plotHmmStates(ex.acgh, 1)
dev.off()

## Plotting summary of the sample profiles

plotSummaryProfile(colorectal)





