### Name: mergeCor
### Title: Class mergeCor, a class for storing data relevant to integrative
###   correlation coefficients.
### Aliases: mergeCor-class mergeCor pairwise.cors integrative.cors
###   pairwise.cors,mergeCor-method integrative.cors,mergeCor-method
###   maxcors,mergeCor-method hist,mergeCor-method plot,list-method
###   notes,mergeCor-method maxcors
### Keywords: classes

### ** Examples

  if(require(Biobase) & require(MASS)){
  data(mergeData)
  merged  <- mergeExprs(sample1,sample2,sample3)
  intcor3  <-intCor(merged,method="pearson")
  plot(merged)
  intcor2  <-intCor(merged[1:2],exact=FALSE)
  plot(merged,pch=4,col=5)

  pairwise.cors(intcor3)
  integrative.cors(intcor3)
  integrative.cors(intcor2)["Hs.12101"]
  maxcors(intcor2)
  }



