## ----eval=FALSE------------------------------------------------------------
#  # install.packages("devtools")
#  devtools::install_github("compbiomed/singleCellTK")

## ----eval=FALSE------------------------------------------------------------
#  source("https://bioconductor.org/biocLite.R")
#  biocVersion()

## ----eval=FALSE------------------------------------------------------------
#  biocLite("BiocUpgrade")

## ----eval=FALSE------------------------------------------------------------
#  biocValid()

## ----eval=FALSE------------------------------------------------------------
#  biocLite()

## ----eval=FALSE------------------------------------------------------------
#  devtools::install_github("compbiomed/singleCellTK")

## ----eval=FALSE------------------------------------------------------------
#  library(singleCellTK)
#  singleCellTK()

## ----eval=FALSE------------------------------------------------------------
#  library(singleCellTK)
#  singleCellTK()

## ---- message=FALSE--------------------------------------------------------
library(singleCellTK)
data("mouseBrainSubsetSCE")
counts_mat <- assay(mouseBrainSubsetSCE, "counts")
sample_annot <- colData(mouseBrainSubsetSCE)
row_annot <- rowData(mouseBrainSubsetSCE)
newSCE <- createSCE(assayFile = counts_mat, annotFile = sample_annot, 
                    featureFile = row_annot, assayName = "counts",
                    inputDataFrames = TRUE, createLogCounts = TRUE)

## ----eval=FALSE------------------------------------------------------------
#  singleCellTK(newSCE)

## ----sessionInfo, echo=FALSE-----------------------------------------------
sessionInfo()

