## ----knitr-options, echo=FALSE, message=FALSE, warning=FALSE---------------
## To render an HTML version that works nicely with github and web pages, do:
## rmarkdown::render("vignettes/vignette.Rmd", "all")
library(knitr)
opts_chunk$set(fig.align = 'center', fig.width = 6, fig.height = 5, dev = 'png',
    error=FALSE, message=FALSE, warning=FALSE)
library(ggplot2)
theme_set(theme_bw(12))

## --------------------------------------------------------------------------
library(scater)
data("sc_example_counts")
data("sc_example_cell_info")
example_sce <- SingleCellExperiment(
    assays = list(counts = sc_example_counts),
    colData = sc_example_cell_info
) 
example_sce <- normalize(example_sce)
example_sce

## ----plot-expression-------------------------------------------------------
plotExpression(example_sce, rownames(example_sce)[1:6],
    x = "Mutation_Status", exprs_values = "logcounts") 

## ----plot-expression-scatter-----------------------------------------------
plotExpression(example_sce, rownames(example_sce)[1:6],
    x = "Gene_0001")

## ----plot-expression-col---------------------------------------------------
plotExpression(example_sce, rownames(example_sce)[1:6],
    colour_by = "Cell_Cycle", shape_by = "Mutation_Status", 
    size_by = "Gene_0002")

## ----plot-expression-theme-bw----------------------------------------------
plotExpression(example_sce, rownames(example_sce)[7:12],
    x = "Mutation_Status", exprs_values = "counts", 
    colour = "Cell_Cycle", show_median = TRUE, 
    xlab = "Mutation Status", log = TRUE)

## ----plot-expression-many--------------------------------------------------
plotExpression(example_sce, rownames(example_sce)[1:6])

## --------------------------------------------------------------------------
example_sce <- runPCA(example_sce)
reducedDimNames(example_sce)

## ----plot-reduceddim-4comp-colby-shapeby-----------------------------------
plotReducedDim(example_sce, use_dimred = "PCA", 
    colour_by = "Treatment", shape_by = "Mutation_Status")

## ----plot-reduceddim-4comp-colby-sizeby-exprs------------------------------
plotReducedDim(example_sce, use_dimred = "PCA", 
    colour_by = "Gene_1000", size_by = "Gene_0500")

## ----plot-pca-default------------------------------------------------------
plotPCA(example_sce)

## ----plot-pca-feature-controls---------------------------------------------
example_sce2 <- runPCA(example_sce, 
    feature_set = rowData(example_sce)$is_feature_control)
plotPCA(example_sce2)

## ----plot-pca-4comp-colby-shapeby------------------------------------------
example_sce <- runPCA(example_sce, ncomponents=20)
plotPCA(example_sce, ncomponents = 4, colour_by = "Treatment",
        shape_by = "Mutation_Status")

## ----plot-pca-4comp-colby-sizeby-exprs-------------------------------------
plotPCA(example_sce, colour_by = "Gene_0001", size_by = "Gene_1000")

## ----plot-tsne-1comp-colby-sizeby-exprs------------------------------------
# Perplexity of 10 just chosen here arbitrarily. 
example_sce <- runTSNE(example_sce, perplexity=10, rand_seed=1000)
plotTSNE(example_sce, colour_by = "Gene_0001", size_by = "Gene_1000")

## ----plot-tsne-from-pca----------------------------------------------------
example_sce <- runTSNE(example_sce, perplexity=10, rand_seed=1000,
    use_dimred="PCA", n_dimred = 10)
plotTSNE(example_sce, colour_by="Treatment")

## ----plot-difmap-1comp-colby-sizeby-exprs----------------------------------
example_sce <- runDiffusionMap(example_sce)
plotDiffusionMap(example_sce, colour_by = "Gene_0001", size_by = "Gene_1000")

## --------------------------------------------------------------------------
sessionInfo()

