## ----setup,echo=FALSE,results="hide"---------------------------------------
suppressPackageStartupMessages({
suppressMessages({
library(rhdf5client)
library(BiocStyle)
library(DT)
library(DelayedArray)
})
})

## ----lkserv----------------------------------------------------------------
library(rhdf5client)
bigec2 = H5S_source(URL_h5serv())
class(bigec2)
bigec2

## ----lkhi------------------------------------------------------------------
groups(bigec2)
links(bigec2,1)
datatable(data.frame(targets(links(bigec2,1))))

## ----lkdb------------------------------------------------------------------
tenx_remote = bigec2[["tenx_full"]]
tenx_remote

## ----getcs-----------------------------------------------------------------
apply(tenx_remote[1:4,1:27998],1,sum)

## ----lkdela----------------------------------------------------------------
del10x = H5S_Array(URL_h5serv(), "tenx_full")
del10x

## ----lkdela2---------------------------------------------------------------
apply(del10x[,1:4],2,sum)

## ----doos------------------------------------------------------------------
con = H5S_source(URL_hsds())   
con = setPath(con, "/home/reshg/tenx_full.h5") # this is as defined in store
ds2 = H5S_dataset2(con)
ds2

## ----lkdel3----------------------------------------------------------------
library(DelayedArray)
del10x_hsds = DelayedArray(new("H5S_ArraySeed", filepath = "", domain = "", 
        host = "", H5S_dataset = ds2))
del10x_hsds
apply(del10x_hsds[,1:4], 2, sum)

## ----initcomp--------------------------------------------------------------
library(reticulate)
np = import("numpy", convert=FALSE)
h5py = import("h5py", convert=FALSE)

## ----dorh------------------------------------------------------------------
Rh5py = h5py[["_hl"]]
names(Rh5py)

## ----domatr----------------------------------------------------------------
h5file = function( file )
  Rh5py$files$File( file )

fn = system.file("hdf5/numiris.h5", package="rhdf5client")
m1 = h5file(fn)
m1
class(m1)

## ----lkkkk-----------------------------------------------------------------
m1$keys()

## ----domr------------------------------------------------------------------
h5dsref = function(filename, dsname="numiris") {
  py_run_string("import h5py", convert=FALSE)
  py_run_string(paste0("f = h5py.File('", filename, "')"))
  mref = py_run_string(paste0("g = f['", dsname, "']"))
  mref$g
}

## ----mkref-----------------------------------------------------------------
numir = h5dsref(fn)
ta = np$take  # can't use `$` on the fly
numirsli = ta(numir, 0:2, 1L)
class(numirsli)
numirsli

## ----reflec----------------------------------------------------------------
names(numirsli)
numirsli$ndim
numirsli$shape
numirsli$T$shape

## ----tx--------------------------------------------------------------------
dim(py_to_r(numirsli)) # all in R

## ----lkcr------------------------------------------------------------------
if (.Platform$OS.type != "windows")  {
tf = tempfile()
nf = h5py$File(tf, "w")
irmat = data.matrix(iris[,1:4])
nf$create_dataset('irisH5', data=r_to_py(irmat))
chk = h5dsref(tf, "irisH5")
ta(chk, 0:4, 0L)
nf$file$close() # no more reading, but
try(ta(chk, 0:4, 0L)) # is the close operation working?
}

## ----getpd-----------------------------------------------------------------
if (.Platform$OS.type != "windows")  {
Rh5pyd = import("h5pyd", as="h5py", convert=FALSE)
tenx_remote = Rh5pyd$File("/home/reshg/tenx_full.h5", "r",
     endpoint=URL_hsds())
tenx_remote
tenx_remote$keys() # only python
py_to_r(tenx_remote$keys()) # the strings of interest
}

## ----lkgs------------------------------------------------------------------
if (.Platform$OS.type != "windows")  {
getslice = function(endpoint, mode, domain, dsname, indexstring="[0,0]") {
   py_run_string("import h5pyd", convert=FALSE)
   py_run_string(paste0("f = h5pyd.File(domain=", sQuote(domain), 
         ", mode = ", sQuote(mode), ", endpoint=", sQuote(endpoint), ")"))
   py_run_string(paste0("g = f['", dsname, "']", indexstring))$g
}
mr = getslice(URL_hsds(), "r", 
   "/home/reshg/tenx_full.h5", "newassay001", "[0:4, 0:27998]")
apply(mr,1,sum)
}

## ----dosl2, eval=FALSE-----------------------------------------------------
#  if (.Platform$OS.type != "windows")  {
#  hh = import("h5pyd", as="h5py") # avoid auth problem?
#  mr = getslice(URL_h5serv(), "r",
#     "tenx_full.h5s.channingremotedata.org", "newassay001", "[0:4, 0:27998]")
#  apply(mr,1,sum)
#  }

## ----lkrr------------------------------------------------------------------
if (.Platform$OS.type != "windows")  {
names(Rh5pyd)
}

## ----lkcr2,eval=FALSE------------------------------------------------------
#  if (.Platform$OS.type != "windows")  {
#  nf = Rh5pyd$File(endpoint=URL_hsds(), mode="w",
#     domain="/home/stvjc/iris_demo.h5")
#  nf$create_dataset('irisH5', data=r_to_py(irmat))
#  }

## ----lkrrrr----------------------------------------------------------------
if (.Platform$OS.type != "windows")  {
getslice(URL_hsds(), mode="r",
   domain="/home/stvjc/iris_demo.h5", "irisH5", "[0:3, 0:3]")
}

## ----lknnnaaa--------------------------------------------------------------
if (.Platform$OS.type != "windows")  {
sort(names(Rh5pyd$File))
}

