/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.classifier.train;

import edu.msu.cme.rdp.classifier.train.LineageSequence;
import edu.msu.cme.rdp.classifier.train.Taxonomy;
import edu.msu.cme.rdp.readseq.utils.orientation.GoodWordIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class RawHierarchyTree {
    private String name;
    private int leaveCount;
    private RawHierarchyTree parent;
    private Map<String, RawHierarchyTree> subclasses = new HashMap<String, RawHierarchyTree>();
    private int[] wordOccurrence;
    private Taxonomy taxon;
    private int genusIndex = -1;

    public RawHierarchyTree(String n, RawHierarchyTree p, Taxonomy tax) {
        this.name = n;
        this.taxon = tax;
        this.leaveCount = -1;
        this.addParent(p);
    }

    private void addParent(RawHierarchyTree p) {
        this.parent = p;
        if (this.parent != null) {
            this.parent.addSubclass(this);
        }
    }

    private void addSubclass(RawHierarchyTree c) {
        this.subclasses.put(c.getName(), c);
    }

    public String getName() {
        return this.name;
    }

    public RawHierarchyTree getParent() {
        return this.parent;
    }

    public Collection getSubclasses() {
        return this.subclasses.values();
    }

    public RawHierarchyTree getSubclassbyName(String n) {
        return this.subclasses.get(n);
    }

    public int getSizeofChildren() {
        int size = this.subclasses.size();
        if (size > 0) {
            return size;
        }
        return this.leaveCount;
    }

    public int getSizeofSubclasses() {
        return this.subclasses.size();
    }

    public void initWordOccurrence(LineageSequence pSeq, float[] wordPriorArr) throws IOException {
        this.leaveCount = this.leaveCount < 0 ? 1 : ++this.leaveCount;
        GoodWordIterator iterator = new GoodWordIterator(pSeq.getSeqString());
        if (this.wordOccurrence == null) {
            this.wordOccurrence = new int[iterator.getMask() + 1];
        }
        int[] wordList = new int[iterator.getNumofWords()];
        for (int i = 0; i < wordList.length; ++i) {
            wordList[i] = -1;
        }
        int numUniqueWords = 0;
        while (iterator.hasNext()) {
            int index = iterator.next();
            if (this.isWordExist(wordList, index)) continue;
            wordList[numUniqueWords] = index;
            int n = index;
            this.wordOccurrence[n] = this.wordOccurrence[n] + 1;
            ++numUniqueWords;
            int n2 = index;
            wordPriorArr[n2] = wordPriorArr[n2] + 1.0f;
        }
    }

    private boolean isWordExist(int[] wordList, int wordIndex) {
        for (int i = 0; i < wordList.length; ++i) {
            if (wordList[i] == wordIndex) {
                return true;
            }
            if (wordList[i] != -1) continue;
            return false;
        }
        return false;
    }

    public int getWordOccurrenceSize() {
        return this.wordOccurrence.length;
    }

    public int getWordOccurrence(int wordIndex) {
        return this.wordOccurrence[wordIndex];
    }

    public void releaseWordOccurrence() {
        this.wordOccurrence = null;
    }

    public int getLeaveCount() {
        if (this.leaveCount >= 0) {
            return this.leaveCount;
        }
        if (this.getSizeofSubclasses() <= 0) {
            return this.leaveCount;
        }
        this.leaveCount = 0;
        Iterator<RawHierarchyTree> i = this.subclasses.values().iterator();
        while (i.hasNext()) {
            this.leaveCount += i.next().getLeaveCount();
        }
        return this.leaveCount;
    }

    public int getGenusNodeCount() {
        if (this.getSizeofSubclasses() <= 0 || this.taxon.hierLevel.equalsIgnoreCase("GENUS")) {
            return 1;
        }
        int genusNodeCount = 0;
        Iterator<RawHierarchyTree> i = this.subclasses.values().iterator();
        while (i.hasNext()) {
            genusNodeCount += i.next().getGenusNodeCount();
        }
        return genusNodeCount;
    }

    public boolean isSingleton() {
        return this.getLeaveCount() <= 1;
    }

    public int getNonSingletonLeaveCount() {
        if (this.isSingleton()) {
            return 0;
        }
        if (this.getSizeofSubclasses() <= 0) {
            return this.leaveCount;
        }
        int nonSingleton = 0;
        Iterator<RawHierarchyTree> i = this.subclasses.values().iterator();
        while (i.hasNext()) {
            nonSingleton += i.next().getNonSingletonLeaveCount();
        }
        return nonSingleton;
    }

    public Taxonomy getTaxonomy() {
        return this.taxon;
    }

    public void setGenusIndex(int i) {
        this.genusIndex = i;
    }

    public int getGenusIndex() {
        return this.genusIndex;
    }

    public void getNodeMap(String level, HashMap<String, RawHierarchyTree> nodeMap) {
        if (this.taxon.getHierLevel().equalsIgnoreCase(level)) {
            nodeMap.put(this.name, this);
            return;
        }
        Collection al = new ArrayList();
        al = this.getSubclasses();
        if (al.isEmpty()) {
            return;
        }
        Iterator i = al.iterator();
        while (i.hasNext()) {
            ((RawHierarchyTree)i.next()).getNodeMap(level, nodeMap);
        }
    }
}

