/*
 * Decompiled with CFR 0.152.
 */
package cn.bgi;

import cn.bgi.FDRcalculator;
import cn.bgi.ProteinGroup;
import de.proteinms.xtandemparser.interfaces.Modification;
import de.proteinms.xtandemparser.xtandem.Domain;
import de.proteinms.xtandemparser.xtandem.FragmentIon;
import de.proteinms.xtandemparser.xtandem.ModificationMap;
import de.proteinms.xtandemparser.xtandem.Peptide;
import de.proteinms.xtandemparser.xtandem.PeptideMap;
import de.proteinms.xtandemparser.xtandem.Spectrum;
import de.proteinms.xtandemparser.xtandem.SupportData;
import de.proteinms.xtandemparser.xtandem.XTandemFile;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class XTandemParser {
    public static void main(String[] args) throws Exception {
        String xmlfile = args[0];
        String fasta = args[1];
        String projname = args[2];
        String outdir = args[3];
        String logDataFile = args[4];
        System.out.println("Process file: " + xmlfile + "...");
        String decoyString = "###REV###";
        File cdir = new File(outdir);
        if (!cdir.isDirectory()) {
            cdir.mkdirs();
        }
        BufferedWriter bWriter = new BufferedWriter(new FileWriter(new File(logDataFile)));
        bWriter.write("spectrum_total\tspectrum\tpeptide\tprotein\tpeptide_summary\tprotein_summary\n");
        File xmlf = new File(xmlfile);
        String xmlFileNameString = xmlf.getName();
        XTandemFile xf = new XTandemFile(xmlfile);
        System.out.println("spectrum number:" + xf.getPerformParameters().getTotalSpectraUsed());
        bWriter.write(String.valueOf(xf.getPerformParameters().getTotalSpectraUsed()) + "\t");
        ModificationMap modMap = xf.getModificationMap();
        String modmass = xf.getInputParameters().getResiduePotModMass();
        String[] varmod = null;
        HashMap<String, Double> varModifiableSites = new HashMap<String, Double>();
        if (!modmass.isEmpty()) {
            String[] stringArray = varmod = xf.getInputParameters().getResiduePotModMass().split(",");
            int n = varmod.length;
            int n2 = 0;
            while (n2 < n) {
                String modif = stringArray[n2];
                double mass = Double.parseDouble(modif.split("@")[0]);
                modif = modif.split("@")[1];
                Pattern pattern = Pattern.compile("\\[(\\w+)\\]");
                Matcher matcher = pattern.matcher(modif);
                if (matcher.find()) {
                    String[] multiSites;
                    String[] stringArray2 = multiSites = matcher.group(1).split("");
                    int n3 = multiSites.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String ms = stringArray2[n4];
                        if (!varModifiableSites.containsKey(ms) && !ms.isEmpty()) {
                            varModifiableSites.put(ms, mass);
                        }
                        ++n4;
                    }
                } else if (!varModifiableSites.containsKey(modif)) {
                    varModifiableSites.put(modif, mass);
                }
                ++n2;
            }
        }
        ArrayList<Spectrum> specList = xf.getSpectraList();
        PeptideMap pepMap = xf.getPeptideMap();
        String pepfile = String.valueOf(outdir) + "/" + projname + "-rawPSMs.txt";
        BufferedWriter pepfilebw = new BufferedWriter(new FileWriter(new File(pepfile)));
        pepfilebw.write("index\tevalue\tcharge\tmass\tmz\tdelta_da\tdelta_ppm\tpeptide\tisdecoy\tmiss\tprotein\trt\tmods\tms2peaks\tms2delta\n");
        int i = 0;
        while (i < specList.size()) {
            Spectrum specTemp = specList.get(i);
            int specNum = specTemp.getSpectrumNumber();
            ArrayList<Peptide> spectrumPeptides = pepMap.getAllPeptides(specNum);
            Peptide bestPeptide = spectrumPeptides.get(0);
            if (bestPeptide != null) {
                Domain firstDomainBestPep = bestPeptide.getDomains().get(0);
                StringBuilder accStringBuilder = new StringBuilder();
                String accString = firstDomainBestPep.getProteinKey().split("\\s")[0];
                accStringBuilder.append(accString);
                int isDecoy = 0;
                Pattern proPattern = Pattern.compile(decoyString);
                Matcher match = proPattern.matcher(accString);
                if (match.find()) {
                    isDecoy = 1;
                }
                int j = 1;
                while (j < bestPeptide.getDomains().size()) {
                    Domain dm = bestPeptide.getDomains().get(j);
                    accStringBuilder.append(";");
                    String accTmp = dm.getProteinKey().split("\\s")[0];
                    accStringBuilder.append(accTmp);
                    if (match.find()) {
                        isDecoy = 1;
                    }
                    ++j;
                }
                int k = 1;
                while (k < spectrumPeptides.size()) {
                    if (spectrumPeptides.get(k).getDomains().get(0).getDomainExpect() == bestPeptide.getDomains().get(0).getDomainExpect() && spectrumPeptides.get(k).getDomains().get(0).getDomainSequence().equalsIgnoreCase(bestPeptide.getDomains().get(0).getDomainSequence())) {
                        int j2 = 0;
                        while (j2 < spectrumPeptides.get(k).getDomains().size()) {
                            Domain dm = spectrumPeptides.get(k).getDomains().get(j2);
                            accStringBuilder.append(";");
                            String accTmp = dm.getProteinKey().split("\\s")[0];
                            accStringBuilder.append(accTmp);
                            if (match.find()) {
                                isDecoy = 1;
                            }
                            ++j2;
                        }
                    }
                    ++k;
                }
                Vector fragIonList = xf.getFragmentIonsForPeptide(bestPeptide, firstDomainBestPep, xf.getInputParameters().getSpectrumMonoIsoMassError());
                ArrayList<Double> ms2errorList = new ArrayList<Double>();
                int j3 = 0;
                while (j3 < fragIonList.size()) {
                    int k2 = 0;
                    while (k2 < ((FragmentIon[])fragIonList.get(j3)).length) {
                        double ms2error = ((FragmentIon[])fragIonList.get(j3))[k2].getTheoreticalExperimentalMassError();
                        ms2errorList.add(ms2error);
                        ++k2;
                    }
                    ++j3;
                }
                String ms2errorString = StringUtils.join(ms2errorList, ";");
                String domainKey = firstDomainBestPep.getDomainKey();
                ArrayList<String> modString = new ArrayList<String>();
                String modSites = "";
                ArrayList<Modification> mdl = modMap.getVariableModifications(domainKey);
                int j4 = 0;
                while (j4 < mdl.size()) {
                    modSites = String.valueOf(modSites) + mdl.get(j4).getName() + ";";
                    String residue = mdl.get(j4).getName().split("@")[1];
                    if (varModifiableSites.containsKey(residue) && !modString.contains(residue)) {
                        modString.add(residue);
                    }
                    ++j4;
                }
                mdl = modMap.getFixedModifications(domainKey);
                j4 = 0;
                while (j4 < mdl.size()) {
                    modSites = String.valueOf(modSites) + mdl.get(j4).getName() + ";";
                    ++j4;
                }
                modSites = modSites.isEmpty() ? "-" : modSites.replaceAll(";$", "");
                specTemp.getExpectValue();
                StringBuilder pepoutBuilder = new StringBuilder();
                pepoutBuilder.append(String.valueOf(xmlFileNameString) + ":" + specNum + "\t");
                pepoutBuilder.append(String.valueOf(firstDomainBestPep.getDomainExpect()) + "\t");
                pepoutBuilder.append(String.valueOf(specTemp.getPrecursorCharge()) + "\t");
                double precmass = specTemp.getPrecursorMh() - firstDomainBestPep.getDomainDeltaMh() - 1.007825;
                pepoutBuilder.append(String.valueOf(precmass) + "\t");
                double mz = (specTemp.getPrecursorMh() - 1.007825 + (double)specTemp.getPrecursorCharge() * 1.007825) / (double)specTemp.getPrecursorCharge();
                pepoutBuilder.append(String.valueOf(mz) + "\t");
                pepoutBuilder.append(String.valueOf(firstDomainBestPep.getDomainDeltaMh()) + "\t");
                double ppm = firstDomainBestPep.getDomainDeltaMh() / precmass * 1000000.0;
                pepoutBuilder.append(String.valueOf(ppm) + "\t");
                pepoutBuilder.append(String.valueOf(firstDomainBestPep.getDomainSequence()) + "\t");
                pepoutBuilder.append(String.valueOf(isDecoy) + "\t");
                pepoutBuilder.append(String.valueOf(firstDomainBestPep.getMissedCleavages()) + "\t");
                pepoutBuilder.append(accStringBuilder + "\t");
                String rt = specTemp.getPrecursorRetentionTime().isEmpty() ? "-1" : specTemp.getPrecursorRetentionTime();
                pepoutBuilder.append(String.valueOf(rt) + "\t");
                pepoutBuilder.append(String.valueOf(modSites) + "\t");
                SupportData supData = xf.getSupportData(bestPeptide.getSpectrumNumber());
                ArrayList<Double> mzValue = supData.getXValuesFragIonMass2Charge();
                pepoutBuilder.append(String.valueOf(mzValue.size()) + "\t");
                pepoutBuilder.append(ms2errorString);
                pepfilebw.write(String.valueOf(pepoutBuilder.toString()) + "\n");
            }
            ++i;
        }
        pepfilebw.close();
        String outFilterPsmFile = String.valueOf(outdir) + "/" + projname + "-peptideSummary.txt";
        FDRcalculator.initialize(true, 0.01, outFilterPsmFile);
        int[] peptides = FDRcalculator.fdrCalc(pepfile);
        String outProtienFile = String.valueOf(outdir) + "/" + projname + "-proteinSummary.txt";
        ProteinGroup.proteinGrouper(outFilterPsmFile, outProtienFile, fasta);
        int sumIdentProteins = ProteinGroup.getSumIdentProteins();
        bWriter.write(String.valueOf(peptides[0]) + "\t");
        bWriter.write(String.valueOf(peptides[1]) + "\t");
        bWriter.write(String.valueOf(sumIdentProteins) + "\t");
        bWriter.write(String.valueOf(outFilterPsmFile) + "\t");
        bWriter.write(String.valueOf(outProtienFile) + "\n");
        bWriter.close();
    }
}

