## ----setup, echo=FALSE, results="hide"-----------------------------------
library(BiocStyle)
knitr::opts_chunk$set(tidy=FALSE, cache=TRUE,
                      dev="png",
                      message=FALSE, error=FALSE,
                      warning=TRUE)

## ----package-select,message=FALSE----------------------------------------
library(isomiRs)
data(mirData)
head(isoSelect(mirData, mirna="hsa-let-7a-5p", 1000))

## ----package-load,message=FALSE------------------------------------------
library(isomiRs)
data(mirData)

## ----package-plot-iso,message=FALSE,eval=FALSE---------------------------
#  ids <- IsomirDataSeqFromFiles(fn_list, design=de)

## ----package-plot-iso-t5,message=FALSE-----------------------------------
ids <- isoCounts(mirData)
isoPlot(ids, type="all", column = "group")

## ----package-count,message=FALSE-----------------------------------------
head(counts(ids))

## ----package-norm,message=FALSE------------------------------------------
library(pheatmap)
ids = isoNorm(ids, formula = ~ group)
pheatmap(counts(ids, norm=TRUE)[1:100,], 
         annotation_col = data.frame(colData(ids)[,1,drop=FALSE]),
         show_rownames = FALSE, scale="row")

## ----package-de,message=FALSE--------------------------------------------
dds <- isoDE(ids, formula=~group)
library(DESeq2)
plotMA(dds)
head(results(dds, format="DataFrame"))

## ----package-de-iso5,message=FALSE---------------------------------------
dds = isoDE(ids, formula=~group, ref=TRUE, iso5=TRUE)
head(results(dds, tidy=TRUE))

## ----package-de-with-deseq2----------------------------------------------
dds = DESeqDataSetFromMatrix(counts(ids),
                             colData(ids), design = ~ group)

## ----package-pls---------------------------------------------------------
ids = isoCounts(ids, iso5=TRUE, minc=10, mins=6)
ids = isoNorm(ids, formula = ~ group)
pls.ids = isoPLSDA(ids, "group", nperm = 2)
df = isoPLSDAplot(pls.ids)

## ----package-plsplot, message=FALSE, eval=FALSE--------------------------
#  pls.ids = isoPLSDA(ids,"group", refinment = FALSE, vip = 0.8)

## ----isonetwork, message=FALSE, error=FALSE, fig.width=7-----------------
# library(org.Mm.eg.db)
# library(clusterProfiler)
data(isoExample)

# ego <- enrichGO(row.names(assay(gene_ex_rse, "norm")),
#                 org.Mm.eg.db, "ENSEMBL", ont = "BP")
data = isoNetwork(mirna_ex_rse, gene_ex_rse, target = ma_ex,
                  enrich = ego, summarize = "group")
isoPlotNet(data)

## ----findtarget----------------------------------------------------------
mirna_ma <- data.frame(gene = names(gene_ex_rse)[1:20],
                       mir = names(mirna_ex_rse))
ma_ex <- findTargets(mirna_ex_rse, gene_ex_rse, mirna_ma)
head(ma_ex[,1:4])

## ----mirna2targetscan----------------------------------------------------
mirna_ma <- mirna2targetscan(c("hsa-miR-34c-5p"))
head(mirna_ma)

## ----sessionInfo---------------------------------------------------------
sessionInfo()

