## ----setup, include = FALSE------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  error = FALSE,
  warning = FALSE,
  message = FALSE
)
stopifnot(requireNamespace("htmltools"))
htmltools::tagList(rmarkdown::html_dependency_font_awesome())

## ----installation, eval=FALSE----------------------------------------------
#  source("http://bioconductor.org/biocLite.R")
#  biocLite("iSEE")

## ----library---------------------------------------------------------------
library("iSEE")

## ----qs-data---------------------------------------------------------------
library(scRNAseq)
data(allen)
library(scater)
sce <- as(allen, "SingleCellExperiment")
counts(sce) <- assay(sce, "tophat_counts")
sce <- normalize(sce)
sce <- runPCA(sce)
sce <- runTSNE(sce)
sce

## ----qs-create-------------------------------------------------------------
app <- iSEE(sce)

## ----qs-launch, eval=FALSE-------------------------------------------------
#  shiny::runApp(app)

## ----allen-dataset---------------------------------------------------------
library(scRNAseq)
data(allen)
class(allen)
library(scater)
sce <- as(allen, "SingleCellExperiment")
counts(sce) <- assay(sce, "tophat_counts")
sce <- normalize(sce)

## ----allen-dataset-2-------------------------------------------------------
sce <- runPCA(sce)
sce <- runTSNE(sce)
reducedDimNames(sce)

## ----colData_sce-----------------------------------------------------------
colnames(colData(sce))

## ----fpkm_color_fun--------------------------------------------------------
fpkm_color_fun <- function(n){
  x <- c("black","brown","red","orange","yellow")
  return(x)
}

## ----driver_color_fun------------------------------------------------------
driver_color_fun <- function(n){
  return(RColorBrewer::brewer.pal(n, "Set2"))
}

## ----qc_color_fun----------------------------------------------------------
qc_color_fun <- function(n){
  qc_colors <- c("forestgreen", "firebrick1")
  names(qc_colors) <- c("Y", "N")
  return(qc_colors)
}

## ----ecm-------------------------------------------------------------------
ecm <- ExperimentColorMap(
  assays = list(
      counts = viridis::viridis,
      cufflinks_fpkm = fpkm_color_fun
  ),
  colData = list(
      passes_qc_checks_s = qc_color_fun,
      driver_1_s = driver_color_fun
  ),
  all_continuous = list(
    assays = viridis::viridis
  )
)
ecm

## ----all_continuous--------------------------------------------------------
ExperimentColorMap(
  all_continuous=list(
    assays=viridis::plasma,
    colData=viridis::inferno
  ),
  global_continuous=viridis::magma  
)

## ----allen-dataset-4-------------------------------------------------------
app <- iSEE(sce, colormap = ecm)

## ----runApp, eval=FALSE----------------------------------------------------
#  shiny::runApp(app)

## ----init------------------------------------------------------------------
init <- DataFrame(
  Name = c("Feature assay plot 1", "Feature assay plot 2"),
  Width = c(6, 6)
)
app <- iSEE(sce, initialPanels = init)

## ----fexArg----------------------------------------------------------------
fexArg <- featAssayPlotDefaults(sce, 2)
fexArg$YAxisFeatName <- c("0610009L18Rik", "0610009B22Rik")
app <- iSEE(sce, initialPanels = init, featAssayArgs = fexArg)

## ----cytof, eval=FALSE-----------------------------------------------------
#  cytof <- readRDS(gzcon(url(
#    "https://www.dropbox.com/s/42kfedfpzyssqvq/cytof_bcrxl_5000cells.rds?dl=1")))

## ----initialPanels_cytof, eval=FALSE---------------------------------------
#  initialPanels = DataFrame(
#    Name = c(paste("Feature assay plot", 1:5), "Reduced dimension plot 1"),
#    Width = c(rep(3, 5), 5))
#  # Feature assay plots
#  fexArg <- featAssayPlotDefaults(cytof, 5)
#  fexArg$XAxis <- "Feature name"
#  fexArg$XAxisFeatName <- c("Cell_length", "CD3", "CD7", "CD3", "CD4")
#  fexArg$YAxisFeatName <- c("CD45", "CD20", "CD45", "CD33", "CD45")
#  fexArg$SelectByPlot <- c("", paste("Feature assay plot", 1:4))
#  fexArg$SelectEffect <- "Restrict"
#  # Reduced dimension plot
#  redArg <- redDimPlotDefaults(cytof, 1)
#  redArg$ColorBy <- "Column data"
#  redArg$ColorByColData <- "population"
#  redArg$SelectByPlot <- "Feature assay plot 5"
#  redArg$SelectEffect <- "Restrict"

## ----iSEE_cytof, eval=FALSE------------------------------------------------
#  iSEE(cytof, initialPanels = initialPanels, featAssayArgs = fexArg, redDimArgs = redArg)

## ----ExperimentHub, eval=FALSE---------------------------------------------
#  stopifnot(
#    require(ExperimentHub),
#    require(SingleCellExperiment),
#    require(irlba),
#    require(Rtsne),
#    requireNamespace("scater")
#  )
#  ehub <- ExperimentHub()
#  eh1 <- ehub[["EH1"]] # an ExpressionSet
#  se1 <- as(eh1, "SummarizedExperiment")
#  sce1 <- as(se1, "SingleCellExperiment")
#  sce1 <- scater::runPCA(sce1, exprs_values = "exprs")
#  irlba_out <- irlba(assay(sce1, "exprs"))
#  tsne_out <- Rtsne(irlba_out$v, pca = FALSE, perplexity = 50, verbose = TRUE)
#  reducedDim(sce1, "TSNE") <- tsne_out$Y

## ----rowData_sce1, eval=FALSE----------------------------------------------
#  num_detected <- rowSums(assay(sce1, "exprs") > 0)
#  rowData(sce1) <- DataFrame(
#    mean_log_exprs = rowMeans(log2(assay(sce1, "exprs") + 1)),
#    num_detected = num_detected,
#    percent_detected = num_detected * 100 / ncol(sce1)
#  )
#  if (interactive()) { iSEE(sce1) }

## ----curl_download, eval=FALSE---------------------------------------------
#  library(curl)
#  rdsURL <- "https://my.file.sharing.website.com/URI?dl=1" # download=true
#  temp_file <- tempfile(pattern = "iSEE_", fileext = ".rds")
#  message("Downloading URL to temporary location: ", temp_file)
#  curl_download(url = rdsURL, destfile = temp_file, quiet = FALSE)
#  sce <- readRDS(temp_file)
#  if (interactive()) { iSEE(sce) }

## ----copy_curl, eval=FALSE-------------------------------------------------
#  newLocation <- "/path/of/your/choice/new_file_name.rds"
#  file.copy(from = temp_file, to = newLocation)

## ----citation--------------------------------------------------------------
citation("iSEE")

## ----sessioninfo-----------------------------------------------------------
sessionInfo()
# devtools::session_info()

