### R code from vignette source 'facopy.Rnw'

###################################################
### code chunk number 1: facopy.Rnw:59-61 (eval = FALSE)
###################################################
## source("http://www.bioconductor.org/biocLite.R")
## biocLite("facopy")


###################################################
### code chunk number 2: facopy.Rnw:66-67
###################################################
library(facopy)


###################################################
### code chunk number 3: facopy.Rnw:80-81
###################################################
getFacopyInfo()


###################################################
### code chunk number 4: facopy.Rnw:86-89
###################################################
# myCalls = readCNData("~/myFolder/", "seqcna")
# myCalls = readCNData("~/myFolder/", "gap", pfbFilename="~/myPfb.pfb")
# myCalls = readCNData("~/myFolder/", "cnanorm", window=50000)


###################################################
### code chunk number 5: facopy.Rnw:94-95
###################################################
data(myCalls)


###################################################
### code chunk number 6: facopy.Rnw:100-105
###################################################
data(myVariables)
class(myVariables)
head(myVariables)

myStudy = addVariables(myCalls, myVariables, c("continuous","categorical"))


###################################################
### code chunk number 7: facopy.Rnw:110-113
###################################################
myStudy = addFeatures(myStudy, "oncogene", "hg18")

summary(myStudy)


###################################################
### code chunk number 8: facopy.Rnw:142-146
###################################################
par(mfrow=c(1,2))
pca1 = plotPCA(myStudy, "any", "age")
pca2 = plotPCA(myStudy, "any", "stage")
head(pca2$eig, 2)


###################################################
### code chunk number 9: facopy.Rnw:163-168
###################################################
variableSummary(myStudy)

head(alterationSummary(myStudy))

variableCor(myStudy)


###################################################
### code chunk number 10: facopy.Rnw:173-175
###################################################
myCallsPreview = preview(myStudy)
sapply(myCallsPreview, head, 1)


###################################################
### code chunk number 11: facopy.Rnw:182-186
###################################################
myArms = c("8q","13q","20q","8p","18q")
myColors = c(rainbow(15)[1:3], rainbow(15)[10:11])

plotBar(myStudy, TRUE, myArms, myColors, ylim=c(-0.4,1))


###################################################
### code chunk number 12: facopy.Rnw:193-194
###################################################
plotHist(myStudy, "amp", "stage", myArms, myColors, bin=0.1, ymax=80)


###################################################
### code chunk number 13: facopy.Rnw:200-201
###################################################
plotZoom(myStudy, "arm", "8p", "del", "stage")


###################################################
### code chunk number 14: facopy.Rnw:206-207
###################################################
plotZoom(myStudy, "feat", "PCM1", "del", "stage")


###################################################
### code chunk number 15: facopy.Rnw:234-241
###################################################
genes = facopy(myStudy, "del", "stage") #1
head(genes[order(genes$p_value),])

genes = facopy(myStudy, "amp", "stage*age", modelPart="predictor") #2
head(genes[order(genes$p_value),])

genes = facopy(myStudy, "amp", "stage", plot=TRUE, db="gsk_colon") #3


###################################################
### code chunk number 16: facopy.Rnw:250-252
###################################################
# eCor = calculateCor(myStudy, "~/myExprData.txt")
# eCor = calculateCor(myStudy, "mrna_merged_median_Zscores", "coadread_tcga_pub")


###################################################
### code chunk number 17: facopy.Rnw:257-258
###################################################
# facopyEnrichment(myStudy, genes, eCor, "~/myFolder/stageAmpEnrichment")


###################################################
### code chunk number 18: facopy.Rnw:288-289
###################################################
sessionInfo() 


