## ----include=FALSE---------------------------------------------------------
library(RTNduals)
data("dt4rtn", package = "RTN")
gexp <- dt4rtn$gexp
annot <- dt4rtn$gexpIDs
tfs <- dt4rtn$tfs[c("IRF8","IRF1","PRDM1","E2F3","STAT4","LMO4","ZNF552")]

## ----eval=FALSE------------------------------------------------------------
#  ##--- load package and dataset for demonstration
#  library(RTNduals)
#  data("dt4rtn", package = "RTN")
#  gexp <- dt4rtn$gexp
#  annot <- dt4rtn$gexpIDs
#  tfs <- dt4rtn$tfs[c("IRF8","IRF1","PRDM1","E2F3","STAT4","LMO4","ZNF552")]

## ----include=FALSE---------------------------------------------------------
##--- generate a pre-processed MBR-class object
rmbr <- mbrPreprocess(gexp=gexp, regulatoryElements=tfs, rowAnnotation=annot, verbose=FALSE)

## ----eval=FALSE------------------------------------------------------------
#  ##--- generate a pre-processed MBR-class object
#  rmbr <- mbrPreprocess(gexp=gexp, regulatoryElements=tfs, rowAnnotation=annot)

## ----include=FALSE---------------------------------------------------------
##--- compute a regulatory network
##--- (set nPermutations>=1000)
rmbr <- mbrPermutation(rmbr, nPermutations=100, pValueCutoff=0.05, verbose=FALSE)

## ----eval=FALSE------------------------------------------------------------
#  ##--- compute a regulatory network
#  ##--- (set nPermutations>=1000)
#  rmbr <- mbrPermutation(rmbr, nPermutations=100, pValueCutoff=0.05)

## ----include=FALSE---------------------------------------------------------
##--- check stability of the regulatory network
##--- (set nBootstrap>=100)
rmbr <- mbrBootstrap(rmbr, nBootstrap=10, verbose=FALSE)

## ----eval=FALSE------------------------------------------------------------
#  ##--- check stability of the regulatory network
#  ##--- (set nBootstrap>=100)
#  rmbr <- mbrBootstrap(rmbr, nBootstrap=10)

## ----include=FALSE---------------------------------------------------------
##---apply DPI algorithm
rmbr <- mbrDpiFilter(rmbr, verbose=FALSE)

## ----eval=FALSE------------------------------------------------------------
#  ##---apply DPI algorithm
#  rmbr <- mbrDpiFilter(rmbr)

## ----include=FALSE---------------------------------------------------------
##--- test associations for dual regulons
rmbr <- mbrAssociation(rmbr, verbose=FALSE)

## ----eval=FALSE------------------------------------------------------------
#  ##--- test associations for dual regulons
#  rmbr <- mbrAssociation(rmbr)

## ----eval=TRUE-------------------------------------------------------------
##--- check summary
mbrGet(rmbr, what="summary")

## ----eval=TRUE-------------------------------------------------------------
##--- get results
overlap <- mbrGet(rmbr, what="dualsOverlap")
correlation <- mbrGet(rmbr, what="dualsCorrelation")

## ----label='Session information', eval=TRUE, echo=FALSE--------------------
sessionInfo()

