
# activatePopover <- function(){
#     txt_histo_M <- paste0("<p>Test",
#                           "test</p><p>Explanation .</p>")
#     
#     txt_histo_MV_per_lines <- paste0("<p>Test",
#                                      "test</p><p>Explanation .</p>")
#     
#     
#     txt_histo_MV_per_lines_per_conditions <- paste0("<p>Test",
#                                                     "test</p><p>Explanation .</p>")
#     
#     
#     addPopover(session, "MVPlots_DS-histo_MV", "Info", 
#                content = txt_histo_M, trigger = 'click')
#     
#     addPopover(session, "MVPlots_DS-histo_MV_per_lines", "Info", 
#                content = txt_histo_MV_per_lines, trigger = 'click')
#     
#     addPopover(session, "MVPlots_DS-histo_MV_per_lines_per_conditions", "Info", 
#                content = txt_histo_MV_per_lines_per_conditions, trigger = 'click')
#     
#     
#     addPopover(session, "MVPlots_filtering-histo_MV", "Info", 
#                content = txt_histo_M, trigger = 'click')
#     
#     addPopover(session, "MVPlots_filtering-histo_MV_per_lines", "Info", 
#                content = txt_histo_MV_per_lines, trigger = 'click')
#     
#     addPopover(session, "MVPlots_filtering-histo_MV_per_lines_per_conditions", "Info", 
#                content = txt_histo_MV_per_lines_per_conditions, trigger = 'click')
#     
#     
# }


# 
# callModule(modulePopover,"modulePopover_toto", data = reactive(paste0(data(), 
#                                                                       a("tidy data paper", 
#                                                                         href = "http://vita.had.co.nz/papers/tidy-data.pdf",
#                                                                         target="_blank"))))



















callModule(modulePopover,"modulePopover_dataset", 
           data = reactive(list(title = p(if(is.null(rv$current.obj.name)) "No dataset" else paste0(rv$current.obj.name)),

                                content="Before each processing step, a backup of the current dataset is stored. It is possible to reload one of them at any time.")))


observe({
    req(input$navbar)
    if (input$navbar=="stop")
        stopApp()
})

getDatasetName <- reactive({
    req(rv$current.obj.name)
    rv$current.obj.name
})


##' Get back to a previous object ---------------------------------------
##' @author Samuel Wieczorek
observeEvent( input$datasets,ignoreInit = TRUE,{ 
    
  
    isolate({
        if (!is.null(input$datasets)) {
            rv$current.obj <- rv$dataset[[input$datasets]]
            
        if (!is.null( rv$current.obj))
            rv$typeOfDataset <- rv$current.obj@experimentData@other$typeOfData
        }
        
    })
})





output$datasetAbsPanel <- renderUI({
    req(rv$current.obj.name)
    div(
        div(
            style="display:inline-block; vertical-align: middle;",
            modulePopoverUI("modulePopover_dataset")),
        div(
            style="display:inline-block; vertical-align: middle;",
            selectInput("datasets", "", choices = list("None"="None"),width = '200px')
        )
    )
})

###-------------------------------------------------------------------
onStop(function() cat("Session stopped\n"))


session$onSessionEnded(function() {
    #setwd(tempdir())
    graphics.off()
    unlink(sessionID, recursive = TRUE)
    unlink(paste(tempdir(), sessionID, commandLogFile, sep="/"),recursive = TRUE)
    unlink(paste(tempdir(), sessionID, sep="/"),recursive = TRUE)
    unlink(paste(tempdir(), "*html", sep="/"))
    unlink("www/*pdf")
    
    #rm(list= list(myListOfThings))
    stopApp()
})


###-------------------------------------------------------------------
ClearUI <- reactive({
        
        #rv$commandLog <- ""
        updateSelectInput(session, 
                          "datasets",  
                          choices = G_noneStr)
        updateRadioButtons(session,"typeOfData",selected = typePeptide )
        updateRadioButtons(session, "checkDataLogged", selected="no")
        updateRadioButtons(session, "autoID", selected = "Auto ID")
        
        updateSelectInput(session, "idBox", selected = NULL)
        
        updateSelectizeInput(session,"eData.box",choices = NULL, selected=NULL)
        updateTextInput(session,"filenameToCreate",value= "")
        updateTextInput(session,"nameExport",value= "")
        
        #UpdateLog("Memory has been cleared","None")
        updateCheckboxInput(session, "replaceAllZeros",value = TRUE)
        updateRadioButtons(session,
                           inputId = "ChooseFilters", 
                           selected = gFilterNone)
        #updateSelectInput(session, "normalization.method",selected = "None")
        # updateSelectInput(session,"type.of.missvalues", selected= "Majoritary" )
        #updateSelectInput(session,"typeImputationMNAR",selected= "QRILC" )
        
    })




loadObjectInMemoryFromConverter_2 <- function(obj){
  rv$typeOfDataset <- obj@experimentData@other$typeOfData
  if (is.null(rv$typeOfDataset)) {rv$typeOfDataset <- ""}
  
  #If there are already pVal values, then do no compute them 
  if (G_logFC_Column %in% names(Biobase::fData(obj) )){
    rv$resAnaDiff <- list(logFC = Biobase::fData(obj)$FC,
                          P_Value = Biobase::fData(obj)$P_Value)
    rv$seuilLogFC <- obj@experimentData@other$threshold_logFC
    rv$seuilPVal  <- obj@experimentData@other$threshold_p_value
    
  }
  
  
  name <- paste ("Original", " - ", rv$typeOfDataset, sep="")
  rv$dataset[[name]] <- obj
  
  
  # txt <- paste("dataset <- list()","\n", "dataset[['", name,"']] <- current.obj","\n","typeOfDataset <- \"",  
  #              rv$typeOfDataset, "\"", "\n",
  #              "colnames(fData(current.obj)) <- gsub(\".\", \"_\", colnames(fData(current.obj)), fixed=TRUE)",
  #              sep="")
  # writeToCommandLogFile(txt)
  # 
  updateSelectInput(session, "datasets", 
                    #label = paste("Dataset versions of", rv$current.obj.name, sep=" "),
                    choices = names(rv$dataset),
                    selected = name)
  
}

#

######################################
loadObjectInMemoryFromConverter <- reactive({
    req(rv$current.obj)
  rv$typeOfDataset <- rv$current.obj@experimentData@other$typeOfData
    if (is.null(rv$typeOfDataset)) {rv$typeOfDataset <- ""}
    
    #If there are already pVal values, then do no compute them 
    if (G_logFC_Column %in% names(Biobase::fData(rv$current.obj) )){
        rv$resAnaDiff <- list(logFC = Biobase::fData(rv$current.obj)$FC,
                              P_Value = Biobase::fData(rv$current.obj)$P_Value)
        rv$seuilLogFC <- rv$current.obj@experimentData@other$threshold_logFC
        rv$seuilPVal  <- rv$current.obj@experimentData@other$threshold_p_value
        
    }
    
    
    name <- paste ("Original", " - ", rv$typeOfDataset, sep="")
    rv$dataset[[name]] <- rv$current.obj
    

        # txt <- paste("dataset <- list()","\n", "dataset[['", name,"']] <- current.obj","\n","typeOfDataset <- \"",  
        #          rv$typeOfDataset, "\"", "\n",
        #          "colnames(fData(current.obj)) <- gsub(\".\", \"_\", colnames(fData(current.obj)), fixed=TRUE)",
        #          sep="")
        # writeToCommandLogFile(txt)
        # 
    
    #if (!is.null(rv$current.obj@experimentData@other$OriginOfValues)){
    #    writeToCommandLogFile("current.obj@experimentData@other$OriginOfValues <- Matrix(as.numeric(!is.na(current.obj)),nrow = nrow(current.obj), sparse=TRUE)")
    #} 
   
    updateSelectInput(session, "datasets", 
                      #label = paste("Dataset versions of", rv$current.obj.name, sep=" "),
                      choices = names(rv$dataset),
                      selected = name)

})

#




###-------------------------------------------------------------------
writeToCommandLogFile <- function(txt, verbose = FALSE){
    rv$commandLog <- c(rv$commandLog, txt)
    # cat(rv$commandLog,
    #     file = paste(tempdir(), sessionID, commandLogFile, sep="/"),
    #     txt,
    #     sep = "\n",
    #     append = TRUE)
    # if (verbose) print(txt)
}

###-------------------------------------------------------------------
dirSessionPath <- paste(tempdir(), sessionID, sep="/")
if (!dir.exists(dirSessionPath)){
    dir.create(dirSessionPath)
}





###-------------------------------------------------------------------
ClearMemory <- function(){
  rv$current.comp = NULL
  
    rv$current.obj = NULL
    rv$current.obj.name = NULL
    rv$deleted.mvLines = NULL
    rv$deleted.stringBased.exprsData = NULL
    rv$deleted.stringBased = NULL
    rv$deleted.stringBased.fData = NULL
    rv$deleted.stringBased = NULL
    rv$DT_filterSummary = data.frame(Filtre=NULL, 
                                     Prefix=NULL,
                                     nbDeleted=NULL, 
                                     Total=NULL, 
                                     stringsAsFactors=F)
    # variable to keep memory of previous datasets before 
    # transformation of the data
    rv$dataset = list()
    # Variable that contains the log for the current R session
    rv$text.log = data.frame(Date="", 
                             Dataset="", 
                             History="", 
                             stringsAsFactors=F)
    rv$listLogFC = list()
    rv$seuilLogFC = 0
    rv$seuilPVal = 1e-60
    rv$tab1 = NULL
    rv$dirname = ""
    rv$dirnameforlink = ""
    rv$conditions = list(cond1 = NULL, cond2 = NULL)
    rv$temp.aggregate = NULL
   rv$calibrationRes = NULL
    rv$errMsgcalibrationPlot = NULL
    rv$errMsgcalibrationPlotALL = NULL
    rv$typeOfDataset = ""
    rv$commandLog =  "" 
    rv$normalizationFamily = NULL
    rv$normalizationMethod = NULL 
    rv$matAdj = NULL
    rv$resAnaDiff = list(FC=NULL, P_Value=NULL, condition1 = NULL, condition2 = NULL)
    rv$res_AllPairwiseComparisons = data.frame()
    rv$indexNA = NULL
    rv$pourcentageNA = 0
    rv$nb.empty.lines = 0
    rv$nbDeleted = 0
    rv$nbDeletedInfos = NULL
    rv$fdr = NULL
    rv$ValidFilteringClicked = FALSE
    rv$ValidImputationClicked = FALSE
    rv$nbTotalAnaDiff = NULL
    rv$nbSelectedAnaDiff = NULL
    rv$nbSelectedTotal_Step3 = NULL
    rv$nbSelected_Step3 = NULL
    rv$GO = list(ProtIDList=NULL,
              gene=NULL,
              proteinsNotMapped=NULL,
              ratio=NULL,
              uniprotID=NULL,
              universeData=NULL,
              enrichGO_data=NULL,
              groupGO_data=NULL)

    rv$impute_Step = 0
    
    
    
    # rv$design = list(designChecked=NULL,
    #                        hot=NULL,
    #                        newOrder=NULL,
    #                        conditionsChecked=NULL,
    #                        designSaved=FALSE)
    
    rv$hot = NULL
    rv$newOrder = NULL
    rv$designChecked = NULL
    rv$designSaved = FALSE
    rv$conditionsChecked = NULL
    
    
    # rv$updateDesign = list(designChecked=NULL,
    #                        hot=NULL,
    #                        newOrder=NULL,
    #                        conditionsChecked=NULL,
    #                        designSaved=FALSE)
    
    
    
    rv$updateDesign_designSaved=FALSE
    rv$updateDesign_designChecked=NULL
    rv$updateDesign_hot=NULL
    rv$updateDesign_newOrder=NULL
    rv$updateDesign_conditionsChecked=NULL
    
    rv$designIsValid = FALSE
    rv$MECIndex = NULL
    rv$tempDatasetImputation = NULL
    rv$text.log <- data.frame(Date="", 
                              Dataset="", 
                              History="", 
                              stringsAsFactors=F)
    rv$GOWarningMessage = NULL
    rv$stringBasedFiltering_Done = FALSE
    rv$iDat = NULL
    rv$imputePlotsSteps = list(step0 = NULL,
                            step1 = NULL,
                            step2 = NULL)
    rv$tempplot = list(Density = NULL,
                       corrMatrix = NULL,
                       varDist = NULL,
                       mvHisto_HC = NULL,
                       mvHisto_perLines_HC = NULL,
                       histo_missvalues_per_lines_per_conditions = NULL)
    rv$PlotParams = list(legDS = NULL,
                         corrMatrixGradient = defaultGradientRate,
                         legDS_Violinplot = NULL,
                        HeatmapLinkage = NULL,
                      HeatmapDistance = NULL
                      )
    rv$indProgressDemomode = 0
    rv$AggregProtStats = data.frame(name = c("Number of peptides",
                                              "Number of specific peptides",
                                              "Number of shared peptides", 
                                              "Number of proteins",
                                              "Number of proteins only defined by specific peptides",
                                              "Number of proteins only defined by shared peptides",
                                              "Number of proteins defined both by shared and specific peptides"),
                                     nb = rep(0,7))
    
    
    
    unlink(paste(tempdir(), sessionID, commandLogFile, sep="/"))
    unlink("www/*pdf")
    
}







#-------------------------------------------------------------
rv <- reactiveValues(
    # variable to handle the current object that will be showed
    current.comp = NULL,
    current.obj = NULL,
    current.obj.name = NULL,
    deleted.mvLines = NULL,
    deleted.stringBased.exprsData = NULL,
    deleted.stringBased.fData = NULL,
    deleted.stringBased = NULL,
    DT_filterSummary = data.frame(Filtre=NULL, 
                                  Prefix=NULL,
                                  nbDeleted=NULL, 
                                  Total=NULL, 
                                  stringsAsFactors=F),
    # variable to keep memory of previous datasets before 
    # transformation of the data
    dataset = list(),
    # Variable that contains the log for the current R session
    text.log = data.frame(Date="", 
                          Dataset="", 
                          History="", 
                          stringsAsFactors=F),
    listLogFC = list(),
    seuilLogFC = 0,
    seuilPVal = 1e-60,
    tab1 = NULL,
    dirname = "",
    dirnameforlink = "",
    conditions = list(cond1 = NULL, cond2 = NULL),
    temp.aggregate = NULL,
    
    
    
    # design = list(designChecked=NULL,
    #                  hot=NULL,
    #                  newOrder=NULL,
    #                  conditionsChecked=NULL,
    #                  designSaved=FALSE),
    
    hot = NULL,
    newOrder = NULL,
    designChecked = NULL,
    designSaved = FALSE,
    conditionsChecked = NULL,
    
    
    
    # updateDesign = list(designChecked=NULL,
    #                        hot=NULL,
    #                        newOrder=NULL,
    #                        conditionsChecked=NULL,
    #                     designSaved=FALSE),
    
    updateDesign_designChecked=NULL,
    updateDesign_hot=NULL,
    updateDesign_newOrder=NULL,
    updateDesign_conditionsChecked=NULL,
    updateDesign_designSaved=FALSE,
    
    
    calibrationRes = NULL,
    errMsgcalibrationPlot = NULL,
    errMsgcalibrationPlotALL = NULL,
    typeOfDataset = "",
    ValidFilteringClicked = FALSE,
    ValidImputationClicked = FALSE,
    commandLog = "", 
    normalizationFamily = NULL,
    normalizationMethod = NULL, 
    matAdj = NULL,
    resAnaDiff = list(FC=NULL, P_Value=NULL, condition1 = NULL, condition2 = NULL),
    res_AllPairwiseComparisons = data.frame(),
    progressImputation = 0,
    indexNA = NULL,
    IP_Client= "",
    pourcentageNA = 0,
    nb.empty.lines = 0,
    nbDeleted = 0,
    nbDeletedInfos = NULL,
    fdr = NULL,
    nbSelectedAnaDiff = NULL,
    nbTotalAnaDiff = NULL,
    nbSelectedTotal_Step3 = NULL,
    nbSelected_Step3 = NULL,
    GO = list(ProtIDList=NULL,
              gene=NULL,
              proteinsNotMapped=NULL,
              ratio=NULL,
              uniprotID=NULL,
              universeData=NULL,
              enrichGO_data=NULL,
              groupGO_data=NULL),

    GOWarningMessage = NULL,

    impute_Step = 0,

    iDat = NULL,
    tempDatasetImputation = NULL,
    MECIndex = NULL,
    stringBasedFiltering_Done = FALSE,
    imputePlotsSteps = list(step0 = NULL,
                            step1 = NULL,
                            step2 = NULL),
    tempplot = list(Density = NULL,
                    corrMatrix = NULL,
                    mvHisto_HC = NULL,
                    mvHisto_perLines_HC = NULL,
                    histo_missvalues_per_lines_per_conditions = NULL),
    PlotParams = list(legDS = NULL,
                      corrMatrixGradient = defaultGradientRate,
                      legDS_Violinplot = NULL,
                      HeatmapLinkage = NULL,
                      HeatmapDistance = NULL
                      
                      ),
    indProgressDemomode = 0,
    AggregProtStats = data.frame(name = c("Number of peptides",
                                              "Number of specific peptides",
                                              "Number of shared peptides", 
                                              "Number of proteins",
                                              "Number of proteins only defined by specific peptides",
                                              "Number of proteins only defined by shared peptides",
                                              "Number of proteins defined both by shared and specific peptides"),
                                     nb = rep(0,7))
    
    )







###-------------------------------------------------------------------
catchToList <- function(expr) {
    val <- NULL
    myWarnings <- NULL
    myErrors <- NULL
    wHandler <- function(w) {
        myWarnings <<- c(myWarnings, w$message)
        invokeRestart("muffleWarning")
    }
    myError <- NULL
    eHandler <- function(e) {
        myError <<- c(myErrors, e$message)
        NULL
    }
    val <- tryCatch(withCallingHandlers(expr, warning = wHandler), 
                    error = eHandler)
    list(value = val, warnings = myWarnings, error=myError)
} 


###-------------------------------------------------------------------
# output$disableAggregationTool <- renderUI({
#     rv$current.obj
# 
#     if (!is.null(rv$current.obj))
#     {
#         if (rv$current.obj@experimentData@other$typeOfData == "protein")
#         {
#     disable(selector = "#navPage li a[data-value=AggregationTab]")
#     tags$style(
# type="text/css","#navPage li a[data-value=AggregationTab] { color:lightgrey;}")
# 
# 
#         } else {
#             enable(selector = "#navPage li a[data-value=AggregationTab]")
# 
#         }
#     }
# 
# })


###-------------------------------------------------------------------
output$CurrentDataset <- renderUI({
    txt <- paste("Current dataset :",input$datasets, sep=" ")
    txt
})



###-------------------------------------------------------------------
GetNbNA <- reactive({
    nb <- sum(is.na(Biobase::exprs(rv$current.obj))==TRUE)
    return(nb)
})



###-------------------------------------------------------------------
output$currentObjLoaded <- reactive({
    rv$current.obj
    return(!is.null(rv$current.obj))})


# 
# observe({
#   req(rv$current.obj)
#   NA.count<- length(which(is.na(Biobase::exprs(rv$current.obj))))
#   if (NA.count == 0){
#     showTab(inputId ="navPage", target = "diffAnalysis")
#   } else {
#     hideTab(inputId ="navPage", target = "diffAnalysis")
#   }
# })


observe({
    rv$current.obj
    
    print(paste0("NeedsUpdate() = ", NeedsUpdate()))
    if (NeedsUpdate()) {
        showTab(inputId ="navPage", target = "updateDesignTab")
        
        hideTab(inputId ="navPage", target = "FilterDataTab")
        hideTab(inputId ="navPage", target = "Normalization")
        hideTab(inputId ="navPage", target = "AggregationTab")
        hideTab(inputId ="navPage", target = "imputationTabs")
        hideTab(inputId ="navPage", target = "diffAnalysisTab")
        hideTab(inputId ="navPage", target = "GOAnalysisTab")
        hideTab(inputId ="navPage", target = "convertTab")
        hideTab(inputId ="navPage", target = "demoTab")
        hideTab(inputId ="navPage", target = "SessionLogsTab")
        
        
    } else {
        hideTab(inputId ="navPage", target = "updateDesignTab")
        
        showTab(inputId ="navPage", target = "FilterDataTab")
        showTab(inputId ="navPage", target = "Normalization")
        showTab(inputId ="navPage", target = "AggregationTab")
        showTab(inputId ="navPage", target = "imputationTabs")
        showTab(inputId ="navPage", target = "diffAnalysisTab")
        showTab(inputId ="navPage", target = "GOAnalysisTab")
        showTab(inputId ="navPage", target = "convertTab")
        showTab(inputId ="navPage", target = "demoTab")
        showTab(inputId ="navPage", target = "SessionLogsTab")
   
    
        if (rv$current.obj@experimentData@other$typeOfData == typeProtein)
            { 
             hideTab(inputId ="navPage", target = "AggregationTab")
            showTab(inputId ="navPage", target = "GOAnalysisTab")
        } else {
            showTab(inputId ="navPage", target = "AggregationTab")
            hideTab(inputId ="navPage", target = "GOAnalysisTab")
        }
    
    
        # hide/show diff Analysis tabPanel
        NA.count<- length(which(is.na(Biobase::exprs(rv$current.obj))))
        if (NA.count == 0){
            showTab(inputId ="navPage", target = "diffAnalysisTab")
        } else {
            hideTab(inputId ="navPage", target = "diffAnalysisTab")
        }
    
    
    
        if (nrow(rv$current.obj) > limitHeatmap)
        { 
            hideTab(inputId ="DS_tabSetPanel", target = "DS_tabHeatmap")
        } else {
            showTab(inputId ="DS_tabSetPanel", target = "DS_tabHeatmap")
         }
    
    
    
    
        nbEmptyLines <- getNumberOfEmptyLines(Biobase::exprs(rv$current.obj))
        if (nbEmptyLines > 0) {
            shinyjs::disable("peptideLevel_perform.imputation.button")
            shinyjs::disable("peptideLevel_ValidImputation")
        } else {
            shinyjs::enable("peptideLevel_perform.imputation.button")
            shinyjs::enable("peptideLevel_ValidImputation")
        }
    
    }
})

