rm(list=ls())
options(shiny.maxRequestSize=300*1024^2) 
require(compiler)
enableJIT(3)

source(file.path("ui", "uiConfigure.R"),  local = TRUE)$value

# initialize data with colnames
df <- data.frame(matrix(c("0","0"), 1, 2))
colnames(df) <- c("Input1", "Input2")



shinyServer(function(input, output, session) {
  
    cat(file=stderr())
    Sys.setlocale("LC_ALL", 'en_GB.UTF-8')
    Sys.setenv("R_ZIPCMD"= Sys.which("zip"))
    sessionID <- Sys.getpid()
    
    
   # unsuspendAll(session)
    

      hideTab(inputId ="navPage", target = "updateDesign")  
      
      
    serverAdmin <- FALSE
    if (isTRUE(serverAdmin)){
        hname <- System$getHostname()
        
        clientdataText <- observe({
            rv$IP_Client = session$clientData$url_hostname
        })
        
        #verbose <- TRUE
        sessionLogFile <- paste("www/sessionLogs_", gsub("\\.", "_", rv$IP_Client), "_", sessionID, ".txt",sep="")
        if (!interactive()) sink(sessionLogFile, type = "output")
    }
    
    env <- environment()
    source(file.path("server", "srv_ModulesSrv.R"),  local = TRUE)$value
    source(file.path("server", "srv_Help.R"),  local = TRUE)$value
    source(file.path("server", "srv_OpenMSnset.R"),  local = TRUE)$value
    source(file.path("server", "srv_General.R"), local = TRUE)$value
    source(file.path("server", "srv_DatasetManager.R"),  local = TRUE)$value
    source(file.path("server", "srv_DescriptiveStats.R"),  local = TRUE)$value
    
    hideTab(inputId ="navPage", target = "updateDesignTab")
     source(file.path("server", "srv_UpdateDesign.R"),  local = TRUE)$value
      source(file.path("server", "srv_BuildDesign.R"),  local = TRUE)$value
      source(file.path("server", "srv_ConvertData.R"),  local = TRUE)$value
      source(file.path("server", "srv_SaveGraphics.R"), local = TRUE)$value
     source(file.path("server", "srv_Filtering.R"),  local = TRUE)$value
      source(file.path("server", "srv_Imputation_ProteinLevel.R"),  local = TRUE)$value
      source(file.path("server", "srv_Imputation_PeptideLevel.R"),  local = TRUE)$value
      source(file.path("server", "srv_Normalization.R"),  local = TRUE)$value
      source(file.path("server", "srv_AnaDiff.R"),  local = TRUE)$value
      source(file.path("server", "srv_Aggregation.R"),  local = TRUE)$value
     source(file.path("server", "srv_GO_enrichment.R"),  local = TRUE)$value
    source(file.path("server", "srv_DemoMode.R"),  local = TRUE)$value
    source(file.path("server", "srv_Export.R"),  local = TRUE)$value
    # 
    outputOptions(output, 'currentObjLoaded', suspendWhenHidden=FALSE)
   # loadLibraries()
    #activatePopover()

    shinyjs::hide("loading_page", anim=FALSE)
    shinyjs::show("main_content", anim=TRUE, animType="fade")
    
    
})
