/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp;

import java.io.Serializable;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionFactory;
import org.biojava.bio.dp.WeightMatrix;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;

public class SimpleWeightMatrix
implements WeightMatrix,
Serializable {
    private static final long serialVersionUID = 73394340224964858L;
    private final Distribution[] columns;
    private final Alphabet alpha;

    public Alphabet getAlphabet() {
        return this.alpha;
    }

    public int columns() {
        return this.columns.length;
    }

    public Distribution getColumn(int column) {
        return this.columns[column];
    }

    public SimpleWeightMatrix(Alphabet alpha, int columns, DistributionFactory dFact) throws IllegalAlphabetException {
        this.alpha = alpha;
        this.columns = new Distribution[columns];
        for (int i = 0; i < columns; ++i) {
            this.columns[i] = dFact.createDistribution(alpha);
        }
    }

    public SimpleWeightMatrix(Distribution[] columns) throws IllegalAlphabetException {
        this.alpha = columns[0].getAlphabet();
        for (int c = 0; c < columns.length; ++c) {
            if (columns[c].getAlphabet() == this.alpha) continue;
            throw new IllegalAlphabetException("All columns must emit the same alphabet. Expecting " + this.alpha.getName() + ", but found " + columns[c].getAlphabet().getName());
        }
        this.columns = columns;
    }

    public int hashCode() {
        int hc = 0;
        for (int c = 0; c < this.columns.length; ++c) {
            hc = 23 * hc + this.columns[c].hashCode();
        }
        return hc;
    }

    public boolean equals(Object o) {
        if (o instanceof WeightMatrix) {
            WeightMatrix wm = (WeightMatrix)o;
            if (wm.columns() != this.columns()) {
                return false;
            }
            if (wm.getAlphabet() != this.getAlphabet()) {
                return false;
            }
            for (int c = 0; c < this.columns(); ++c) {
                if (this.getColumn(c).equals(wm.getColumn(c))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

