/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.synonyms.readers;

import cytoscape.AllTests;
import cytoscape.data.synonyms.Thesaurus;
import cytoscape.data.synonyms.readers.ThesaurusFlatFileReader;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ThesaurusFlatFileReaderTest
extends TestCase {
    public ThesaurusFlatFileReaderTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testReadSmallYeastThesaurus() throws Exception {
        AllTests.standardOut("testReadSmallYeastThesaurus");
        String filename = "testData/yeastSmall.txt";
        ThesaurusFlatFileReader reader = new ThesaurusFlatFileReader(filename);
        Thesaurus thesaurus = reader.getThesaurus();
        ThesaurusFlatFileReaderTest.assertTrue(thesaurus.getSpecies().equals("Saccharomyces cerevisiae"));
        ThesaurusFlatFileReaderTest.assertTrue(thesaurus.nodeLabelCount() == 8);
        String[] canonical = new String[]{"YHR047C", "YBL074C", "YKL106W", "YLR027C", "YGL119W", "YBR236C", "YKL112W", "YMR072W"};
        String[] common = new String[]{"AAP1'", "AAR2", "AAT1", "AAT2", "ABC1", "ABD1", "ABF1", "ABF2"};
        int[] alternateNameCount = new int[]{1, 0, 0, 1, 0, 0, 3, 0};
        for (int i = 0; i < canonical.length; ++i) {
            ThesaurusFlatFileReaderTest.assertTrue(thesaurus.getCommonName(canonical[i]).equals(common[i]));
            ThesaurusFlatFileReaderTest.assertTrue(thesaurus.getNodeLabel(common[i]).equals(canonical[i]));
            String[] alternateNames = thesaurus.getAlternateCommonNames(canonical[i]);
            if (i == 6) {
                String orf = canonical[i];
                ThesaurusFlatFileReaderTest.assertTrue(orf.equals("YKL112W"));
                ThesaurusFlatFileReaderTest.assertTrue(alternateNames[0].equals("BAF1"));
                ThesaurusFlatFileReaderTest.assertTrue(alternateNames[1].equals("OBF1"));
                ThesaurusFlatFileReaderTest.assertTrue(alternateNames[2].equals("REB2"));
            }
            for (int j = 0; j < alternateNames.length; ++j) {
                AllTests.standardOut(canonical[i] + " -> " + alternateNames[j]);
            }
            ThesaurusFlatFileReaderTest.assertTrue(alternateNames.length == alternateNameCount[i]);
        }
    }

    public static void main(String[] args) {
        TestRunner.run(new TestSuite(ThesaurusFlatFileReaderTest.class));
    }
}

