/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.ontology.readers;

import cytoscape.data.ontology.DBReference;
import cytoscape.data.ontology.readers.DBCrossReferenceReader;
import cytoscape.util.URLUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import junit.framework.TestCase;

public class DBCrossReferenceReaderTest
extends TestCase {
    DBCrossReferenceReader rd;

    protected void setUp() throws Exception {
        super.setUp();
        this.rd = new DBCrossReferenceReader();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.rd = null;
    }

    public void testGetXrefMap() {
        try {
            this.rd.readResourceFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Map<String, DBReference> sampleMap = this.rd.getXrefMap();
        DBCrossReferenceReaderTest.assertTrue(sampleMap.size() > 0);
        DBCrossReferenceReaderTest.assertTrue(sampleMap.containsKey("KEGG_PATHWAY"));
        DBCrossReferenceReaderTest.assertTrue(sampleMap.containsKey("AgBase"));
        DBCrossReferenceReaderTest.assertTrue(sampleMap.containsKey("ZFIN"));
        DBReference ref = sampleMap.get("SGD");
        DBCrossReferenceReaderTest.assertEquals("Saccharomyces Genome Database", ref.getFullName());
        try {
            URL url = ref.getGenericURL();
            DBCrossReferenceReaderTest.assertEquals("http://www.yeastgenome.org/", url.toString());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        DBCrossReferenceReaderTest.assertEquals("Identifier for SGD Loci", ref.getObject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String connectToURL(URL url) throws IOException {
        URLConnection uc = URLUtil.getURLConnection(url);
        uc.setReadTimeout(5000);
        StringBuffer sb = new StringBuffer();
        InputStream is = null;
        try {
            is = uc.getInputStream();
            BufferedReader reader = null;
            try {
                String s;
                reader = new BufferedReader(new InputStreamReader(is));
                while ((s = reader.readLine()) != null) {
                    sb.append(s);
                }
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                reader.close();
                throw throwable;
            }
            reader.close();
            Object var10_10 = null;
            if (is == null) return sb.toString();
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (is == null) throw throwable;
            is.close();
            throw throwable;
        }
        is.close();
        return sb.toString();
    }
}

