/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper;

import com.install4j.runtime.installer.helper.Logger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class VariableEncoding {
    private static final String BOOLEAN_SUFFIX = "$Boolean";
    private static final String DATE_SUFFIX = "$Date";
    private static final String INTEGER_SUFFIX = "$Integer";
    private static final String LONG_SUFFIX = "$Long";
    private static final String INT_ARRAY_SUFFIX = "$IntArray";
    private static final String STRING_ARRAY_SUFFIX = "$StringArray";

    public static Map decodeVariables(Properties properties) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            String string3 = string;
            int n = string.indexOf(36);
            if (n > -1) {
                string3 = string.substring(0, n);
            }
            try {
                hashMap.put(string3, VariableEncoding.decodeVariable(string, string2));
            }
            catch (Exception exception) {
                String string4 = "Could not decode variable " + string + ": " + exception.toString();
                Logger.getInstance().error(null, string4);
                System.err.println(string4);
            }
        }
        return hashMap;
    }

    private static Object decodeVariable(String string, String string2) {
        if (string.endsWith(BOOLEAN_SUFFIX)) {
            return new Boolean(string2);
        }
        if (string.endsWith(DATE_SUFFIX)) {
            return new Date(Long.parseLong(string2));
        }
        if (string.endsWith(INTEGER_SUFFIX)) {
            return new Integer(string2);
        }
        if (string.endsWith(LONG_SUFFIX)) {
            return new Long(string2);
        }
        if (string.endsWith(INT_ARRAY_SUFFIX)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            Object object = new StringTokenizer(string2, ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string3 = ((StringTokenizer)object).nextToken();
                arrayList.add(string3.trim());
            }
            object = new int[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                String string4 = (String)arrayList.get(i);
                object[i] = Integer.parseInt(string4);
            }
            return object;
        }
        if (string.endsWith(STRING_ARRAY_SUFFIX)) {
            return VariableEncoding.decodeStringArray(string2);
        }
        return string2;
    }

    private static Object decodeStringArray(String string) {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = null;
        for (int i = 0; i < string.length(); ++i) {
            n = string.charAt(i);
            if (n == 34) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                    continue;
                }
                arrayList.add(stringBuffer.toString());
                stringBuffer = null;
                continue;
            }
            if (n == 92) {
                ++i;
                if (stringBuffer == null) continue;
                stringBuffer.append(string.charAt(i));
                continue;
            }
            if (stringBuffer == null) continue;
            stringBuffer.append((char)n);
        }
        String[] stringArray = new String[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            stringArray[n] = (String)arrayList.get(n);
        }
        return stringArray;
    }

    public static void encodeVariable(Properties properties, String string, Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof String) {
            properties.put(string, object);
        } else if (object instanceof Boolean) {
            properties.put(string + BOOLEAN_SUFFIX, object.toString());
        } else if (object instanceof Date) {
            properties.put(string + DATE_SUFFIX, String.valueOf(((Date)object).getTime()));
        } else if (object instanceof Integer) {
            properties.put(string + INTEGER_SUFFIX, object.toString());
        } else if (object instanceof Long) {
            properties.put(string + LONG_SUFFIX, object.toString());
        } else if (object instanceof int[]) {
            int[] nArray = (int[])object;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < nArray.length; ++i) {
                stringBuffer.append(nArray[i]);
                if (i >= nArray.length - 1) continue;
                stringBuffer.append(",");
            }
            properties.put(string + INT_ARRAY_SUFFIX, stringBuffer.toString());
        } else if (object instanceof String[]) {
            String[] stringArray = (String[])object;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append("\"").append(VariableEncoding.encodeArrayString(stringArray[i])).append("\"");
                if (i >= stringArray.length - 1) continue;
                stringBuffer.append(",");
            }
            properties.put(string + STRING_ARRAY_SUFFIX, stringBuffer.toString());
        }
    }

    private static String encodeArrayString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                stringBuffer.append("\\\"");
                continue;
            }
            if (c == '\\') {
                stringBuffer.append("\\\\");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        Properties properties = new Properties();
        VariableEncoding.encodeVariable(properties, "stringVar", "test\\\"");
        VariableEncoding.encodeVariable(properties, "boolVar", new Boolean(true));
        VariableEncoding.encodeVariable(properties, "integerVar", new Integer(123));
        VariableEncoding.encodeVariable(properties, "dateVar", new Date());
        VariableEncoding.encodeVariable(properties, "intArray", new int[0]);
        VariableEncoding.encodeVariable(properties, "stringArray", new String[0]);
        properties.list(System.out);
        System.out.println("decode");
        Map map = VariableEncoding.decodeVariables(properties);
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            System.out.println(entry.getKey());
            System.out.println(entry.getValue().getClass().getName() + ": " + entry.getValue());
            System.out.println("---------");
        }
    }
}

