### R code from vignette source 'CoGAPSUsersManual.Rnw'

###################################################
### code chunk number 1: GAPSSimpSim
###################################################
library('CoGAPS')
data('SimpSim')
nIter <- 5000
results <- gapsRun(SimpSim.D, SimpSim.S, nFactor=3,
    nEquil=nIter, nSample=nIter)
plotGAPS(results$Amean, results$Pmean, 'ModSimFigs')


###################################################
### code chunk number 2: ModSimPtrue
###################################################
arrayIdx <- 1:ncol(SimpSim.P)
matplot(arrayIdx, t(SimpSim.P), type='l', lwd=10)


###################################################
### code chunk number 3: SimCoGAPS
###################################################
library('CoGAPS')
data('SimpSim')
nIter <- 5000 
results <- CoGAPS(data=SimpSim.D, unc=SimpSim.S, 
      GStoGenes=GSets,
                  nFactor=3,
                  nEquil=nIter, nSample=nIter,
                  plot=FALSE)
plotGAPS(results$Amean, results$Pmean, 'GSFigs')


###################################################
### code chunk number 4: CoGAPSUsersManual.Rnw:266-275 (eval = FALSE)
###################################################
## library('CoGAPS')
## data('GIST_TS_20084')
## data('TFGSList')
## nIter <- 10000 
## results <- CoGAPS(GIST.D, GIST.S, tf2ugFC,
##                   nFactor=5,
##                   nEquil=nIter, nSample=nIter,
##                   plot=FALSE)
## plotGAPS(results$Amean, results$Pmean, 'GISTFigs')


###################################################
### code chunk number 5: CoGAPSUsersManual.Rnw:327-341 (eval = FALSE)
###################################################
## 
## # define transcription factors of interest based on Ochs et al. (2009)
## TFs <- c("c.Jun", 'NF.kappaB', 'Smad4', "STAT3", "Elk.1", "c.Myc", "E2F.1",
##          "AP.1", "CREB", "FOXO", "p53", "Sp1")
## 
## # take the results from the previously run analysis
## # set membership statistics
## permTFStats <- list()
## for (tf in TFs) {
##      genes <- levels(tf2ugFC[,tf])
##      genes <- genes[2:length(genes)]
##      permTFStats[[tf]] <- computeGeneTFProb(Amean = results$Amean,
##                                             Asd = results$Asd, genes)
## }


