## ----load_data-------------------------------------------------------------
library(synlet)
data("exampleDat")
head(exampleDat)

## ----zFactor---------------------------------------------------------------
res <- zFactor(exampleDat, negativeCon = "scrambled control si1", positiveCon = "PLK1 si1")
head(res)

## ----heatmap---------------------------------------------------------------
plateHeatmap(exampleDat)

## --------------------------------------------------------------------------
scatterPlot(exampleDat, controlOnly = FALSE, colour = rainbow(10), "PLK1 si1", "scrambled control si1", "lipid only")

## ----ZPrime----------------------------------------------------------------
zF_mean <- zFactor(exampleDat, negativeCon = "scrambled control si1", positiveCon = "PLK1 si1")
zF_med <- zFactor(exampleDat, negativeCon = "scrambled control si1", positiveCon = "PLK1 si1", useMean = FALSE)

## ----genePlot--------------------------------------------------------------
tem.plot <- siRNAPlot("AAK1", exampleDat, controlsiRNA = c("lipid only", "scrambled control si1"), FILEPATH = ".",  zPrimeMed = zF_med,
          zPrimeMean = zF_mean, treatment = "treatment", control = "control", normMethod = c("PLATE", "lipid only", "scrambled control si1"))

## ----bscore----------------------------------------------------------------
bscore.res <- sapply(as.character(unique(exampleDat$MASTER_PLATE))[1], bScore, exampleDat, control = "control", treatment = "treatment", simplify = FALSE)
head(bscore.res$P001)

## ----t_test----------------------------------------------------------------
bscore.ttest  <- sapply(names(bscore.res), tTest, bscore.res, numTreat = 3, numCont = 3, simplify = FALSE, USE.NAMES = TRUE)
bscore.combined <- data.frame(do.call(rbind, lapply(names(bscore.ttest), function(x) if (!is.null(bscore.ttest[[x]])) {data.frame(MASTER_PLATE = x, siRNAs = rownames(bscore.ttest[[x]]), bscore.ttest[[x]])})))
head(bscore.combined)

## ----madSelection----------------------------------------------------------
madSelection <- sapply(as.character(unique(exampleDat$MASTER_PLATE)), madSelect, exampleDat, control = "control", treatment = "treatment", simplify = FALSE)
madSelection.c <- do.call(rbind, lapply(names(madSelection), function(x) madSelection[[x]]))
head(madSelection.c)

## ----rankProd--------------------------------------------------------------
rankp.res <- sapply(as.character(unique(exampleDat$MASTER_PLATE)), rankProdHits, exampleDat, control = "control", treatment = "treatment", simplify = FALSE)
rankp.c <- data.frame(do.call(rbind, lapply(names(rankp.res), function(x) rankp.res[[x]])))
head(rankp.c)

## ----rsa-------------------------------------------------------------------
rsaHits(exampleDat, treatment = "treatment", control = "control", normMethod = "PLATE", LB = 0.2, UB = 0.8, revHits = FALSE, Bonferroni = FALSE, outputFile = "RSAhits.csv")
rsa.res <- read.delim("RSAhits.csv", check.names = FALSE)
head(rsa.res)

## --------------------------------------------------------------------------
sessionInfo()

