/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.biojava3.core.exceptions.ParserException;
import org.biojava3.core.sequence.features.DBReferenceInfo;
import org.biojava3.core.sequence.features.TextFeature;
import org.biojava3.core.sequence.io.GenericGenbankHeaderParser;
import org.biojava3.core.sequence.io.template.SequenceParserInterface;
import org.biojava3.core.sequence.template.AbstractSequence;
import org.biojava3.core.sequence.template.Compound;

public class GenbankSequenceParser<S extends AbstractSequence<C>, C extends Compound>
implements SequenceParserInterface {
    private String seqData = null;
    private GenericGenbankHeaderParser<S, C> headerParser;
    private String header;
    private String accession;
    public LinkedHashMap<String, ArrayList<DBReferenceInfo>> mapDB;
    private TreeMap<String, TextFeature<AbstractSequence<C>, C>> mapFeature;
    public static final String GENBANK_FORMAT = "GENBANK";
    protected static final String LOCUS_TAG = "LOCUS";
    protected static final String DEFINITION_TAG = "DEFINITION";
    protected static final String ACCESSION_TAG = "ACCESSION";
    protected static final String VERSION_TAG = "VERSION";
    protected static final String KEYWORDS_TAG = "KEYWORDS";
    protected static final String SOURCE_TAG = "SOURCE";
    protected static final String ORGANISM_TAG = "ORGANISM";
    protected static final String REFERENCE_TAG = "REFERENCE";
    protected static final String AUTHORS_TAG = "AUTHORS";
    protected static final String CONSORTIUM_TAG = "CONSRTM";
    protected static final String TITLE_TAG = "TITLE";
    protected static final String JOURNAL_TAG = "JOURNAL";
    protected static final String PUBMED_TAG = "PUBMED";
    protected static final String MEDLINE_TAG = "MEDLINE";
    protected static final String REMARK_TAG = "REMARK";
    protected static final String COMMENT_TAG = "COMMENT";
    protected static final String FEATURE_TAG = "FEATURES";
    protected static final String BASE_COUNT_TAG_FULL = "BASE COUNT";
    protected static final String BASE_COUNT_TAG = "BASE";
    protected static final String START_SEQUENCE_TAG = "ORIGIN";
    protected static final String END_SEQUENCE_TAG = "//";
    protected static final Pattern lp = Pattern.compile("^(\\S+)\\s+\\d+\\s+(bp|aa)\\s{1,4}([dms]s-)?(\\S+)?\\s+(circular|linear)?\\s*(\\S+)?\\s*(\\S+)?$");
    protected static final Pattern vp = Pattern.compile("^(\\S*?)(\\.(\\d+))?(\\s+GI:(\\S+))?$");
    protected static final Pattern refRange = Pattern.compile("^\\s*(\\d+)\\s+to\\s+(\\d+)$");
    protected static final Pattern refp = Pattern.compile("^(\\d+)\\s*(?:(\\((?:bases|residues)\\s+(\\d+\\s+to\\s+\\d+(\\s*;\\s*\\d+\\s+to\\s+\\d+)*)\\))|\\(sites\\))?");
    protected static final Pattern dbxp = Pattern.compile("^([^:]+):(\\S+)$");
    protected static final Pattern sectp = Pattern.compile("^(\\s{0,8}(\\S+)\\s{0,7}(.*)|\\s{21}(/\\S+?)=(.*)|\\s{21}(/\\S+))$");
    protected static final Pattern readableFiles = Pattern.compile(".*(g[bp]k*$|\\u002eg[bp].*)");
    protected static final Pattern headerLine = Pattern.compile("^LOCUS.*");

    private String parse(BufferedReader bufferedReader) {
        String sectionKey = null;
        do {
            List<String[]> section;
            if ((sectionKey = (section = this.readSection(bufferedReader)).get(0)[0]) == null) {
                throw new ParserException("Section key was null");
            }
            if (sectionKey.equals(LOCUS_TAG)) {
                String loc;
                this.header = loc = section.get(0)[1];
                Matcher m = lp.matcher(loc);
                if (m.matches()) {
                    this.headerParser.setName(m.group(1));
                    this.headerParser.setAccession(m.group(1));
                    continue;
                }
                throw new ParserException("Bad locus line");
            }
            if (sectionKey.equals(DEFINITION_TAG)) {
                this.headerParser.setDescription(section.get(0)[1]);
                continue;
            }
            if (sectionKey.equals(ACCESSION_TAG)) {
                String[] accs = section.get(0)[1].split("\\s+");
                this.accession = accs[0].trim();
                this.headerParser.setAccession(this.accession);
                continue;
            }
            if (sectionKey.equals(VERSION_TAG)) {
                String ver = section.get(0)[1];
                Matcher m = vp.matcher(ver);
                if (m.matches()) {
                    String verAcc = m.group(1);
                    if (!this.accession.equals(verAcc)) {
                        this.accession = verAcc;
                    }
                    if (m.group(3) != null) {
                        this.headerParser.setVersion(Integer.parseInt(m.group(3)));
                    }
                    if (m.group(5) == null) continue;
                    this.headerParser.setIdentifier(m.group(5));
                    continue;
                }
                throw new ParserException("Bad version line");
            }
            if (sectionKey.equals(KEYWORDS_TAG) || sectionKey.equals(SOURCE_TAG) || sectionKey.equals(REFERENCE_TAG)) continue;
            if (sectionKey.equals(COMMENT_TAG)) {
                this.headerParser.setComment(section.get(0)[1]);
                continue;
            }
            if (sectionKey.equals(FEATURE_TAG)) {
                boolean skippingBond = false;
                for (int i = 1; i < section.size(); ++i) {
                    String key = section.get(i)[0];
                    String val = section.get(i)[1];
                    if (key.startsWith("/")) {
                        if (skippingBond) continue;
                        key = key.substring(1);
                        if ((val = val.replaceAll("\\s*[\\n\\r]+\\s*", " ").trim()).endsWith("\"")) {
                            val = val.substring(1, val.length() - 1);
                        }
                        if (key.equals("db_xref")) {
                            Matcher m = dbxp.matcher(val);
                            if (m.matches()) {
                                String dbname = m.group(1);
                                String raccession = m.group(2);
                                ArrayList<DBReferenceInfo> listDBEntry = new ArrayList<DBReferenceInfo>();
                                listDBEntry.add(new DBReferenceInfo(dbname, raccession));
                                this.mapDB.put(key, listDBEntry);
                                continue;
                            }
                            throw new ParserException("Bad dbxref");
                        }
                        if (key.equalsIgnoreCase("organism")) {
                            this.mapFeature.put(key, new TextFeature(key, val.replace('\n', ' '), "organism", "organism"));
                            continue;
                        }
                        if (key.equalsIgnoreCase("translation")) {
                            val = val.replaceAll("\\s+", "");
                            this.mapFeature.put(key, new TextFeature(key, val, "translation", "translation"));
                            continue;
                        }
                        this.mapFeature.put(key, new TextFeature(key, val, key, key));
                        continue;
                    }
                    if (key.equalsIgnoreCase("bond")) {
                        skippingBond = true;
                        continue;
                    }
                    skippingBond = false;
                    this.mapFeature.put(key, new TextFeature(key, val, key, key));
                }
            } else {
                if (sectionKey.equals(BASE_COUNT_TAG) || !sectionKey.equals(START_SEQUENCE_TAG)) continue;
                StringBuffer seq = new StringBuffer();
                for (int i = 1; i < section.size(); ++i) {
                    seq.append(section.get(i)[1]);
                }
                this.seqData = seq.toString().replaceAll("\\s+", "").replaceAll("[\\.|~]", "-").toUpperCase();
            }
        } while (!sectionKey.equals(END_SEQUENCE_TAG));
        return this.seqData;
    }

    private List<String[]> readSection(BufferedReader bufferedReader) {
        ArrayList<String[]> section = new ArrayList<String[]>();
        String line = "";
        String currKey = null;
        StringBuffer currVal = new StringBuffer();
        boolean done = false;
        int linecount = 0;
        try {
            while (!done) {
                String firstSecKey;
                bufferedReader.mark(320);
                line = bufferedReader.readLine();
                String string = firstSecKey = section.isEmpty() ? "" : ((String[])section.get(0))[0];
                if (line != null && line.matches("\\p{Space}*")) continue;
                if (line == null || !line.startsWith(" ") && linecount++ > 0 && (!firstSecKey.equals(START_SEQUENCE_TAG) || line.startsWith(END_SEQUENCE_TAG))) {
                    section.add(new String[]{currKey, currVal.toString()});
                    bufferedReader.reset();
                    done = true;
                    continue;
                }
                Matcher m = sectp.matcher(line);
                if (m.matches()) {
                    if (currKey != null) {
                        section.add(new String[]{currKey, currVal.toString()});
                    }
                    currKey = m.group(2) == null ? (m.group(4) == null ? m.group(6) : m.group(4)) : m.group(2);
                    currVal = new StringBuffer();
                    currVal.append((m.group(2) == null ? (m.group(4) == null ? "" : m.group(5)) : m.group(3)).trim());
                    continue;
                }
                if (line.startsWith(START_SEQUENCE_TAG) || line.startsWith(END_SEQUENCE_TAG)) {
                    currKey = line;
                    continue;
                }
                currVal.append("\n");
                currVal.append(currKey.charAt(0) == '/' ? line.substring(21) : line.substring(12));
            }
        }
        catch (IOException e) {
            throw new ParserException(e.getMessage());
        }
        catch (RuntimeException e) {
            throw new ParserException(e.getMessage());
        }
        return section;
    }

    @Override
    public String getSequence(BufferedReader bufferedReader, int sequenceLength) throws Exception {
        this.mapFeature = new TreeMap();
        this.mapDB = new LinkedHashMap();
        this.headerParser = new GenericGenbankHeaderParser();
        this.parse(bufferedReader);
        return this.seqData;
    }

    public String getHeader() {
        return this.header;
    }

    public GenericGenbankHeaderParser<S, C> getSequenceHeaderParser() {
        return this.headerParser;
    }

    public LinkedHashMap<String, ArrayList<DBReferenceInfo>> getDatabaseReferences() {
        return this.mapDB;
    }

    public ArrayList<String> getKeyWords() {
        return new ArrayList<String>(this.mapFeature.keySet());
    }
}

