/*
 * Decompiled with CFR 0.152.
 */
package de.proteinms.xtandemparser.viewer;

import com.compomics.util.gui.spectrum.DefaultSpectrumAnnotation;
import com.compomics.util.gui.spectrum.SpectrumPanel;
import com.compomics.util.protein.Header;
import com.jgoodies.looks.HeaderStyle;
import de.proteinms.xtandemparser.interfaces.Modification;
import de.proteinms.xtandemparser.viewer.FileSelector;
import de.proteinms.xtandemparser.viewer.HelpFrame;
import de.proteinms.xtandemparser.viewer.ParametersDialog;
import de.proteinms.xtandemparser.viewer.ProgressDialog;
import de.proteinms.xtandemparser.viewer.Properties;
import de.proteinms.xtandemparser.viewer.TxtFileFilter;
import de.proteinms.xtandemparser.xtandem.Domain;
import de.proteinms.xtandemparser.xtandem.FixedModification;
import de.proteinms.xtandemparser.xtandem.FragmentIon;
import de.proteinms.xtandemparser.xtandem.Peptide;
import de.proteinms.xtandemparser.xtandem.PeptideMap;
import de.proteinms.xtandemparser.xtandem.Protein;
import de.proteinms.xtandemparser.xtandem.ProteinMap;
import de.proteinms.xtandemparser.xtandem.Spectrum;
import de.proteinms.xtandemparser.xtandem.SupportData;
import de.proteinms.xtandemparser.xtandem.VariableModification;
import de.proteinms.xtandemparser.xtandem.XTandemFile;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.xml.parsers.ParserConfigurationException;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTableHeader;
import org.xml.sax.SAXException;

public class XTandemViewer
extends JFrame {
    private static boolean useErrorLog = true;
    public static final String APPTITLE = "X!Tandem Viewer";
    private static final String MODIFICATIONSLEGEND = "  |  <M *> are fixed and <M $> are variable modifications.";
    private String lastSelectedFolder = "user.home";
    private SpectrumPanel spectrumPanel;
    private String xTandemFile;
    private HashMap<Integer, ArrayList<Peptide>> peptideMap;
    private HashMap<String, String> proteinLabelMap;
    private HashMap<Integer, ArrayList<Double>> allMzValues;
    private HashMap<Integer, ArrayList<Double>> allIntensityValues;
    private HashMap<String, ArrayList<Modification>> allFixMods;
    private HashMap<String, ArrayList<Modification>> allVarMods;
    private HashMap<String, FragmentIon[]> ionsMap;
    private HashMap<Integer, String> accMap;
    private Vector spectraTableColToolTips;
    private Vector spectrumTableColToolTips;
    private Vector spectrumJXTableColToolTips;
    private Vector identificationsJXTableColumnToolTips;
    private HashMap<String, Vector<DefaultSpectrumAnnotation>> allAnnotations;
    private JCheckBox aIonsJCheckBox;
    private JCheckBox bIonsJCheckBox;
    private JCheckBox cIonsJCheckBox;
    private JCheckBox chargeOneJCheckBox;
    private JCheckBox chargeTwoJCheckBox;
    private JCheckBox chargeOverTwoJCheckBox;
    private JCheckBox xIonsJCheckBox;
    private JCheckBox yIonsJCheckBox;
    private JCheckBox zIonsJCheckBox;
    private JLabel modificationDetailsJLabel;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane3;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JXTable identificationsTable;
    private JXTable spectraTable;
    private JXTable spectrumJXTable;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel spectrumJPanel;
    private double fragmentIonMassAccuracy = 0.5;
    private ProgressDialog progressDialog;
    private JMenuItem openMenuItem;
    private JMenuItem exitMenuItem;
    private JMenuItem aboutMenuItem;
    private JMenuItem helpMenuItem;
    private JMenuItem exportSpectraTableMenuItem;
    private JMenuItem exportAllIdentificationsMenuItem;
    private JMenuItem exportAllSpectraMenuItem;
    private JMenuItem exportSelectedSpectrumMenuItem;
    private XTandemFile iXTandemFile;
    private JMenuItem fragmentIonMassAccuracyMenuItem;

    public XTandemViewer(String aXTandemXmlFile, String lastSelectedFolder) {
        if (useErrorLog && !this.getJarFilePath().equalsIgnoreCase(".")) {
            try {
                String path = "" + this.getClass().getProtectionDomain().getCodeSource().getLocation();
                if (path.startsWith("file:")) {
                    path = path.substring("file:".length(), path.lastIndexOf("/"));
                }
                path = path + "/resources/conf/ErrorLog.txt";
                path = path.replace("%20", " ");
                File file = new File(path);
                System.setOut(new PrintStream(new FileOutputStream(file, true)));
                System.setErr(new PrintStream(new FileOutputStream(file, true)));
                if (!file.exists()) {
                    file.createNewFile();
                    FileWriter w = new FileWriter(file);
                    BufferedWriter bw = new BufferedWriter(w);
                    bw.close();
                    w.close();
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "An error occured when trying to create the ErrorLog.See ../resources/conf/ErrorLog.txt for more details.", "Error Creating ErrorLog", 0);
                e.printStackTrace();
            }
        }
        this.constructMenu();
        this.initComponents();
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/xtandemviewer.gif")));
        this.spectraTable.getColumn((Object)" ").setMaxWidth(35);
        this.spectraTable.getColumn((Object)" ").setMinWidth(35);
        this.spectraTable.getColumn((Object)"m/z").setMaxWidth(65);
        this.spectraTable.getColumn((Object)"m/z").setMinWidth(65);
        this.spectraTable.getColumn((Object)"Charge").setMaxWidth(65);
        this.spectraTable.getColumn((Object)"Charge").setMinWidth(65);
        this.spectraTable.getColumn((Object)"Identified").setMaxWidth(80);
        this.spectraTable.getColumn((Object)"Identified").setMinWidth(80);
        this.spectrumJXTable.getColumn((Object)" ").setMaxWidth(35);
        this.spectrumJXTable.getColumn((Object)" ").setMinWidth(35);
        this.identificationsTable.getColumn((Object)" ").setMaxWidth(35);
        this.identificationsTable.getColumn((Object)" ").setMinWidth(35);
        this.identificationsTable.getColumn((Object)"Start").setMaxWidth(45);
        this.identificationsTable.getColumn((Object)"Start").setMinWidth(45);
        this.identificationsTable.getColumn((Object)"End").setMaxWidth(45);
        this.identificationsTable.getColumn((Object)"End").setMinWidth(45);
        this.identificationsTable.getColumn((Object)"Exp. Mass").setMaxWidth(75);
        this.identificationsTable.getColumn((Object)"Exp. Mass").setMinWidth(75);
        this.identificationsTable.getColumn((Object)"Theo. Mass").setMaxWidth(75);
        this.identificationsTable.getColumn((Object)"Theo. Mass").setMinWidth(75);
        this.identificationsTable.getColumn((Object)"E-value").setMinWidth(75);
        this.identificationsTable.getColumn((Object)"E-value").setMaxWidth(75);
        this.identificationsTable.getColumn((Object)"Accession").setPreferredWidth(10);
        this.spectraTable.getTableHeader().setReorderingAllowed(false);
        this.spectrumJXTable.getTableHeader().setReorderingAllowed(false);
        this.identificationsTable.getTableHeader().setReorderingAllowed(false);
        this.spectraTableColToolTips = new Vector();
        this.spectraTableColToolTips.add("Spectrum Number");
        this.spectraTableColToolTips.add("Spectrum File Name");
        this.spectraTableColToolTips.add("Precursor Mass Over Charge Ratio");
        this.spectraTableColToolTips.add("Precursor Charge");
        this.spectraTableColToolTips.add("Spectrum Identified");
        this.spectrumTableColToolTips = new Vector();
        this.spectrumTableColToolTips.add(null);
        this.spectrumTableColToolTips.add("Mass Over Charge Ratio");
        this.spectrumTableColToolTips.add("Intensity");
        this.spectrumJXTableColToolTips = new Vector();
        this.spectrumJXTableColToolTips.add(null);
        this.spectrumJXTableColToolTips.add("Mass Over Charge Ratio");
        this.spectrumJXTableColToolTips.add("Intensity");
        this.identificationsJXTableColumnToolTips = new Vector();
        this.identificationsJXTableColumnToolTips.add("Spectrum Number");
        this.identificationsJXTableColumnToolTips.add("Peptide Sequence");
        this.identificationsJXTableColumnToolTips.add("Modified Peptide Sequence");
        this.identificationsJXTableColumnToolTips.add("Peptide Start Index");
        this.identificationsJXTableColumnToolTips.add("Peptide End Index");
        this.identificationsJXTableColumnToolTips.add("Experimental Mass");
        this.identificationsJXTableColumnToolTips.add("Theoretical Mass");
        this.identificationsJXTableColumnToolTips.add("E-value");
        this.identificationsJXTableColumnToolTips.add("Protein Accession Number");
        this.identificationsJXTableColumnToolTips.add("Protein Description");
        this.setMinimumSize(new Dimension(900, 600));
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        this.insertFiles(aXTandemXmlFile, lastSelectedFolder);
    }

    private String getJarFilePath() {
        String path = this.getClass().getResource("XTandemViewer.class").getPath();
        if (path.lastIndexOf("/xtandem-parser-") != -1) {
            path = path.startsWith("file:") ? path.substring("file:".length(), path.lastIndexOf("/xtandem-parser-")) : path.substring(0, path.lastIndexOf("/xtandem-parser-"));
            path = path.replace("%20", " ");
        } else {
            path = ".";
        }
        return path;
    }

    private void constructMenu() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.putClientProperty("jgoodies.headerStyle", HeaderStyle.SINGLE);
        menuBar.putClientProperty("Plastic.is3D", Boolean.FALSE);
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('F');
        JMenu exportMenu = new JMenu("Export");
        exportMenu.setMnemonic('E');
        JMenu parameterMenu = new JMenu("Parameters");
        parameterMenu.setMnemonic('P');
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic('H');
        menuBar.add(fileMenu);
        menuBar.add(exportMenu);
        menuBar.add(parameterMenu);
        menuBar.add(helpMenu);
        this.openMenuItem = new JMenuItem();
        this.exitMenuItem = new JMenuItem();
        this.helpMenuItem = new JMenuItem();
        this.aboutMenuItem = new JMenuItem();
        this.exportSpectraTableMenuItem = new JMenuItem();
        this.exportAllIdentificationsMenuItem = new JMenuItem();
        this.exportAllSpectraMenuItem = new JMenuItem();
        this.exportSelectedSpectrumMenuItem = new JMenuItem();
        this.fragmentIonMassAccuracyMenuItem = new JMenuItem();
        this.fragmentIonMassAccuracyMenuItem.setMnemonic('I');
        this.fragmentIonMassAccuracyMenuItem.setText("Fragment Ion Mass Accuracy");
        this.fragmentIonMassAccuracyMenuItem.setToolTipText("Set the fragment ion mass accuracy");
        this.fragmentIonMassAccuracyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XTandemViewer.this.fragmentIonMassAccuracyMenuItemActionPerformed(evt);
            }
        });
        parameterMenu.add(this.fragmentIonMassAccuracyMenuItem);
        this.exportSpectraTableMenuItem.setMnemonic('T');
        this.exportSpectraTableMenuItem.setText("Spectra Files Table");
        this.exportSpectraTableMenuItem.setToolTipText("Export the Spectra Files Table as Tab Delimited Text File");
        this.exportSpectraTableMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XTandemViewer.this.exportSpectraFilesTable(evt);
            }
        });
        exportMenu.add(this.exportSpectraTableMenuItem);
        this.exportAllIdentificationsMenuItem.setMnemonic('I');
        this.exportAllIdentificationsMenuItem.setText("All Identifications (all hits)");
        this.exportAllIdentificationsMenuItem.setToolTipText("Export All Identifications (all hits) as Tab Delimited Text File");
        this.exportAllIdentificationsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XTandemViewer.this.exportAllIdentifications(evt);
            }
        });
        exportMenu.add(this.exportAllIdentificationsMenuItem);
        this.exportSelectedSpectrumMenuItem.setMnemonic('S');
        this.exportSelectedSpectrumMenuItem.setText("Selected Spectrum");
        this.exportSelectedSpectrumMenuItem.setToolTipText("Export the Selected Spectrum as Tab Delimited Text File");
        this.exportSelectedSpectrumMenuItem.setEnabled(false);
        this.exportSelectedSpectrumMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XTandemViewer.this.exportSelectedSpectrum(evt);
            }
        });
        exportMenu.add(this.exportSelectedSpectrumMenuItem);
        this.exportAllSpectraMenuItem.setMnemonic('S');
        this.exportAllSpectraMenuItem.setText("All Spectra");
        this.exportAllSpectraMenuItem.setToolTipText("Export all the Spectra as DTA Files");
        this.exportAllSpectraMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XTandemViewer.this.exportAllSpectra(evt);
            }
        });
        exportMenu.add(this.exportAllSpectraMenuItem);
        this.helpMenuItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.helpMenuItem.setMnemonic('H');
        this.helpMenuItem.setText("Help");
        this.helpMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XTandemViewer.this.helpTriggered();
            }
        });
        helpMenu.add(this.helpMenuItem);
        this.aboutMenuItem.setMnemonic('a');
        this.aboutMenuItem.setText("About");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XTandemViewer.this.aboutTriggered();
            }
        });
        helpMenu.add(this.aboutMenuItem);
        this.openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 3));
        this.openMenuItem.setMnemonic('O');
        this.openMenuItem.setText("Open");
        this.openMenuItem.setToolTipText("Open a New X!Tandem XML File");
        this.openMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XTandemViewer.this.openActionPerformed(evt);
            }
        });
        fileMenu.add(this.openMenuItem);
        this.exitMenuItem.setMnemonic('x');
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.setToolTipText("Exit XTandem Viewer");
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                System.exit(0);
            }
        });
        fileMenu.add(this.exitMenuItem);
        this.setJMenuBar(menuBar);
    }

    private void fragmentIonMassAccuracyMenuItemActionPerformed(ActionEvent evt) {
        new ParametersDialog(this, true);
    }

    private void helpTriggered() {
        this.setCursor(new Cursor(3));
        new HelpFrame(this, this.getClass().getResource("/html/help.html"));
        this.setCursor(new Cursor(0));
    }

    private void aboutTriggered() {
        StringBuffer tMsg = new StringBuffer();
        tMsg.append("X!Tandem Viewer " + new Properties().getVersion());
        tMsg.append("\n");
        tMsg.append("\n");
        tMsg.append("The XTandem parser is a Java project for extracting information from X!Tandem output xml files.");
        tMsg.append("\n");
        tMsg.append("\n");
        tMsg.append("The latest version is available at http://xtandem-parser.googlecode.com");
        tMsg.append("\n");
        tMsg.append("\n");
        tMsg.append("If any questions arise, contact the corresponding author: ");
        tMsg.append("\n");
        tMsg.append("Thilo.Muth@uni-jena.de");
        tMsg.append("\n");
        tMsg.append("\n");
        tMsg.append("");
        tMsg.append("");
        JOptionPane.showMessageDialog(this, tMsg, "About X!Tandem Viewer " + new Properties().getVersion(), 1);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.spectraTable = new JXTable(){

            protected JXTableHeader createDefaultTableHeader() {
                return new JXTableHeader(this.columnModel){

                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        String tip = (String)XTandemViewer.this.spectraTableColToolTips.get(realIndex);
                        return tip;
                    }
                };
            }
        };
        this.jPanel2 = new JPanel();
        this.modificationDetailsJLabel = new JLabel();
        JLabel jLabel1 = new JLabel();
        JScrollPane jScrollPane4 = new JScrollPane();
        this.identificationsTable = new JXTable(){

            protected JXTableHeader createDefaultTableHeader() {
                return new JXTableHeader(this.columnModel){

                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        String tip = (String)XTandemViewer.this.identificationsJXTableColumnToolTips.get(realIndex);
                        return tip;
                    }
                };
            }
        };
        this.jPanel3 = new JPanel();
        this.spectrumJPanel = new JPanel();
        this.jPanel4 = new JPanel();
        this.aIonsJCheckBox = new JCheckBox();
        this.bIonsJCheckBox = new JCheckBox();
        this.cIonsJCheckBox = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.yIonsJCheckBox = new JCheckBox();
        this.xIonsJCheckBox = new JCheckBox();
        this.zIonsJCheckBox = new JCheckBox();
        this.jSeparator2 = new JSeparator();
        this.chargeOneJCheckBox = new JCheckBox();
        this.chargeTwoJCheckBox = new JCheckBox();
        this.chargeOverTwoJCheckBox = new JCheckBox();
        this.jScrollPane1 = new JScrollPane();
        this.spectrumJXTable = new JXTable(){

            protected JXTableHeader createDefaultTableHeader() {
                return new JXTableHeader(this.columnModel){

                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        String tip = (String)XTandemViewer.this.spectrumJXTableColToolTips.get(realIndex);
                        return tip;
                    }
                };
            }
        };
        this.setDefaultCloseOperation(3);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Spectra Files"));
        this.spectraTable.setModel((TableModel)new DefaultTableModel(new Object[0][], new String[]{" ", "Filename", "m/z", "Charge", "Identified"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class, String.class, Double.class, Integer.class, Boolean.class};
                this.canEdit = new boolean[]{false, false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.spectraTable.setOpaque(false);
        this.spectraTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                XTandemViewer.this.spectraJXTableKeyReleased(evt);
            }
        });
        this.spectraTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                XTandemViewer.this.spectraJXTableMouseClicked(evt);
            }
        });
        this.jScrollPane3.setViewportView((Component)this.spectraTable);
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane3, -1, 460, Short.MAX_VALUE).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jScrollPane3, -1, 383, Short.MAX_VALUE).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Identifications"));
        this.modificationDetailsJLabel.setFont(this.modificationDetailsJLabel.getFont().deriveFont(this.modificationDetailsJLabel.getFont().getStyle() | 0));
        jLabel1.setFont(jLabel1.getFont().deriveFont(jLabel1.getFont().getStyle() | 0));
        jLabel1.setText("Legend:   ");
        this.identificationsTable.setModel((TableModel)new DefaultTableModel(new Object[0][], new String[]{" ", "Sequence", "Modified Sequence", "Start", "End", "Exp. Mass", "Theo. Mass", "E-value", "Accession", "Description"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class, String.class, String.class, Integer.class, Integer.class, Double.class, Double.class, Float.class, Float.class, String.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.identificationsTable.setOpaque(false);
        jScrollPane4.setViewportView((Component)this.identificationsTable);
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)jLabel1).addPreferredGap(0).add((Component)this.modificationDetailsJLabel)).add(2, (Component)jScrollPane4, -1, 1146, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)jScrollPane4, -1, 90, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)jLabel1).add((Component)this.modificationDetailsJLabel))));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Spectrum"));
        this.spectrumJPanel.setBorder(BorderFactory.createEtchedBorder());
        this.spectrumJPanel.setLayout(new BoxLayout(this.spectrumJPanel, 2));
        this.aIonsJCheckBox.setSelected(true);
        this.aIonsJCheckBox.setText("a");
        this.aIonsJCheckBox.setToolTipText("Show a-ions");
        this.aIonsJCheckBox.setMaximumSize(new Dimension(39, 23));
        this.aIonsJCheckBox.setMinimumSize(new Dimension(39, 23));
        this.aIonsJCheckBox.setPreferredSize(new Dimension(39, 23));
        this.aIonsJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XTandemViewer.this.aIonsJCheckBoxActionPerformed(evt);
            }
        });
        this.bIonsJCheckBox.setSelected(true);
        this.bIonsJCheckBox.setText("b");
        this.bIonsJCheckBox.setToolTipText("Show b-ions");
        this.bIonsJCheckBox.setMaximumSize(new Dimension(39, 23));
        this.bIonsJCheckBox.setMinimumSize(new Dimension(39, 23));
        this.bIonsJCheckBox.setPreferredSize(new Dimension(39, 23));
        this.bIonsJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XTandemViewer.this.bIonsJCheckBoxActionPerformed();
            }
        });
        this.cIonsJCheckBox.setSelected(true);
        this.cIonsJCheckBox.setText("c");
        this.cIonsJCheckBox.setToolTipText("Show c-ions");
        this.cIonsJCheckBox.setMaximumSize(new Dimension(39, 23));
        this.cIonsJCheckBox.setMinimumSize(new Dimension(39, 23));
        this.cIonsJCheckBox.setPreferredSize(new Dimension(39, 23));
        this.cIonsJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XTandemViewer.this.cIonsJCheckBoxActionPerformed();
            }
        });
        this.yIonsJCheckBox.setSelected(true);
        this.yIonsJCheckBox.setText("y");
        this.yIonsJCheckBox.setToolTipText("Show y-ions");
        this.yIonsJCheckBox.setMaximumSize(new Dimension(39, 23));
        this.yIonsJCheckBox.setMinimumSize(new Dimension(39, 23));
        this.yIonsJCheckBox.setPreferredSize(new Dimension(39, 23));
        this.yIonsJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XTandemViewer.this.yIonsJCheckBoxActionPerformed();
            }
        });
        this.xIonsJCheckBox.setSelected(true);
        this.xIonsJCheckBox.setText("x");
        this.xIonsJCheckBox.setToolTipText("Show x-ions");
        this.xIonsJCheckBox.setMaximumSize(new Dimension(39, 23));
        this.xIonsJCheckBox.setMinimumSize(new Dimension(39, 23));
        this.xIonsJCheckBox.setPreferredSize(new Dimension(39, 23));
        this.xIonsJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XTandemViewer.this.xIonsJCheckBoxActionPerformed();
            }
        });
        this.zIonsJCheckBox.setSelected(true);
        this.zIonsJCheckBox.setText("z");
        this.zIonsJCheckBox.setToolTipText("Show z-ions");
        this.zIonsJCheckBox.setMaximumSize(new Dimension(39, 23));
        this.zIonsJCheckBox.setMinimumSize(new Dimension(39, 23));
        this.zIonsJCheckBox.setPreferredSize(new Dimension(39, 23));
        this.zIonsJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XTandemViewer.this.zIonsJCheckBoxActionPerformed();
            }
        });
        this.chargeOneJCheckBox.setSelected(true);
        this.chargeOneJCheckBox.setText("+");
        this.chargeOneJCheckBox.setToolTipText("Show ions with charge 1");
        this.chargeOneJCheckBox.setMaximumSize(new Dimension(39, 23));
        this.chargeOneJCheckBox.setMinimumSize(new Dimension(39, 23));
        this.chargeOneJCheckBox.setPreferredSize(new Dimension(39, 23));
        this.chargeOneJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XTandemViewer.this.chargeOneJCheckBoxActionPerformed();
            }
        });
        this.chargeTwoJCheckBox.setSelected(true);
        this.chargeTwoJCheckBox.setText("++");
        this.chargeTwoJCheckBox.setToolTipText("Show ions with charge 2");
        this.chargeTwoJCheckBox.setMaximumSize(new Dimension(39, 23));
        this.chargeTwoJCheckBox.setMinimumSize(new Dimension(39, 23));
        this.chargeTwoJCheckBox.setPreferredSize(new Dimension(39, 23));
        this.chargeTwoJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XTandemViewer.this.chargeTwoJCheckBoxActionPerformed();
            }
        });
        this.chargeOverTwoJCheckBox.setSelected(true);
        this.chargeOverTwoJCheckBox.setText(">2");
        this.chargeOverTwoJCheckBox.setToolTipText("Show ions with charge >2");
        this.chargeOverTwoJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XTandemViewer.this.chargeOverTwoJCheckBoxActionPerformed();
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout((Container)this.jPanel4);
        this.jPanel4.setLayout((LayoutManager)jPanel4Layout);
        jPanel4Layout.setHorizontalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((Component)this.yIonsJCheckBox, -1, 44, Short.MAX_VALUE).add(2, (GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((Component)this.chargeOneJCheckBox, -1, 42, Short.MAX_VALUE).add(2, 2, 2)).add(2, (Component)this.zIonsJCheckBox, -1, 44, Short.MAX_VALUE).add((Component)this.xIonsJCheckBox, -1, 44, Short.MAX_VALUE).add(2, (GroupLayout.Group)jPanel4Layout.createParallelGroup(1, false).add(2, (Component)this.chargeTwoJCheckBox, -1, -1, Short.MAX_VALUE).add(2, (Component)this.chargeOverTwoJCheckBox, -2, 44, -2)).add((Component)this.bIonsJCheckBox, -1, 44, Short.MAX_VALUE).add((Component)this.aIonsJCheckBox, -1, 44, Short.MAX_VALUE).add((Component)this.cIonsJCheckBox, -1, 44, Short.MAX_VALUE).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((Component)this.jSeparator2, -1, 34, Short.MAX_VALUE).addContainerGap()).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((Component)this.jSeparator1, -1, 34, Short.MAX_VALUE).addContainerGap()))));
        jPanel4Layout.setVerticalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().addContainerGap().add((Component)this.aIonsJCheckBox, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.bIonsJCheckBox, -1, 24, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.cIonsJCheckBox, -1, 24, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.jSeparator1, -2, -1, -2).add(13, 13, 13).add((Component)this.xIonsJCheckBox, -1, 24, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.yIonsJCheckBox, -1, 24, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.zIonsJCheckBox, -1, -1, Short.MAX_VALUE).add(12, 12, 12).add((Component)this.jSeparator2, -2, 8, -2).addPreferredGap(0).add((Component)this.chargeOneJCheckBox, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.chargeTwoJCheckBox, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.chargeOverTwoJCheckBox, -1, -1, Short.MAX_VALUE).add(13, 13, 13)));
        this.spectrumJXTable.setModel((TableModel)new DefaultTableModel(new Object[0][], new String[]{" ", "m/z", "Intensity"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class, Integer.class, Integer.class};
                this.canEdit = new boolean[]{false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.spectrumJXTable.setOpaque(false);
        this.jScrollPane1.setViewportView((Component)this.spectrumJXTable);
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(2).add((Component)this.jScrollPane1, -1, 632, Short.MAX_VALUE).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)this.spectrumJPanel, -1, 578, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jPanel4, -2, 48, -2))).addContainerGap()));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.spectrumJPanel, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel4, -1, -1, Short.MAX_VALUE)).addPreferredGap(1).add((Component)this.jScrollPane1, -1, 97, Short.MAX_VALUE).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel1, -2, -1, -2).add(18, 18, 18).add((Component)this.jPanel3, -1, -1, Short.MAX_VALUE)).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel3, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.jPanel2, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    void insertFiles(String aXTandemFile, String lastSelectedFolder) {
        this.xTandemFile = aXTandemFile;
        this.progressDialog = new ProgressDialog(this);
        this.lastSelectedFolder = lastSelectedFolder;
        this.setTitle("X!Tandem Viewer " + new Properties().getVersion() + "  ---  " + new File(this.xTandemFile).getPath());
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                XTandemViewer.this.progressDialog.setTitle("Parsing XML File. Please Wait...");
                XTandemViewer.this.progressDialog.setIndeterminate(true);
                XTandemViewer.this.progressDialog.setVisible(true);
            }
        }, "ProgressDialog");
        t.start();
        new Thread("ParserThread"){

            @Override
            public void run() {
                XTandemViewer.this.spectraTable.setSortable(false);
                while (XTandemViewer.this.spectraTable.getModel().getRowCount() > 0) {
                    ((DefaultTableModel)XTandemViewer.this.spectraTable.getModel()).removeRow(0);
                }
                while (XTandemViewer.this.spectrumJXTable.getModel().getRowCount() > 0) {
                    ((DefaultTableModel)XTandemViewer.this.spectrumJXTable.getModel()).removeRow(0);
                }
                while (XTandemViewer.this.identificationsTable.getModel().getRowCount() > 0) {
                    ((DefaultTableModel)XTandemViewer.this.identificationsTable.getModel()).removeRow(0);
                }
                XTandemViewer.this.modificationDetailsJLabel.setText("");
                while (XTandemViewer.this.spectrumJPanel.getComponents().length > 0) {
                    XTandemViewer.this.spectrumJPanel.remove(0);
                }
                XTandemViewer.this.spectrumJPanel.validate();
                XTandemViewer.this.spectrumJPanel.repaint();
                try {
                    XTandemViewer.this.iXTandemFile = new XTandemFile(XTandemViewer.this.xTandemFile);
                }
                catch (OutOfMemoryError error) {
                    Runtime.getRuntime().gc();
                    JOptionPane.showMessageDialog(null, "The task used up all the available memory and had to be stopped.\nMemory boundaries are set in ../Properties/JavaOptions.txt.", "Out of Memory Error", 0);
                    error.printStackTrace();
                    System.exit(0);
                }
                catch (SAXException saxException) {
                    saxException.getMessage();
                    JOptionPane.showMessageDialog(null, "Error during parsing the xml file!\n" + saxException.getMessage() + "\n" + "Please verify the file format.", "Parser error", 0);
                    System.exit(0);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    parserConfigurationException.getMessage();
                    JOptionPane.showMessageDialog(null, "Error during parsing the xml file!\n" + parserConfigurationException.getMessage() + "\n" + "Please verify the file format.", "Parser error", 0);
                    System.exit(0);
                }
                XTandemViewer.this.peptideMap = new HashMap();
                XTandemViewer.this.proteinLabelMap = new HashMap();
                XTandemViewer.this.accMap = new HashMap();
                XTandemViewer.this.allMzValues = new HashMap();
                XTandemViewer.this.allIntensityValues = new HashMap();
                XTandemViewer.this.allFixMods = new HashMap();
                XTandemViewer.this.allVarMods = new HashMap();
                XTandemViewer.this.ionsMap = new HashMap();
                Iterator iter = XTandemViewer.this.iXTandemFile.getSpectraIterator();
                PeptideMap pepMap = XTandemViewer.this.iXTandemFile.getPeptideMap();
                ProteinMap protMap = XTandemViewer.this.iXTandemFile.getProteinMap();
                while (iter.hasNext()) {
                    Spectrum spectrum = (Spectrum)iter.next();
                    int spectrumNumber = spectrum.getSpectrumNumber();
                    ArrayList<Peptide> pepList = pepMap.getAllPeptides(spectrumNumber);
                    for (Peptide peptide : pepList) {
                        List<Domain> domainList = peptide.getDomains();
                        for (Domain domain : domainList) {
                            Protein protein = protMap.getProtein(domain.getProteinKey());
                            if (protein != null) {
                                String protAccession = protein.getDescription() != null ? protein.getDescription() : protein.getLabel();
                                XTandemViewer.this.proteinLabelMap.put(domain.getDomainKey(), protAccession);
                            }
                            ArrayList<Modification> fixModList = XTandemViewer.this.iXTandemFile.getModificationMap().getFixedModifications(domain.getDomainKey());
                            ArrayList<Modification> varModList = XTandemViewer.this.iXTandemFile.getModificationMap().getVariableModifications(domain.getDomainKey());
                            XTandemViewer.this.allFixMods.put(domain.getDomainKey(), fixModList);
                            XTandemViewer.this.allVarMods.put(domain.getDomainKey(), varModList);
                            Vector IonVector = XTandemViewer.this.iXTandemFile.getFragmentIonsForPeptide(peptide, domain, XTandemViewer.this.fragmentIonMassAccuracy);
                            for (int i = 0; i < IonVector.size(); ++i) {
                                FragmentIon[] ions = (FragmentIon[])IonVector.get(i);
                                XTandemViewer.this.ionsMap.put(domain.getDomainKey() + "_" + i, ions);
                            }
                        }
                    }
                    SupportData supportData = XTandemViewer.this.iXTandemFile.getSupportData(spectrumNumber);
                    XTandemViewer.this.peptideMap.put(spectrumNumber, pepList);
                    String label = supportData.getFragIonSpectrumDescription();
                    int precursorCharge = spectrum.getPrecursorCharge();
                    double precursorMh = spectrum.getPrecursorMh();
                    String accession = spectrum.getLabel();
                    boolean identified = !pepList.isEmpty();
                    XTandemViewer.this.accMap.put(spectrumNumber, accession);
                    ((DefaultTableModel)XTandemViewer.this.spectraTable.getModel()).addRow(new Object[]{spectrumNumber, label, precursorMh, precursorCharge, identified});
                    ArrayList<Double> mzValues = supportData.getXValuesFragIonMass2Charge();
                    ArrayList<Double> intensityValues = supportData.getYValuesFragIonMass2Charge();
                    XTandemViewer.this.allMzValues.put(spectrumNumber, mzValues);
                    XTandemViewer.this.allIntensityValues.put(spectrumNumber, intensityValues);
                }
                XTandemViewer.this.spectraTable.setSortable(true);
                XTandemViewer.this.progressDialog.setVisible(false);
                XTandemViewer.this.progressDialog.dispose();
                if (XTandemViewer.this.spectraTable.getRowCount() > 0) {
                    XTandemViewer.this.spectraTable.setRowSelectionInterval(0, 0);
                    XTandemViewer.this.spectraJXTableMouseClicked(null);
                }
            }
        }.start();
    }

    private Vector<DefaultSpectrumAnnotation> filterAnnotations(Vector<DefaultSpectrumAnnotation> annotations) {
        Vector<DefaultSpectrumAnnotation> filteredAnnotations = new Vector<DefaultSpectrumAnnotation>();
        for (int i = 0; i < annotations.size(); ++i) {
            String currentLabel = annotations.get(i).getLabel();
            boolean useAnnotation = true;
            if (currentLabel.lastIndexOf("a") != -1) {
                if (!this.aIonsJCheckBox.isSelected()) {
                    useAnnotation = false;
                }
            } else if (currentLabel.lastIndexOf("b") != -1) {
                if (!this.bIonsJCheckBox.isSelected()) {
                    useAnnotation = false;
                }
            } else if (currentLabel.lastIndexOf("c") != -1) {
                if (!this.cIonsJCheckBox.isSelected()) {
                    useAnnotation = false;
                }
            } else if (currentLabel.lastIndexOf("x") != -1) {
                if (!this.xIonsJCheckBox.isSelected()) {
                    useAnnotation = false;
                }
            } else if (currentLabel.lastIndexOf("y") != -1) {
                if (!this.yIonsJCheckBox.isSelected()) {
                    useAnnotation = false;
                }
            } else if (currentLabel.lastIndexOf("z") != -1 && !this.zIonsJCheckBox.isSelected()) {
                useAnnotation = false;
            }
            if (useAnnotation) {
                if (currentLabel.lastIndexOf("+") == -1) {
                    if (!this.chargeOneJCheckBox.isSelected()) {
                        useAnnotation = false;
                    }
                } else if (currentLabel.lastIndexOf("+++") != -1) {
                    if (!this.chargeOverTwoJCheckBox.isSelected()) {
                        useAnnotation = false;
                    }
                } else if (currentLabel.lastIndexOf("++") != -1 && !this.chargeTwoJCheckBox.isSelected()) {
                    useAnnotation = false;
                }
            }
            if (!useAnnotation) continue;
            filteredAnnotations.add(annotations.get(i));
        }
        return filteredAnnotations;
    }

    private void openActionPerformed(ActionEvent evt) {
        new FileSelector(this, APPTITLE);
    }

    private void bIonsJCheckBoxActionPerformed() {
        this.aIonsJCheckBoxActionPerformed(null);
    }

    private void cIonsJCheckBoxActionPerformed() {
        this.aIonsJCheckBoxActionPerformed(null);
    }

    private void yIonsJCheckBoxActionPerformed() {
        this.aIonsJCheckBoxActionPerformed(null);
    }

    private void xIonsJCheckBoxActionPerformed() {
        this.aIonsJCheckBoxActionPerformed(null);
    }

    private void zIonsJCheckBoxActionPerformed() {
        this.aIonsJCheckBoxActionPerformed(null);
    }

    private void chargeOneJCheckBoxActionPerformed() {
        this.aIonsJCheckBoxActionPerformed(null);
    }

    private void chargeTwoJCheckBoxActionPerformed() {
        this.aIonsJCheckBoxActionPerformed(null);
    }

    private void chargeOverTwoJCheckBoxActionPerformed() {
        this.aIonsJCheckBoxActionPerformed(null);
    }

    private void aIonsJCheckBoxActionPerformed(ActionEvent evt) {
        if (this.identificationsTable.getRowCount() > 0) {
            int selectedRow = 0;
            if (this.identificationsTable.getRowCount() > 1 && this.identificationsTable.getSelectedRow() != -1) {
                selectedRow = this.identificationsTable.getSelectedRow();
            }
            Vector<DefaultSpectrumAnnotation> currentAnnotations = this.allAnnotations.get(this.identificationsTable.getValueAt(selectedRow, 1) + "_" + this.identificationsTable.getValueAt(selectedRow, 7));
            this.spectrumPanel.setAnnotations(this.filterAnnotations(currentAnnotations));
            this.spectrumPanel.validate();
            this.spectrumPanel.repaint();
        }
    }

    private void spectraJXTableKeyReleased(KeyEvent evt) {
        this.spectraJXTableMouseClicked(null);
    }

    private void spectraJXTableMouseClicked(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        int row = this.spectraTable.getSelectedRow();
        if (row != -1) {
            List mzValues = this.allMzValues.get((Integer)this.spectraTable.getValueAt(row, 0));
            List intensityValues = this.allIntensityValues.get((Integer)this.spectraTable.getValueAt(row, 0));
            while (this.spectrumJXTable.getRowCount() > 0) {
                ((DefaultTableModel)this.spectrumJXTable.getModel()).removeRow(0);
            }
            this.spectrumJXTable.scrollRectToVisible(this.spectrumJXTable.getCellRect(0, 0, false));
            while (this.spectrumJPanel.getComponents().length > 0) {
                this.spectrumJPanel.remove(0);
            }
            double[] mzValuesAsDouble = new double[mzValues.size()];
            double[] intensityValuesAsDouble = new double[mzValues.size()];
            for (int i = 0; i < mzValues.size(); ++i) {
                ((DefaultTableModel)this.spectrumJXTable.getModel()).addRow(new Object[]{i + 1, mzValues.get(i), intensityValues.get(i)});
                mzValuesAsDouble[i] = (Double)mzValues.get(i);
                intensityValuesAsDouble[i] = (Double)intensityValues.get(i);
            }
            this.exportSelectedSpectrumMenuItem.setEnabled(true);
            this.spectrumPanel = new SpectrumPanel(mzValuesAsDouble, intensityValuesAsDouble, (Double)this.spectraTable.getValueAt(row, 2), "" + this.spectraTable.getValueAt(row, 3), (String)this.spectraTable.getValueAt(row, 1), 60, false);
            this.spectrumJPanel.add(this.spectrumPanel);
            this.spectrumJPanel.validate();
            this.spectrumJPanel.repaint();
            while (this.identificationsTable.getRowCount() > 0) {
                ((DefaultTableModel)this.identificationsTable.getModel()).removeRow(0);
            }
            this.allAnnotations = new HashMap();
            this.modificationDetailsJLabel.setText("");
            if (this.peptideMap.get((Integer)this.spectraTable.getValueAt(row, 0)) != null) {
                ArrayList<Peptide> pepList = this.peptideMap.get((Integer)this.spectraTable.getValueAt(row, 0));
                Iterator<Peptide> pepIter = pepList.iterator();
                String modificationDetails = "";
                while (pepIter.hasNext()) {
                    Peptide peptide = pepIter.next();
                    List<Domain> domainList = peptide.getDomains();
                    for (Domain domain : domainList) {
                        int j;
                        int modIndex;
                        int[] modRes;
                        int i;
                        String sequence = domain.getDomainSequence();
                        String[] modifications = new String[sequence.length()];
                        for (int i2 = 0; i2 < modifications.length; ++i2) {
                            modifications[i2] = "";
                        }
                        String modifiedSequence = "";
                        String nTerminal = "";
                        String cTerminal = "";
                        ArrayList<Modification> fixedModList = this.allFixMods.get(domain.getDomainKey());
                        ArrayList<Modification> varModList = this.allVarMods.get(domain.getDomainKey());
                        if (fixedModList != null) {
                            for (i = 0; i < fixedModList.size(); ++i) {
                                FixedModification fixMod = (FixedModification)fixedModList.get(i);
                                modRes = new int[domain.getDomainSequence().length()];
                                modIndex = Integer.parseInt(fixMod.getLocation()) - domain.getDomainStart();
                                modRes[modIndex] = fixMod.getNumber();
                                for (j = 0; j < modRes.length; ++j) {
                                    if (modRes[j] <= 0) continue;
                                    int n = j;
                                    modifications[n] = modifications[n] + "<M" + modRes[j] + "*" + ">";
                                }
                            }
                        }
                        if (varModList != null) {
                            for (i = 0; i < varModList.size(); ++i) {
                                VariableModification varMod = (VariableModification)varModList.get(i);
                                modRes = new int[domain.getDomainSequence().length()];
                                modIndex = Integer.parseInt(varMod.getLocation()) - domain.getDomainStart();
                                modRes[modIndex] = varMod.getNumber();
                                for (j = 0; j < modRes.length; ++j) {
                                    if (modRes[j] <= 0) continue;
                                    int n = j;
                                    modifications[n] = modifications[n] + "<M" + modRes[j] + "$" + ">";
                                }
                            }
                        }
                        for (i = 0; i < modifications.length; ++i) {
                            modifiedSequence = modifiedSequence + sequence.substring(i, i + 1);
                            if (modifications[i].equalsIgnoreCase("")) continue;
                            String[] residues = modifications[i].split(">");
                            for (int j2 = 0; j2 < residues.length; ++j2) {
                                String currentMod = residues[j2] + ">";
                                int fixModIndex = 0;
                                int varModIndex = 0;
                                if (currentMod.length() > 0) {
                                    if (currentMod.contains("*")) {
                                        fixModIndex = Integer.parseInt(currentMod.substring(2, 3)) - 1;
                                    } else if (currentMod.contains("$")) {
                                        varModIndex = Integer.parseInt(currentMod.substring(2, 3)) - 1;
                                    }
                                }
                                if (modificationDetails.lastIndexOf(currentMod) == -1) {
                                    if (fixedModList.size() > 0 && currentMod.contains("*")) {
                                        modificationDetails = modificationDetails + currentMod + " " + fixedModList.get(fixModIndex).getName();
                                        if (fixedModList.get(fixModIndex).isSubstitution()) {
                                            modificationDetails = modificationDetails + " Sub. (orignal AA): " + fixedModList.get(fixModIndex).getSubstitutedAminoAcid();
                                        }
                                        modificationDetails = modificationDetails + ", ";
                                    } else if (varModList.size() > 0 && currentMod.contains("$")) {
                                        modificationDetails = modificationDetails + currentMod + " " + varModList.get(varModIndex).getName();
                                        if (varModList.get(varModIndex).isSubstitution()) {
                                            modificationDetails = modificationDetails + " Sub. (orignal AA): " + varModList.get(varModIndex).getSubstitutedAminoAcid();
                                        }
                                        modificationDetails = modificationDetails + ", ";
                                    }
                                    modifiedSequence = modifiedSequence + currentMod;
                                    continue;
                                }
                                modifiedSequence = modifiedSequence + currentMod;
                            }
                        }
                        nTerminal = nTerminal.length() == 0 ? "NH2-" : nTerminal + "-";
                        cTerminal = cTerminal.length() == 0 ? "-COOH" : "-" + cTerminal;
                        int[][] ionCoverage = new int[sequence.length() + 1][12];
                        Vector<DefaultSpectrumAnnotation> currentAnnotations = new Vector<DefaultSpectrumAnnotation>();
                        for (int i3 = 0; i3 < 12; ++i3) {
                            FragmentIon[] ions;
                            for (FragmentIon ion : ions = this.ionsMap.get(domain.getDomainKey() + "_" + i3)) {
                                int ionNumber = ion.getNumber();
                                int ionType = ion.getType();
                                double mzValue = ion.getMZ();
                                Color color = i3 % 2 == 0 ? Color.BLUE : Color.BLACK;
                                if (ionType == 0) {
                                    int[] nArray = ionCoverage[ionNumber];
                                    nArray[0] = nArray[0] + 1;
                                }
                                if (ionType == 2) {
                                    int[] nArray = ionCoverage[ionNumber];
                                    nArray[1] = nArray[1] + 1;
                                }
                                if (ionType == 1) {
                                    int[] nArray = ionCoverage[ionNumber];
                                    nArray[2] = nArray[2] + 1;
                                }
                                if (ionType == 3) {
                                    int[] nArray = ionCoverage[ionNumber];
                                    nArray[3] = nArray[3] + 1;
                                }
                                if (ionType == 5) {
                                    int[] nArray = ionCoverage[ionNumber];
                                    nArray[4] = nArray[4] + 1;
                                }
                                if (ionType == 4) {
                                    int[] nArray = ionCoverage[ionNumber];
                                    nArray[5] = nArray[5] + 1;
                                }
                                if (ionType == 6) {
                                    int[] nArray = ionCoverage[ionNumber];
                                    nArray[6] = nArray[6] + 1;
                                }
                                if (ionType == 7) {
                                    int[] nArray = ionCoverage[ionNumber];
                                    nArray[7] = nArray[7] + 1;
                                }
                                if (ionType == 8) {
                                    int[] nArray = ionCoverage[ionNumber];
                                    nArray[8] = nArray[8] + 1;
                                }
                                if (ionType == 10) {
                                    int[] nArray = ionCoverage[ionNumber];
                                    nArray[9] = nArray[9] + 1;
                                }
                                if (ionType == 9) {
                                    int[] nArray = ionCoverage[ionNumber];
                                    nArray[10] = nArray[10] + 1;
                                }
                                if (ionType == 11) {
                                    int[] nArray = ionCoverage[ionNumber];
                                    nArray[11] = nArray[11] + 1;
                                }
                                String ionDesc = ion.getLetter();
                                if (ionNumber > 0) {
                                    ionDesc = ionDesc + ionNumber;
                                }
                                if (ion.getCharge() > 1.0) {
                                    int j3 = 0;
                                    while ((double)j3 < ion.getCharge()) {
                                        ionDesc = ionDesc + "+";
                                        ++j3;
                                    }
                                }
                                currentAnnotations.add(new DefaultSpectrumAnnotation(mzValue, this.fragmentIonMassAccuracy, color, ionDesc));
                            }
                        }
                        this.allAnnotations.put(sequence + "_" + domain.getDomainExpect(), currentAnnotations);
                        if (this.allAnnotations.size() == 1) {
                            this.spectrumPanel.setAnnotations(this.filterAnnotations(currentAnnotations));
                            this.spectrumPanel.validate();
                            this.spectrumPanel.repaint();
                        }
                        int[][] ionCoverageProcessed = new int[sequence.length()][2];
                        if (ionCoverage[1][3] > 0 || ionCoverage[1][4] > 0 || ionCoverage[1][5] > 0) {
                            ionCoverageProcessed[0][0] = 1;
                        }
                        if (ionCoverage[1][8] > 0 || ionCoverage[1][9] > 0 || ionCoverage[1][10] > 0) {
                            ionCoverageProcessed[ionCoverage.length - 2][1] = 1;
                        }
                        if (ionCoverage[ionCoverage.length - 1][3] > 0 || ionCoverage[ionCoverage.length - 1][4] > 0 || ionCoverage[ionCoverage.length - 1][5] > 0) {
                            ionCoverageProcessed[ionCoverage.length - 2][0] = 1;
                        }
                        if (ionCoverage[ionCoverage.length - 1][8] > 0 || ionCoverage[ionCoverage.length - 1][9] > 0 || ionCoverage[ionCoverage.length - 1][10] > 0) {
                            ionCoverageProcessed[0][1] = 1;
                        }
                        for (int i4 = 2; i4 < ionCoverage.length - 1; ++i4) {
                            ionCoverageProcessed[i4 - 1][0] = ionCoverage[i4][3] > 0 && ionCoverage[i4 - 1][3] > 0 || ionCoverage[i4][4] > 0 && ionCoverage[i4 - 1][4] > 0 || ionCoverage[i4][5] > 0 && ionCoverage[i4 - 1][5] > 0 ? 1 : 0;
                            ionCoverageProcessed[ionCoverage.length - 1 - i4][1] = ionCoverage[i4][8] > 0 && ionCoverage[i4 - 1][8] > 0 || ionCoverage[i4][9] > 0 && ionCoverage[i4 - 1][9] > 0 || ionCoverage[i4][10] > 0 && ionCoverage[i4 - 1][10] > 0 ? 1 : 0;
                        }
                        String modifiedSequenceColorCoded = "<html>";
                        if (!nTerminal.startsWith("<")) {
                            modifiedSequenceColorCoded = modifiedSequenceColorCoded + nTerminal;
                        } else {
                            modifiedSequenceColorCoded = modifiedSequenceColorCoded + "&lt;";
                            modifiedSequenceColorCoded = modifiedSequenceColorCoded + nTerminal.substring(1, nTerminal.length() - 2);
                            modifiedSequenceColorCoded = modifiedSequenceColorCoded + "&gt;-";
                        }
                        int aminoAcidCounter = 0;
                        for (int i5 = 0; i5 < modifiedSequence.length(); ++i5) {
                            if (modifiedSequence.charAt(i5) == '<') {
                                if (ionCoverageProcessed[aminoAcidCounter - 1][0] > 0) {
                                    modifiedSequenceColorCoded = modifiedSequenceColorCoded + "<u>";
                                }
                                if (ionCoverageProcessed[aminoAcidCounter - 1][1] > 0) {
                                    modifiedSequenceColorCoded = modifiedSequenceColorCoded + "<font color=\"red\">";
                                }
                                modifiedSequenceColorCoded = modifiedSequenceColorCoded + "&lt;";
                                ++i5;
                                while (modifiedSequence.charAt(i5) != '>') {
                                    modifiedSequenceColorCoded = modifiedSequenceColorCoded + modifiedSequence.charAt(i5++);
                                }
                                modifiedSequenceColorCoded = modifiedSequenceColorCoded + "&gt;";
                                if (ionCoverageProcessed[aminoAcidCounter - 1][0] > 0) {
                                    modifiedSequenceColorCoded = modifiedSequenceColorCoded + "</u>";
                                }
                                if (ionCoverageProcessed[aminoAcidCounter - 1][1] > 0) {
                                    modifiedSequenceColorCoded = modifiedSequenceColorCoded + "</font>";
                                }
                            } else {
                                if (ionCoverageProcessed[aminoAcidCounter][0] > 0) {
                                    modifiedSequenceColorCoded = modifiedSequenceColorCoded + "<u>";
                                }
                                if (ionCoverageProcessed[aminoAcidCounter][1] > 0) {
                                    modifiedSequenceColorCoded = modifiedSequenceColorCoded + "<font color=\"red\">";
                                }
                                modifiedSequenceColorCoded = modifiedSequenceColorCoded + modifiedSequence.charAt(i5);
                                if (ionCoverageProcessed[aminoAcidCounter][0] > 0) {
                                    modifiedSequenceColorCoded = modifiedSequenceColorCoded + "</u>";
                                }
                                if (ionCoverageProcessed[aminoAcidCounter][1] > 0) {
                                    modifiedSequenceColorCoded = modifiedSequenceColorCoded + "</font>";
                                }
                                ++aminoAcidCounter;
                            }
                            modifiedSequenceColorCoded = modifiedSequenceColorCoded + "<font color=\"black\">";
                        }
                        if (!cTerminal.startsWith("-<")) {
                            modifiedSequenceColorCoded = modifiedSequenceColorCoded + cTerminal;
                        } else {
                            modifiedSequenceColorCoded = modifiedSequenceColorCoded + "-&lt;";
                            modifiedSequenceColorCoded = modifiedSequenceColorCoded + cTerminal.substring(2, cTerminal.length() - 1);
                            modifiedSequenceColorCoded = modifiedSequenceColorCoded + "&gt;";
                        }
                        modifiedSequenceColorCoded = modifiedSequenceColorCoded + "</html>";
                        double theoMass = domain.getDomainMh() + domain.getDomainDeltaMh();
                        Header header = Header.parseFromFASTA(this.proteinLabelMap.get(domain.getDomainKey()));
                        String accession = header.getAccession();
                        String description = header.getDescription();
                        ((DefaultTableModel)this.identificationsTable.getModel()).addRow(new Object[]{(Integer)this.spectraTable.getValueAt(row, 0), sequence, modifiedSequenceColorCoded, domain.getDomainStart(), domain.getDomainEnd(), new Double(domain.getDomainMh()), new Double(theoMass), new Float(domain.getDomainExpect()), accession, description});
                    }
                }
                if (modificationDetails.endsWith(", ")) {
                    modificationDetails = modificationDetails.substring(0, modificationDetails.length() - 2);
                }
                if (modificationDetails.length() > 0) {
                    this.modificationDetailsJLabel.setText(modificationDetails + MODIFICATIONSLEGEND);
                }
                if (this.identificationsTable.getRowCount() > 1) {
                    this.identificationsTable.setRowSelectionInterval(0, 0);
                }
            }
        }
        this.setCursor(new Cursor(0));
    }

    private void exportSpectraFilesTable(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser(this.lastSelectedFolder);
        chooser.setFileFilter(new TxtFileFilter());
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle("Export Spectra File Details");
        int returnVal = chooser.showSaveDialog(this);
        if (returnVal == 0) {
            int option;
            File selectedFile = chooser.getSelectedFile();
            if (!selectedFile.getName().toLowerCase().endsWith(".txt")) {
                selectedFile = new File(selectedFile.getAbsolutePath() + ".txt");
            }
            while (selectedFile.exists() && (option = JOptionPane.showConfirmDialog(this, "The  file " + chooser.getSelectedFile().getName() + " already exists. Replace file?", "Replace File?", 1)) == 1) {
                chooser = new JFileChooser(this.lastSelectedFolder);
                chooser.setFileFilter(new TxtFileFilter());
                chooser.setMultiSelectionEnabled(false);
                chooser.setDialogTitle("Export Spectra File Details");
                returnVal = chooser.showSaveDialog(this);
                if (returnVal == 1) {
                    return;
                }
                selectedFile = chooser.getSelectedFile();
                if (selectedFile.getName().toLowerCase().endsWith(".txt")) continue;
                selectedFile = new File(selectedFile.getAbsolutePath() + ".txt");
            }
            this.setCursor(new Cursor(3));
            try {
                selectedFile = chooser.getSelectedFile();
                if (!selectedFile.getName().toLowerCase().endsWith(".txt")) {
                    selectedFile = new File(selectedFile.getAbsolutePath() + ".txt");
                }
                if (selectedFile.exists()) {
                    selectedFile.delete();
                }
                selectedFile.createNewFile();
                FileWriter f = new FileWriter(selectedFile);
                for (int j = 0; j < this.spectraTable.getColumnCount() - 1; ++j) {
                    f.write(this.spectraTable.getColumnName(j) + "\t");
                }
                f.write(this.spectraTable.getColumnName(this.spectraTable.getColumnCount() - 1) + "\n");
                for (int i = 0; i < this.spectraTable.getRowCount(); ++i) {
                    for (int j = 0; j < this.spectraTable.getColumnCount() - 1; ++j) {
                        f.write(this.spectraTable.getValueAt(i, j) + "\t");
                    }
                    f.write(this.spectraTable.getValueAt(i, this.spectraTable.getColumnCount() - 1) + "\n");
                }
                f.close();
                this.lastSelectedFolder = selectedFile.getPath();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "An error occured when exporting the spectra file details.", "Error Exporting Spectra Files", 0);
                ex.printStackTrace();
            }
            this.setCursor(new Cursor(0));
        }
    }

    private void exportAllIdentifications(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser(this.lastSelectedFolder);
        chooser.setFileFilter(new TxtFileFilter());
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle("Export All Identifications");
        int returnVal = chooser.showSaveDialog(this);
        if (returnVal == 0) {
            int option;
            File selectedFile = chooser.getSelectedFile();
            if (!selectedFile.getName().toLowerCase().endsWith(".txt")) {
                selectedFile = new File(selectedFile.getAbsolutePath() + ".txt");
            }
            while (selectedFile.exists() && (option = JOptionPane.showConfirmDialog(this, "The  file " + chooser.getSelectedFile().getName() + " already exists. Replace file?", "Replace File?", 1)) == 1) {
                chooser = new JFileChooser(this.lastSelectedFolder);
                chooser.setFileFilter(new TxtFileFilter());
                chooser.setMultiSelectionEnabled(false);
                chooser.setDialogTitle("Export All Identifications");
                returnVal = chooser.showSaveDialog(this);
                if (returnVal == 1) {
                    return;
                }
                selectedFile = chooser.getSelectedFile();
                if (selectedFile.getName().toLowerCase().endsWith(".txt")) continue;
                selectedFile = new File(selectedFile.getAbsolutePath() + ".txt");
            }
            this.setCursor(new Cursor(3));
            try {
                selectedFile = chooser.getSelectedFile();
                if (!selectedFile.getName().toLowerCase().endsWith(".txt")) {
                    selectedFile = new File(selectedFile.getAbsolutePath() + ".txt");
                }
                if (selectedFile.exists()) {
                    selectedFile.delete();
                }
                selectedFile.createNewFile();
                FileWriter f = new FileWriter(selectedFile);
                for (int j = 0; j < this.identificationsTable.getColumnCount() - 1; ++j) {
                    if (j == 2) {
                        f.write("Modified Sequence\t");
                        f.write("Ion Coverage\t");
                        continue;
                    }
                    f.write(this.identificationsTable.getColumnName(j) + "\t");
                }
                f.write(this.identificationsTable.getColumnName(this.identificationsTable.getColumnCount() - 1) + "\n");
                Iterator iter = this.iXTandemFile.getSpectraIterator();
                String modificationDetails = "";
                while (iter.hasNext()) {
                    ArrayList<Peptide> pepList = this.peptideMap.get(((Spectrum)iter.next()).getSpectrumNumber());
                    for (Peptide peptide : pepList) {
                        List<Domain> domainList = peptide.getDomains();
                        for (Domain domain : domainList) {
                            int j;
                            int modIndex;
                            int[] modRes;
                            int i;
                            String sequence = domain.getDomainSequence();
                            String[] modifications = new String[sequence.length()];
                            for (int i2 = 0; i2 < modifications.length; ++i2) {
                                modifications[i2] = "";
                            }
                            String modifiedSequence = "";
                            String nTerminal = "";
                            String cTerminal = "";
                            ArrayList<Modification> fixedModList = this.allFixMods.get(domain.getDomainKey());
                            ArrayList<Modification> varModList = this.allVarMods.get(domain.getDomainKey());
                            if (fixedModList != null) {
                                for (i = 0; i < fixedModList.size(); ++i) {
                                    FixedModification fixMod = (FixedModification)fixedModList.get(i);
                                    modRes = new int[domain.getDomainSequence().length()];
                                    modIndex = Integer.parseInt(fixMod.getLocation()) - domain.getDomainStart();
                                    modRes[modIndex] = fixMod.getNumber();
                                    for (j = 0; j < modRes.length; ++j) {
                                        if (modRes[j] <= 0) continue;
                                        int n = j;
                                        modifications[n] = modifications[n] + "<M" + modRes[j] + "*" + ">";
                                    }
                                }
                            }
                            if (varModList != null) {
                                for (i = 0; i < varModList.size(); ++i) {
                                    VariableModification varMod = (VariableModification)varModList.get(i);
                                    modRes = new int[domain.getDomainSequence().length()];
                                    modIndex = Integer.parseInt(varMod.getLocation()) - domain.getDomainStart();
                                    modRes[modIndex] = varMod.getNumber();
                                    for (j = 0; j < modRes.length; ++j) {
                                        if (modRes[j] <= 0) continue;
                                        int n = j;
                                        modifications[n] = modifications[n] + "<M" + modRes[j] + "*" + ">";
                                    }
                                }
                            }
                            for (i = 0; i < modifications.length; ++i) {
                                modifiedSequence = modifiedSequence + sequence.substring(i, i + 1);
                                if (modifications[i].equalsIgnoreCase("")) continue;
                                String[] residues = modifications[i].split(">");
                                for (int j2 = 0; j2 < residues.length; ++j2) {
                                    String currentMod = residues[j2] + ">";
                                    if (modificationDetails.lastIndexOf(currentMod) == -1) {
                                        if (fixedModList.size() > 0) {
                                            modificationDetails = modificationDetails + currentMod + " " + fixedModList.get(j2).getName() + ", ";
                                        } else if (varModList.size() > 0) {
                                            modificationDetails = modificationDetails + currentMod + " " + varModList.get(j2).getName() + ", ";
                                        }
                                        modifiedSequence = modifiedSequence + currentMod;
                                        continue;
                                    }
                                    modifiedSequence = modifiedSequence + currentMod;
                                }
                            }
                            nTerminal = nTerminal.length() == 0 ? "NH2-" : nTerminal + "-";
                            cTerminal = cTerminal.length() == 0 ? "-COOH" : "-" + cTerminal;
                            int[][] ionCoverage = new int[sequence.length() + 1][12];
                            for (int i3 = 0; i3 < 12; ++i3) {
                                FragmentIon[] ions;
                                for (FragmentIon ion : ions = this.ionsMap.get(domain.getDomainKey() + "_" + i3)) {
                                    int ionNumber = ion.getNumber();
                                    int ionType = ion.getType();
                                    double mzValue = ion.getMZ();
                                    Color color = i3 % 2 == 0 ? Color.BLUE : Color.BLACK;
                                    if (ionType == 0) {
                                        int[] nArray = ionCoverage[ionNumber];
                                        nArray[0] = nArray[0] + 1;
                                    }
                                    if (ionType == 2) {
                                        int[] nArray = ionCoverage[ionNumber];
                                        nArray[1] = nArray[1] + 1;
                                    }
                                    if (ionType == 1) {
                                        int[] nArray = ionCoverage[ionNumber];
                                        nArray[2] = nArray[2] + 1;
                                    }
                                    if (ionType == 3) {
                                        int[] nArray = ionCoverage[ionNumber];
                                        nArray[3] = nArray[3] + 1;
                                    }
                                    if (ionType == 5) {
                                        int[] nArray = ionCoverage[ionNumber];
                                        nArray[4] = nArray[4] + 1;
                                    }
                                    if (ionType == 4) {
                                        int[] nArray = ionCoverage[ionNumber];
                                        nArray[5] = nArray[5] + 1;
                                    }
                                    if (ionType == 6) {
                                        int[] nArray = ionCoverage[ionNumber];
                                        nArray[6] = nArray[6] + 1;
                                    }
                                    if (ionType == 7) {
                                        int[] nArray = ionCoverage[ionNumber];
                                        nArray[7] = nArray[7] + 1;
                                    }
                                    if (ionType == 8) {
                                        int[] nArray = ionCoverage[ionNumber];
                                        nArray[8] = nArray[8] + 1;
                                    }
                                    if (ionType == 10) {
                                        int[] nArray = ionCoverage[ionNumber];
                                        nArray[9] = nArray[9] + 1;
                                    }
                                    if (ionType == 9) {
                                        int[] nArray = ionCoverage[ionNumber];
                                        nArray[10] = nArray[10] + 1;
                                    }
                                    if (ionType != 11) continue;
                                    int[] nArray = ionCoverage[ionNumber];
                                    nArray[11] = nArray[11] + 1;
                                }
                            }
                            int[][] ionCoverageProcessed = new int[sequence.length()][2];
                            if (ionCoverage[1][3] > 0 || ionCoverage[1][4] > 0 || ionCoverage[1][5] > 0) {
                                ionCoverageProcessed[0][0] = 1;
                            }
                            if (ionCoverage[1][8] > 0 || ionCoverage[1][9] > 0 || ionCoverage[1][10] > 0) {
                                ionCoverageProcessed[ionCoverage.length - 2][1] = 1;
                            }
                            if (ionCoverage[ionCoverage.length - 1][3] > 0 || ionCoverage[ionCoverage.length - 1][4] > 0 || ionCoverage[ionCoverage.length - 1][5] > 0) {
                                ionCoverageProcessed[ionCoverage.length - 2][0] = 1;
                            }
                            if (ionCoverage[ionCoverage.length - 1][8] > 0 || ionCoverage[ionCoverage.length - 1][9] > 0 || ionCoverage[ionCoverage.length - 1][10] > 0) {
                                ionCoverageProcessed[0][1] = 1;
                            }
                            for (int i4 = 2; i4 < ionCoverage.length - 1; ++i4) {
                                ionCoverageProcessed[i4 - 1][0] = ionCoverage[i4][3] > 0 && ionCoverage[i4 - 1][3] > 0 || ionCoverage[i4][4] > 0 && ionCoverage[i4 - 1][4] > 0 || ionCoverage[i4][5] > 0 && ionCoverage[i4 - 1][5] > 0 ? 1 : 0;
                                ionCoverageProcessed[ionCoverage.length - 1 - i4][1] = ionCoverage[i4][8] > 0 && ionCoverage[i4 - 1][8] > 0 || ionCoverage[i4][9] > 0 && ionCoverage[i4 - 1][9] > 0 || ionCoverage[i4][10] > 0 && ionCoverage[i4 - 1][10] > 0 ? 1 : 0;
                            }
                            String modifiedSequenceColorCoded = "<html>";
                            if (!nTerminal.startsWith("<")) {
                                modifiedSequenceColorCoded = modifiedSequenceColorCoded + nTerminal;
                            } else {
                                modifiedSequenceColorCoded = modifiedSequenceColorCoded + "&lt;";
                                modifiedSequenceColorCoded = modifiedSequenceColorCoded + nTerminal.substring(1, nTerminal.length() - 2);
                                modifiedSequenceColorCoded = modifiedSequenceColorCoded + "&gt;-";
                            }
                            int aminoAcidCounter = 0;
                            for (int i5 = 0; i5 < modifiedSequence.length(); ++i5) {
                                if (modifiedSequence.charAt(i5) == '<') {
                                    if (ionCoverageProcessed[aminoAcidCounter - 1][0] > 0) {
                                        modifiedSequenceColorCoded = modifiedSequenceColorCoded + "<u>";
                                    }
                                    if (ionCoverageProcessed[aminoAcidCounter - 1][1] > 0) {
                                        modifiedSequenceColorCoded = modifiedSequenceColorCoded + "<font color=\"red\">";
                                    }
                                    modifiedSequenceColorCoded = modifiedSequenceColorCoded + "&lt;";
                                    ++i5;
                                    while (modifiedSequence.charAt(i5) != '>') {
                                        modifiedSequenceColorCoded = modifiedSequenceColorCoded + modifiedSequence.charAt(i5++);
                                    }
                                    modifiedSequenceColorCoded = modifiedSequenceColorCoded + "&gt;";
                                    if (ionCoverageProcessed[aminoAcidCounter - 1][0] > 0) {
                                        modifiedSequenceColorCoded = modifiedSequenceColorCoded + "</u>";
                                    }
                                    if (ionCoverageProcessed[aminoAcidCounter - 1][1] > 0) {
                                        modifiedSequenceColorCoded = modifiedSequenceColorCoded + "</font>";
                                    }
                                } else {
                                    if (ionCoverageProcessed[aminoAcidCounter][0] > 0) {
                                        modifiedSequenceColorCoded = modifiedSequenceColorCoded + "<u>";
                                    }
                                    if (ionCoverageProcessed[aminoAcidCounter][1] > 0) {
                                        modifiedSequenceColorCoded = modifiedSequenceColorCoded + "<font color=\"red\">";
                                    }
                                    modifiedSequenceColorCoded = modifiedSequenceColorCoded + modifiedSequence.charAt(i5);
                                    if (ionCoverageProcessed[aminoAcidCounter][0] > 0) {
                                        modifiedSequenceColorCoded = modifiedSequenceColorCoded + "</u>";
                                    }
                                    if (ionCoverageProcessed[aminoAcidCounter][1] > 0) {
                                        modifiedSequenceColorCoded = modifiedSequenceColorCoded + "</font>";
                                    }
                                    ++aminoAcidCounter;
                                }
                                modifiedSequenceColorCoded = modifiedSequenceColorCoded + "<font color=\"black\">";
                            }
                            if (!cTerminal.startsWith("-<")) {
                                modifiedSequenceColorCoded = modifiedSequenceColorCoded + cTerminal;
                            } else {
                                modifiedSequenceColorCoded = modifiedSequenceColorCoded + "-&lt;";
                                modifiedSequenceColorCoded = modifiedSequenceColorCoded + cTerminal.substring(2, cTerminal.length() - 1);
                                modifiedSequenceColorCoded = modifiedSequenceColorCoded + "&gt;";
                            }
                            modifiedSequenceColorCoded = modifiedSequenceColorCoded + "</html>";
                            modifiedSequence = nTerminal + modifiedSequence + cTerminal;
                            double theoMass = domain.getDomainMh() + domain.getDomainDeltaMh();
                            String accession = this.proteinLabelMap.get(domain.getDomainKey());
                            f.write(peptide.getSpectrumNumber() + "\t" + sequence + "\t" + modifiedSequence + "\t" + modifiedSequenceColorCoded + "\t" + domain.getDomainStart() + "\t" + domain.getDomainEnd() + "\t" + new Double(domain.getDomainMh()) + "\t" + theoMass + "\t" + new Float(domain.getDomainExpect()) + "\t" + accession + "\n");
                        }
                    }
                }
                f.close();
                this.lastSelectedFolder = selectedFile.getPath();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "An error occured when exporting the identifications.", "Error Exporting Identifications", 0);
                ex.printStackTrace();
            }
        }
        this.setCursor(new Cursor(0));
    }

    private void exportSelectedSpectrum(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser(this.lastSelectedFolder);
        chooser.setFileFilter(new TxtFileFilter());
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle("Export Selected Spectrum");
        int returnVal = chooser.showSaveDialog(this);
        if (returnVal == 0) {
            int option;
            File selectedFile = chooser.getSelectedFile();
            if (!selectedFile.getName().toLowerCase().endsWith(".txt")) {
                selectedFile = new File(selectedFile.getAbsolutePath() + ".txt");
            }
            while (selectedFile.exists() && (option = JOptionPane.showConfirmDialog(this, "The  file " + chooser.getSelectedFile().getName() + " already exists. Replace file?", "Replace File?", 1)) == 1) {
                chooser = new JFileChooser(this.lastSelectedFolder);
                chooser.setFileFilter(new TxtFileFilter());
                chooser.setMultiSelectionEnabled(false);
                chooser.setDialogTitle("Export Selected Spectrum");
                returnVal = chooser.showSaveDialog(this);
                if (returnVal == 1) {
                    return;
                }
                selectedFile = chooser.getSelectedFile();
                if (selectedFile.getName().toLowerCase().endsWith(".txt")) continue;
                selectedFile = new File(selectedFile.getAbsolutePath() + ".txt");
            }
            this.setCursor(new Cursor(3));
            try {
                selectedFile = chooser.getSelectedFile();
                if (!selectedFile.getName().toLowerCase().endsWith(".txt")) {
                    selectedFile = new File(selectedFile.getAbsolutePath() + ".txt");
                }
                if (selectedFile.exists()) {
                    selectedFile.delete();
                }
                selectedFile.createNewFile();
                FileWriter f = new FileWriter(selectedFile);
                for (int j = 0; j < this.spectrumJXTable.getColumnCount() - 1; ++j) {
                    f.write(this.spectrumJXTable.getColumnName(j) + "\t");
                }
                f.write(this.spectrumJXTable.getColumnName(this.spectrumJXTable.getColumnCount() - 1) + "\n");
                for (int i = 0; i < this.spectrumJXTable.getRowCount(); ++i) {
                    for (int j = 0; j < this.spectrumJXTable.getColumnCount() - 1; ++j) {
                        f.write(this.spectrumJXTable.getValueAt(i, j) + "\t");
                    }
                    f.write(this.spectrumJXTable.getValueAt(i, this.spectrumJXTable.getColumnCount() - 1) + "\n");
                }
                f.close();
                this.lastSelectedFolder = selectedFile.getPath();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "An error occured when exporting the selected spectrum.", "Error Exporting Selected Spectrum", 0);
                ex.printStackTrace();
            }
            this.setCursor(new Cursor(0));
        }
    }

    private void exportAllSpectra(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser(this.lastSelectedFolder);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle("Export All Spectra As DTA Files");
        int returnVal = chooser.showSaveDialog(this);
        if (returnVal == 0) {
            this.setCursor(new Cursor(3));
            File selectedFolder = chooser.getSelectedFile();
            for (int j = 0; j < this.spectraTable.getRowCount(); ++j) {
                List mzValues = this.allMzValues.get((Integer)this.spectraTable.getValueAt(j, 0));
                List intensityValues = this.allIntensityValues.get((Integer)this.spectraTable.getValueAt(j, 0));
                String spectrum = this.spectraTable.getValueAt(j, 1).toString();
                if (spectrum.contains(".")) {
                    spectrum = spectrum.replace(".", "_");
                }
                if (spectrum.contains("|")) {
                    spectrum = spectrum.replace("|", "_");
                }
                spectrum = spectrum.replaceAll("/+", "_");
                spectrum = spectrum.replaceAll("\\+", "_");
                File currentFile = new File(selectedFolder, "" + spectrum + ".dta");
                try {
                    FileWriter f = new FileWriter(currentFile);
                    double precusorMz = (Double)this.spectraTable.getValueAt(j, 2);
                    int precursorCharge = (Integer)this.spectraTable.getValueAt(j, 3);
                    double precursorMh = precusorMz * (double)precursorCharge - (double)precursorCharge * 1.007825 + 1.007825;
                    f.write("" + precursorMh);
                    f.write(" " + precursorCharge + "\n");
                    for (int i = 0; i < mzValues.size(); ++i) {
                        f.write(mzValues.get(i) + " " + intensityValues.get(i) + "\n");
                    }
                    f.close();
                    this.lastSelectedFolder = currentFile.getPath();
                    continue;
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(this, "An error occured when exporting the spectra.", "Error Exporting Spectra", 0);
                    ex.printStackTrace();
                }
            }
            this.setCursor(new Cursor(0));
        }
    }

    public double getFragmentIonMassAccuracy() {
        return this.fragmentIonMassAccuracy;
    }

    public void setFragmentIonMassAccuracy(double fragmentIonMassAccuracy) {
        this.fragmentIonMassAccuracy = fragmentIonMassAccuracy;
    }

    public String getXTandemFile() {
        return this.xTandemFile;
    }
}

