/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.spectrum;

import com.compomics.util.Util;
import com.compomics.util.gui.events.RescalingEvent;
import com.compomics.util.gui.interfaces.SpectrumAnnotation;
import com.compomics.util.gui.interfaces.SpectrumPanelListener;
import com.compomics.util.gui.spectrum.ReferenceArea;
import com.compomics.util.gui.spectrum.SpectrumPanel;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Line2D;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public abstract class GraphicsPanel
extends JPanel {
    private float peakWidth = 1.0f;
    private float backgroundPeakWidth = 1.0f;
    private boolean subscriptAnnotationNumbers = true;
    private Color peakWaterMarkColor = new Color(100, 100, 100, 50);
    private boolean scientificXAxis = false;
    private boolean scientificYAxis = false;
    private String scientificPattern = "##0.#####E0";
    private HashMap<String, ReferenceArea> referenceAreasXAxis = new HashMap();
    private HashMap<String, ReferenceArea> referenceAreasYAxis = new HashMap();
    protected boolean miniature = false;
    protected boolean yDataIsPositive = true;
    protected float alphaLevel = 0.3f;
    protected int dataSetCounter = 0;
    protected int dataSetCounterMirroredSpectra = 0;
    public final int INTERACTIVE_STATUS = 0;
    public final int ANNOTATED_STATUS = 1;
    protected static HashMap<Double, String> iKnownMassDeltas = null;
    private boolean useMassDeltaCombinations = true;
    protected double deltaMassWindow = 0.2;
    protected String iXAxisLabel = "m/z";
    protected String iYAxisLabel = "Int";
    protected Color iFilenameColor = null;
    protected ArrayList<Color> iDataPointAndLineColor = new ArrayList();
    protected ArrayList<Color> iDataPointAndLineColorMirroredSpectra = new ArrayList();
    protected ArrayList<Color> iAreaUnderCurveColor = new ArrayList();
    protected ArrayList<Color> iAreaUnderCurveColorMirroredSpectra = new ArrayList();
    protected Integer iPointSize = 0;
    protected String iFilename = null;
    protected String iFilenameMirrorredSpectrum = null;
    protected ArrayList iSpecPanelListeners = new ArrayList();
    protected int iPointDetectionTolerance = 5;
    protected int iStartXLoc = 0;
    protected int iStartYLoc = 0;
    protected int iEndXLoc = 0;
    protected double xAxisZoomRangeLowerValue = 0.0;
    protected double xAxisZoomRangeUpperValue = 0.0;
    protected int iDragXLoc = 0;
    protected double iXScaleUnit = 0.0;
    protected double iYScaleUnit = 0.0;
    protected int iXUnit = 0;
    protected int iYUnit = 0;
    protected int iXPadding = 0;
    protected int iTopPadding = 0;
    protected boolean iXAxisStartAtZero = true;
    protected boolean iDragged = false;
    protected int xTagCount = 10;
    protected int yTagCount = 10;
    protected int padding = 20;
    protected int currentPadding = 20;
    protected int maxPadding = 50;
    protected boolean showFileName = true;
    protected boolean showPrecursorDetails = true;
    protected boolean showResolution = true;
    protected ArrayList<double[]> iXAxisData = null;
    protected ArrayList<double[]> iXAxisDataMirroredSpectrum = null;
    protected double iXAxisMin = 0.0;
    protected double iXAxisMax = 0.0;
    protected double iYAxisMin = 0.0;
    protected double iYAxisMax = 0.0;
    protected double iAnnotationYAxisThreshold = 0.0;
    protected ArrayList<double[]> iYAxisData = null;
    protected ArrayList<double[]> iYAxisDataMirroredSpectrum = null;
    protected double iPrecursorMZ = 0.0;
    protected double iPrecursorMZMirroredSpectrum = 0.0;
    protected String iPrecursorCharge = null;
    protected String iPrecursorChargeMirorredSpectrum = null;
    protected ArrayList<int[]> iXAxisDataInPixels = null;
    protected ArrayList<int[]> iYAxisDataInPixels = null;
    protected ArrayList<int[]> iXAxisDataInPixelsMirroredSpectrum = null;
    protected ArrayList<int[]> iYAxisDataInPixelsMirroredSpectrum = null;
    protected boolean iHighLight = false;
    protected int iHighLightIndex = 0;
    protected int iHighLightDatasetIndex = 0;
    protected boolean iClicked = false;
    protected int iClickedIndex = 0;
    protected int iClickedDataSetIndex = 0;
    protected Vector iClickedList = new Vector(15, 5);
    protected Vector iClickedListDatasetIndices = new Vector(15, 5);
    protected Vector iStoredSequence = new Vector(15, 5);
    protected Vector iStoredSequenceDatasetIndices = new Vector(15, 5);
    protected Vector iAnnotations = new Vector(50, 20);
    protected int iMinDrag = 15;
    protected DrawingStyle iCurrentDrawStyle = DrawingStyle.LINES;
    protected int iDotRadius = 2;
    protected int iMSLevel = 0;
    protected boolean showAllPeaks = true;
    protected boolean yAxisZoomExcludesBackgroundPeaks = false;
    protected GraphicsPanelType currentGraphicsPanelType = GraphicsPanelType.centroidSpectrum;

    public boolean isSubscriptAnnotationNumbers() {
        return this.subscriptAnnotationNumbers;
    }

    public void setSubscriptAnnotationNumbers(boolean subscriptAnnotationNumbers) {
        this.subscriptAnnotationNumbers = subscriptAnnotationNumbers;
    }

    public boolean yAxisZoomOnlyExcludesBackgroundPeaks() {
        return this.yAxisZoomExcludesBackgroundPeaks;
    }

    public void setYAxisZoomExcludesBackgroundPeaks(boolean yAxisZoomExcludesBackgroundPeaks) {
        this.yAxisZoomExcludesBackgroundPeaks = yAxisZoomExcludesBackgroundPeaks;
    }

    public boolean useMassDeltaCombinations() {
        return this.useMassDeltaCombinations;
    }

    public void setUseMassDeltaCombinations(boolean useMassDeltaCombinations) {
        this.useMassDeltaCombinations = useMassDeltaCombinations;
    }

    public boolean showPrecursorDetails() {
        return this.showPrecursorDetails;
    }

    public void setShowPrecursorDetails(boolean showPrecursorDetails) {
        this.showPrecursorDetails = showPrecursorDetails;
    }

    public boolean showResolution() {
        return this.showResolution;
    }

    public void setShowResolution(boolean showResolution) {
        this.showResolution = showResolution;
    }

    public boolean yDataIsPositive() {
        return this.yDataIsPositive;
    }

    public void setYDataIsPositive(boolean yDataIsPositive) {
        this.yDataIsPositive = yDataIsPositive;
    }

    public boolean isMiniature() {
        return this.miniature;
    }

    public void setMiniature(boolean miniature) {
        this.miniature = miniature;
    }

    public double getXAxisZoomRangeLowerValue() {
        return this.xAxisZoomRangeLowerValue;
    }

    public double getXAxisZoomRangeUpperValue() {
        return this.xAxisZoomRangeUpperValue;
    }

    public double getDeltaMassWindow() {
        return this.deltaMassWindow;
    }

    public void setDeltaMassWindow(double deltaMassWindow) {
        this.deltaMassWindow = deltaMassWindow;
    }

    public static HashMap<Double, String> getKnownMassDeltas() {
        return iKnownMassDeltas;
    }

    public static void setKnownMassDeltas(HashMap<Double, String> aiKnownMassDeltas) {
        iKnownMassDeltas = aiKnownMassDeltas;
    }

    public ArrayList<double[]> getXAxisData() {
        return this.iXAxisData;
    }

    public ArrayList<double[]> getYAxisData() {
        return this.iYAxisData;
    }

    public float getAlphaLevel() {
        return this.alphaLevel;
    }

    public void setAlphaLevel(float alphaLevel) {
        this.alphaLevel = alphaLevel;
    }

    public void setXAxisStartAtZero(boolean aXAxisStartAtZero) {
        this.iXAxisStartAtZero = aXAxisStartAtZero;
    }

    public void setMaxPadding(int aMaxPadding) {
        this.maxPadding = aMaxPadding;
    }

    public int getMaxPadding() {
        return this.maxPadding;
    }

    public float getPeakWidth() {
        return this.peakWidth;
    }

    public void setPeakWidth(float peakWidth) {
        this.peakWidth = peakWidth;
    }

    public float getBackgroundPeakWidth() {
        return this.backgroundPeakWidth;
    }

    public void setBackgroundPeakWidth(float backgroundPeakWidth) {
        this.backgroundPeakWidth = backgroundPeakWidth;
    }

    public void setAnnotations(List<SpectrumAnnotation> aAnnotations) {
        this.iAnnotations = new Vector(50, 25);
        if (aAnnotations != null) {
            HashSet<String> removeDupes = new HashSet<String>(aAnnotations.size());
            for (SpectrumAnnotation annotation : aAnnotations) {
                String key = annotation.getLabel() + annotation.getMZ();
                if (removeDupes.contains(key)) continue;
                removeDupes.add(key);
                this.iAnnotations.add(annotation);
            }
        }
    }

    public void setAnnotationYAxisThreshold(double aThreshold) {
        this.iAnnotationYAxisThreshold = aThreshold / 100.0 * this.iYAxisMax;
    }

    public void setFilenameColor(Color aFilenameColor) {
        this.iFilenameColor = aFilenameColor;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.iXAxisData != null) {
            int secondDataSetIndex;
            int first;
            int i;
            int liClickedSize;
            if (this.iDragged && this.iDragXLoc > 0) {
                g.drawLine(this.iStartXLoc, this.iStartYLoc, this.iDragXLoc, this.iStartYLoc);
                g.drawLine(this.iStartXLoc, this.iStartYLoc - 2, this.iStartXLoc, this.iStartYLoc + 2);
                g.drawLine(this.iDragXLoc, this.iStartYLoc - 2, this.iDragXLoc, this.iStartYLoc + 2);
            }
            this.iXAxisMin = (int)Math.floor(this.iXAxisMin);
            this.iXAxisMax = (int)Math.ceil(this.iXAxisMax);
            this.iYAxisMin = (int)Math.floor(this.iYAxisMin);
            this.iYAxisMax = (int)Math.ceil(this.iYAxisMax);
            this.drawAxes(g, this.iXAxisMin, this.iXAxisMax, 2, this.iYAxisMin, this.iYAxisMax);
            this.drawYAxisReferenceAreas(g, false);
            this.drawXAxisReferenceAreas(g, false);
            if (this.currentGraphicsPanelType.equals((Object)GraphicsPanelType.profileChromatogram) || this.currentGraphicsPanelType.equals((Object)GraphicsPanelType.profileSpectrum) || this.currentGraphicsPanelType.equals((Object)GraphicsPanelType.isotopicDistributionProfile)) {
                this.drawFilledPolygon(g);
            } else {
                this.drawPeaks(g);
                if (this.dataSetCounterMirroredSpectra > 0) {
                    this.drawMirroredPeaks(g);
                }
            }
            if (this.iClicked && this.iHighLight && this.iClickedIndex != this.iHighLightIndex) {
                this.drawMeasurementLine(this.iClickedIndex, this.iClickedDataSetIndex, this.iHighLightIndex, this.iHighLightDatasetIndex, g, Color.blue, 0);
            }
            if (this.iHighLight) {
                this.highLightPeak(this.iHighLightIndex, this.iHighLightDatasetIndex, g);
                this.iHighLight = false;
            }
            if (this.iClicked) {
                this.highlightClicked(this.iClickedIndex, this.iHighLightDatasetIndex, g);
            }
            if ((liClickedSize = this.iClickedList.size()) > 0) {
                for (i = 0; i < liClickedSize; ++i) {
                    int second;
                    first = (Integer)this.iClickedList.get(i);
                    int firstDataSetIndex = (Integer)this.iClickedListDatasetIndices.get(i);
                    if (i + 1 == liClickedSize) {
                        second = this.iClickedIndex;
                        secondDataSetIndex = this.iClickedDataSetIndex;
                    } else {
                        second = (Integer)this.iClickedList.get(i + 1);
                        secondDataSetIndex = (Integer)this.iClickedListDatasetIndices.get(i + 1);
                    }
                    this.drawMeasurementLine(first, firstDataSetIndex, second, secondDataSetIndex, g, Color.LIGHT_GRAY, 0);
                }
            }
            if (this.iStoredSequence.size() > 0) {
                for (i = 1; i < this.iStoredSequence.size(); ++i) {
                    first = (Integer)this.iStoredSequence.get(i - 1);
                    int second = (Integer)this.iStoredSequence.get(i);
                    int firstDataSetIndex = (Integer)this.iStoredSequenceDatasetIndices.get(i - 1);
                    secondDataSetIndex = (Integer)this.iStoredSequenceDatasetIndices.get(i);
                    this.drawMeasurementLine(first, firstDataSetIndex, second, secondDataSetIndex, g, Color.red, g.getFontMetrics().getAscent() + 15);
                }
            }
            if (this.iAnnotations != null && this.iAnnotations.size() > 0 && !this.miniature) {
                HashMap<String, Integer> annotatedPeaks = new HashMap<String, Integer>();
                for (int i2 = 0; i2 < this.iAnnotations.size(); ++i2) {
                    Object o = this.iAnnotations.get(i2);
                    if (!(o instanceof SpectrumAnnotation)) continue;
                    SpectrumAnnotation sa = (SpectrumAnnotation)o;
                    this.annotate(sa, g, annotatedPeaks);
                }
            }
            this.drawYAxisReferenceAreas(g, true);
            this.drawXAxisReferenceAreas(g, true);
            this.drawAxes(g, this.iXAxisMin, this.iXAxisMax, 2, this.iYAxisMin, this.iYAxisMax);
        }
    }

    protected void drawXAxisReferenceAreas(Graphics g, boolean drawOnTop) {
        FontMetrics fm = g.getFontMetrics();
        Font oldFont = this.getFont();
        Graphics2D g2d = (Graphics2D)g;
        Color originalColor = g2d.getColor();
        Composite originalComposite = g2d.getComposite();
        Stroke originalStroke = g2d.getStroke();
        Iterator<String> allReferenceAreas = this.referenceAreasXAxis.keySet().iterator();
        while (allReferenceAreas.hasNext()) {
            int end;
            ReferenceArea currentReferenceArea = this.referenceAreasXAxis.get(allReferenceAreas.next());
            if (drawOnTop != currentReferenceArea.drawOnTop()) continue;
            g.setColor(currentReferenceArea.getAreaColor());
            g2d.setComposite(this.makeComposite(currentReferenceArea.getAlpha()));
            int[] xTemp = new int[4];
            int[] yTemp = new int[4];
            double tempDouble = (currentReferenceArea.getStart() - this.iXAxisMin) / this.iXScaleUnit;
            int start = (int)tempDouble;
            if (tempDouble - (double)start >= 0.5) {
                ++start;
            }
            if ((tempDouble = (currentReferenceArea.getEnd() - this.iXAxisMin) / this.iXScaleUnit) - (double)(end = (int)tempDouble) >= 0.5) {
                ++end;
            }
            int y = (int)(this.iYScaleUnit / this.iYAxisMax + (double)(this.iXPadding / 2));
            int areaHeight = this.getHeight() - this.currentPadding - y;
            xTemp[0] = start + this.iXPadding;
            yTemp[0] = y += (int)((double)areaHeight - (double)areaHeight * currentReferenceArea.getPercentLength());
            xTemp[1] = end + this.iXPadding;
            yTemp[1] = y;
            xTemp[2] = end + this.iXPadding;
            yTemp[2] = this.getHeight() - this.currentPadding;
            xTemp[3] = start + this.iXPadding;
            yTemp[3] = this.getHeight() - this.currentPadding;
            g2d.fillPolygon(xTemp, yTemp, xTemp.length);
            g2d.setComposite(originalComposite);
            g2d.setColor(currentReferenceArea.getBorderColor());
            g2d.setStroke(new BasicStroke(currentReferenceArea.getBorderWidth()));
            g2d.drawRect(xTemp[0], yTemp[0], xTemp[1] - xTemp[0], yTemp[2] - yTemp[0]);
            g2d.setStroke(originalStroke);
            g2d.setColor(originalColor);
            if (!currentReferenceArea.drawLabel() || this.miniature) continue;
            g2d.setColor(currentReferenceArea.getLabelColor());
            if (currentReferenceArea.useBoldFont()) {
                g.setFont(new Font(oldFont.getName(), oldFont.getStyle() | 1, oldFont.getSize()));
            } else {
                g.setFont(new Font(oldFont.getName(), oldFont.getStyle(), oldFont.getSize()));
            }
            String label = currentReferenceArea.getLabel();
            int width = g.getFontMetrics().stringWidth(label);
            int xPosText = xTemp[0] + Math.abs(xTemp[1] - xTemp[0]) / 2 - width / 2;
            g2d.drawString(label, xPosText, y + (int)fm.getStringBounds(label, g).getHeight() + 8);
        }
        g2d.setColor(originalColor);
        g2d.setComposite(originalComposite);
        g.setFont(oldFont);
    }

    protected void drawYAxisReferenceAreas(Graphics g, boolean drawOnTop) {
        FontMetrics fm = g.getFontMetrics();
        Font oldFont = this.getFont();
        Graphics2D g2d = (Graphics2D)g;
        Stroke originalStroke = g2d.getStroke();
        Color originalColor = g2d.getColor();
        Composite originalComposite = g2d.getComposite();
        Iterator<String> allReferenceAreas = this.referenceAreasYAxis.keySet().iterator();
        while (allReferenceAreas.hasNext()) {
            int end;
            ReferenceArea currentReferenceArea = this.referenceAreasYAxis.get(allReferenceAreas.next());
            if (drawOnTop != currentReferenceArea.drawOnTop()) continue;
            g.setColor(currentReferenceArea.getAreaColor());
            g2d.setComposite(this.makeComposite(currentReferenceArea.getAlpha()));
            int[] xTemp = new int[4];
            int[] yTemp = new int[4];
            double tempDouble = (currentReferenceArea.getStart() - this.iYAxisMin) / this.iYScaleUnit;
            int start = (int)tempDouble;
            if (tempDouble - (double)start >= 0.5) {
                ++start;
            }
            if ((tempDouble = (currentReferenceArea.getEnd() - this.iYAxisMin) / this.iYScaleUnit) - (double)(end = (int)tempDouble) >= 0.5) {
                ++end;
            }
            int areaLength = this.getWidth() - this.currentPadding;
            int xMax = (int)((double)areaLength * currentReferenceArea.getPercentLength());
            xTemp[0] = this.currentPadding;
            yTemp[0] = this.getHeight() - start - this.currentPadding;
            xTemp[1] = this.currentPadding;
            yTemp[1] = this.getHeight() - end - this.currentPadding;
            xTemp[2] = xMax;
            yTemp[2] = this.getHeight() - end - this.currentPadding;
            xTemp[3] = xMax;
            yTemp[3] = this.getHeight() - start - this.currentPadding;
            g2d.fillPolygon(xTemp, yTemp, xTemp.length);
            g2d.setComposite(originalComposite);
            g2d.setColor(currentReferenceArea.getBorderColor());
            g2d.setStroke(new BasicStroke(currentReferenceArea.getBorderWidth()));
            g2d.drawRect(xTemp[0], yTemp[2], xTemp[2] - xTemp[0], yTemp[0] - yTemp[2]);
            g2d.setStroke(originalStroke);
            g2d.setColor(originalColor);
            if (!currentReferenceArea.drawLabel() || this.miniature) continue;
            g2d.setColor(currentReferenceArea.getLabelColor());
            if (currentReferenceArea.useBoldFont()) {
                g.setFont(new Font(oldFont.getName(), oldFont.getStyle() | 1, oldFont.getSize()));
            } else {
                g.setFont(new Font(oldFont.getName(), oldFont.getStyle(), oldFont.getSize()));
            }
            String label = currentReferenceArea.getLabel();
            g2d.drawString(label, this.currentPadding + 5, this.getHeight() - end - this.currentPadding + (int)fm.getStringBounds(label, g).getHeight());
        }
        g2d.setColor(originalColor);
        g2d.setComposite(originalComposite);
    }

    public double getMaxXAxisValue() {
        double maxValue = Double.MIN_VALUE;
        for (int i = 0; i < this.iXAxisData.size(); ++i) {
            if (this.iXAxisData.get(i).length <= 0 || !(this.iXAxisData.get(i)[this.iXAxisData.get(i).length - 1] > maxValue)) continue;
            maxValue = this.iXAxisData.get(i)[this.iXAxisData.get(i).length - 1];
        }
        return maxValue;
    }

    public double getMinXAxisValue() {
        double minValue = Double.MAX_VALUE;
        for (int i = 0; i < this.iXAxisData.size(); ++i) {
            if (!(this.iXAxisData.get(i)[0] < minValue)) continue;
            minValue = this.iXAxisData.get(i)[0];
        }
        return minValue;
    }

    public void addSpectrumPanelListener(SpectrumPanelListener aListener) {
        this.iSpecPanelListeners.add(aListener);
    }

    protected void addListeners() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (GraphicsPanel.this.iXAxisData != null) {
                    if (e.getButton() == 3 || e.getButton() == 2) {
                        if (GraphicsPanel.this.iXAxisStartAtZero) {
                            GraphicsPanel.this.rescale(0.0, GraphicsPanel.this.getMaxXAxisValue());
                        } else {
                            double tempMinXValue = GraphicsPanel.this.getMinXAxisValue();
                            if ((GraphicsPanel.this.currentGraphicsPanelType.equals((Object)GraphicsPanelType.isotopicDistributionProfile) || GraphicsPanel.this.currentGraphicsPanelType.equals((Object)GraphicsPanelType.isotopicDistributionCentroid)) && (tempMinXValue -= 1.0) < 0.0) {
                                tempMinXValue = 0.0;
                            }
                            GraphicsPanel.this.rescale(tempMinXValue, GraphicsPanel.this.getMaxXAxisValue());
                        }
                        GraphicsPanel.this.iDragged = false;
                        GraphicsPanel.this.repaint();
                    } else if (e.getButton() == 1) {
                        GraphicsPanel.this.iEndXLoc = e.getX();
                        int min = Math.min(GraphicsPanel.this.iEndXLoc, GraphicsPanel.this.iStartXLoc);
                        int max = Math.max(GraphicsPanel.this.iEndXLoc, GraphicsPanel.this.iStartXLoc);
                        double start = GraphicsPanel.this.iXAxisMin + (double)(min - GraphicsPanel.this.iXPadding) * GraphicsPanel.this.iXScaleUnit;
                        double end = GraphicsPanel.this.iXAxisMin + (double)(max - GraphicsPanel.this.iXPadding) * GraphicsPanel.this.iXScaleUnit;
                        if (GraphicsPanel.this.iDragged) {
                            GraphicsPanel.this.iDragged = false;
                            if (max - min > GraphicsPanel.this.iMinDrag) {
                                GraphicsPanel.this.rescale(start, end);
                            }
                            GraphicsPanel.this.iDragXLoc = 0;
                            GraphicsPanel.this.repaint();
                        }
                    }
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (GraphicsPanel.this.iXAxisData != null) {
                    if (e.getButton() == 1 && e.getModifiersEx() == 640) {
                        GraphicsPanel.this.iStoredSequence = new Vector(15, 5);
                        GraphicsPanel.this.iStoredSequenceDatasetIndices = new Vector(15, 5);
                        GraphicsPanel.this.repaint();
                    } else if (e.getButton() == 1 && e.getModifiersEx() == 128) {
                        GraphicsPanel.this.iClicked = false;
                        GraphicsPanel.this.iClickedList = new Vector(15, 5);
                        GraphicsPanel.this.iClickedListDatasetIndices = new Vector(15, 5);
                        GraphicsPanel.this.repaint();
                    } else if (e.getButton() == 1 && e.getModifiersEx() == 64) {
                        if (GraphicsPanel.this.iClickedList != null && GraphicsPanel.this.iClickedList.size() > 0 && GraphicsPanel.this.iHighLightIndex == GraphicsPanel.this.iClickedIndex) {
                            GraphicsPanel.this.iClickedIndex = (Integer)GraphicsPanel.this.iClickedList.get(GraphicsPanel.this.iClickedList.size() - 1);
                            GraphicsPanel.this.iClickedDataSetIndex = (Integer)GraphicsPanel.this.iClickedListDatasetIndices.get(GraphicsPanel.this.iClickedListDatasetIndices.size() - 1);
                            GraphicsPanel.this.iClickedList.remove(GraphicsPanel.this.iClickedList.size() - 1);
                            GraphicsPanel.this.iClickedListDatasetIndices.remove(GraphicsPanel.this.iClickedListDatasetIndices.size() - 1);
                            GraphicsPanel.this.repaint();
                        }
                    } else if (e.getButton() == 1 && e.getModifiersEx() == 512) {
                        if (GraphicsPanel.this.iClickedList != null && GraphicsPanel.this.iClickedList.size() > 0) {
                            GraphicsPanel.this.iStoredSequence = (Vector)GraphicsPanel.this.iClickedList.clone();
                            GraphicsPanel.this.iStoredSequence.add(GraphicsPanel.this.iClickedIndex);
                            GraphicsPanel.this.iStoredSequenceDatasetIndices = (Vector)GraphicsPanel.this.iClickedListDatasetIndices.clone();
                            GraphicsPanel.this.iStoredSequenceDatasetIndices.add(GraphicsPanel.this.iClickedDataSetIndex);
                            GraphicsPanel.this.iClicked = false;
                            GraphicsPanel.this.iClickedList = new Vector(15, 5);
                            GraphicsPanel.this.iClickedListDatasetIndices = new Vector(15, 5);
                            GraphicsPanel.this.repaint();
                        }
                    } else if (e.getButton() == 1) {
                        if (GraphicsPanel.this.iClicked && GraphicsPanel.this.iClickedIndex != GraphicsPanel.this.iHighLightIndex) {
                            GraphicsPanel.this.iClickedList.add(GraphicsPanel.this.iClickedIndex);
                            GraphicsPanel.this.iClickedListDatasetIndices.add(GraphicsPanel.this.iClickedDataSetIndex);
                        }
                        GraphicsPanel.this.iClicked = true;
                        GraphicsPanel.this.iClickedIndex = GraphicsPanel.this.iHighLightIndex;
                        GraphicsPanel.this.iClickedDataSetIndex = GraphicsPanel.this.iHighLightDatasetIndex;
                        GraphicsPanel.this.repaint();
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    GraphicsPanel.this.iStartXLoc = e.getX();
                    GraphicsPanel.this.iStartYLoc = e.getY();
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    GraphicsPanel.this.iDragged = true;
                    GraphicsPanel.this.iDragXLoc = e.getX();
                    GraphicsPanel.this.repaint();
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (GraphicsPanel.this.iXAxisData != null && GraphicsPanel.this.iXAxisDataInPixels != null) {
                    int x = e.getX();
                    int y = e.getY();
                    int highestPeakInRange = 0;
                    block0: for (int j = 0; j < GraphicsPanel.this.iXAxisDataInPixels.size(); ++j) {
                        for (int i = 0; i < GraphicsPanel.this.iXAxisDataInPixels.get(j).length; ++i) {
                            int delta = GraphicsPanel.this.iXAxisDataInPixels.get(j)[i] - x;
                            if (Math.abs(delta) < GraphicsPanel.this.iPointDetectionTolerance) {
                                int deltaYPixels = y - GraphicsPanel.this.iYAxisDataInPixels.get(j)[i];
                                if (deltaYPixels >= 0 || Math.abs(deltaYPixels) >= GraphicsPanel.this.getHeight() - GraphicsPanel.this.iYAxisDataInPixels.get(j)[i] || highestPeakInRange >= GraphicsPanel.this.getHeight() - GraphicsPanel.this.iYAxisDataInPixels.get(j)[i]) continue;
                                GraphicsPanel.this.iHighLight = true;
                                GraphicsPanel.this.iHighLightIndex = i;
                                GraphicsPanel.this.iHighLightDatasetIndex = j;
                                highestPeakInRange = GraphicsPanel.this.getHeight() - GraphicsPanel.this.iYAxisDataInPixels.get(j)[i];
                                GraphicsPanel.this.repaint();
                                continue;
                            }
                            if (delta >= GraphicsPanel.this.iPointDetectionTolerance) continue block0;
                        }
                    }
                    GraphicsPanel.this.repaint();
                }
            }
        });
    }

    public void rescale(double aMinXAxisValue, double aMaxXAxisValue) {
        this.rescale(aMinXAxisValue, aMaxXAxisValue, true);
    }

    public void addReferenceAreaXAxis(ReferenceArea referenceArea) {
        this.referenceAreasXAxis.put(referenceArea.getIdentifier(), referenceArea);
    }

    public void removeReferenceAreaXAxis(String identifier) {
        this.referenceAreasXAxis.remove(identifier);
    }

    public void removeAllReferenceAreasXAxis() {
        this.referenceAreasXAxis = new HashMap();
    }

    public HashMap<String, ReferenceArea> getAllReferenceAreasXAxis() {
        return this.referenceAreasXAxis;
    }

    public void addReferenceAreaYAxis(ReferenceArea referenceArea) {
        this.referenceAreasYAxis.put(referenceArea.getIdentifier(), referenceArea);
    }

    public void removeReferenceAreaYAxis(String identifier) {
        this.referenceAreasYAxis.remove(identifier);
    }

    public void removeAllReferenceAreasYAxis() {
        this.referenceAreasYAxis = new HashMap();
    }

    public HashMap<String, ReferenceArea> getAllReferenceAreasYAxis() {
        return this.referenceAreasYAxis;
    }

    public void setDataPointAndLineColor(Color aColor, int index) {
        if (index < this.iDataPointAndLineColor.size() && index >= 0) {
            this.iDataPointAndLineColor.set(index, aColor);
        }
    }

    public void setAreaUnderCurveColor(Color aColor, int index) {
        if (index < this.iAreaUnderCurveColor.size() && index >= 0) {
            this.iAreaUnderCurveColor.set(index, aColor);
        }
    }

    public ArrayList<Color> getAreaUnderCurveColors() {
        return this.iAreaUnderCurveColor;
    }

    public void rescale(double aMinXAxisValue, double aMaxXAxisValue, boolean aNotifyListeners) {
        double delta;
        double tempOoM;
        double lMass;
        int i;
        int j;
        this.xAxisZoomRangeLowerValue = aMinXAxisValue;
        this.xAxisZoomRangeUpperValue = aMaxXAxisValue;
        double maxInt = 1.0;
        block0: for (j = 0; j < this.iXAxisData.size(); ++j) {
            for (i = 0; i < this.iXAxisData.get(j).length; ++i) {
                lMass = this.iXAxisData.get(j)[i];
                if (lMass < aMinXAxisValue) continue;
                if (lMass > aMaxXAxisValue) continue block0;
                if (!(this.iYAxisData.get(j)[i] > maxInt)) continue;
                boolean annotatedPeak = false;
                if (this.yAxisZoomExcludesBackgroundPeaks) {
                    annotatedPeak = this.isPeakAnnotated(this.iXAxisData.get(j)[i]);
                }
                if (this.yAxisZoomExcludesBackgroundPeaks && (!this.yAxisZoomExcludesBackgroundPeaks || !annotatedPeak) && !this.showAllPeaks) continue;
                maxInt = this.iYAxisData.get(j)[i];
            }
        }
        if (this.dataSetCounterMirroredSpectra > 0) {
            block2: for (j = 0; j < this.iXAxisDataMirroredSpectrum.size(); ++j) {
                for (i = 0; i < this.iXAxisDataMirroredSpectrum.get(j).length; ++i) {
                    lMass = this.iXAxisDataMirroredSpectrum.get(j)[i];
                    if (lMass < aMinXAxisValue) continue;
                    if (lMass > aMaxXAxisValue) continue block2;
                    if (!(this.iYAxisDataMirroredSpectrum.get(j)[i] > maxInt) || this.yAxisZoomExcludesBackgroundPeaks && !this.showAllPeaks) continue;
                    maxInt = this.iYAxisDataMirroredSpectrum.get(j)[i];
                }
            }
        }
        if ((tempOoM = Math.log(delta = aMaxXAxisValue - aMinXAxisValue) / Math.log(10.0) - 1.0) < 0.0) {
            tempOoM -= 1.0;
        }
        int orderOfMagnitude = (int)tempOoM;
        double power = Math.pow(10.0, orderOfMagnitude);
        this.iXAxisMin = aMinXAxisValue - aMinXAxisValue % power;
        this.iXAxisMax = aMaxXAxisValue + (power - aMaxXAxisValue % power);
        this.iYAxisMax = maxInt + maxInt / 10.0;
        int liSize = this.iSpecPanelListeners.size();
        RescalingEvent re = new RescalingEvent(this, aMinXAxisValue, aMaxXAxisValue);
        if (aNotifyListeners) {
            for (int i2 = 0; i2 < liSize; ++i2) {
                ((SpectrumPanelListener)this.iSpecPanelListeners.get(i2)).rescaled(re);
            }
        }
    }

    protected void processXAndYData(double[] aXAxisData, double[] aYAxisData, Color dataPointAndLineColor, Color areaUnderCurveColor) {
        if (this.dataSetCounter == 0) {
            this.iXAxisData = new ArrayList();
            this.iYAxisData = new ArrayList();
        }
        this.iDataPointAndLineColor.add(dataPointAndLineColor);
        this.iAreaUnderCurveColor.add(areaUnderCurveColor);
        HashMap<Double, Double> peaks = new HashMap<Double, Double>(aXAxisData.length);
        for (int i = 0; i < aXAxisData.length; ++i) {
            peaks.put(new Double(aXAxisData[i]), new Double(aYAxisData[i]));
        }
        this.iXAxisData.add(new double[peaks.size()]);
        this.iYAxisData.add(new double[peaks.size()]);
        double maxYAxisValue = 0.0;
        TreeSet masses = new TreeSet(peaks.keySet());
        Iterator iter = masses.iterator();
        int count = 0;
        while (iter.hasNext()) {
            Double key = (Double)iter.next();
            double xValue = key;
            double yValue = (Double)peaks.get(key);
            if (yValue > maxYAxisValue) {
                maxYAxisValue = yValue;
            }
            this.iXAxisData.get((int)this.dataSetCounter)[count] = xValue;
            this.iYAxisData.get((int)this.dataSetCounter)[count] = yValue;
            ++count;
        }
        if (this.iXAxisStartAtZero) {
            this.rescale(0.0, this.getMaxXAxisValue());
        } else {
            this.rescale(this.getMinXAxisValue(), this.getMaxXAxisValue());
        }
        ++this.dataSetCounter;
    }

    protected void processMirroredXAndYData(double[] aXAxisData, double[] aYAxisData, Color dataPointAndLineColor, Color areaUnderCurveColor) {
        if (this.dataSetCounterMirroredSpectra == 0) {
            this.iXAxisDataMirroredSpectrum = new ArrayList();
            this.iYAxisDataMirroredSpectrum = new ArrayList();
        }
        this.iDataPointAndLineColorMirroredSpectra.add(dataPointAndLineColor);
        this.iAreaUnderCurveColorMirroredSpectra.add(areaUnderCurveColor);
        HashMap<Double, Double> peaks = new HashMap<Double, Double>(aXAxisData.length);
        for (int i = 0; i < aXAxisData.length; ++i) {
            peaks.put(new Double(aXAxisData[i]), new Double(aYAxisData[i]));
        }
        this.iXAxisDataMirroredSpectrum.add(new double[peaks.size()]);
        this.iYAxisDataMirroredSpectrum.add(new double[peaks.size()]);
        double maxYAxisValue = 0.0;
        TreeSet masses = new TreeSet(peaks.keySet());
        Iterator iter = masses.iterator();
        int count = 0;
        while (iter.hasNext()) {
            Double key = (Double)iter.next();
            double xValue = key;
            double yValue = (Double)peaks.get(key);
            if (yValue > maxYAxisValue) {
                maxYAxisValue = yValue;
            }
            this.iXAxisDataMirroredSpectrum.get((int)this.dataSetCounterMirroredSpectra)[count] = xValue;
            this.iYAxisDataMirroredSpectrum.get((int)this.dataSetCounterMirroredSpectra)[count] = yValue;
            ++count;
        }
        if (this.iXAxisStartAtZero) {
            this.rescale(0.0, this.getMaxXAxisValue());
        } else {
            this.rescale(this.getMinXAxisValue(), this.getMaxXAxisValue());
        }
        ++this.dataSetCounterMirroredSpectra;
    }

    protected int[] drawAxes(Graphics g, double aXMin, double aXMax, int aXScale, double aYMin, double aYMax) {
        FontMetrics fm = g.getFontMetrics();
        int xAxisLabelWidth = fm.stringWidth(this.iXAxisLabel);
        int yAxisLabelWidth = fm.stringWidth(this.iYAxisLabel);
        int minWidth = fm.stringWidth(Double.toString(aYMin));
        int maxWidth = fm.stringWidth(Double.toString(aYMax));
        int max = Math.max(Math.max(xAxisLabelWidth, yAxisLabelWidth), Math.max(minWidth, maxWidth));
        this.currentPadding = this.padding;
        if (this.padding - max < 0) {
            this.currentPadding += max;
            if (this.currentPadding > this.maxPadding) {
                this.currentPadding = this.maxPadding;
            }
        } else {
            this.currentPadding *= 2;
        }
        int xAxis = this.getWidth() - 2 * this.currentPadding;
        int xAxisYLocation = this.getHeight() - this.currentPadding;
        if (this.dataSetCounterMirroredSpectra > 0) {
            xAxisYLocation = (this.getHeight() - this.currentPadding) / 2;
        }
        if (this.yDataIsPositive) {
            Color currentColor = g.getColor();
            g.setColor(this.getBackground());
            if (this.miniature) {
                g.fillRect(this.currentPadding, xAxisYLocation, this.getWidth() - this.currentPadding - 2, 2);
            } else {
                g.fillRect(this.currentPadding, xAxisYLocation, this.getWidth() - this.currentPadding - 2, 20);
            }
            g.setColor(currentColor);
        }
        g.drawLine(this.currentPadding, xAxisYLocation, this.getWidth() - this.currentPadding, xAxisYLocation);
        if (!this.miniature) {
            g.fillPolygon(new int[]{this.getWidth() - this.currentPadding - 3, this.getWidth() - this.currentPadding - 3, this.getWidth() - this.currentPadding + 2}, new int[]{xAxisYLocation + 5, xAxisYLocation - 5, xAxisYLocation}, 3);
            if (this.iXAxisLabel.equalsIgnoreCase("m/z")) {
                g.drawString(this.iXAxisLabel, this.getWidth() - (this.currentPadding - this.padding / 2), xAxisYLocation + 4);
            } else {
                g.drawString(this.iXAxisLabel, this.getWidth() - (xAxisLabelWidth + 5), xAxisYLocation - this.currentPadding / 2);
            }
            g.drawLine(this.currentPadding, this.getHeight() - this.currentPadding, this.currentPadding, this.currentPadding / 2);
        }
        this.iXPadding = this.currentPadding;
        int yAxis = xAxisYLocation - this.currentPadding / 2;
        if (!this.miniature) {
            g.fillPolygon(new int[]{this.currentPadding - 5, this.currentPadding + 5, this.currentPadding}, new int[]{this.currentPadding / 2 + 3, this.currentPadding / 2 + 3, this.currentPadding / 2 - 2}, 3);
            if (this.iYAxisLabel.equalsIgnoreCase("Int")) {
                g.drawString(this.iYAxisLabel, this.currentPadding - yAxisLabelWidth, this.currentPadding / 2 - 4);
            } else {
                g.drawString(this.iYAxisLabel, this.currentPadding - yAxisLabelWidth / 5, this.currentPadding / 2 - 4);
            }
        }
        this.drawXTags(g, (int)Math.floor(aXMin), (int)Math.ceil(aXMax), aXScale, xAxis, this.currentPadding);
        int yTemp = yAxis;
        if (this.iAnnotations != null && this.iAnnotations.size() > 0 && !this.miniature) {
            yTemp -= 20;
        }
        this.iTopPadding = this.getHeight() - yTemp - 5;
        this.drawYTags(g, (int)Math.floor(aYMin), (int)Math.ceil(aYMax), yTemp, this.currentPadding);
        return new int[]{xAxis, yAxis};
    }

    protected void drawXTags(Graphics g, int aMin, int aMax, int aXScale, int aXAxisWidth, int aPadding) {
        block24: {
            int xLoc;
            FontMetrics fm = g.getFontMetrics();
            double delta = aMax - aMin;
            this.iXScaleUnit = delta / (double)aXAxisWidth;
            if ((this.currentGraphicsPanelType.equals((Object)GraphicsPanelType.centroidSpectrum) || this.currentGraphicsPanelType.equals((Object)GraphicsPanelType.profileSpectrum)) && !this.miniature) {
                String resolution = "";
                if (this.showResolution) {
                    resolution = "Resolution: " + new BigDecimal(this.iXScaleUnit).setScale(2, 4).toString();
                }
                String msLevel_and_optional_precursor = "";
                if (this.showPrecursorDetails) {
                    msLevel_and_optional_precursor = "MS level: " + this.iMSLevel;
                    msLevel_and_optional_precursor = this.iMSLevel > 0 ? msLevel_and_optional_precursor + "   Precursor M/Z: " + this.iPrecursorMZ + " (" + this.iPrecursorCharge + ")" : "Precursor M/Z: " + this.iPrecursorMZ + " (" + this.iPrecursorCharge + ")";
                }
                String filename = "";
                if (this.showFileName) {
                    filename = "Filename: " + this.iFilename;
                }
                int precLength = fm.stringWidth(msLevel_and_optional_precursor);
                int resLength = fm.stringWidth(resolution);
                int xDistance = (this.getWidth() - this.iXPadding * 2) / 4 - precLength / 2;
                int fromBottom = fm.getAscent() / 2;
                Font oldFont = this.getFont();
                int smallFontCorrection = 0;
                int yHeight = this.getHeight() - fromBottom;
                int xAdditionForResolution = precLength + 15;
                int xAdditionForFilename = xAdditionForResolution + resLength + 15;
                if (precLength + resLength + 45 + fm.stringWidth(filename) > aXAxisWidth) {
                    g.setFont(new Font(oldFont.getName(), oldFont.getStyle(), oldFont.getSize() - 2));
                    smallFontCorrection = g.getFontMetrics().getAscent();
                    xAdditionForFilename = g.getFontMetrics().stringWidth(msLevel_and_optional_precursor) + 5;
                    xAdditionForResolution = g.getFontMetrics().stringWidth(msLevel_and_optional_precursor) / 2;
                    xDistance = aPadding;
                }
                g.drawString(msLevel_and_optional_precursor, xDistance, yHeight - smallFontCorrection);
                g.drawString(resolution, xDistance + xAdditionForResolution, yHeight);
                Color foreground = null;
                if (this.iFilenameColor != null) {
                    foreground = g.getColor();
                    g.setColor(this.iFilenameColor);
                }
                g.drawString(filename, xDistance + xAdditionForFilename, yHeight - smallFontCorrection);
                if (foreground != null) {
                    g.setColor(foreground);
                }
                g.setFont(oldFont);
            }
            if (this.miniature) break block24;
            int labelHeight = fm.getAscent() + 5;
            int tagWidthEstimate = fm.stringWidth("1545") + 15;
            int numberTimes = aXAxisWidth / tagWidthEstimate;
            double scaleUnitXTags = (double)aXAxisWidth / delta;
            int distanceBetweenTags = this.findOptimalTagDistance(numberTimes, delta);
            DecimalFormat numberFormat = new DecimalFormat();
            numberFormat.setGroupingSize(3);
            numberFormat.setGroupingUsed(true);
            if (this.scientificXAxis) {
                numberFormat = new DecimalFormat(this.scientificPattern);
            }
            int xAxisYLocation = this.getHeight();
            if (this.dataSetCounterMirroredSpectra > 0) {
                xAxisYLocation = (this.getHeight() + this.currentPadding) / 2;
            }
            if (delta > 1.0) {
                boolean drawValue;
                int labelWidth;
                String label;
                long lTagValue = 0L;
                for (int i = 0; i < aMax; ++i) {
                    int xLoc2;
                    if ((aMin + i) % distanceBetweenTags != 0 || (xLoc2 = (int)((double)aPadding + (double)i * scaleUnitXTags)) >= aPadding + aXAxisWidth) continue;
                    g.drawLine(xLoc2, xAxisYLocation - aPadding, xLoc2, xAxisYLocation - aPadding + 3);
                    int labelAsInt = aMin + i;
                    label = numberFormat.format(labelAsInt);
                    labelWidth = fm.stringWidth(label);
                    drawValue = true;
                    if (labelAsInt == 0 && this.dataSetCounterMirroredSpectra > 0) {
                        drawValue = false;
                    }
                    if (drawValue) {
                        g.drawString(label, xLoc2 - labelWidth / 2, xAxisYLocation - aPadding + labelHeight);
                    }
                    lTagValue = i;
                    break;
                }
                while (lTagValue < (long)aMax && distanceBetweenTags > 0) {
                    xLoc = (int)((double)aPadding + (double)lTagValue * scaleUnitXTags);
                    if (xLoc < aPadding + aXAxisWidth) {
                        g.drawLine(xLoc, xAxisYLocation - aPadding, xLoc, xAxisYLocation - aPadding + 3);
                        long labelAsInt = (long)aMin + lTagValue;
                        label = numberFormat.format(labelAsInt);
                        labelWidth = fm.stringWidth(label);
                        drawValue = true;
                        if (labelAsInt == 0L && this.dataSetCounterMirroredSpectra > 0) {
                            drawValue = false;
                        }
                        if (drawValue) {
                            g.drawString(label, xLoc - labelWidth / 2, xAxisYLocation - aPadding + labelHeight);
                        }
                    }
                    lTagValue += (long)distanceBetweenTags;
                }
            } else {
                int numberOfTags = 10;
                if (numberTimes >= numberOfTags) {
                    scaleUnitXTags = aXAxisWidth / numberOfTags;
                } else {
                    numberOfTags = 5;
                    if (numberTimes >= numberOfTags) {
                        scaleUnitXTags = aXAxisWidth / numberOfTags;
                    } else {
                        numberOfTags = 2;
                        if (numberTimes >= numberOfTags) {
                            numberOfTags = 1;
                        }
                    }
                }
                for (int i = 0; i < numberOfTags; ++i) {
                    xLoc = (int)((double)aPadding + (double)i * scaleUnitXTags);
                    if (xLoc >= aPadding + aXAxisWidth) continue;
                    g.drawLine(xLoc, this.getHeight() - aPadding, xLoc, this.getHeight() - aPadding + 3);
                    double labelAsdouble = (double)aMin + 1.0 / (double)numberOfTags * (double)i;
                    String label = numberFormat.format(labelAsdouble);
                    int labelWidth = fm.stringWidth(label);
                    g.drawString(label, xLoc - labelWidth / 2, this.getHeight() - aPadding + labelHeight);
                }
            }
        }
    }

    protected void drawYTags(Graphics g, int aMin, int aMax, int aYAxisHeight, int aPadding) {
        FontMetrics fm = g.getFontMetrics();
        int labelHeight = fm.getAscent();
        int tagHeightEstimate = labelHeight + 10;
        int numberTimes = aYAxisHeight / tagHeightEstimate;
        double delta = aMax - aMin;
        this.iYScaleUnit = delta / (double)aYAxisHeight;
        if (!this.miniature) {
            int labelWidth;
            String label;
            long labelAsInt;
            int yLoc;
            long lTagValue;
            double scaleUnitYTags = (double)aYAxisHeight / delta;
            int distanceBetweenTags = this.findOptimalTagDistance(numberTimes, delta);
            DecimalFormat numberFormat = new DecimalFormat();
            numberFormat.setGroupingSize(3);
            numberFormat.setGroupingUsed(true);
            if (this.scientificYAxis) {
                numberFormat = new DecimalFormat(this.scientificPattern);
            }
            String largestLabel = numberFormat.format(aMax);
            Font oldFont = g.getFont();
            int sizeCounter = 0;
            int margin = aPadding - 10;
            while (g.getFontMetrics().stringWidth(largestLabel) >= margin) {
                g.setFont(new Font(oldFont.getName(), oldFont.getStyle(), oldFont.getSize() - ++sizeCounter));
            }
            if (oldFont.getSize() - sizeCounter > 0) {
                g.setFont(new Font(oldFont.getName(), oldFont.getStyle(), oldFont.getSize() - sizeCounter));
            } else {
                g.setFont(new Font(oldFont.getName(), oldFont.getStyle(), 1));
            }
            int height = this.getHeight();
            if (this.dataSetCounterMirroredSpectra > 0) {
                height = this.getHeight() - (this.getHeight() - this.currentPadding) / 2;
            }
            for (lTagValue = 0L; lTagValue < (long)aMax; lTagValue += (long)distanceBetweenTags) {
                yLoc = (int)((double)aPadding + (double)lTagValue * scaleUnitYTags);
                g.drawLine(aPadding, height - yLoc, aPadding - 3, height - yLoc);
                labelAsInt = (long)aMin + lTagValue;
                label = numberFormat.format(labelAsInt);
                labelWidth = g.getFontMetrics().stringWidth(label) + 5;
                g.drawString(label, aPadding - labelWidth, height - yLoc + g.getFontMetrics().getAscent() / 2 - 1);
            }
            if (this.dataSetCounterMirroredSpectra > 0) {
                height = (this.getHeight() - this.currentPadding * 3) / 2;
                for (lTagValue = 0L; lTagValue < (long)aMax; lTagValue += (long)distanceBetweenTags) {
                    yLoc = (int)((double)aPadding + (double)lTagValue * scaleUnitYTags);
                    labelAsInt = (long)aMin + lTagValue;
                    if (labelAsInt == 0L) continue;
                    g.drawLine(aPadding, height + yLoc, aPadding - 3, height + yLoc);
                    label = numberFormat.format(labelAsInt);
                    labelWidth = g.getFontMetrics().stringWidth(label) + 5;
                    g.drawString(label, aPadding - labelWidth, height + yLoc + g.getFontMetrics().getAscent() / 2 - 1);
                }
            }
            g.setFont(oldFont);
        }
    }

    private int findOptimalTagDistance(int maxNumberOfTags, double delta) {
        int[] distanceAlternatives = new int[]{1, 5};
        int optimalDistance = 1;
        boolean optimalDistanceFound = false;
        for (int i = 0; i < distanceAlternatives.length && !optimalDistanceFound; ++i) {
            if (!(delta / (double)distanceAlternatives[i] <= (double)maxNumberOfTags)) continue;
            optimalDistance = distanceAlternatives[i];
            optimalDistanceFound = true;
        }
        int tempOptimalDistance = 10;
        while (!optimalDistanceFound) {
            if (delta / ((double)tempOptimalDistance * 2.5) <= (double)maxNumberOfTags) {
                optimalDistance = Double.valueOf((double)tempOptimalDistance * 2.5).intValue();
                optimalDistanceFound = true;
            }
            if (delta / (double)(tempOptimalDistance * 5) <= (double)maxNumberOfTags && !optimalDistanceFound) {
                optimalDistance = Double.valueOf(tempOptimalDistance * 5).intValue();
                optimalDistanceFound = true;
            }
            if (delta / (double)(tempOptimalDistance * 10) <= (double)maxNumberOfTags && !optimalDistanceFound) {
                optimalDistance = Double.valueOf(tempOptimalDistance * 10).intValue();
                optimalDistanceFound = true;
            }
            tempOptimalDistance *= 10;
        }
        return optimalDistance;
    }

    protected void highLightPeak(int aIndex, int dataSetIndex, Graphics g) {
        this.highLight(aIndex, dataSetIndex, g, Color.blue, null, 0, true, 1);
    }

    protected void highlightClicked(int aIndex, int dataSetIndex, Graphics g) {
        this.highLight(aIndex, dataSetIndex, g, Color.BLACK, null, 0, true, 1);
    }

    protected void highLight(int aIndex, int dataSetIndex, Graphics g, Color aColor, String aComment, int aPixelsSpacer, boolean aShowArrow, int aAnnotationCounter) {
        int y;
        int x = this.iXAxisDataInPixels.get(dataSetIndex)[aIndex];
        if (aPixelsSpacer < 0) {
            y = this.iTopPadding;
        } else {
            y = this.iYAxisDataInPixels.get(dataSetIndex)[aIndex] - aPixelsSpacer;
            if (y < 0) {
                y = this.iTopPadding / 3 - (aAnnotationCounter - 3) * (g.getFontMetrics().getAscent() + 4);
            }
        }
        if (y < this.iTopPadding / 3 && this.dataSetCounterMirroredSpectra == 0) {
            y = this.iTopPadding / 3 - (aAnnotationCounter - 3) * (g.getFontMetrics().getAscent() + 4);
        }
        Color originalColor = g.getColor();
        g.setColor(aColor);
        int arrowSpacer = 10;
        if (aShowArrow) {
            g.fillPolygon(new int[]{x - 3, x + 3, x}, new int[]{y - 6, y - 6, y - 3}, 3);
            arrowSpacer = 13;
        }
        if (aComment != null && !aComment.trim().equals("")) {
            aComment = aComment.trim();
            if (this.subscriptAnnotationNumbers) {
                int commentXStart = x - g.getFontMetrics().stringWidth(aComment) / 2;
                Font oldFont = g.getFont();
                for (int i = 0; i < aComment.length(); ++i) {
                    int tempX = commentXStart + g.getFontMetrics().stringWidth(aComment.substring(0, i));
                    if (Character.isDigit(aComment.charAt(i))) {
                        g.setFont(new Font(oldFont.getName(), oldFont.getStyle(), oldFont.getSize() - 2));
                        g.drawString("" + aComment.charAt(i), tempX, y - arrowSpacer + 3);
                    } else {
                        g.drawString("" + aComment.charAt(i), tempX, y - arrowSpacer);
                    }
                    g.setFont(oldFont);
                }
            } else {
                g.drawString(aComment, x - g.getFontMetrics().stringWidth(aComment) / 2, y - arrowSpacer);
            }
        } else {
            String xValue = Double.toString(Util.roundDouble(this.iXAxisData.get(dataSetIndex)[aIndex], 4));
            String yValue = Double.toString(Util.roundDouble(this.iYAxisData.get(dataSetIndex)[aIndex], 4));
            String label = "(" + xValue + ", " + yValue + ")";
            int halfWayMass = g.getFontMetrics().stringWidth(label) / 2;
            g.drawString(label, x - halfWayMass, y - arrowSpacer);
        }
        if (aPixelsSpacer != 0 && aShowArrow) {
            this.dropDottedLine(aIndex, dataSetIndex, y + 2, g);
        }
        g.setColor(originalColor);
    }

    protected void drawMeasurementLine(int aFirstIndex, int aFirstDatasetIndex, int aSecondIndex, int aSecondDatasetIndex, Graphics g, Color aColor, int aExtraPadding) {
        int x1 = this.iXAxisDataInPixels.get(aFirstDatasetIndex)[aFirstIndex];
        int x2 = this.iXAxisDataInPixels.get(aSecondDatasetIndex)[aSecondIndex];
        if (x1 == 0 && x2 == 0) {
            return;
        }
        if (x1 == 0) {
            x1 = this.iXAxisData.get(aFirstDatasetIndex)[aFirstIndex] < this.iXAxisMin ? this.iXPadding + 1 : this.getWidth() - this.iXPadding - 1;
        } else if (x2 == 0) {
            x2 = this.iXAxisData.get(aSecondDatasetIndex)[aSecondIndex] < this.iXAxisMin ? this.iXPadding + 1 : this.getWidth() - this.iXPadding - 1;
        }
        double delta = Math.abs(this.iXAxisData.get(aFirstDatasetIndex)[aFirstIndex] - this.iXAxisData.get(aSecondDatasetIndex)[aSecondIndex]);
        String deltaMass = new BigDecimal(delta).setScale(2, 4).toString();
        String deNovoTag = this.findDeltaMassMatches(delta, this.deltaMassWindow);
        int deNovoTagWidth = g.getFontMetrics().stringWidth(deNovoTag);
        int deltaMassWidth = g.getFontMetrics().stringWidth(deltaMass);
        int y = (int)(this.iYScaleUnit / this.iYAxisMax + (double)(this.iXPadding / 2)) + aExtraPadding;
        Color originalColor = g.getColor();
        g.setColor(aColor);
        g.drawLine(x1, y, x2, y);
        g.drawLine(x1, y - 3, x1, y + 3);
        g.drawLine(x2, y - 3, x2, y + 3);
        this.dropDottedLine(aFirstIndex, aFirstDatasetIndex, y - 3, g);
        this.dropDottedLine(aSecondIndex, aSecondDatasetIndex, y - 3, g);
        int xPosText = Math.min(x1, x2) + Math.abs(x1 - x2) / 2 - deNovoTagWidth / 2;
        g.drawString(deNovoTag, xPosText, y - 5);
        xPosText = Math.min(x1, x2) + Math.abs(x1 - x2) / 2 - deltaMassWidth / 2;
        g.drawString(deltaMass, xPosText, y + 15);
        g.setColor(originalColor);
    }

    protected void dropDottedLine(int aPeakIndex, int aDatasetIndex, int aTotalHeight, Graphics g) {
        int x = this.iXAxisDataInPixels.get(aDatasetIndex)[aPeakIndex];
        int y = this.iYAxisDataInPixels.get(aDatasetIndex)[aPeakIndex];
        if (y - aTotalHeight > 10) {
            for (int start = aTotalHeight; start < y; start += 7) {
                g.drawLine(x, start, x, start + 2);
            }
        }
    }

    protected String findDeltaMassMatches(double aDelta, double aWindow) {
        StringBuilder result = new StringBuilder("");
        boolean appended = false;
        if (iKnownMassDeltas != null) {
            for (Double mass : iKnownMassDeltas.keySet()) {
                if (!(Math.abs(mass - aDelta) < aWindow)) continue;
                if (appended) {
                    result.append(" ");
                } else {
                    appended = true;
                }
                result.append(iKnownMassDeltas.get(mass));
            }
            if (this.useMassDeltaCombinations) {
                Iterator<Double> iter1 = iKnownMassDeltas.keySet().iterator();
                ArrayList<String> addedMassDeltas = new ArrayList<String>();
                while (iter1.hasNext()) {
                    Double mass1 = iter1.next();
                    for (Double mass2 : iKnownMassDeltas.keySet()) {
                        Double mass = mass1 + mass2;
                        if (!(Math.abs(mass - aDelta) < aWindow) || addedMassDeltas.contains(iKnownMassDeltas.get(mass2) + "" + iKnownMassDeltas.get(mass1))) continue;
                        if (appended) {
                            result.append(" ");
                        } else {
                            appended = true;
                        }
                        result.append(iKnownMassDeltas.get(mass1) + "" + iKnownMassDeltas.get(mass2));
                        addedMassDeltas.add(iKnownMassDeltas.get(mass1) + "" + iKnownMassDeltas.get(mass2));
                    }
                }
            }
        }
        return result.toString();
    }

    protected void annotate(SpectrumAnnotation aSA, Graphics g, HashMap<String, Integer> aAlreadyAnnotated) {
        double xValue = aSA.getMZ();
        double error = Math.abs(aSA.getErrorMargin());
        if (!(xValue < this.iXAxisMin) && !(xValue > this.iXAxisMax)) {
            boolean foundMatch = false;
            int peakIndex = -1;
            int dataSetIndex = -1;
            block0: for (int j = 0; j < this.iXAxisData.size(); ++j) {
                for (int i = 0; i < this.iXAxisData.get(j).length; ++i) {
                    double delta = this.iXAxisData.get(j)[i] - xValue;
                    if (Math.abs(delta) <= error) {
                        if (!foundMatch) {
                            foundMatch = true;
                            peakIndex = i;
                            dataSetIndex = j;
                            continue;
                        }
                        if (!(this.iYAxisData.get(j)[i] > this.iYAxisData.get(dataSetIndex)[peakIndex])) continue;
                        peakIndex = i;
                        dataSetIndex = j;
                        continue;
                    }
                    if (delta > error) continue block0;
                }
            }
            if (foundMatch && this.iYAxisData.get(dataSetIndex)[peakIndex] > this.iAnnotationYAxisThreshold) {
                String label = aSA.getLabel();
                int spacer = (int)((this.iYAxisData.get(dataSetIndex)[peakIndex] - this.iYAxisMin) / this.iYScaleUnit) / 2;
                boolean showArrow = true;
                String key = dataSetIndex + "_" + peakIndex;
                if (aAlreadyAnnotated.containsKey(key)) {
                    int count = aAlreadyAnnotated.get(key);
                    spacer += count * (g.getFontMetrics().getAscent() + 4);
                    aAlreadyAnnotated.put(key, count + 1);
                    showArrow = false;
                } else {
                    aAlreadyAnnotated.put(key, 1);
                }
                this.highLight(peakIndex, dataSetIndex, g, aSA.getColor(), label, spacer, showArrow, aAlreadyAnnotated.get(key));
            }
        }
    }

    protected void drawMirroredPeaks(Graphics g) {
        Color originalColor = g.getColor();
        this.iXAxisDataInPixelsMirroredSpectrum = new ArrayList();
        this.iYAxisDataInPixelsMirroredSpectrum = new ArrayList();
        block0: for (int j = 0; j < this.iXAxisDataMirroredSpectrum.size(); ++j) {
            g.setColor(this.iDataPointAndLineColorMirroredSpectra.get(j));
            this.iXAxisDataInPixelsMirroredSpectrum.add(new int[this.iXAxisDataMirroredSpectrum.get(j).length]);
            this.iYAxisDataInPixelsMirroredSpectrum.add(new int[this.iYAxisDataMirroredSpectrum.get(j).length]);
            for (int i = 0; i < this.iXAxisDataMirroredSpectrum.get(j).length; ++i) {
                BasicStroke stroke;
                double lXAxisValue = this.iXAxisDataMirroredSpectrum.get(j)[i];
                if (lXAxisValue < this.iXAxisMin) continue;
                if (lXAxisValue > this.iXAxisMax) continue block0;
                boolean annotatedPeak = true;
                if (!this.showAllPeaks) {
                    annotatedPeak = this.isPeakAnnotated(lXAxisValue);
                }
                double lYAxisValue = this.iYAxisDataMirroredSpectrum.get(j)[i];
                double tempDouble = (lXAxisValue - this.iXAxisMin) / this.iXScaleUnit;
                int temp = (int)tempDouble;
                if (tempDouble - (double)temp >= 0.5) {
                    ++temp;
                }
                int xAxisPxl = temp + this.iXPadding;
                if (annotatedPeak || this.showAllPeaks) {
                    this.iXAxisDataInPixelsMirroredSpectrum.get((int)j)[i] = xAxisPxl;
                }
                if ((tempDouble = (lYAxisValue - this.iYAxisMin) / this.iYScaleUnit) - (double)(temp = (int)tempDouble) >= 0.5) {
                    ++temp;
                }
                int xAxisYLocation = (this.getHeight() + this.currentPadding) / 2;
                int yValuePxl = xAxisYLocation + (temp - this.iXPadding);
                if (annotatedPeak || this.showAllPeaks) {
                    this.iYAxisDataInPixelsMirroredSpectrum.get((int)j)[i] = yValuePxl;
                }
                Color currentColor = g.getColor();
                Graphics2D g2 = (Graphics2D)g;
                Stroke tempStroke = g2.getStroke();
                if (!annotatedPeak && !this.showAllPeaks) {
                    g.setColor(this.peakWaterMarkColor);
                    stroke = new BasicStroke(this.backgroundPeakWidth);
                    g2.setStroke(stroke);
                } else {
                    stroke = new BasicStroke(this.peakWidth);
                    g2.setStroke(stroke);
                }
                if (this.iCurrentDrawStyle == DrawingStyle.LINES) {
                    g2.draw(new Line2D.Double(xAxisPxl, xAxisYLocation - this.iXPadding, xAxisPxl, yValuePxl));
                } else if (this.iCurrentDrawStyle == DrawingStyle.DOTS) {
                    g.fillOval(xAxisPxl - this.iDotRadius, yValuePxl - this.iDotRadius, this.iDotRadius * 2, this.iDotRadius * 2);
                }
                g2.setStroke(tempStroke);
                g.setColor(currentColor);
            }
        }
        g.setColor(originalColor);
    }

    protected void drawPeaks(Graphics g) {
        Color originalColor = g.getColor();
        this.iXAxisDataInPixels = new ArrayList();
        this.iYAxisDataInPixels = new ArrayList();
        block0: for (int j = 0; j < this.iXAxisData.size(); ++j) {
            g.setColor(this.iDataPointAndLineColor.get(j));
            this.iXAxisDataInPixels.add(new int[this.iXAxisData.get(j).length]);
            this.iYAxisDataInPixels.add(new int[this.iYAxisData.get(j).length]);
            for (int i = 0; i < this.iXAxisData.get(j).length; ++i) {
                BasicStroke stroke;
                double lXAxisValue = this.iXAxisData.get(j)[i];
                if (lXAxisValue < this.iXAxisMin) continue;
                if (lXAxisValue > this.iXAxisMax) continue block0;
                boolean annotatedPeak = true;
                if (!this.showAllPeaks) {
                    annotatedPeak = this.isPeakAnnotated(lXAxisValue);
                }
                double lYAxisValue = this.iYAxisData.get(j)[i];
                double tempDouble = (lXAxisValue - this.iXAxisMin) / this.iXScaleUnit;
                int temp = (int)tempDouble;
                if (tempDouble - (double)temp >= 0.5) {
                    ++temp;
                }
                int xAxisPxl = temp + this.iXPadding;
                if (annotatedPeak || this.showAllPeaks) {
                    this.iXAxisDataInPixels.get((int)j)[i] = xAxisPxl;
                }
                if ((tempDouble = (lYAxisValue - this.iYAxisMin) / this.iYScaleUnit) - (double)(temp = (int)tempDouble) >= 0.5) {
                    ++temp;
                }
                int xAxisYLocation = this.getHeight();
                if (this.dataSetCounterMirroredSpectra > 0) {
                    xAxisYLocation = (this.getHeight() + this.currentPadding) / 2;
                }
                int yValuePxl = xAxisYLocation - (temp + this.iXPadding);
                if (annotatedPeak || this.showAllPeaks) {
                    this.iYAxisDataInPixels.get((int)j)[i] = yValuePxl;
                }
                Color currentColor = g.getColor();
                Graphics2D g2 = (Graphics2D)g;
                Stroke tempStroke = g2.getStroke();
                if (!annotatedPeak && !this.showAllPeaks) {
                    g.setColor(this.peakWaterMarkColor);
                    stroke = new BasicStroke(this.backgroundPeakWidth);
                    g2.setStroke(stroke);
                } else {
                    stroke = new BasicStroke(this.peakWidth);
                    g2.setStroke(stroke);
                }
                if (this.iCurrentDrawStyle == DrawingStyle.LINES) {
                    g2.draw(new Line2D.Double(xAxisPxl, xAxisYLocation - this.iXPadding, xAxisPxl, yValuePxl));
                } else if (this.iCurrentDrawStyle == DrawingStyle.DOTS) {
                    g.fillOval(xAxisPxl - this.iDotRadius, yValuePxl - this.iDotRadius, this.iDotRadius * 2, this.iDotRadius * 2);
                }
                g2.setStroke(tempStroke);
                g.setColor(currentColor);
            }
        }
        g.setColor(originalColor);
    }

    protected void drawFilledPolygon(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Color originalColor = g2d.getColor();
        Composite originalComposite = g2d.getComposite();
        this.iXAxisDataInPixels = new ArrayList();
        this.iYAxisDataInPixels = new ArrayList();
        for (int j = 0; j < this.iXAxisData.size(); ++j) {
            int i;
            this.iXAxisDataInPixels.add(new int[this.iXAxisData.get(j).length]);
            this.iYAxisDataInPixels.add(new int[this.iYAxisData.get(j).length]);
            ArrayList<Integer> xAxisPointsShown = new ArrayList<Integer>();
            ArrayList<Integer> yAxisPointsShown = new ArrayList<Integer>();
            for (int i2 = 0; i2 < this.iXAxisData.get(j).length; ++i2) {
                int yAxisPxl;
                int xAxisPxl;
                double xMeasurement = this.iXAxisData.get(j)[i2];
                if (xMeasurement < this.iXAxisMin) continue;
                if (xMeasurement > this.iXAxisMax) break;
                double yMeasurement = this.iYAxisData.get(j)[i2];
                double tempDouble = (xMeasurement - this.iXAxisMin) / this.iXScaleUnit;
                int temp = (int)tempDouble;
                if (tempDouble - (double)temp >= 0.5) {
                    ++temp;
                }
                this.iXAxisDataInPixels.get((int)j)[i2] = xAxisPxl = temp + this.iXPadding;
                tempDouble = (yMeasurement - this.iYAxisMin) / this.iYScaleUnit;
                temp = (int)tempDouble;
                if (tempDouble - (double)temp >= 0.5) {
                    ++temp;
                }
                this.iYAxisDataInPixels.get((int)j)[i2] = yAxisPxl = this.getHeight() - (temp + this.iXPadding);
                xAxisPointsShown.add(xAxisPxl);
                yAxisPointsShown.add(yAxisPxl);
            }
            if (xAxisPointsShown.isEmpty()) continue;
            g.setColor(this.iAreaUnderCurveColor.get(j));
            if (j != 0) {
                g2d.setComposite(this.makeComposite(this.alphaLevel));
            }
            int[] xTemp = new int[xAxisPointsShown.size() + 2];
            int[] yTemp = new int[yAxisPointsShown.size() + 2];
            xTemp[0] = (Integer)xAxisPointsShown.get(0);
            yTemp[0] = this.getHeight() - this.iXPadding;
            for (i = 0; i < xAxisPointsShown.size(); ++i) {
                xTemp[i + 1] = (Integer)xAxisPointsShown.get(i);
                yTemp[i + 1] = (Integer)yAxisPointsShown.get(i);
            }
            xTemp[xTemp.length - 1] = (Integer)xAxisPointsShown.get(xAxisPointsShown.size() - 1);
            yTemp[xTemp.length - 1] = this.getHeight() - this.iXPadding;
            g2d.fillPolygon(xTemp, yTemp, xTemp.length);
            g.setColor(this.iDataPointAndLineColor.get(j));
            g2d.drawPolyline(xTemp, yTemp, xTemp.length);
            for (i = 1; i < xTemp.length - 1; ++i) {
                int x = xTemp[i] - this.iPointSize / 2;
                int y = yTemp[i] - this.iPointSize / 2;
                g2d.fillOval(x, y, this.iPointSize, this.iPointSize);
            }
            g2d.setComposite(originalComposite);
        }
        g2d.setColor(originalColor);
    }

    private AlphaComposite makeComposite(float alpha) {
        int type = 3;
        return AlphaComposite.getInstance(type, alpha);
    }

    public void setScientificXAxis(boolean scientificXAxis) {
        this.scientificXAxis = scientificXAxis;
    }

    public void setScientificXAxis(String pattern) {
        this.scientificXAxis = true;
        this.scientificPattern = pattern;
    }

    public void setScientificYAxis(boolean scientificYAxis) {
        this.scientificYAxis = scientificYAxis;
    }

    public void setScientificYAxis(String pattern) {
        this.scientificYAxis = true;
        this.scientificPattern = pattern;
    }

    public Color getPeakWaterMarkColor() {
        return this.peakWaterMarkColor;
    }

    public void setPeakWaterMarkColor(Color peakWaterMarkColor) {
        this.peakWaterMarkColor = peakWaterMarkColor;
    }

    private boolean isPeakAnnotated(double xAxisValue) {
        boolean annotatedPeak = false;
        for (int m = 0; m < this.iAnnotations.size() && !annotatedPeak; ++m) {
            Object o = this.iAnnotations.get(m);
            if (!(o instanceof SpectrumAnnotation)) continue;
            SpectrumAnnotation sa = (SpectrumAnnotation)o;
            double xValue = sa.getMZ();
            double error = Math.abs(sa.getErrorMargin());
            double delta = xAxisValue - xValue;
            if (!(Math.abs(delta) <= error)) continue;
            annotatedPeak = true;
        }
        return annotatedPeak;
    }

    static {
        try {
            if (iKnownMassDeltas == null) {
                iKnownMassDeltas = new HashMap();
                Properties temp = new Properties();
                InputStream is = SpectrumPanel.class.getClassLoader().getResourceAsStream("SpectrumPanel.properties");
                if (is != null) {
                    temp.load(is);
                    is.close();
                    for (String string : temp.keySet()) {
                        iKnownMassDeltas.put(new Double(string), temp.getProperty(string));
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static enum GraphicsPanelType {
        profileSpectrum,
        centroidSpectrum,
        profileChromatogram,
        centroidChromatogram,
        isotopicDistributionCentroid,
        isotopicDistributionProfile;

    }

    public static enum DrawingStyle {
        LINES,
        DOTS;

    }
}

