/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.tags;

import com.compomics.util.experiment.biology.AminoAcid;
import com.compomics.util.experiment.biology.AminoAcidPattern;
import com.compomics.util.experiment.biology.Atom;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.tags.TagComponent;
import com.compomics.util.experiment.identification.tags.tagcomponents.MassGap;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.preferences.ModificationProfile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import no.uib.jsparklines.renderers.util.Util;

public class Tag
extends ExperimentObject {
    static final long serialVersionUID = 1625541843008045218L;
    private ArrayList<TagComponent> content = new ArrayList();

    public Tag() {
    }

    public Tag(double nTermGap, AminoAcidPattern sequenceTag, double cTermGap) {
        this.addMassGap(nTermGap);
        this.addAminoAcidSequence(sequenceTag);
        this.addMassGap(cTermGap);
    }

    public ArrayList<TagComponent> getContent() {
        return this.content;
    }

    public void addMassGap(double massGap) {
        if (massGap != 0.0) {
            this.content.add(new MassGap(massGap));
        }
    }

    public void addAminoAcidSequence(AminoAcidPattern aminoAcidSequence) {
        if (aminoAcidSequence.length() > 0) {
            TagComponent lastComponent;
            if (!this.content.isEmpty() && (lastComponent = this.content.get(this.content.size() - 1)) instanceof AminoAcidPattern) {
                AminoAcidPattern pattern = (AminoAcidPattern)lastComponent;
                pattern.append(aminoAcidSequence);
                return;
            }
            this.content.add(aminoAcidSequence);
        }
    }

    public String asSequence() {
        String result = "";
        for (TagComponent tagComponent : this.content) {
            result = result + tagComponent.asSequence();
        }
        return result;
    }

    public String getLongestAminoAcidSequence() {
        String result = "";
        AminoAcidPattern lastAminoAcidPattern = null;
        for (TagComponent tagComponent : this.content) {
            if (tagComponent instanceof MassGap) {
                if (lastAminoAcidPattern != null && lastAminoAcidPattern.length() > result.length()) {
                    result = lastAminoAcidPattern.asSequence();
                }
                lastAminoAcidPattern = null;
                continue;
            }
            if (!(tagComponent instanceof AminoAcidPattern)) continue;
            AminoAcidPattern currentPattern = (AminoAcidPattern)tagComponent;
            if (lastAminoAcidPattern == null) {
                lastAminoAcidPattern = currentPattern;
                continue;
            }
            lastAminoAcidPattern.append(currentPattern);
        }
        if (lastAminoAcidPattern != null && lastAminoAcidPattern.length() > result.length()) {
            result = lastAminoAcidPattern.asSequence();
        }
        return result;
    }

    public double getMass() {
        double mass = Atom.H.getMonoisotopicMass();
        for (TagComponent tagComponent : this.content) {
            mass += tagComponent.getMass().doubleValue();
        }
        return mass += Atom.H.getMonoisotopicMass() + Atom.O.getMonoisotopicMass();
    }

    public double getMass(boolean includeCTermGap, boolean includeNTermGap) {
        double mass = this.getMass();
        if (!includeCTermGap) {
            mass -= this.getCTerminalGap();
        }
        if (!includeNTermGap) {
            mass -= this.getNTerminalGap();
        }
        return mass;
    }

    public double getNTerminalGap() {
        if (this.content.isEmpty()) {
            return 0.0;
        }
        TagComponent tagComponent = this.content.get(0);
        if (tagComponent instanceof MassGap) {
            return tagComponent.getMass();
        }
        return 0.0;
    }

    public double getCTerminalGap() {
        if (this.content.isEmpty()) {
            return 0.0;
        }
        TagComponent tagComponent = this.content.get(this.content.size() - 1);
        if (tagComponent instanceof MassGap) {
            return tagComponent.getMass();
        }
        return 0.0;
    }

    public String getTaggedModifiedSequence(ModificationProfile modificationProfile, boolean useHtmlColorCoding, boolean includeHtmlStartEndTags, boolean useShortName, boolean excludeAllFixedModifications, boolean includeTerminalGaps) {
        return Tag.getTaggedModifiedSequence(modificationProfile, this, useHtmlColorCoding, includeHtmlStartEndTags, useShortName, excludeAllFixedModifications, includeTerminalGaps);
    }

    public String getTaggedModifiedSequence(ModificationProfile modificationProfile, boolean useHtmlColorCoding, boolean includeHtmlStartEndTags, boolean useShortName, boolean includeTerminalGaps) {
        return Tag.getTaggedModifiedSequence(modificationProfile, this, useHtmlColorCoding, includeHtmlStartEndTags, useShortName, false, includeTerminalGaps);
    }

    public static String getTaggedModifiedSequence(ModificationProfile modificationProfile, Tag tag, boolean useHtmlColorCoding, boolean includeHtmlStartEndTags, boolean useShortName, boolean excludeAllFixedPtms, boolean includeTerminalGaps) {
        String modifiedSequence = "";
        if (useHtmlColorCoding && includeHtmlStartEndTags) {
            modifiedSequence = modifiedSequence + "<html>";
        }
        modifiedSequence = modifiedSequence + tag.getNTerminal(includeTerminalGaps);
        for (int i = 0; i < tag.getContent().size(); ++i) {
            TagComponent tagComponent = tag.getContent().get(i);
            if (tagComponent instanceof AminoAcidPattern) {
                AminoAcidPattern aminoAcidPattern = (AminoAcidPattern)tagComponent;
                modifiedSequence = modifiedSequence + aminoAcidPattern.getTaggedModifiedSequence(modificationProfile, useHtmlColorCoding, useShortName, excludeAllFixedPtms);
                continue;
            }
            if (!includeTerminalGaps && (i <= 0 || i >= tag.getContent().size() - 1)) continue;
            modifiedSequence = modifiedSequence + tagComponent.asSequence();
        }
        modifiedSequence = modifiedSequence + tag.getCTerminal(includeTerminalGaps);
        if (useHtmlColorCoding && includeHtmlStartEndTags) {
            modifiedSequence = modifiedSequence + "</html>";
        }
        return modifiedSequence;
    }

    public String getNTerminal(boolean includeTerminalGaps) {
        if (this.content.isEmpty()) {
            return "";
        }
        TagComponent firstComponent = this.content.get(0);
        if (firstComponent instanceof AminoAcidPattern) {
            AminoAcidPattern aminoAcidPattern = (AminoAcidPattern)firstComponent;
            String nTerm = "NH2";
            PTMFactory ptmFactory = PTMFactory.getInstance();
            for (ModificationMatch modificationMatch : aminoAcidPattern.getModificationsAt(1)) {
                PTM ptm = ptmFactory.getPTM(modificationMatch.getTheoreticPtm());
                if (ptm.getType() == 0 || ptm.getType() == 9) continue;
                nTerm = ptmFactory.getShortName(modificationMatch.getTheoreticPtm());
            }
            nTerm = nTerm.replaceAll("-", " ");
            return nTerm + "-";
        }
        if (firstComponent instanceof MassGap) {
            if (includeTerminalGaps) {
                return firstComponent.asSequence();
            }
            return Util.roundDouble((double)firstComponent.getMass(), (int)2) + "-";
        }
        throw new IllegalArgumentException("Terminal tag not implemented for TagComponent " + firstComponent.getClass() + ".");
    }

    public String getCTerminal(boolean includeTerminalGaps) {
        if (this.content.isEmpty()) {
            return "";
        }
        TagComponent lastComponent = this.content.get(this.content.size() - 1);
        if (lastComponent instanceof AminoAcidPattern) {
            AminoAcidPattern aminoAcidPattern = (AminoAcidPattern)lastComponent;
            String cTerm = "COOH";
            PTMFactory ptmFactory = PTMFactory.getInstance();
            for (ModificationMatch modificationMatch : aminoAcidPattern.getModificationsAt(1)) {
                PTM ptm = ptmFactory.getPTM(modificationMatch.getTheoreticPtm());
                if (ptm.getType() == 0 || ptm.getType() == 9) continue;
                cTerm = ptmFactory.getShortName(modificationMatch.getTheoreticPtm());
            }
            cTerm = cTerm.replaceAll("-", " ");
            return "-" + cTerm;
        }
        if (lastComponent instanceof MassGap) {
            if (includeTerminalGaps) {
                return lastComponent.asSequence();
            }
            return "-" + Util.roundDouble((double)lastComponent.getMass(), (int)2);
        }
        throw new IllegalArgumentException("Terminal tag not implemented for TagComponent " + lastComponent.getClass() + ".");
    }

    public int getLengthInAminoAcid() {
        int length = 0;
        for (TagComponent tagComponent : this.content) {
            if (tagComponent instanceof AminoAcidPattern) {
                AminoAcidPattern aminoAcidPattern = (AminoAcidPattern)tagComponent;
                length += aminoAcidPattern.length();
                continue;
            }
            ++length;
        }
        return length;
    }

    public ArrayList<Integer> getPotentialModificationSites(PTM ptm, AminoAcidPattern.MatchingType matchingType, Double massTolerance) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException {
        ArrayList<Integer> possibleSites = new ArrayList<Integer>();
        AminoAcidPattern ptmPattern = ptm.getPattern();
        int patternLength = ptmPattern.length();
        switch (ptm.getType()) {
            case 0: {
                int offset = 0;
                for (TagComponent tagComponent : this.content) {
                    if (tagComponent instanceof AminoAcidPattern) {
                        AminoAcidPattern aminoAcidPattern = (AminoAcidPattern)tagComponent;
                        for (int i : ptmPattern.getIndexes(aminoAcidPattern)) {
                            possibleSites.add(i + offset);
                        }
                        offset += aminoAcidPattern.length();
                        continue;
                    }
                    ++offset;
                }
                return possibleSites;
            }
            case 3: 
            case 7: {
                possibleSites.add(patternLength);
                return possibleSites;
            }
            case 1: 
            case 5: {
                possibleSites.add(1);
                return possibleSites;
            }
            case 4: 
            case 8: {
                if (this.content.isEmpty()) {
                    return new ArrayList<Integer>();
                }
                TagComponent component = this.content.get(this.content.size() - 1);
                if (component instanceof AminoAcidPattern) {
                    AminoAcidPattern aminoAcidPattern = (AminoAcidPattern)component;
                    if (ptmPattern.isEnding(aminoAcidPattern)) {
                        possibleSites.add(patternLength);
                    }
                } else {
                    possibleSites.add(patternLength);
                }
                return possibleSites;
            }
            case 2: 
            case 6: {
                if (this.content.isEmpty()) {
                    return new ArrayList<Integer>();
                }
                TagComponent component = this.content.get(0);
                if (component instanceof AminoAcidPattern) {
                    AminoAcidPattern aminoAcidPattern = (AminoAcidPattern)component;
                    if (ptmPattern.isStarting(aminoAcidPattern)) {
                        possibleSites.add(patternLength);
                    }
                } else {
                    possibleSites.add(patternLength);
                }
                return possibleSites;
            }
        }
        throw new IllegalArgumentException("PTM type " + ptm.getType() + " not recognized.");
    }

    public boolean isSameAs(Tag anotherTag) {
        if (this.content.size() != anotherTag.getContent().size()) {
            return false;
        }
        for (int i = 0; i < this.content.size(); ++i) {
            TagComponent component2;
            TagComponent component1 = this.content.get(i);
            if (!component1.isSameAs(component2 = anotherTag.getContent().get(i))) continue;
            return false;
        }
        return true;
    }

    public HashMap<Integer, ArrayList<Peptide>> getPeptideMatches(String sequence, int tagIndex, int componentIndex, AminoAcidPattern.MatchingType matchingType, Double massTolerance, ArrayList<String> fixedModifications, ArrayList<String> variableModifications, boolean reportFixedPtms) {
        PTM ptm;
        PTM ptm2;
        HashMap<Integer, ArrayList<Peptide>> result = new HashMap<Integer, ArrayList<Peptide>>();
        double minMod = 0.0;
        for (String modificationName : variableModifications) {
            PTM ptm3 = PTMFactory.getInstance().getPTM(modificationName);
            if (!(ptm3.getMass() < minMod)) continue;
            minMod = ptm3.getMass();
        }
        int sequenceLastIndex = sequence.length() - 1;
        HashMap<AminoAcidPattern, Integer> nTermPossiblePatternsIndexes = new HashMap<AminoAcidPattern, Integer>();
        nTermPossiblePatternsIndexes.put(new AminoAcidPattern(), tagIndex);
        for (int i = componentIndex - 1; i >= 0; --i) {
            TagComponent tagComponent = this.content.get(i);
            HashMap<AminoAcidPattern, Integer> newIndexes = new HashMap<AminoAcidPattern, Integer>();
            if (tagComponent instanceof AminoAcidPattern) {
                for (AminoAcidPattern nTermPattern : nTermPossiblePatternsIndexes.keySet()) {
                    String subSequence;
                    AminoAcidPattern aminoAcidPattern;
                    int aaIndex = (Integer)nTermPossiblePatternsIndexes.get(nTermPattern);
                    int startIndex = aaIndex - (aminoAcidPattern = (AminoAcidPattern)tagComponent).length();
                    if (startIndex < 0 || !aminoAcidPattern.matches(subSequence = sequence.substring(startIndex, aaIndex), matchingType, massTolerance)) continue;
                    AminoAcidPattern newPattern = (AminoAcidPattern)tagComponent;
                    boolean goodTerminalPTms = true;
                    if (i == 0) {
                        for (String modificationName : fixedModifications) {
                            boolean found;
                            PTM ptm4 = PTMFactory.getInstance().getPTM(modificationName);
                            if (ptm4.getType() == 5 || ptm4.getType() == 1 && startIndex == 0) {
                                found = false;
                                for (ModificationMatch modificationMatch : newPattern.getModificationsAt(1)) {
                                    if (!modificationMatch.getTheoreticPtm().equals(modificationName)) continue;
                                    found = true;
                                    break;
                                }
                                if (found) continue;
                                goodTerminalPTms = false;
                                break;
                            }
                            if (ptm4.getType() != 6 && (ptm4.getType() != 2 || startIndex != 0)) continue;
                            if (ptm4.getPattern().firstIndex(subSequence, matchingType, massTolerance) != 0) {
                                goodTerminalPTms = false;
                                break;
                            }
                            found = false;
                            for (ModificationMatch modificationMatch : newPattern.getModificationsAt(1)) {
                                if (!modificationMatch.getTheoreticPtm().equals(modificationName)) continue;
                                found = true;
                                break;
                            }
                            if (found) continue;
                            goodTerminalPTms = false;
                            break;
                        }
                    }
                    if (!goodTerminalPTms) continue;
                    newPattern.append(nTermPattern);
                    newIndexes.put(newPattern, startIndex);
                }
            } else if (tagComponent instanceof MassGap) {
                double massGap = tagComponent.getMass();
                for (AminoAcidPattern nTermPattern : nTermPossiblePatternsIndexes.keySet()) {
                    int aaIndex = (Integer)nTermPossiblePatternsIndexes.get(nTermPattern);
                    HashMap<AminoAcidPattern, Double> possiblePatternsMasses = new HashMap<AminoAcidPattern, Double>();
                    ArrayList<AminoAcidPattern> validPatterns = new ArrayList<AminoAcidPattern>();
                    while (--aaIndex >= 0) {
                        AminoAcidPattern ptmPattern;
                        char aa = sequence.charAt(aaIndex);
                        AminoAcid aminoAcid = AminoAcid.getAminoAcid(aa);
                        double fixedMass = 0.0;
                        ArrayList<ModificationMatch> fixedModificationMatches = new ArrayList<ModificationMatch>();
                        for (String modificationName : fixedModifications) {
                            PTM ptm5 = PTMFactory.getInstance().getPTM(modificationName);
                            AminoAcidPattern ptmPattern2 = ptm5.getPattern();
                            if (ptm5.getType() != 0 || !ptmPattern2.isTargeted(aa, ptmPattern2.getTarget(), matchingType, massTolerance)) continue;
                            fixedMass += ptm5.getMass();
                            fixedModificationMatches.add(new ModificationMatch(modificationName, false, 1));
                        }
                        if (possiblePatternsMasses.isEmpty()) {
                            AminoAcidPattern newPattern = new AminoAcidPattern(aminoAcid.singleLetterCode);
                            if (reportFixedPtms) {
                                for (ModificationMatch modificationMatch : fixedModificationMatches) {
                                    newPattern.addModificationMatch(1, modificationMatch);
                                }
                            }
                            double noModMass = aminoAcid.monoisotopicMass + fixedMass;
                            possiblePatternsMasses.put(newPattern, noModMass);
                            for (String modificationName : variableModifications) {
                                ptm2 = PTMFactory.getInstance().getPTM(modificationName);
                                AminoAcidPattern ptmPattern3 = ptm2.getPattern();
                                if (ptm2.getType() != 0 || !ptmPattern3.isTargeted(aa, ptmPattern3.getTarget(), matchingType, massTolerance)) continue;
                                newPattern = new AminoAcidPattern(aminoAcid.singleLetterCode);
                                newPattern.addModificationMatch(1, new ModificationMatch(modificationName, true, 1));
                                double newMass = noModMass + ptm2.getMass();
                                possiblePatternsMasses.put(newPattern, newMass);
                            }
                        } else {
                            HashMap<AminoAcidPattern, Double> newPatternsMasses = new HashMap<AminoAcidPattern, Double>();
                            for (AminoAcidPattern aminoAcidPattern : possiblePatternsMasses.keySet()) {
                                AminoAcidPattern newPattern = new AminoAcidPattern(aminoAcid.singleLetterCode);
                                double noModMass = aminoAcid.monoisotopicMass + fixedMass + (Double)possiblePatternsMasses.get(aminoAcidPattern);
                                newPattern.append(aminoAcidPattern);
                                if (reportFixedPtms) {
                                    for (ModificationMatch modificationMatch : fixedModificationMatches) {
                                        newPattern.addModificationMatch(1, modificationMatch);
                                    }
                                }
                                newPatternsMasses.put(newPattern, noModMass);
                                for (String modificationName : variableModifications) {
                                    ptm = PTMFactory.getInstance().getPTM(modificationName);
                                    ptmPattern = ptm.getPattern();
                                    if (ptm.getType() != 0 || !ptmPattern.isTargeted(aa, ptmPattern.getTarget(), matchingType, massTolerance)) continue;
                                    newPattern = new AminoAcidPattern(aminoAcid.singleLetterCode);
                                    newPattern.append(aminoAcidPattern);
                                    newPattern.addModificationMatch(1, new ModificationMatch(modificationName, true, 1));
                                    double newMass = noModMass + ptm.getMass();
                                    newPatternsMasses.put(newPattern, newMass);
                                }
                            }
                            possiblePatternsMasses = newPatternsMasses;
                        }
                        ArrayList<ModificationMatch> nTermModifications = new ArrayList<ModificationMatch>();
                        double fixedNTermModifications = 0.0;
                        for (String modificationName : fixedModifications) {
                            ptm2 = PTMFactory.getInstance().getPTM(modificationName);
                            if (ptm2.getType() != 5) continue;
                            fixedNTermModifications = ptm2.getMass();
                            nTermModifications.add(new ModificationMatch(modificationName, false, 1));
                            break;
                        }
                        if (aaIndex == 0) {
                            for (String modificationName : fixedModifications) {
                                ptm2 = PTMFactory.getInstance().getPTM(modificationName);
                                if (ptm2.getType() != 1) continue;
                                fixedNTermModifications = ptm2.getMass();
                                nTermModifications.add(new ModificationMatch(modificationName, false, 1));
                                break;
                            }
                        }
                        ArrayList aminoAcidPatterns = new ArrayList(possiblePatternsMasses.keySet());
                        block16: for (AminoAcidPattern aminoAcidPattern : aminoAcidPatterns) {
                            AminoAcidPattern ptmPattern4;
                            PTM ptm6;
                            for (String modificationName : fixedModifications) {
                                ptm = PTMFactory.getInstance().getPTM(modificationName);
                                ptmPattern = ptm.getPattern();
                                if (ptm.getType() != 6 || !ptmPattern.isTargeted(aminoAcidPattern.getTargetedAA((int)0).get((int)0).singleLetterCode.charAt(0), ptmPattern.getTarget(), matchingType, massTolerance)) continue;
                                fixedNTermModifications = ptm.getMass();
                                nTermModifications.add(new ModificationMatch(modificationName, false, 1));
                                break;
                            }
                            if (aaIndex == 0) {
                                for (String modificationName : fixedModifications) {
                                    ptm = PTMFactory.getInstance().getPTM(modificationName);
                                    ptmPattern = ptm.getPattern();
                                    if (ptm.getType() != 2 || !ptmPattern.isTargeted(aminoAcidPattern.getTargetedAA((int)0).get((int)0).singleLetterCode.charAt(0), ptmPattern.getTarget(), matchingType, massTolerance)) continue;
                                    fixedNTermModifications = ptm.getMass();
                                    nTermModifications.add(new ModificationMatch(modificationName, false, 1));
                                    break;
                                }
                            }
                            if ((Double)possiblePatternsMasses.get(aminoAcidPattern) + fixedNTermModifications + minMod > massGap + massTolerance) {
                                possiblePatternsMasses.remove(aminoAcidPattern);
                                continue;
                            }
                            if (Math.abs((Double)possiblePatternsMasses.get(aminoAcidPattern) + fixedNTermModifications - massGap) <= massTolerance) {
                                if (reportFixedPtms) {
                                    for (ModificationMatch modificationMatch : nTermModifications) {
                                        aminoAcidPattern.addModificationMatch(1, modificationMatch);
                                    }
                                }
                                validPatterns.add(aminoAcidPattern);
                                possiblePatternsMasses.remove(aminoAcidPattern);
                                continue;
                            }
                            boolean found = false;
                            if (aaIndex == 0) {
                                for (String modificationName : variableModifications) {
                                    ptm6 = PTMFactory.getInstance().getPTM(modificationName);
                                    ptmPattern4 = ptm6.getPattern();
                                    if (ptm6.getType() != 1 && (ptm6.getType() != 2 || !ptmPattern4.isTargeted(aminoAcidPattern.getTargetedAA((int)0).get((int)0).singleLetterCode.charAt(0), ptmPattern4.getTarget(), matchingType, massTolerance)) || !(Math.abs((Double)possiblePatternsMasses.get(aminoAcidPattern) + fixedNTermModifications + ptm6.getMass() - massGap) <= massTolerance)) continue;
                                    aminoAcidPattern.addModificationMatch(1, new ModificationMatch(modificationName, true, 1));
                                    if (reportFixedPtms) {
                                        for (ModificationMatch modificationMatch : nTermModifications) {
                                            aminoAcidPattern.addModificationMatch(1, modificationMatch);
                                        }
                                    }
                                    validPatterns.add(aminoAcidPattern);
                                    possiblePatternsMasses.remove(aminoAcidPattern);
                                    found = true;
                                    break;
                                }
                            }
                            if (found) continue;
                            for (String modificationName : variableModifications) {
                                ptm6 = PTMFactory.getInstance().getPTM(modificationName);
                                ptmPattern4 = ptm6.getPattern();
                                if (ptm6.getType() != 5 && (ptm6.getType() != 6 || !ptmPattern4.isTargeted(aminoAcidPattern.getTargetedAA((int)0).get((int)0).singleLetterCode.charAt(0), ptmPattern4.getTarget(), matchingType, massTolerance)) || !(Math.abs((Double)possiblePatternsMasses.get(aminoAcidPattern) + fixedNTermModifications + ptm6.getMass() - massGap) <= massTolerance)) continue;
                                aminoAcidPattern.addModificationMatch(1, new ModificationMatch(modificationName, true, 1));
                                if (reportFixedPtms) {
                                    for (ModificationMatch modificationMatch : nTermModifications) {
                                        aminoAcidPattern.addModificationMatch(1, modificationMatch);
                                    }
                                }
                                validPatterns.add(aminoAcidPattern);
                                possiblePatternsMasses.remove(aminoAcidPattern);
                                continue block16;
                            }
                        }
                        if (!possiblePatternsMasses.isEmpty()) continue;
                        break;
                    }
                    for (AminoAcidPattern aminoAcidPattern : validPatterns) {
                        aminoAcidPattern.append(nTermPattern);
                        int newIndex = (Integer)nTermPossiblePatternsIndexes.get(nTermPattern) - aminoAcidPattern.length();
                        newIndexes.put(aminoAcidPattern, newIndex);
                    }
                }
            } else {
                throw new IllegalArgumentException("Tag component " + tagComponent.getClass() + " not implemented for sequence matching.");
            }
            if (newIndexes.isEmpty()) {
                return result;
            }
            nTermPossiblePatternsIndexes = newIndexes;
        }
        AminoAcidPattern tagPattern = (AminoAcidPattern)this.content.get(componentIndex);
        if (componentIndex == 0) {
            boolean goodTerminalPTms = true;
            for (String modificationName : fixedModifications) {
                boolean found;
                PTM ptm7 = PTMFactory.getInstance().getPTM(modificationName);
                if (ptm7.getType() == 5 || ptm7.getType() == 1 && tagIndex == 0) {
                    found = false;
                    for (ModificationMatch modificationMatch : tagPattern.getModificationsAt(1)) {
                        if (!modificationMatch.getTheoreticPtm().equals(modificationName)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    goodTerminalPTms = false;
                    break;
                }
                if (ptm7.getType() != 6 && (ptm7.getType() != 2 || tagIndex != 0)) continue;
                if (ptm7.getPattern().firstIndex(tagPattern, matchingType, massTolerance) != 0) {
                    goodTerminalPTms = false;
                    break;
                }
                found = false;
                for (ModificationMatch modificationMatch : tagPattern.getModificationsAt(1)) {
                    if (!modificationMatch.getTheoreticPtm().equals(modificationName)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                goodTerminalPTms = false;
                break;
            }
            if (!goodTerminalPTms) {
                return result;
            }
        }
        int endTagIndex = tagIndex + tagPattern.length() - 1;
        if (componentIndex == this.content.size() - 1) {
            boolean goodTerminalPTms = true;
            for (String modificationName : fixedModifications) {
                PTM ptm8 = PTMFactory.getInstance().getPTM(modificationName);
                if (ptm8.getType() == 7 || ptm8.getType() == 3 && endTagIndex == sequenceLastIndex) {
                    boolean found = false;
                    for (ModificationMatch modificationMatch : tagPattern.getModificationsAt(tagPattern.length())) {
                        if (!modificationMatch.getTheoreticPtm().equals(modificationName)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    goodTerminalPTms = false;
                    break;
                }
                if (ptm8.getType() != 8 && (ptm8.getType() != 4 || endTagIndex != sequenceLastIndex)) continue;
                if (ptm8.getPattern().firstIndex(tagPattern, matchingType, massTolerance) != 0) {
                    goodTerminalPTms = false;
                    break;
                }
                boolean found = false;
                for (ModificationMatch modificationMatch : tagPattern.getModificationsAt(tagPattern.length())) {
                    if (!modificationMatch.getTheoreticPtm().equals(modificationName)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                goodTerminalPTms = false;
                break;
            }
            if (!goodTerminalPTms) {
                return result;
            }
        }
        HashMap<AminoAcidPattern, Integer> cTermPossiblePatternsIndexes = new HashMap<AminoAcidPattern, Integer>();
        cTermPossiblePatternsIndexes.put(new AminoAcidPattern(), endTagIndex);
        for (int i = componentIndex + 1; i < this.content.size(); ++i) {
            TagComponent tagComponent = this.content.get(i);
            HashMap<AminoAcidPattern, Integer> newIndexes = new HashMap<AminoAcidPattern, Integer>();
            if (tagComponent instanceof AminoAcidPattern) {
                for (AminoAcidPattern cTermPattern : cTermPossiblePatternsIndexes.keySet()) {
                    String subSequence;
                    AminoAcidPattern aminoAcidPattern;
                    int aaIndex = (Integer)cTermPossiblePatternsIndexes.get(cTermPattern);
                    int endIndex = aaIndex + (aminoAcidPattern = (AminoAcidPattern)tagComponent).length();
                    if (endIndex > sequenceLastIndex || !aminoAcidPattern.matches(subSequence = sequence.substring(aaIndex, endIndex), matchingType, massTolerance)) continue;
                    AminoAcidPattern newPattern = (AminoAcidPattern)tagComponent;
                    boolean goodTerminalPTms = true;
                    if (i == 0) {
                        for (String modificationName : fixedModifications) {
                            boolean found;
                            PTM ptm9 = PTMFactory.getInstance().getPTM(modificationName);
                            if (ptm9.getType() == 7 || ptm9.getType() == 3 && endIndex == sequenceLastIndex) {
                                found = false;
                                for (ModificationMatch modificationMatch : newPattern.getModificationsAt(newPattern.length())) {
                                    if (!modificationMatch.getTheoreticPtm().equals(modificationName)) continue;
                                    found = true;
                                    break;
                                }
                                if (found) continue;
                                goodTerminalPTms = false;
                                break;
                            }
                            if (ptm9.getType() != 8 && (ptm9.getType() != 4 || endIndex != sequenceLastIndex)) continue;
                            if (ptm9.getPattern().firstIndex(subSequence, matchingType, massTolerance) != 0) {
                                goodTerminalPTms = false;
                                break;
                            }
                            found = false;
                            for (ModificationMatch modificationMatch : newPattern.getModificationsAt(newPattern.length())) {
                                if (!modificationMatch.getTheoreticPtm().equals(modificationName)) continue;
                                found = true;
                                break;
                            }
                            if (found) continue;
                            goodTerminalPTms = false;
                            break;
                        }
                    }
                    if (!goodTerminalPTms) continue;
                    cTermPattern.append(newPattern);
                    newIndexes.put(cTermPattern, endIndex);
                }
            } else if (tagComponent instanceof MassGap) {
                double massGap = tagComponent.getMass();
                for (AminoAcidPattern cTermPattern : cTermPossiblePatternsIndexes.keySet()) {
                    int aaIndex = (Integer)cTermPossiblePatternsIndexes.get(cTermPattern);
                    HashMap<AminoAcidPattern, Double> possiblePatternsMasses = new HashMap<AminoAcidPattern, Double>();
                    ArrayList<AminoAcidPattern> validPatterns = new ArrayList<AminoAcidPattern>();
                    while (++aaIndex <= sequenceLastIndex) {
                        AminoAcidPattern ptmPattern;
                        PTM ptm10;
                        char aa = sequence.charAt(aaIndex);
                        AminoAcid aminoAcid = AminoAcid.getAminoAcid(aa);
                        double fixedMass = 0.0;
                        ArrayList<ModificationMatch> fixedModificationMatches = new ArrayList<ModificationMatch>();
                        for (String modificationName : fixedModifications) {
                            ptm2 = PTMFactory.getInstance().getPTM(modificationName);
                            AminoAcidPattern ptmPattern5 = ptm2.getPattern();
                            if (ptm2.getType() != 0 || !ptmPattern5.isTargeted(aa, ptmPattern5.getTarget(), matchingType, massTolerance)) continue;
                            fixedMass += ptm2.getMass();
                            fixedModificationMatches.add(new ModificationMatch(modificationName, false, 1));
                        }
                        if (possiblePatternsMasses.isEmpty()) {
                            AminoAcidPattern newPattern = new AminoAcidPattern(aminoAcid.singleLetterCode);
                            int modIndex = newPattern.length();
                            if (reportFixedPtms) {
                                for (ModificationMatch modificationMatch : fixedModificationMatches) {
                                    modificationMatch.setModificationSite(modIndex);
                                    newPattern.addModificationMatch(modIndex, modificationMatch);
                                }
                            }
                            double noModMass = aminoAcid.monoisotopicMass + fixedMass;
                            possiblePatternsMasses.put(newPattern, noModMass);
                            for (String modificationName : variableModifications) {
                                PTM ptm11 = PTMFactory.getInstance().getPTM(modificationName);
                                AminoAcidPattern ptmPattern6 = ptm11.getPattern();
                                if (ptm11.getType() != 0 || !ptmPattern6.isTargeted(aa, ptmPattern6.getTarget(), matchingType, massTolerance)) continue;
                                newPattern = new AminoAcidPattern(aminoAcid.singleLetterCode);
                                newPattern.addModificationMatch(modIndex, new ModificationMatch(modificationName, true, modIndex));
                                double newMass = noModMass + ptm11.getMass();
                                possiblePatternsMasses.put(newPattern, newMass);
                            }
                        } else {
                            HashMap<AminoAcidPattern, Double> newPatternsMasses = new HashMap<AminoAcidPattern, Double>();
                            for (AminoAcidPattern aminoAcidPattern : possiblePatternsMasses.keySet()) {
                                AminoAcidPattern newPattern = new AminoAcidPattern(aminoAcidPattern);
                                double noModMass = aminoAcid.monoisotopicMass + fixedMass + (Double)possiblePatternsMasses.get(aminoAcidPattern);
                                newPattern.append(new AminoAcidPattern(aminoAcid.singleLetterCode));
                                int modIndex = newPattern.length();
                                if (reportFixedPtms) {
                                    for (ModificationMatch modificationMatch : fixedModificationMatches) {
                                        modificationMatch.setModificationSite(modIndex);
                                        newPattern.addModificationMatch(modIndex, modificationMatch);
                                    }
                                }
                                newPatternsMasses.put(newPattern, noModMass);
                                for (String modificationName : variableModifications) {
                                    ptm10 = PTMFactory.getInstance().getPTM(modificationName);
                                    ptmPattern = ptm10.getPattern();
                                    if (ptm10.getType() != 0 || !ptmPattern.isTargeted(aa, ptmPattern.getTarget(), matchingType, massTolerance)) continue;
                                    newPattern = new AminoAcidPattern(aminoAcidPattern);
                                    newPattern.append(new AminoAcidPattern(aminoAcid.singleLetterCode));
                                    newPattern.addModificationMatch(modIndex, new ModificationMatch(modificationName, true, modIndex));
                                    double newMass = noModMass + ptm10.getMass();
                                    newPatternsMasses.put(newPattern, newMass);
                                }
                            }
                            possiblePatternsMasses = newPatternsMasses;
                        }
                        double fixedCTermModifications = 0.0;
                        ArrayList<ModificationMatch> cTermModifications = new ArrayList<ModificationMatch>();
                        for (String modificationName : fixedModifications) {
                            ptm = PTMFactory.getInstance().getPTM(modificationName);
                            if (ptm.getType() != 7) continue;
                            fixedCTermModifications = ptm.getMass();
                            cTermModifications.add(new ModificationMatch(modificationName, false, 1));
                            break;
                        }
                        if (aaIndex == sequenceLastIndex) {
                            for (String modificationName : fixedModifications) {
                                ptm = PTMFactory.getInstance().getPTM(modificationName);
                                if (ptm.getType() != 3) continue;
                                fixedCTermModifications = ptm.getMass();
                                cTermModifications.add(new ModificationMatch(modificationName, false, 1));
                                break;
                            }
                        }
                        ArrayList aminoAcidPatterns = new ArrayList(possiblePatternsMasses.keySet());
                        block46: for (AminoAcidPattern aminoAcidPattern : aminoAcidPatterns) {
                            AminoAcidPattern ptmPattern7;
                            PTM ptm12;
                            int lastAminoAcidIndex = aminoAcidPattern.length() - 1;
                            for (String modificationName : fixedModifications) {
                                ptm10 = PTMFactory.getInstance().getPTM(modificationName);
                                ptmPattern = ptm10.getPattern();
                                if (ptm10.getType() != 8 || !ptmPattern.isTargeted(aminoAcidPattern.getTargetedAA((int)lastAminoAcidIndex).get((int)0).singleLetterCode.charAt(0), ptmPattern.getTarget(), matchingType, massTolerance)) continue;
                                fixedCTermModifications = ptm10.getMass();
                                cTermModifications.add(new ModificationMatch(modificationName, false, 1));
                                break;
                            }
                            if (aaIndex == lastAminoAcidIndex) {
                                for (String modificationName : fixedModifications) {
                                    ptm10 = PTMFactory.getInstance().getPTM(modificationName);
                                    ptmPattern = ptm10.getPattern();
                                    if (ptm10.getType() != 4 || !ptmPattern.isTargeted(aminoAcidPattern.getTargetedAA((int)lastAminoAcidIndex).get((int)0).singleLetterCode.charAt(0), ptmPattern.getTarget(), matchingType, massTolerance)) continue;
                                    fixedCTermModifications = ptm10.getMass();
                                    cTermModifications.add(new ModificationMatch(modificationName, false, 1));
                                    break;
                                }
                            }
                            if ((Double)possiblePatternsMasses.get(aminoAcidPattern) + fixedCTermModifications + minMod > massGap + massTolerance) {
                                possiblePatternsMasses.remove(aminoAcidPattern);
                                continue;
                            }
                            int modIndex = aminoAcidPattern.length();
                            if (Math.abs((Double)possiblePatternsMasses.get(aminoAcidPattern) + fixedCTermModifications - massGap) <= massTolerance) {
                                validPatterns.add(aminoAcidPattern);
                                if (reportFixedPtms) {
                                    for (ModificationMatch modificationMatch : cTermModifications) {
                                        modificationMatch.setModificationSite(modIndex);
                                        aminoAcidPattern.addModificationMatch(modIndex, modificationMatch);
                                    }
                                }
                                possiblePatternsMasses.remove(aminoAcidPattern);
                                continue;
                            }
                            boolean found = false;
                            if (aaIndex == lastAminoAcidIndex) {
                                for (String modificationName : variableModifications) {
                                    ptm12 = PTMFactory.getInstance().getPTM(modificationName);
                                    ptmPattern7 = ptm12.getPattern();
                                    if (ptm12.getType() != 3 && (ptm12.getType() != 4 || !ptmPattern7.isTargeted(aminoAcidPattern.getTargetedAA((int)lastAminoAcidIndex).get((int)0).singleLetterCode.charAt(0), ptmPattern7.getTarget(), matchingType, massTolerance)) || !(Math.abs((Double)possiblePatternsMasses.get(aminoAcidPattern) + fixedCTermModifications + ptm12.getMass() - massGap) <= massTolerance)) continue;
                                    aminoAcidPattern.addModificationMatch(lastAminoAcidIndex, new ModificationMatch(modificationName, true, modIndex));
                                    validPatterns.add(aminoAcidPattern);
                                    if (reportFixedPtms) {
                                        for (ModificationMatch modificationMatch : cTermModifications) {
                                            modificationMatch.setModificationSite(modIndex);
                                            aminoAcidPattern.addModificationMatch(modIndex, modificationMatch);
                                        }
                                    }
                                    possiblePatternsMasses.remove(aminoAcidPattern);
                                    found = true;
                                    break;
                                }
                            }
                            if (found) continue;
                            for (String modificationName : variableModifications) {
                                ptm12 = PTMFactory.getInstance().getPTM(modificationName);
                                ptmPattern7 = ptm12.getPattern();
                                if (ptm12.getType() != 7 && (ptm12.getType() != 8 || !ptmPattern7.isTargeted(aminoAcidPattern.getTargetedAA((int)lastAminoAcidIndex).get((int)0).singleLetterCode.charAt(0), ptmPattern7.getTarget(), matchingType, massTolerance)) || !(Math.abs((Double)possiblePatternsMasses.get(aminoAcidPattern) + fixedCTermModifications + ptm12.getMass() - massGap) <= massTolerance)) continue;
                                aminoAcidPattern.addModificationMatch(lastAminoAcidIndex, new ModificationMatch(modificationName, true, modIndex));
                                if (reportFixedPtms) {
                                    for (ModificationMatch modificationMatch : cTermModifications) {
                                        modificationMatch.setModificationSite(modIndex);
                                        aminoAcidPattern.addModificationMatch(modIndex, modificationMatch);
                                    }
                                }
                                validPatterns.add(aminoAcidPattern);
                                possiblePatternsMasses.remove(aminoAcidPattern);
                                continue block46;
                            }
                        }
                        if (!possiblePatternsMasses.isEmpty()) continue;
                        break;
                    }
                    for (AminoAcidPattern aminoAcidPattern : validPatterns) {
                        AminoAcidPattern newPattern = new AminoAcidPattern(cTermPattern);
                        newPattern.append(aminoAcidPattern);
                        int newIndex = (Integer)cTermPossiblePatternsIndexes.get(cTermPattern) + aminoAcidPattern.length();
                        newIndexes.put(newPattern, newIndex);
                    }
                }
            } else {
                throw new IllegalArgumentException("Tag component " + tagComponent.getClass() + " not implemented for sequence mating.");
            }
            if (newIndexes.isEmpty()) {
                return result;
            }
            cTermPossiblePatternsIndexes = newIndexes;
        }
        String seedSequence = sequence.substring(tagIndex, tagIndex + tagPattern.length());
        for (AminoAcidPattern nTerm : nTermPossiblePatternsIndexes.keySet()) {
            int nTermIndex = (Integer)nTermPossiblePatternsIndexes.get(nTerm);
            StringBuilder nTermSequence = new StringBuilder(nTerm.length() + seedSequence.length());
            for (int i = 0; i < nTerm.length(); ++i) {
                nTermSequence.append(nTerm.getTargetedAA((int)i).get((int)0).singleLetterCode);
            }
            nTermSequence.append(seedSequence);
            for (AminoAcidPattern cTerm : cTermPossiblePatternsIndexes.keySet()) {
                HashMap<Integer, ArrayList<ModificationMatch>> sequenceModifications;
                StringBuilder peptideSequence = new StringBuilder(nTerm.length() + seedSequence.length() + cTerm.length());
                peptideSequence.append((CharSequence)nTermSequence);
                ArrayList<ModificationMatch> modificationMatches = new ArrayList<ModificationMatch>();
                HashMap<Integer, ArrayList<ModificationMatch>> nTermModifications = nTerm.getModificationMatches();
                if (nTermModifications != null) {
                    for (int i : nTermModifications.keySet()) {
                        for (ModificationMatch modificationMatch : nTermModifications.get(i)) {
                            modificationMatches.add(new ModificationMatch(modificationMatch.getTheoreticPtm(), modificationMatch.isVariable(), i));
                        }
                    }
                }
                if ((sequenceModifications = tagPattern.getModificationMatches()) != null) {
                    for (int i : sequenceModifications.keySet()) {
                        for (ModificationMatch modificationMatch : sequenceModifications.get(i)) {
                            modificationMatches.add(new ModificationMatch(modificationMatch.getTheoreticPtm(), modificationMatch.isVariable(), nTerm.length() + i));
                        }
                    }
                }
                for (int i = 0; i < cTerm.length(); ++i) {
                    peptideSequence.append(cTerm.getTargetedAA((int)i).get((int)0).singleLetterCode);
                }
                HashMap<Integer, ArrayList<ModificationMatch>> cTermModifications = cTerm.getModificationMatches();
                if (cTermModifications != null) {
                    for (int i : cTermModifications.keySet()) {
                        for (ModificationMatch modificationMatch : cTermModifications.get(i)) {
                            modificationMatches.add(new ModificationMatch(modificationMatch.getTheoreticPtm(), modificationMatch.isVariable(), nTerm.length() + tagPattern.length() + i));
                        }
                    }
                }
                Peptide peptide = new Peptide(peptideSequence.toString(), modificationMatches);
                ArrayList<Peptide> peptides = result.get(nTermIndex);
                if (peptides == null) {
                    peptides = new ArrayList();
                    result.put(nTermIndex, peptides);
                }
                peptides.add(peptide);
            }
        }
        return result;
    }

    public static String getTagModificationsAsString(Tag tag) {
        HashMap modMap = new HashMap();
        int offset = 0;
        for (TagComponent tagComponent : tag.getContent()) {
            if (tagComponent instanceof MassGap) {
                ++offset;
                continue;
            }
            if (tagComponent instanceof AminoAcidPattern) {
                AminoAcidPattern aminoAcidPattern = (AminoAcidPattern)tagComponent;
                for (int i = 1; i <= aminoAcidPattern.length(); ++i) {
                    for (ModificationMatch modificationMatch : aminoAcidPattern.getModificationsAt(i)) {
                        if (!modificationMatch.isVariable()) continue;
                        if (!modMap.containsKey(modificationMatch.getTheoreticPtm())) {
                            modMap.put(modificationMatch.getTheoreticPtm(), new ArrayList());
                        }
                        ((ArrayList)modMap.get(modificationMatch.getTheoreticPtm())).add(i + offset);
                    }
                }
                offset += aminoAcidPattern.length();
                continue;
            }
            throw new IllegalArgumentException("Modification summary not implemented for TagComponent " + tagComponent.getClass() + ".");
        }
        StringBuilder result = new StringBuilder();
        boolean first = true;
        ArrayList mods = new ArrayList(modMap.keySet());
        Collections.sort(mods);
        for (String mod : mods) {
            if (first) {
                first = false;
            } else {
                result.append(", ");
            }
            boolean first2 = true;
            result.append(mod);
            result.append(" (");
            Iterator i$ = ((ArrayList)modMap.get(mod)).iterator();
            while (i$.hasNext()) {
                int aa = (Integer)i$.next();
                if (first2) {
                    first2 = false;
                } else {
                    result.append(", ");
                }
                result.append(aa);
            }
            result.append(")");
        }
        return result.toString();
    }

    public String toString() {
        return this.asSequence();
    }
}

