/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.examples;

import com.compomics.util.gui.spectrum.SpectrumPanel;
import com.compomics.util.io.PklFile;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class MirroredSpectraTestDialog
extends JDialog {
    private JPanel backgroundPanel;

    public MirroredSpectraTestDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        try {
            File spectrumFileA = new File(this.getJarFilePath() + "/exampleFiles/exampleSpectrumA.pkl");
            PklFile pklFileA = new PklFile(spectrumFileA);
            File spectrumFileB = new File(this.getJarFilePath() + "/exampleFiles/exampleSpectrumA.pkl");
            PklFile pklFileB = new PklFile(spectrumFileB);
            SpectrumPanel spectrumPanel = new SpectrumPanel(pklFileA.getMzValues(), pklFileA.getIntensityValues(), pklFileA.getPrecursorMz(), "" + pklFileA.getPrecurorCharge(), "" + pklFileA.getFileName(), 50, false, false, false, 2, false);
            spectrumPanel.addMirroredSpectrum(pklFileB.getMzValues(), pklFileB.getIntensityValues(), pklFileB.getPrecursorMz(), "" + pklFileB.getPrecurorCharge(), "" + pklFileB.getFileName(), false, Color.BLUE, Color.BLUE);
            this.backgroundPanel.add(spectrumPanel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Mirrored Spectra Demo");
        this.backgroundPanel.setLayout(new BoxLayout(this.backgroundPanel, 2));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.backgroundPanel, -1, 1085, Short.MAX_VALUE).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, 650, Short.MAX_VALUE));
        this.pack();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(MirroredSpectraTestDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(MirroredSpectraTestDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(MirroredSpectraTestDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(MirroredSpectraTestDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MirroredSpectraTestDialog dialog = new MirroredSpectraTestDialog((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setLocationRelativeTo(null);
                dialog.setVisible(true);
            }
        });
    }

    private String getJarFilePath() {
        String path = this.getClass().getResource("MirroredSpectraTestDialog.class").getPath();
        if (path.lastIndexOf("/utilities-") != -1) {
            path = path.startsWith("file:") ? path.substring("file:".length(), path.lastIndexOf("/utilities-")) : path.substring(0, path.lastIndexOf("/utilities-"));
            path = path.replace("%20", " ");
            path = path.replace("%5b", "[");
            path = path.replace("%5d", "]");
        } else {
            path = ".";
        }
        return path;
    }
}

