/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.software.dialogs;

import com.compomics.util.Util;
import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.preferences.UtilitiesUserPreferences;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class RelimsSetupDialog
extends JDialog {
    private UtilitiesUserPreferences utilitiesUserPreferences;
    private String lastSelectedFolder = "";
    private JPanel backgroundPanel;
    private JButton browseButton;
    private JButton cancelButton;
    private JLabel jLabel2;
    private JButton okButton;
    private JButton relimsButton;
    private JLabel relimsDownloadLinkLabel;
    private JPanel relimsDownloadPanel;
    private JLabel relimsInfoLabel;
    private JTextField relimsInstallationJTextField;
    private JPanel relimsInstallationPanel;
    private JLabel relimsJarFileHelpLabel;

    public RelimsSetupDialog(JFrame parent, boolean modal) throws FileNotFoundException, IOException, ClassNotFoundException {
        super((Frame)parent, modal);
        this.initComponents();
        this.utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
        if (this.utilitiesUserPreferences != null) {
            this.relimsInstallationJTextField.setText(this.utilitiesUserPreferences.getRelimsPath());
            this.lastSelectedFolder = this.utilitiesUserPreferences.getRelimsPath();
        }
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.backgroundPanel = new JPanel();
        this.relimsInstallationPanel = new JPanel();
        this.relimsInstallationJTextField = new JTextField();
        this.browseButton = new JButton();
        this.relimsJarFileHelpLabel = new JLabel();
        this.relimsDownloadPanel = new JPanel();
        this.relimsInfoLabel = new JLabel();
        this.relimsDownloadLinkLabel = new JLabel();
        this.relimsButton = new JButton();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jLabel2.setText("jLabel2");
        this.setDefaultCloseOperation(2);
        this.setTitle("Relims Settings");
        this.setResizable(false);
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.relimsInstallationPanel.setBorder(BorderFactory.createTitledBorder("Relims Installation"));
        this.relimsInstallationPanel.setOpaque(false);
        this.relimsInstallationJTextField.setEditable(false);
        this.relimsInstallationJTextField.setToolTipText("The folder containing the Relims jar file.");
        this.browseButton.setText("Browse");
        this.browseButton.setToolTipText("The folder containing the Relims jar file.");
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RelimsSetupDialog.this.browseButtonActionPerformed(evt);
            }
        });
        this.relimsJarFileHelpLabel.setFont(this.relimsJarFileHelpLabel.getFont().deriveFont(this.relimsJarFileHelpLabel.getFont().getStyle() | 2));
        this.relimsJarFileHelpLabel.setText("Please locate the folder containing the Relims jar file.");
        GroupLayout relimsInstallationPanelLayout = new GroupLayout(this.relimsInstallationPanel);
        this.relimsInstallationPanel.setLayout(relimsInstallationPanelLayout);
        relimsInstallationPanelLayout.setHorizontalGroup(relimsInstallationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, relimsInstallationPanelLayout.createSequentialGroup().addContainerGap().addGroup(relimsInstallationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(relimsInstallationPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.relimsJarFileHelpLabel)).addComponent(this.relimsInstallationJTextField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton).addContainerGap()));
        relimsInstallationPanelLayout.setVerticalGroup(relimsInstallationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(relimsInstallationPanelLayout.createSequentialGroup().addContainerGap().addGroup(relimsInstallationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.relimsInstallationJTextField, -2, -1, -2).addComponent(this.browseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.relimsJarFileHelpLabel).addContainerGap(-1, Short.MAX_VALUE)));
        this.relimsDownloadPanel.setBorder(BorderFactory.createTitledBorder("Download Relims"));
        this.relimsDownloadPanel.setOpaque(false);
        this.relimsInfoLabel.setFont(this.relimsInfoLabel.getFont().deriveFont(this.relimsInfoLabel.getFont().getStyle() | 1));
        this.relimsInfoLabel.setText("Relims - re-analyze public PRIDE projects with user defined search parameters");
        this.relimsDownloadLinkLabel.setText("<html>Download here: <a href> http://compomics-relims.googlecode.com</a></html>");
        this.relimsDownloadLinkLabel.setToolTipText("Go to http://relims.googlecode.com");
        this.relimsDownloadLinkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                RelimsSetupDialog.this.relimsDownloadLinkLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                RelimsSetupDialog.this.relimsDownloadLinkLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                RelimsSetupDialog.this.relimsDownloadLinkLabelMouseExited(evt);
            }
        });
        this.relimsButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/relims_logo.png")));
        this.relimsButton.setToolTipText("Go to http://relims.googlecode.com");
        this.relimsButton.setBorderPainted(false);
        this.relimsButton.setContentAreaFilled(false);
        this.relimsButton.setFocusPainted(false);
        this.relimsButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                RelimsSetupDialog.this.relimsButtonMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                RelimsSetupDialog.this.relimsButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                RelimsSetupDialog.this.relimsButtonMouseExited(evt);
            }
        });
        GroupLayout relimsDownloadPanelLayout = new GroupLayout(this.relimsDownloadPanel);
        this.relimsDownloadPanel.setLayout(relimsDownloadPanelLayout);
        relimsDownloadPanelLayout.setHorizontalGroup(relimsDownloadPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(relimsDownloadPanelLayout.createSequentialGroup().addContainerGap().addGroup(relimsDownloadPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.relimsInfoLabel).addComponent(this.relimsDownloadLinkLabel, -2, -1, -2)).addGap(0, 60, Short.MAX_VALUE).addComponent(this.relimsButton).addContainerGap()));
        relimsDownloadPanelLayout.setVerticalGroup(relimsDownloadPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(relimsDownloadPanelLayout.createSequentialGroup().addGap(15, 15, 15).addComponent(this.relimsInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.relimsDownloadLinkLabel, -2, -1, -2)).addComponent(this.relimsButton));
        this.okButton.setText("OK");
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RelimsSetupDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RelimsSetupDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.relimsDownloadPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent(this.relimsInstallationPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        backgroundPanelLayout.linkSize(0, this.cancelButton, this.okButton);
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.relimsInstallationPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.relimsDownloadPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        File selectedFile = Util.getUserSelectedFile(this, ".jar", "Relims jar file (.jar)", "Select Relims Jar File", this.lastSelectedFolder, true);
        if (selectedFile != null) {
            if (!selectedFile.getName().endsWith(".jar")) {
                JOptionPane.showMessageDialog(this, "The selected file is not a jar file!", "Wrong File Selected", 2);
                this.okButton.setEnabled(false);
            } else if (selectedFile.getName().indexOf("relims") == -1) {
                JOptionPane.showMessageDialog(this, "The selected file is not a Relims jar file!", "Wrong File Selected", 2);
                this.okButton.setEnabled(false);
            } else {
                this.lastSelectedFolder = selectedFile.getPath();
                this.relimsInstallationJTextField.setText(this.lastSelectedFolder);
                this.okButton.setEnabled(true);
            }
        }
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.utilitiesUserPreferences.setRelimsPath(this.relimsInstallationJTextField.getText());
        try {
            UtilitiesUserPreferences.saveUserPreferences(this.utilitiesUserPreferences);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "An error occurred while saving the preferences.", "Error", 2);
        }
        this.dispose();
    }

    private void relimsDownloadLinkLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void relimsDownloadLinkLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void relimsDownloadLinkLabelMouseClicked(MouseEvent evt) {
        this.openRelimsWebPage();
    }

    private void relimsButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void relimsButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void relimsButtonMouseClicked(MouseEvent evt) {
        this.openRelimsWebPage();
    }

    private void openRelimsWebPage() {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://compomics-relims.googlecode.com");
        this.setCursor(new Cursor(0));
    }
}

