/*
 * Decompiled with CFR 0.152.
 */
package cn.genomics;

import cn.genomics.Function;
import cn.genomics.GeneInfo;
import cn.genomics.VarInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SavDBCreate {
    public static boolean HASXREF = true;
    public static int SOURCE = 0;
    public static final int BATCHSIZE = 200000;
    public static final int NEARGENE = 1000;
    public static final int GENOMEBINSIZE = 100000;
    public static final int EXPANDBIN = (int)Math.floor(20.0);
    private static HashMap<String, ArrayList<GeneInfo>> newgenedb = new HashMap();
    private static HashMap<String, String> geneidmap = new HashMap();
    private static HashMap<String, String> coding_mRNA = new HashMap();
    private static HashMap<String, Integer> cdslen = new HashMap();
    private static HashMap<String, Integer> mrnalen = new HashMap();
    private static HashMap<String, ArrayList<VarInfo>> refseqvar = new HashMap();
    private static int linecount = 0;
    private static int invalidcount = 0;
    private static int batchcount = 1;
    private static int count = 1;
    private static String outfile = null;
    private static String protease = null;
    private static HashMap<String, String> seqhash = new HashMap();
    private static HashMap<String, String> revseq = new HashMap();
    private static HashMap<String, String> mRNA2Prot = new HashMap();
    private static HashMap<String, String> mRNA2Sp = new HashMap();
    private static HashMap<String, String> mRNA2Desc = new HashMap();
    public static final HashMap<String, String> codon = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("TTT", "F");
            this.put("TTC", "F");
            this.put("TCT", "S");
            this.put("TCC", "S");
            this.put("TAT", "Y");
            this.put("TAC", "Y");
            this.put("TGT", "C");
            this.put("TGC", "C");
            this.put("TTA", "L");
            this.put("TCA", "S");
            this.put("TAA", "*");
            this.put("TGA", "*");
            this.put("TTG", "L");
            this.put("TCG", "S");
            this.put("TAG", "*");
            this.put("TGG", "W");
            this.put("CTT", "L");
            this.put("CTC", "L");
            this.put("CCT", "P");
            this.put("CCC", "P");
            this.put("CAT", "H");
            this.put("CAC", "H");
            this.put("CGT", "R");
            this.put("CGC", "R");
            this.put("CTA", "L");
            this.put("CTG", "L");
            this.put("CCA", "P");
            this.put("CCG", "P");
            this.put("CAA", "Q");
            this.put("CAG", "Q");
            this.put("CGA", "R");
            this.put("CGG", "R");
            this.put("ATT", "I");
            this.put("ATC", "I");
            this.put("ACT", "T");
            this.put("ACC", "T");
            this.put("AAT", "N");
            this.put("AAC", "N");
            this.put("AGT", "S");
            this.put("AGC", "S");
            this.put("ATA", "I");
            this.put("ACA", "T");
            this.put("AAA", "K");
            this.put("AGA", "R");
            this.put("ATG", "M");
            this.put("ACG", "T");
            this.put("AAG", "K");
            this.put("AGG", "R");
            this.put("GTT", "V");
            this.put("GTC", "V");
            this.put("GCT", "A");
            this.put("GCC", "A");
            this.put("GAT", "D");
            this.put("GAC", "D");
            this.put("GGT", "G");
            this.put("GGC", "G");
            this.put("GTA", "V");
            this.put("GTG", "V");
            this.put("GCA", "A");
            this.put("GCG", "A");
            this.put("GAA", "E");
            this.put("GAG", "E");
            this.put("GGA", "G");
            this.put("GGG", "G");
        }
    };
    public static final HashMap<String, String> codonm = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("TTT", "F");
            this.put("TTC", "F");
            this.put("TCT", "S");
            this.put("TCC", "S");
            this.put("TAT", "Y");
            this.put("TAC", "Y");
            this.put("TGT", "C");
            this.put("TGC", "C");
            this.put("TTA", "L");
            this.put("TCA", "S");
            this.put("TAA", "*");
            this.put("TGA", "W");
            this.put("TTG", "L");
            this.put("TCG", "S");
            this.put("TAG", "*");
            this.put("TGG", "W");
            this.put("CTT", "L");
            this.put("CTC", "L");
            this.put("CCT", "P");
            this.put("CCC", "P");
            this.put("CAT", "H");
            this.put("CAC", "H");
            this.put("CGT", "R");
            this.put("CGC", "R");
            this.put("CTA", "L");
            this.put("CTG", "L");
            this.put("CCA", "P");
            this.put("CCG", "P");
            this.put("CAA", "Q");
            this.put("CAG", "Q");
            this.put("CGA", "R");
            this.put("CGG", "R");
            this.put("ATT", "I");
            this.put("ATC", "I");
            this.put("ACT", "T");
            this.put("ACC", "T");
            this.put("AAT", "N");
            this.put("AAC", "N");
            this.put("AGT", "S");
            this.put("AGC", "S");
            this.put("ATA", "M");
            this.put("ACA", "T");
            this.put("AAA", "K");
            this.put("AGA", "*");
            this.put("ATG", "M");
            this.put("ACG", "T");
            this.put("AAG", "K");
            this.put("AGG", "*");
            this.put("GTT", "V");
            this.put("GTC", "V");
            this.put("GCT", "A");
            this.put("GCC", "A");
            this.put("GAT", "D");
            this.put("GAC", "D");
            this.put("GGT", "G");
            this.put("GGC", "G");
            this.put("GTA", "V");
            this.put("GTG", "V");
            this.put("GCA", "A");
            this.put("GCG", "A");
            this.put("GAA", "E");
            this.put("GAG", "E");
            this.put("GGA", "G");
            this.put("GGG", "G");
        }
    };

    public static void main(String[] args) throws IOException {
        if (args.length < 6) {
            System.err.println("Error:invalid input parameter values!!!");
            System.exit(1);
        }
        int totalquerycount = 0;
        int totalinvalidcount = 0;
        protease = args[3];
        outfile = args[4];
        if (args[5].startsWith("noxref")) {
            HASXREF = false;
        }
        SavDBCreate.readUCSCGeneAnnotation(args[1]);
        if (HASXREF) {
            SavDBCreate.readXref(args[5]);
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        System.out.println("NOTICE: Current time is " + df.format(new Date()));
        BufferedReader queryFin = new BufferedReader(new FileReader(args[0]));
        BufferedWriter mapfile = new BufferedWriter(new FileWriter(new File(String.valueOf(outfile) + ".ms2.map.tsv")));
        BufferedWriter savdbfile = new BufferedWriter(new FileWriter(new File(String.valueOf(outfile) + ".ms2.fasta")));
        if (HASXREF) {
            mapfile.write("ID\tProtein_ID\tGene\tStart\tMut_coords\tEnd\tAA_wild\tAA_mut\tType\tMut_ID\tchromosome\tChr_coords\tmRNA_coords\tNA_wild\tNA_mut\tStrand\tWtnt3\tVarnt3\tProtID\tSpID\tDesc\n");
        } else {
            mapfile.write("ID\tProtein_ID\tGene\tStart\tMut_coords\tEnd\tAA_wild\tAA_mut\tType\tMut_ID\tchromosome\tChr_coords\tmRNA_coords\tNA_wild\tNA_mut\tStrand\tWtnt3\tVarnt3\n");
        }
        while (true) {
            linecount = 0;
            invalidcount = 0;
            SavDBCreate.newprocessNextQueryBatchByGene(queryFin, args[2], mapfile, savdbfile);
            totalquerycount += linecount;
            totalinvalidcount += invalidcount;
            if (linecount != 200000) break;
            System.out.println("NOTICE: Begin processing batch " + ++batchcount + " (each batch contains " + 200000 + " variants)");
        }
        SavDBCreate.getAllRefSeqPro(args[2], savdbfile);
        for (String key : revseq.keySet()) {
            savdbfile.write(">###REV###" + key + "\n" + revseq.get(key) + "\n");
        }
        mapfile.close();
        savdbfile.close();
        queryFin.close();
    }

    public static void readUCSCGeneAnnotation(String dbfile) throws NumberFormatException, IOException {
        String line;
        HashMap genedb = new HashMap();
        HashMap<String, Integer> name2count = new HashMap<String, Integer>();
        HashMap<String, Integer> iscoding = new HashMap<String, Integer>();
        int genecount = 0;
        int ncgenecount = 0;
        LineNumberReader genedbFin = new LineNumberReader(new FileReader(dbfile));
        int bin_i = -1;
        int name_i = -1;
        int chrom_i = -1;
        int strand_i = -1;
        int txStart_i = -1;
        int txEnd_i = -1;
        int cdsStart_i = -1;
        int cdsEnd_i = -1;
        int exonCount_i = -1;
        int exonStarts_i = -1;
        int exonEnds_i = -1;
        int score_i = -1;
        int name2_i = -1;
        int cdsStartStat_i = -1;
        int cdsEndStat_i = -1;
        int exonFrames_i = -1;
        while ((line = genedbFin.readLine()) != null) {
            Pattern pat;
            Matcher matcher;
            String[] record = line.split("\t");
            if (genedbFin.getLineNumber() == 1) {
                if (line.startsWith("#")) {
                    int i = 0;
                    while (i < record.length) {
                        if (record[i].endsWith("bin")) {
                            bin_i = i;
                        } else if (record[i].endsWith("name")) {
                            name_i = i;
                        } else if (record[i].endsWith("chrom")) {
                            chrom_i = i;
                        } else if (record[i].endsWith("strand")) {
                            strand_i = i;
                        } else if (record[i].endsWith("txStart")) {
                            txStart_i = i;
                        } else if (record[i].endsWith("txEnd")) {
                            txEnd_i = i;
                        } else if (record[i].endsWith("cdsStart")) {
                            cdsStart_i = i;
                        } else if (record[i].endsWith("cdsEnd")) {
                            cdsEnd_i = i;
                        } else if (record[i].endsWith("exonCount")) {
                            exonCount_i = i;
                        } else if (record[i].endsWith("exonStarts")) {
                            exonStarts_i = i;
                        } else if (record[i].endsWith("exonEnds")) {
                            exonEnds_i = i;
                        } else if (record[i].endsWith("score")) {
                            score_i = i;
                        } else if (record[i].endsWith("name2")) {
                            name2_i = i;
                        } else if (record[i].endsWith("cdsStartStat")) {
                            cdsStartStat_i = i;
                        } else if (record[i].endsWith("cdsEndStat")) {
                            cdsEndStat_i = i;
                        } else if (record[i].endsWith("exonFrames")) {
                            exonFrames_i = i;
                        }
                        ++i;
                    }
                    continue;
                }
                System.err.println("Error:invalid title of annotation file!!!");
                System.exit(1);
                continue;
            }
            String name = record[name_i];
            String chr = record[chrom_i];
            String dbstrand = record[strand_i];
            int txstart = Integer.valueOf(record[txStart_i]);
            int txend = Integer.valueOf(record[txEnd_i]);
            int cdsstart = Integer.valueOf(record[cdsStart_i]);
            int cdsend = Integer.valueOf(record[cdsEnd_i]);
            int exoncount = Integer.valueOf(record[exonCount_i]);
            String exonstart = record[exonStarts_i];
            String exonend = record[exonEnds_i];
            String id = record[score_i];
            String name2 = record[name2_i];
            String cdsstartstat = record[cdsStartStat_i];
            String cdsendstat = record[cdsEndStat_i];
            String exonframes = record[exonFrames_i];
            if (genedbFin.getLineNumber() == 2 && name.startsWith("ENST")) {
                SOURCE = 1;
            }
            if ((matcher = (pat = Pattern.compile("hap\\d+$")).matcher(chr)).find()) continue;
            chr = chr.replaceAll("chr", "");
            if (!dbstrand.equals("+") && !dbstrand.equals("-")) {
                System.err.println("Error: invalid dbstrand information found (dbstrand has to be + or -): <" + line + ">");
                System.exit(1);
            }
            String[] exonstart_ay_s = exonstart.split(",");
            String[] exonend_ay_s = exonend.split(",");
            if (exonstart_ay_s.length != exoncount) {
                System.err.println("Error: invalid record found in " + dbfile + " (exoncount discordance): <" + exoncount + " vs " + exonstart_ay_s.length + ">");
                System.exit(1);
            }
            if (exonstart_ay_s.length != exonend_ay_s.length) {
                System.err.println("Error: invalid record found in " + dbfile + " (exonstart and exonend count discordance): <" + exonstart_ay_s.length + " vs " + exonend_ay_s.length + ">");
                System.exit(1);
            }
            ++txstart;
            ++cdsstart;
            int[] exonstart_ay_i = new int[exonstart_ay_s.length];
            int[] exonend_ay_i = new int[exonend_ay_s.length];
            int i = 0;
            while (i < exonstart_ay_s.length) {
                exonstart_ay_i[i] = Integer.valueOf(exonstart_ay_s[i]) + 1;
                ++i;
            }
            i = 0;
            while (i < exonend_ay_s.length) {
                exonend_ay_i[i] = Integer.valueOf(exonend_ay_s[i]);
                ++i;
            }
            int cdslength = 0;
            int mrnalength = 0;
            int i2 = 0;
            while (i2 < exonstart_ay_i.length) {
                mrnalength += exonend_ay_i[i2] - exonstart_ay_i[i2] + 1;
                ++i2;
            }
            i2 = 0;
            while (i2 < exonstart_ay_i.length) {
                if (cdsstart >= exonstart_ay_i[i2] && cdsstart <= exonend_ay_i[i2]) {
                    if (cdsend <= exonend_ay_i[i2]) {
                        cdslength = cdsend - cdsstart + 1;
                        break;
                    }
                    cdslength += exonend_ay_i[i2] - cdsstart + 1;
                } else if (cdslength > 0 && cdsend < exonstart_ay_i[i2]) {
                    System.err.println("FATAL ERROR: impossible scenario for " + name + " in " + dbfile + " (cdsend is less than exon start)");
                    System.exit(1);
                } else {
                    if (cdslength > 0 && cdsend <= exonend_ay_i[i2]) {
                        cdslength += cdsend - exonstart_ay_i[i2] + 1;
                        break;
                    }
                    if (cdslength > 0 && cdsend > exonend_ay_i[i2]) {
                        cdslength += exonend_ay_i[i2] - exonstart_ay_i[i2] + 1;
                    }
                }
                ++i2;
            }
            if (cdsstart != cdsend + 1) {
                if (mrnalen.containsKey(name) && mrnalen.get(name) != mrnalength) {
                    System.out.println("WARNING: " + name + " occurs more than once in " + dbfile + " with different mRNA length. The first occurences with identical mRNA length will be uesd in analysis.");
                    continue;
                }
                if (cdslen.containsKey(name) && cdslen.get(name) != cdslength) {
                    System.out.println("WARNING: " + name + " occurs more than once in " + dbfile + " with different CDS length. The first occurences with identical CDS length will be uesd in analysis.");
                    continue;
                }
                iscoding.put(name2, 1);
            }
            cdslen.put(name, cdslength);
            mrnalen.put(name, mrnalength);
            int bin1 = (int)Math.floor((txstart - 1000) / 100000);
            int bin2 = (int)Math.floor((txend + 1000) / 100000);
            int nextbin = bin1;
            while (nextbin <= bin2) {
                ArrayList<GeneInfo> list;
                GeneInfo geneobj = new GeneInfo();
                geneobj.setName(name);
                geneobj.setChr(chr);
                geneobj.setDBStrand(dbstrand);
                geneobj.setTxStart(txstart);
                geneobj.setTxEnd(txend);
                geneobj.setCdsStart(cdsstart);
                geneobj.setCdsEnd(cdsend);
                geneobj.setExonEnd(exonend_ay_i);
                geneobj.setExonStart(exonstart_ay_i);
                geneobj.setName2(name2);
                geneobj.setExonFrame(exonframes);
                String key = String.valueOf(chr) + "," + String.valueOf(nextbin);
                if (genedb.containsKey(key)) {
                    list = new ArrayList<GeneInfo>();
                    Iterator it = ((ArrayList)genedb.get(key)).iterator();
                    while (it.hasNext()) {
                        list.add((GeneInfo)it.next());
                    }
                    list.add(geneobj);
                    genedb.put(key, list);
                } else {
                    list = new ArrayList();
                    list.add(geneobj);
                    genedb.put(key, list);
                }
                ++nextbin;
            }
            geneidmap.put(name, name2);
            ++genecount;
            if (name2count.containsKey(name2)) {
                name2count.put(name2, (Integer)name2count.get(name2) + 1);
            } else {
                name2count.put(name2, 1);
            }
            if (cdsstart == cdsend + 1) {
                ++ncgenecount;
                continue;
            }
            coding_mRNA.put(name, "1");
        }
        genedbFin.close();
        HashMap<String, Integer> badgene = new HashMap<String, Integer>();
        for (String key : genedb.keySet()) {
            ArrayList oldgenedb = new ArrayList();
            ArrayList<GeneInfo> newgenedb = new ArrayList<GeneInfo>();
            oldgenedb = (ArrayList)genedb.get(key);
            for (GeneInfo geneinfo : oldgenedb) {
                if (!cdslen.containsKey(geneinfo.getName()) && iscoding.containsKey(geneinfo.getName2())) {
                    if (badgene.containsKey(geneinfo.getName())) {
                        badgene.put(geneinfo.getName(), (Integer)badgene.get(geneinfo.getName()) + 1);
                        System.err.println("WARNING: " + geneinfo.getName() + " will be ignored in analysis, because it is a non-coding transcript but the associated gene has another coding transcript");
                        continue;
                    }
                    badgene.put(geneinfo.getName(), 1);
                    continue;
                }
                newgenedb.add(geneinfo);
            }
        }
        for (String key : genedb.keySet()) {
            ArrayList sortgenedb = new ArrayList();
            sortgenedb = (ArrayList)genedb.get(key);
            int i = 1;
            while (i < sortgenedb.size()) {
                int j = i;
                while (j > 0) {
                    if (((GeneInfo)sortgenedb.get(j)).getTxStart() >= ((GeneInfo)sortgenedb.get(j - 1)).getTxStart()) break;
                    GeneInfo temp = (GeneInfo)sortgenedb.get(j - 1);
                    sortgenedb.set(j - 1, (GeneInfo)sortgenedb.get(j));
                    sortgenedb.set(j, temp);
                    --j;
                }
                ++i;
            }
            newgenedb.put(key, sortgenedb);
        }
        System.out.println("Done with " + genecount + " transcripts (including " + ncgenecount + " without coding sequence annotation) for " + name2count.size() + " unique genes");
    }

    public static void newprocessNextQueryBatchByGene(BufferedReader queryFin, String fastafile, BufferedWriter mapfile, BufferedWriter savdbfile) throws IOException {
        refseqvar.clear();
        int i = 1;
        while (i <= 200000) {
            String line = queryFin.readLine();
            ++linecount;
            if (line == null) break;
            if (!line.startsWith("#")) {
                int invalid = 0;
                String[] nextline = line.split("\\s+");
                if (nextline.length < 5) {
                    ++invalid;
                }
                String chr = nextline[0];
                int pos = Integer.valueOf(nextline[1]);
                String id = nextline[2];
                String ref = nextline[3];
                String obs = nextline[4];
                int start = pos;
                int end = pos;
                if (nextline.length >= 5) {
                    ref = ref.toUpperCase();
                    obs = obs.toUpperCase();
                    chr = chr.replaceAll("^chr", "");
                    Pattern pat1 = Pattern.compile("[^\\w\\.]");
                    Pattern pat2 = Pattern.compile("[^\\d]");
                    Pattern pat3 = Pattern.compile("[^ACTG0-]");
                    Matcher mt1 = pat1.matcher(chr);
                    Matcher mt2 = pat2.matcher(nextline[1]);
                    Matcher mt3 = pat1.matcher(id);
                    Matcher mt4 = pat3.matcher(ref);
                    Matcher mt5 = pat3.matcher(obs);
                    if (mt1.find() || mt2.find() || mt3.find()) {
                        ++invalid;
                    } else if (ref.equals("-") && obs.equals("-") || mt4.find() || mt5.find() || mt2.find() || mt3.find() || start > end || !ref.equals("0") && end - start + 1 != ref.length() || ref.equals("-") && start != end) {
                        ++invalid;
                    }
                    if (ref.length() > 1 || obs.length() > 1) {
                        ++invalid;
                    }
                }
                if (invalid > 0) {
                    ++invalidcount;
                } else {
                    HashMap<String, Integer> exonic = new HashMap<String, Integer>();
                    int foundgenic = 0;
                    int bin1 = (int)Math.floor(start / 100000 - 1);
                    if (bin1 < 0) {
                        bin1 = 0;
                    }
                    int bin2 = (int)Math.floor(end / 100000 + 1);
                    while (!newgenedb.containsKey(String.valueOf(chr) + "," + String.valueOf(bin1)) && bin1 > (int)Math.floor(start / 100000) - EXPANDBIN) {
                        if (bin1 <= 0) break;
                        --bin1;
                    }
                    while (!newgenedb.containsKey(String.valueOf(chr) + "," + String.valueOf(bin2)) && bin2 < (int)Math.floor(end / 100000) + EXPANDBIN) {
                        ++bin2;
                    }
                    HashMap<String, Integer> seen = new HashMap<String, Integer>();
                    int nextbin = bin1;
                    while (nextbin <= bin2) {
                        if (newgenedb.containsKey(String.valueOf(chr) + "," + String.valueOf(nextbin))) {
                            ArrayList<Object> genedb = new ArrayList();
                            genedb = newgenedb.get(String.valueOf(chr) + "," + String.valueOf(nextbin));
                            block4: for (GeneInfo geneInfo : genedb) {
                                Iterator<VarInfo> it;
                                ArrayList<VarInfo> list;
                                int k;
                                String name = geneInfo.getName();
                                String dbstrand = geneInfo.getDBStrand();
                                int txstart = geneInfo.getTxStart();
                                int txend = geneInfo.getTxEnd();
                                int cdsstart = geneInfo.getCdsStart();
                                int cdsend = geneInfo.getCdsEnd();
                                int[] exonstart_ay_i = geneInfo.getExonStart();
                                int[] exonend_ay_i = geneInfo.getExonEnd();
                                String name2 = geneInfo.getName2();
                                String exonframes = geneInfo.getExonFrame();
                                String[] exonframes_ay_s = exonframes.split(",");
                                if (seen.containsKey(String.valueOf(name) + "," + txstart)) continue;
                                if (seen.containsKey(String.valueOf(name) + "," + txstart)) {
                                    seen.put(String.valueOf(name) + "," + txstart, (Integer)seen.get(String.valueOf(name) + "," + txstart) + 1);
                                } else {
                                    seen.put(String.valueOf(name) + "," + txstart, 1);
                                }
                                int current_ncRNA = 0;
                                if (end >= txstart && start <= txend && cdsstart == cdsend + 1) {
                                    if (start > txstart && start <= txend || end >= txstart && end <= txend || start <= txstart && end >= txend) {
                                        ++foundgenic;
                                    }
                                    cdsstart = txstart;
                                    cdsend = txend;
                                    ++current_ncRNA;
                                }
                                int lenintron = 0;
                                int lenexon = 0;
                                int rcdsstart = -1;
                                int rvarstart = -1;
                                int rvarend = -1;
                                if (dbstrand.equals("+")) {
                                    k = 0;
                                    while (k < exonstart_ay_i.length) {
                                        if (k > 0) {
                                            lenintron += exonstart_ay_i[k] - exonend_ay_i[k - 1] - 1;
                                        }
                                        lenexon += exonend_ay_i[k] - exonstart_ay_i[k] + 1;
                                        if (cdsstart >= exonstart_ay_i[k]) {
                                            rcdsstart = cdsstart - txstart - lenintron + 1;
                                            if (cdsstart <= exonend_ay_i[k]) {
                                                lenexon = exonend_ay_i[k] - cdsstart + 1;
                                            }
                                        }
                                        if (start >= exonstart_ay_i[k] && start <= exonend_ay_i[k]) {
                                            rvarstart = start - txstart - lenintron + 1;
                                            int m = k;
                                            while (m < exonstart_ay_i.length) {
                                                if (m > k) {
                                                    lenintron += exonstart_ay_i[m] - exonend_ay_i[m - 1] - 1;
                                                }
                                                if (end < exonstart_ay_i[m]) break;
                                                if (end <= exonend_ay_i[m]) {
                                                    rvarend = end - txstart - lenintron + 1;
                                                    break;
                                                }
                                                ++m;
                                            }
                                            if (end >= cdsstart && start <= cdsend) {
                                                if (exonic.containsKey(name2)) {
                                                    exonic.put(name2, (Integer)exonic.get(name2) + 1);
                                                } else {
                                                    exonic.put(name2, 1);
                                                }
                                                if (current_ncRNA == 0) {
                                                    VarInfo varobj = new VarInfo();
                                                    varobj.setName(name);
                                                    varobj.setRCdsStart(rcdsstart);
                                                    varobj.setRVarStart(rvarstart);
                                                    varobj.setRVarEnd(rvarend);
                                                    varobj.setDBStrand(dbstrand);
                                                    varobj.setIndex(i);
                                                    varobj.setExonNum(k + 1);
                                                    varobj.setEntry(line);
                                                    varobj.setBias(Integer.valueOf(exonframes_ay_s[0]));
                                                    if (refseqvar.containsKey(name)) {
                                                        list = new ArrayList<VarInfo>();
                                                        it = refseqvar.get(name).iterator();
                                                        while (it.hasNext()) {
                                                            list.add(it.next());
                                                        }
                                                        list.add(varobj);
                                                        refseqvar.put(name, list);
                                                    } else {
                                                        list = new ArrayList();
                                                        list.add(varobj);
                                                        refseqvar.put(name, list);
                                                    }
                                                }
                                            }
                                            ++foundgenic;
                                            continue block4;
                                        }
                                        ++k;
                                    }
                                    continue;
                                }
                                if (!dbstrand.equals("-")) continue;
                                k = exonstart_ay_i.length - 1;
                                while (k >= 0) {
                                    if (k < exonstart_ay_i.length - 1) {
                                        lenintron += exonstart_ay_i[k + 1] - exonend_ay_i[k] - 1;
                                    }
                                    lenexon += exonend_ay_i[k] - exonstart_ay_i[k] + 1;
                                    if (cdsend <= exonend_ay_i[k]) {
                                        rcdsstart = txend - cdsend - lenintron + 1;
                                        if (cdsend >= exonstart_ay_i[k]) {
                                            lenexon = cdsend - exonstart_ay_i[k] + 1;
                                        }
                                    }
                                    if (end <= exonend_ay_i[k] && end >= exonstart_ay_i[k]) {
                                        rvarstart = txend - end - lenintron + 1;
                                        int m = k;
                                        while (m >= 0) {
                                            if (m < k) {
                                                lenintron += exonstart_ay_i[m + 1] - exonend_ay_i[m] - 1;
                                            }
                                            if (start > exonend_ay_i[m]) break;
                                            if (start >= exonstart_ay_i[m]) {
                                                rvarend = txend - start - lenintron + 1;
                                                break;
                                            }
                                            --m;
                                        }
                                        if (!(end < cdsstart || start > cdsend || start == cdsend && ref.equals("-"))) {
                                            if (exonic.containsKey(name2)) {
                                                exonic.put(name2, (Integer)exonic.get(name2) + 1);
                                            } else {
                                                exonic.put(name2, 1);
                                            }
                                            if (current_ncRNA == 0) {
                                                VarInfo varobj = new VarInfo();
                                                varobj.setName(name);
                                                varobj.setRCdsStart(rcdsstart);
                                                varobj.setRVarStart(rvarstart);
                                                varobj.setRVarEnd(rvarend);
                                                varobj.setDBStrand(dbstrand);
                                                varobj.setIndex(i);
                                                varobj.setExonNum(exonstart_ay_i.length - k);
                                                varobj.setEntry(line);
                                                varobj.setBias(Integer.valueOf(exonframes_ay_s[exonframes_ay_s.length - 1]));
                                                if (refseqvar.containsKey(name)) {
                                                    list = new ArrayList();
                                                    it = refseqvar.get(name).iterator();
                                                    while (it.hasNext()) {
                                                        list.add(it.next());
                                                    }
                                                    list.add(varobj);
                                                    refseqvar.put(name, list);
                                                } else {
                                                    list = new ArrayList();
                                                    list.add(varobj);
                                                    refseqvar.put(name, list);
                                                }
                                            }
                                        }
                                        ++foundgenic;
                                        continue block4;
                                    }
                                    --k;
                                }
                            }
                        }
                        ++nextbin;
                    }
                    if (i == 10000000) {
                        System.out.println("NOTICE: Finished analyzing " + i + " query variants");
                    }
                }
            }
            ++i;
        }
        System.out.println("Done with reading " + refseqvar.size() + " refseq entrys");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        System.out.println("NOTICE: Current time is " + df.format(new Date()));
        if (!refseqvar.isEmpty()) {
            SavDBCreate.createSAVDB(fastafile, mapfile, savdbfile);
        }
    }

    public static void createSAVDB(String fastafile, BufferedWriter mapfile, BufferedWriter savdbfile) throws IOException {
        HashMap<Integer, String> varinfo = new HashMap<Integer, String>();
        HashMap<Integer, Integer> unmatch_wtnt_ref = new HashMap<Integer, Integer>();
        HashMap<Integer, Function> function = new HashMap<Integer, Function>();
        SavDBCreate.readSeqFromFASTADB(fastafile);
        for (String seqid : refseqvar.keySet()) {
            ArrayList<Object> varlist = new ArrayList();
            varlist = refseqvar.get(seqid);
            for (VarInfo varInfo : varlist) {
                int fs;
                String refcdsseq;
                int end;
                int start;
                String obs;
                String ref;
                String id;
                int pos;
                String chr;
                String varaa;
                String wtaa;
                String varnt3;
                String wtnt3;
                int index;
                String refstrand;
                int refvarstart;
                int refcdsstart;
                block60: {
                    refcdsstart = varInfo.getRCdsStart();
                    refvarstart = varInfo.getRVarStart();
                    int refvarend = varInfo.getRVarEnd();
                    refstrand = varInfo.getDBStrand();
                    index = varInfo.getIndex();
                    int exonpos = varInfo.getExonNum();
                    int bias = varInfo.getBias();
                    String line = varInfo.getEntry();
                    wtnt3 = null;
                    varnt3 = null;
                    wtaa = null;
                    varaa = null;
                    int refcdsend = cdslen.get(seqid) + refcdsstart - 1;
                    String[] nextline = line.split("\\s+");
                    chr = nextline[0];
                    pos = Integer.valueOf(nextline[1]);
                    id = nextline[2];
                    ref = nextline[3];
                    obs = nextline[4];
                    start = pos;
                    end = pos;
                    ref = ref.toUpperCase();
                    obs = obs.toUpperCase();
                    chr = chr.replaceAll("^chr", "");
                    varinfo.put(index, line);
                    if (id.isEmpty() || id.startsWith(".")) {
                        id = "NULL";
                    }
                    refcdsseq = "";
                    try {
                        refcdsseq = seqhash.get(seqid).substring(refcdsstart - 1, refcdsend);
                    }
                    catch (Exception e) {
                        System.err.println("Fatal Error1: " + chr + "\t" + pos + "\t" + id + "\t" + ref + "\t" + obs + "\t" + seqid + "\t" + pos + "\t" + refvarstart + '\t' + refcdsstart + '\t' + refcdsend + '\t' + seqhash.get(seqid));
                        continue;
                    }
                    if (bias == 1) {
                        --refcdsstart;
                        refcdsseq = "N" + refcdsseq;
                    } else if (bias == 2) {
                        refcdsstart -= 2;
                        refcdsseq = "NN" + refcdsseq;
                    }
                    if (SavDBCreate.getStopCount(SavDBCreate.translateDNA(refcdsseq, chr)) >= 4) {
                        if (SavDBCreate.getStopCount(SavDBCreate.translateDNA("N" + refcdsseq, chr)) < 4) {
                            --refcdsstart;
                            refcdsseq = "N" + refcdsseq;
                        } else if (SavDBCreate.getStopCount(SavDBCreate.translateDNA("NN" + refcdsseq, chr)) < 4) {
                            refcdsstart -= 2;
                            refcdsseq = "NN" + refcdsseq;
                        } else {
                            System.out.println("WARNING:potential wrong annotation:" + seqid);
                        }
                    }
                    if (!seqhash.containsKey(seqid)) {
                        if (function.containsKey(index)) continue;
                        Function funobj = new Function();
                        funobj.setUnknown("UNKNOWN");
                        function.put(index, funobj);
                        continue;
                    }
                    fs = (refvarstart - refcdsstart) % 3;
                    int end_fs = (refvarend - refcdsstart) % 3;
                    if (refvarstart - fs - 1 > seqhash.get(seqid).length()) {
                        System.err.println("WARNING: Potential database annotation error seqid=" + seqid + ", refvarstart=" + refvarstart + ", fs=" + fs + ", seqlength=" + seqhash.get(seqid).length() + " refcdsstart=" + refcdsstart + ", with inputline=" + line);
                        continue;
                    }
                    try {
                        Function funobj;
                        if (refvarstart - fs - 1 < 0) {
                            funobj = new Function();
                            funobj.setUnknown("UNKNOWN");
                            function.put(index, funobj);
                            continue;
                        }
                        if (seqhash.get(seqid).substring(refvarstart - fs - 1).length() >= 3 && refvarstart - fs - 1 > 0) {
                            wtnt3 = seqhash.get(seqid).substring(refvarstart - fs - 1, refvarstart - fs - 1 + 3);
                            break block60;
                        }
                        if (function.containsKey(index)) continue;
                        funobj = new Function();
                        funobj.setUnknown("UNKNOWN");
                        function.put(index, funobj);
                    }
                    catch (Exception e) {
                        System.err.println("Fatal Error2: " + chr + "\t" + pos + "\t" + id + "\t" + ref + "\t" + obs + "\t" + seqid + "\t" + pos + "\t" + refvarstart + '\t' + fs + "\t" + seqhash.get(seqid));
                    }
                    continue;
                }
                char[] wtnt3_ay_c = wtnt3.toCharArray();
                String[] wtnt3_ay_s = new String[3];
                int i = 0;
                while (i < wtnt3_ay_c.length) {
                    wtnt3_ay_s[i] = String.valueOf(wtnt3_ay_c[i]);
                    ++i;
                }
                if (refstrand.equals("-")) {
                    obs = SavDBCreate.revcom(obs);
                    ref = SavDBCreate.revcom(ref);
                }
                int varpos_na = -1;
                if (start == end) {
                    String miss_cleavage_seq;
                    Matcher mat;
                    String proseq_var;
                    String proseq;
                    String id_suffix;
                    String type;
                    int varpos;
                    block61: {
                        if (ref.equals("-") || obs.equals("-") || obs.length() > 1) continue;
                        if (fs == 1) {
                            varnt3 = String.valueOf(wtnt3_ay_s[0]) + obs + wtnt3_ay_s[2];
                            varpos_na = refvarstart - refcdsstart + 1;
                            if (!ref.isEmpty() && !String.valueOf(wtnt3_ay_s[1]).equals(ref)) {
                                unmatch_wtnt_ref.put(index, 1);
                            }
                        } else if (fs == 2) {
                            varnt3 = String.valueOf(wtnt3_ay_s[0]) + wtnt3_ay_s[1] + obs;
                            varpos_na = refvarstart - refcdsstart + 1;
                            if (!ref.isEmpty() && !String.valueOf(wtnt3_ay_s[2]).equals(ref)) {
                                unmatch_wtnt_ref.put(index, 1);
                            }
                        } else {
                            varnt3 = String.valueOf(obs) + wtnt3_ay_s[1] + wtnt3_ay_s[2];
                            varpos_na = refvarstart - refcdsstart + 1;
                            if (!ref.isEmpty() && !String.valueOf(wtnt3_ay_s[0]).equals(ref)) {
                                unmatch_wtnt_ref.put(index, 1);
                            }
                        }
                        wtaa = SavDBCreate.translateDNA(wtnt3, chr);
                        varaa = SavDBCreate.translateDNA(varnt3, chr);
                        varpos = (int)Math.floor((refvarstart - refcdsstart) / 3) + 1;
                        if (wtaa.equals(varaa)) continue;
                        type = "";
                        id_suffix = "";
                        if (wtaa.equals("*")) {
                            type = "stoploss";
                            id_suffix = "SL";
                        } else if (varaa.equals("*")) {
                            type = "stopgain";
                            id_suffix = "SG";
                        } else {
                            type = "missense";
                            id_suffix = "MS";
                        }
                        proseq = SavDBCreate.translateDNA(refcdsseq, chr);
                        proseq_var = null;
                        try {
                            if (proseq.length() < varpos || wtaa.equals("I") && varaa.equals("L") || wtaa.equals("L") && varaa.equals("I")) continue;
                            if (wtaa.equals("*") && proseq.length() == varpos - 1) {
                                proseq = String.valueOf(proseq) + "*";
                            }
                            if (proseq.substring(varpos - 1, varpos).equals(wtaa) || proseq.substring(varpos - 1, varpos).equals("X")) {
                                StringBuffer proseq_buffer = new StringBuffer(proseq);
                                proseq_buffer.replace(varpos - 1, varpos, varaa);
                                proseq_var = proseq_buffer.toString();
                                break block61;
                            }
                            System.err.println("WARNING: ALLELE MISMATCH:" + seqid + "  user-specified-amino acid=" + wtaa + "  refseq-inferred-amino acid=" + proseq.substring(varpos - 1, varpos) + "\t" + chr + "\t" + pos + "\t" + id + "\t" + ref + "\t" + obs + "\t" + seqid + "\t" + wtaa + "\t" + varpos + "\t" + varaa + "\t" + proseq + '\t' + refcdsseq);
                        }
                        catch (Exception e) {
                            System.err.println("Fatal Error3: " + chr + "\t" + pos + "\t" + id + "\t" + ref + "\t" + obs + "\t" + seqid + "\t" + wtaa + "\t" + varpos + "\t" + varaa + "\t" + proseq + "\t" + refcdsseq);
                        }
                        continue;
                    }
                    if (protease.equals("0")) {
                        int len = proseq_var.length();
                        if (HASXREF) {
                            mapfile.write("VAR" + count + "|" + "1" + "-" + len + "|" + wtaa + varpos + varaa + "|" + id_suffix + "\t" + seqid + "\t" + geneidmap.get(seqid) + "\t" + "1" + "\t" + varpos + "\t" + len + "\t" + wtaa + "\t" + varaa + "\t" + type + "\t" + id + "\t" + chr + "\t" + start + "\t" + varpos_na + "\t" + ref + "\t" + obs + "\t" + refstrand + "\t" + wtnt3 + "\t" + varnt3 + "\t" + mRNA2Prot.get(seqid) + "\t" + mRNA2Sp.get(seqid) + "\t" + mRNA2Desc.get(seqid) + "\n");
                        } else {
                            mapfile.write("VAR" + count + "|" + "1" + "-" + len + "|" + wtaa + varpos + varaa + "|" + id_suffix + "\t" + seqid + "\t" + geneidmap.get(seqid) + "\t" + "1" + "\t" + varpos + "\t" + len + "\t" + wtaa + "\t" + varaa + "\t" + type + "\t" + id + "\t" + chr + "\t" + start + "\t" + varpos_na + "\t" + ref + "\t" + obs + "\t" + refstrand + "\t" + wtnt3 + "\t" + varnt3 + "\n");
                        }
                        savdbfile.write(">VAR" + count + "|" + "1" + "-" + len + "|" + wtaa + varpos + varaa + "|" + id_suffix + "\n" + proseq_var + "\n");
                        revseq.put("VAR" + count + "|" + "1" + "-" + len + "|" + wtaa + varpos + varaa + "|" + id_suffix, new StringBuffer(proseq_var).reverse().toString());
                        ++count;
                        continue;
                    }
                    Pattern pat = null;
                    if (protease.equals("1")) {
                        pat = Pattern.compile("(.*?([KR]|$))");
                    } else if (protease.equals("2")) {
                        pat = Pattern.compile("(.*?([KR]|$)(?!P))");
                    } else if (protease.equals("3")) {
                        pat = Pattern.compile("(.*?([R]|$)(?!P))");
                    } else if (protease.equals("4")) {
                        pat = Pattern.compile("(.*?([K]|$)(?!P))");
                    } else if (protease.equals("5")) {
                        pat = Pattern.compile("(.*?([E]|$))");
                    } else if (protease.equals("6")) {
                        pat = Pattern.compile("(.+?(?=[BD]|$))");
                    } else if (protease.equals("7")) {
                        pat = Pattern.compile("(.*?([FLWY]|$)(?!P))");
                    }
                    try {
                        mat = pat.matcher(proseq_var);
                    }
                    catch (Exception e) {
                        System.err.println("Fatal Error4: " + chr + "\t" + pos + "\t" + id + "\t" + ref + "\t" + obs + "\t" + seqid + "\t" + wtaa + "\t" + varpos + "\t" + varaa + "\t" + proseq + '\t' + refcdsseq);
                        continue;
                    }
                    String pad_bef2 = "";
                    String pad_bef1 = "";
                    String current_pep = "";
                    String pad_af1 = "";
                    String pad_af2 = "";
                    int coord_bef2 = 1;
                    int coord_bef1 = 1;
                    int coord_af1 = proseq_var.length();
                    int coord_af2 = proseq_var.length();
                    while (mat.find()) {
                        int rel_start = mat.start() + 1;
                        int rel_end = mat.end();
                        if (varpos >= rel_start && varpos <= rel_end) {
                            current_pep = mat.group(1);
                            if (mat.find()) {
                                pad_af1 = mat.group(1);
                                coord_af1 = mat.end();
                            }
                            if (!mat.find()) break;
                            pad_af2 = mat.group(1);
                            coord_af2 = mat.end();
                            break;
                        }
                        pad_bef2 = pad_bef1;
                        pad_bef1 = mat.group(1);
                        coord_bef2 = coord_bef1;
                        coord_bef1 = rel_start;
                    }
                    if ((miss_cleavage_seq = String.valueOf(pad_bef2) + pad_bef1 + current_pep + pad_af1 + pad_af2).length() < 5) continue;
                    if (HASXREF) {
                        mapfile.write("VAR" + count + "|" + coord_bef2 + "-" + coord_af2 + "|" + wtaa + varpos + varaa + "|" + id_suffix + "\t" + seqid + "\t" + geneidmap.get(seqid) + "\t" + coord_bef2 + "\t" + varpos + "\t" + coord_af2 + "\t" + wtaa + "\t" + varaa + "\t" + type + "\t" + id + "\t" + chr + "\t" + start + "\t" + varpos_na + "\t" + ref + "\t" + obs + "\t" + refstrand + "\t" + wtnt3 + "\t" + varnt3 + "\t" + mRNA2Prot.get(seqid) + "\t" + mRNA2Sp.get(seqid) + "\t" + mRNA2Desc.get(seqid) + "\n");
                    } else {
                        mapfile.write("VAR" + count + "|" + coord_bef2 + "-" + coord_af2 + "|" + wtaa + varpos + varaa + "|" + id_suffix + "\t" + seqid + "\t" + geneidmap.get(seqid) + "\t" + coord_bef2 + "\t" + varpos + "\t" + coord_af2 + "\t" + wtaa + "\t" + varaa + "\t" + type + "\t" + id + "\t" + chr + "\t" + start + "\t" + varpos_na + "\t" + ref + "\t" + obs + "\t" + refstrand + "\t" + wtnt3 + "\t" + varnt3 + "\n");
                    }
                    savdbfile.write(">VAR" + count + "|" + coord_bef2 + "-" + coord_af2 + "|" + wtaa + varpos + varaa + "|" + id_suffix + "\n" + miss_cleavage_seq + "\n");
                    revseq.put("VAR" + count + "|" + coord_bef2 + "-" + coord_af2 + "|" + wtaa + varpos + varaa + "|" + id_suffix, new StringBuffer(miss_cleavage_seq).reverse().toString());
                    ++count;
                    continue;
                }
                obs.equals("-");
            }
        }
        System.out.println("Done with writing SAV info");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        System.out.println("NOTICE: Current time is " + df.format(new Date()));
    }

    /*
     * WARNING - void declaration
     */
    public static void annotateExonicVariants(String fastafile) throws IOException {
        void var8_10;
        HashMap<Integer, String> varinfo = new HashMap<Integer, String>();
        HashMap<Integer, Integer> unmatch_wtnt_ref = new HashMap<Integer, Integer>();
        HashMap<Integer, Function> function = new HashMap<Integer, Function>();
        SavDBCreate.readSeqFromFASTADB(fastafile);
        for (String seqid : refseqvar.keySet()) {
            ArrayList<Object> varlist = new ArrayList();
            varlist = refseqvar.get(seqid);
            for (VarInfo varInfo : varlist) {
                int fs;
                int end;
                int start;
                String obs;
                String ref;
                String chr;
                String varaa;
                String wtaa;
                String varnt3;
                String wtnt3;
                int exonpos;
                int index;
                String refstrand;
                int refvarstart;
                int refcdsstart;
                block40: {
                    refcdsstart = varInfo.getRCdsStart();
                    refvarstart = varInfo.getRVarStart();
                    int refvarend = varInfo.getRVarEnd();
                    refstrand = varInfo.getDBStrand();
                    index = varInfo.getIndex();
                    int bias = varInfo.getBias();
                    exonpos = varInfo.getExonNum();
                    String line = varInfo.getEntry();
                    wtnt3 = null;
                    varnt3 = null;
                    wtaa = null;
                    varaa = null;
                    int refcdsend = cdslen.get(seqid) + refcdsstart - 1;
                    String[] nextline = line.split("\\s+");
                    chr = nextline[0];
                    int pos = Integer.valueOf(nextline[1]);
                    String id = nextline[2];
                    ref = nextline[3];
                    obs = nextline[4];
                    start = pos;
                    end = pos;
                    ref = ref.toUpperCase();
                    obs = obs.toUpperCase();
                    chr = chr.replaceAll("^chr", "");
                    varinfo.put(index, line);
                    String refcdsseq = seqhash.get(seqid).substring(refcdsstart - 1, refcdsend);
                    if (bias == 1) {
                        --refcdsstart;
                        refcdsseq = "N" + refcdsseq;
                    } else if (bias == 2) {
                        refcdsstart -= 2;
                        refcdsseq = "NN" + refcdsseq;
                    }
                    if (SavDBCreate.getStopCount(SavDBCreate.translateDNA(refcdsseq, chr)) >= 4) {
                        if (SavDBCreate.getStopCount(SavDBCreate.translateDNA("N" + refcdsseq, chr)) < 4) {
                            --refcdsstart;
                            refcdsseq = "N" + refcdsseq;
                        } else if (SavDBCreate.getStopCount(SavDBCreate.translateDNA("NN" + refcdsseq, chr)) < 4) {
                            refcdsstart -= 2;
                            refcdsseq = "NN" + refcdsseq;
                        } else {
                            System.out.println("WARNING:potential wrong annotation:" + seqid);
                        }
                    }
                    if (!seqhash.containsKey(seqid)) {
                        if (function.containsKey(index)) continue;
                        Function funobj = new Function();
                        funobj.setUnknown("UNKNOWN");
                        function.put(index, funobj);
                        continue;
                    }
                    fs = (refvarstart - refcdsstart) % 3;
                    int end_fs = (refvarend - refcdsstart) % 3;
                    if (refvarstart - fs - 1 > seqhash.get(seqid).length()) {
                        System.err.println("WARNING: Potential database annotation error seqid=" + seqid + ", refvarstart=" + refvarstart + ", fs=" + fs + ", seqlength=" + seqhash.get(seqid).length() + " refcdsstart=" + refcdsstart + ", with inputline=" + line);
                        continue;
                    }
                    try {
                        Function funobj;
                        if (refvarstart - fs - 1 < 0) {
                            funobj = new Function();
                            funobj.setUnknown("UNKNOWN");
                            function.put(index, funobj);
                            continue;
                        }
                        if (seqhash.get(seqid).substring(refvarstart - fs - 1).length() >= 3 && refvarstart - fs - 1 > 0) {
                            wtnt3 = seqhash.get(seqid).substring(refvarstart - fs - 1, refvarstart - fs - 1 + 3);
                            break block40;
                        }
                        if (function.containsKey(index)) continue;
                        funobj = new Function();
                        funobj.setUnknown("UNKNOWN");
                        function.put(index, funobj);
                    }
                    catch (Exception e) {
                        System.err.println("Fatal Error1: " + chr + "\t" + pos + "\t" + id + "\t" + ref + "\t" + obs + "\t" + seqid + "\t" + pos + "\t" + refvarstart + '\t' + fs + "\t" + seqhash.get(seqid));
                    }
                    continue;
                }
                char[] wtnt3_ay_c = wtnt3.toCharArray();
                String[] wtnt3_ay_s = new String[3];
                int i = 0;
                while (i < wtnt3_ay_c.length) {
                    wtnt3_ay_s[i] = String.valueOf(wtnt3_ay_c[i]);
                    ++i;
                }
                if (refstrand.equals("-")) {
                    obs = SavDBCreate.revcom(obs);
                    ref = SavDBCreate.revcom(ref);
                }
                if (start == end) {
                    Function newfunobj;
                    String canno;
                    if (ref.equals("-") || obs.equals("-") || obs.length() > 1) continue;
                    if (fs == 1) {
                        varnt3 = String.valueOf(wtnt3_ay_s[0]) + obs + wtnt3_ay_s[2];
                        canno = "c." + wtnt3_ay_s[1] + (refvarstart - refcdsstart + 1) + obs + ":" + wtnt3 + "=>" + varnt3;
                        if (!ref.isEmpty() && !String.valueOf(wtnt3_ay_s[1]).equals(ref)) {
                            unmatch_wtnt_ref.put(index, 1);
                        }
                    } else if (fs == 2) {
                        varnt3 = String.valueOf(wtnt3_ay_s[0]) + wtnt3_ay_s[1] + obs;
                        canno = "c." + wtnt3_ay_s[2] + (refvarstart - refcdsstart + 1) + obs + ":" + wtnt3 + "=>" + varnt3;
                        if (!ref.isEmpty() && !String.valueOf(wtnt3_ay_s[2]).equals(ref)) {
                            unmatch_wtnt_ref.put(index, 1);
                        }
                    } else {
                        varnt3 = String.valueOf(obs) + wtnt3_ay_s[1] + wtnt3_ay_s[2];
                        canno = "c." + wtnt3_ay_s[0] + (refvarstart - refcdsstart + 1) + obs + ":" + wtnt3 + "=>" + varnt3;
                        if (!ref.isEmpty() && !String.valueOf(wtnt3_ay_s[0]).equals(ref)) {
                            unmatch_wtnt_ref.put(index, 1);
                        }
                    }
                    wtaa = SavDBCreate.translateDNA(wtnt3, chr);
                    varaa = SavDBCreate.translateDNA(varnt3, chr);
                    int varpos = (int)Math.floor((refvarstart - refcdsstart) / 3) + 1;
                    if (wtaa.equals(varaa)) {
                        if (wtaa.equals(Character.valueOf('*'))) {
                            wtaa = "X";
                            varaa = "X";
                        }
                        if (function.containsKey(index) && (((Function)function.get(index)).getNssnv() != null || ((Function)function.get(index)).getStoploss() != null || ((Function)function.get(index)).getStopgain() != null)) continue;
                        if (function.containsKey(index) && ((Function)function.get(index)).getSsnv() != null) {
                            Function oldfunobj = (Function)function.get(index);
                            newfunobj = new Function();
                            newfunobj.setSsnv(String.valueOf(oldfunobj.getSsnv()) + "," + geneidmap.get(seqid) + ":" + seqid + ":exon" + exonpos + ":" + canno + ":p." + wtaa + varpos + varaa);
                            function.put(index, newfunobj);
                            continue;
                        }
                        Function funobj = new Function();
                        funobj.setSsnv(String.valueOf(geneidmap.get(seqid)) + ":" + seqid + ":exon" + exonpos + ":" + canno + ":p." + wtaa + varpos + varaa);
                        function.put(index, funobj);
                        continue;
                    }
                    if (function.containsKey(index) && (((Function)function.get(index)).getStoploss() != null || ((Function)function.get(index)).getStopgain() != null)) continue;
                    if (function.containsKey(index) && ((Function)function.get(index)).getNssnv() != null) {
                        Function oldfunobj = (Function)function.get(index);
                        newfunobj = new Function();
                        newfunobj.setNssnv(String.valueOf(oldfunobj.getNssnv()) + "," + geneidmap.get(seqid) + ":" + seqid + ":exon" + exonpos + ":" + canno + ":p." + wtaa + varpos + varaa);
                        function.put(index, newfunobj);
                        continue;
                    }
                    Function funobj = new Function();
                    funobj.setNssnv(String.valueOf(geneidmap.get(seqid)) + ":" + seqid + ":exon" + exonpos + ":" + canno + ":p." + wtaa + varpos + varaa);
                    function.put(index, funobj);
                    continue;
                }
                obs.equals("-");
            }
        }
        BufferedWriter exonicFout = new BufferedWriter(new FileWriter(new File(String.valueOf(outfile) + ".exonic_variant_function")));
        Object[] key_arr = function.keySet().toArray();
        Arrays.sort(key_arr);
        Object[] objectArray = key_arr;
        int n = key_arr.length;
        boolean n2 = false;
        while (var8_10 < n) {
            Object key = objectArray[var8_10];
            int index = (Integer)key;
            int lineindex = index + (batchcount - 1) * 200000;
            exonicFout.write("line" + lineindex + "\t");
            Function funobj = (Function)function.get(index);
            if (funobj.getStopgain() != null) {
                exonicFout.write("stopgain SNV\t" + funobj.getStopgain() + "\t");
            } else if (funobj.getStoploss() != null) {
                exonicFout.write("stoploss SNV\t" + funobj.getStoploss() + "\t");
            } else if (funobj.getNssnv() != null) {
                exonicFout.write("nonsynonymous SNV\t" + funobj.getNssnv() + "\t");
            } else if (funobj.getSsnv() != null) {
                exonicFout.write("synonymous SNV\t" + funobj.getSsnv() + "\t");
            } else if (funobj.getUnknown() != null) {
                exonicFout.write("unknown\t" + funobj.getUnknown() + "\t");
            }
            exonicFout.write(String.valueOf((String)varinfo.get(index)) + "\n");
            ++var8_10;
        }
        exonicFout.close();
    }

    public static void readSeqFromFASTADB(String fastafile) throws IOException {
        String line;
        BufferedReader seqFin = new BufferedReader(new FileReader(fastafile));
        System.out.println("NOTICE: Reading FASTA sequences from " + fastafile + " ... ");
        String seqid = "";
        String curseq = "";
        HashMap<String, Integer> badorf = new HashMap<String, Integer>();
        int orfwarning = 0;
        Pattern pattern = Pattern.compile("^>.*(NM_\\d+|ENST\\d+)");
        while ((line = seqFin.readLine()) != null) {
            Matcher matcher = pattern.matcher(line);
            if (matcher.find()) {
                if (coding_mRNA.containsKey(seqid)) {
                    if (seqhash.containsKey(seqid)) {
                        if (orfwarning == 0 && badorf.containsKey(seqid)) {
                            seqhash.put(seqid, curseq);
                            badorf.put(seqid, 0);
                        }
                    } else {
                        seqhash.put(seqid, curseq);
                    }
                }
                seqid = matcher.group(1);
                curseq = "";
                Pattern pat1 = Pattern.compile("does not have correct ORF annotation");
                Matcher mat1 = pat1.matcher(line);
                if (mat1.find()) {
                    ++orfwarning;
                    if (badorf.containsKey(seqid)) {
                        badorf.put(seqid, (Integer)badorf.get(seqid) + 1);
                        continue;
                    }
                    badorf.put(seqid, 1);
                    continue;
                }
                orfwarning = 0;
                continue;
            }
            if (!coding_mRNA.containsKey(seqid)) continue;
            curseq = String.valueOf(curseq) + line.toUpperCase();
        }
        if (coding_mRNA.containsKey(seqid)) {
            if (seqhash.containsKey(seqid)) {
                if (orfwarning == 0 && badorf.containsKey(seqid)) {
                    seqhash.put(seqid, curseq);
                    badorf.put(seqid, 0);
                }
            } else {
                seqhash.put(seqid, curseq);
            }
        }
        seqFin.close();
        System.out.println("Done with reading " + seqhash.keySet().size() + " mRNA sequences(includes coding and non-coding)");
        if (seqhash.keySet().size() < refseqvar.keySet().size()) {
            ArrayList<String> seqnotfound = new ArrayList<String>();
            ArrayList seqnotfound_example = new ArrayList();
            for (String key : refseqvar.keySet()) {
                if (!seqid.contains(key)) {
                    seqnotfound.add(key);
                }
                System.out.println("WARNING: A total of " + seqnotfound.size() + " sequences cannot be found in " + fastafile);
            }
        }
        if (!badorf.isEmpty()) {
            System.out.println("WARNING: A total of " + badorf.keySet().size() + " sequences will be ignored due to lack of correct ORF annotation");
            Iterator iter = badorf.keySet().iterator();
            while (iter.hasNext()) {
                seqhash.remove(iter.next());
            }
        }
    }

    public static String revcom(String seq) {
        String revseq = new StringBuffer(seq).reverse().toString();
        char[] revseq_ay = revseq.toCharArray();
        int i = 0;
        while (i < revseq_ay.length) {
            if (revseq_ay[i] == 'A') {
                revseq_ay[i] = 84;
            } else if (revseq_ay[i] == 'T') {
                revseq_ay[i] = 65;
            } else if (revseq_ay[i] == 'C') {
                revseq_ay[i] = 71;
            } else if (revseq_ay[i] == 'G') {
                revseq_ay[i] = 67;
            } else if (revseq_ay[i] == 'a') {
                revseq_ay[i] = 116;
            } else if (revseq_ay[i] == 't') {
                revseq_ay[i] = 97;
            } else if (revseq_ay[i] == 'c') {
                revseq_ay[i] = 103;
            } else if (revseq_ay[i] == 'g') {
                revseq_ay[i] = 99;
            }
            ++i;
        }
        revseq = new String(revseq_ay);
        return revseq;
    }

    public static String translateDNA(String seq, String chr1) {
        seq = seq.toUpperCase();
        Pattern pat = Pattern.compile("([ACGTNacgt]{3})");
        Matcher mat = pat.matcher(seq);
        String protein = "";
        while (mat.find()) {
            String c = mat.group(1);
            if (chr1.toUpperCase().equals("M") || chr1.toUpperCase().equals("MT")) {
                if (codonm.containsKey(c)) {
                    protein = String.valueOf(protein) + codonm.get(c);
                    continue;
                }
                protein = String.valueOf(protein) + "X";
                continue;
            }
            protein = codon.containsKey(c) ? String.valueOf(protein) + codon.get(c) : String.valueOf(protein) + "X";
        }
        return protein;
    }

    public static int getStopCount(String seq) {
        Pattern pat = Pattern.compile("\\*");
        Matcher mat = pat.matcher(seq);
        int stop_count = 0;
        while (mat.find()) {
            ++stop_count;
        }
        return stop_count;
    }

    public static void getAllRefSeqPro(String fastafile, BufferedWriter savdbfile) throws IOException {
        Iterator<String> iter = newgenedb.keySet().iterator();
        HashMap<String, Integer> unique = new HashMap<String, Integer>();
        while (iter.hasNext()) {
            String key = iter.next();
            ArrayList<Object> geneobj = new ArrayList();
            geneobj = newgenedb.get(key);
            for (GeneInfo geneInfo : geneobj) {
                String name = geneInfo.getName();
                String chr = geneInfo.getChr();
                String strand = geneInfo.getDBStrand();
                int cdsstart = geneInfo.getCdsStart();
                int cdsend = geneInfo.getCdsEnd();
                int txstart = geneInfo.getTxStart();
                int txend = geneInfo.getTxEnd();
                int[] exonstart_ay_i = geneInfo.getExonStart();
                int[] exonend_ay_i = geneInfo.getExonEnd();
                String name2 = geneInfo.getName2();
                String exonframes = geneInfo.getExonFrame();
                String[] exonframes_ay_s = exonframes.split(",");
                if (cdsstart == cdsend + 1 || unique.containsKey(name)) continue;
                unique.put(name, 1);
                int lenintron = 0;
                int lenexon = 0;
                int rcdsstart = -1;
                int rcdsend = -1;
                int bias = 0;
                if (strand.equals("+")) {
                    int k = 0;
                    while (k < exonstart_ay_i.length) {
                        if (k > 0) {
                            lenintron += exonstart_ay_i[k] - exonend_ay_i[k - 1] - 1;
                        }
                        lenexon += exonend_ay_i[k] - exonstart_ay_i[k] + 1;
                        if (cdsstart >= exonstart_ay_i[k]) {
                            rcdsstart = cdsstart - txstart - lenintron + 1;
                            if (cdsstart <= exonend_ay_i[k]) {
                                lenexon = exonend_ay_i[k] - cdsstart + 1;
                            }
                        }
                        ++k;
                    }
                    rcdsend = cdslen.get(name) + rcdsstart - 1;
                    bias = Integer.valueOf(exonframes_ay_s[0]);
                } else if (strand.equals("-")) {
                    int k = exonstart_ay_i.length - 1;
                    while (k >= 0) {
                        if (k < exonstart_ay_i.length - 1) {
                            lenintron += exonstart_ay_i[k + 1] - exonend_ay_i[k] - 1;
                        }
                        lenexon += exonend_ay_i[k] - exonstart_ay_i[k] + 1;
                        if (cdsend <= exonend_ay_i[k]) {
                            rcdsstart = txend - cdsend - lenintron + 1;
                            if (cdsend >= exonstart_ay_i[k]) {
                                lenexon = cdsend - exonstart_ay_i[k] + 1;
                            }
                        }
                        --k;
                    }
                    rcdsend = cdslen.get(name) + rcdsstart - 1;
                    bias = Integer.valueOf(exonframes_ay_s[exonframes_ay_s.length - 1]);
                }
                String refcdsseq = seqhash.get(name).substring(rcdsstart - 1, rcdsend);
                if (bias == 1) {
                    --rcdsstart;
                    refcdsseq = "N" + refcdsseq;
                } else if (bias == 2) {
                    rcdsstart -= 2;
                    refcdsseq = "NN" + refcdsseq;
                }
                if (SavDBCreate.getStopCount(SavDBCreate.translateDNA(refcdsseq, chr)) >= 4) {
                    if (SavDBCreate.getStopCount(SavDBCreate.translateDNA("N" + refcdsseq, chr)) < 4) {
                        --rcdsstart;
                        refcdsseq = "N" + refcdsseq;
                    } else if (SavDBCreate.getStopCount(SavDBCreate.translateDNA("NN" + refcdsseq, chr)) < 4) {
                        rcdsstart -= 2;
                        refcdsseq = "NN" + refcdsseq;
                    }
                }
                String proseq = SavDBCreate.translateDNA(refcdsseq, chr);
                savdbfile.write(">" + name + "\n" + proseq + "\n");
                revseq.put(name, new StringBuffer(proseq).reverse().toString());
            }
        }
    }

    public static void readXref(String file) throws IOException {
        String line;
        LineNumberReader genedbFin = new LineNumberReader(new FileReader(file));
        int ensMrna_i = -1;
        int ensProt_i = -1;
        int desc_i = -1;
        int refMrna_i = -1;
        int refProt_i = -1;
        int sp_i = -1;
        while ((line = genedbFin.readLine()) != null) {
            String[] record = line.split("\t", -1);
            if (genedbFin.getLineNumber() == 1) {
                int i = 0;
                while (i < record.length) {
                    if (record[i].startsWith("Ensembl Transcript ID")) {
                        ensMrna_i = i;
                    } else if (record[i].startsWith("Ensembl Protein ID")) {
                        ensProt_i = i;
                    } else if (record[i].startsWith("Description")) {
                        desc_i = i;
                    } else if (record[i].startsWith("RefSeq mRNA")) {
                        refMrna_i = i;
                    } else if (record[i].startsWith("RefSeq Protein")) {
                        refProt_i = i;
                    } else if (record[i].startsWith("UniProt/SwissProt")) {
                        sp_i = i;
                    }
                    ++i;
                }
            }
            String ensMrna = "NULL";
            String ensProt = "NULL";
            String refMrna = "NULL";
            String refProt = "NULL";
            String desc = "NULL";
            String spID = "NULL";
            if (ensMrna_i > -1) {
                ensMrna = record[ensMrna_i].isEmpty() ? "NULL" : record[ensMrna_i];
            }
            if (ensProt_i > -1) {
                ensProt = record[ensProt_i].isEmpty() ? "NULL" : record[ensProt_i];
            }
            if (refMrna_i > -1) {
                refMrna = record[refMrna_i].isEmpty() ? "NULL" : record[refMrna_i];
            }
            if (refProt_i > -1) {
                refProt = record[refProt_i].isEmpty() ? "NULL" : record[refProt_i];
            }
            if (desc_i > -1) {
                desc = record[desc_i].isEmpty() ? "NULL" : record[desc_i];
            }
            if (sp_i > -1) {
                spID = record[sp_i].isEmpty() ? "NULL" : record[sp_i];
            }
            if (SOURCE == 0) {
                mRNA2Prot.put(refMrna, refProt);
                mRNA2Desc.put(refMrna, desc);
                mRNA2Sp.put(refMrna, spID);
                continue;
            }
            if (SOURCE != 1) continue;
            mRNA2Prot.put(ensMrna, ensProt);
            mRNA2Desc.put(ensMrna, desc);
            mRNA2Sp.put(ensMrna, spID);
        }
    }
}

