/*
 * Decompiled with CFR 0.152.
 */
package de.proteinms.xtandemparser.viewer;

import de.proteinms.xtandemparser.viewer.BareBonesBrowserLaunch;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jdesktop.layout.GroupLayout;

public class HelpFrame
extends JFrame {
    private JEditorPane editorPane;
    private URL iUrl;
    private JButton closeButton;
    private JScrollPane scrollPane;

    public HelpFrame(JFrame parent, URL aUrl) {
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/xtandemviewer.gif")));
        this.setTitle("X!Tandem Viewer --- Help");
        this.setDefaultCloseOperation(2);
        this.editorPane = new JEditorPane();
        this.editorPane.setEditable(false);
        this.editorPane.setContentType("text/html");
        this.closeButton = new JButton();
        this.scrollPane = new JScrollPane();
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HelpFrame.this.close();
            }
        });
        this.editorPane.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.editorPane.setContentType("text/html");
        this.editorPane.setEditable(false);
        this.editorPane.setMinimumSize(new Dimension(10, 10));
        this.editorPane.setPreferredSize(new Dimension(10, 10));
        this.editorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
                HelpFrame.this.editorPaneHyperlinkUpdate(evt);
            }
        });
        this.scrollPane.setViewportView(this.editorPane);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.scrollPane, -1, 235, Short.MAX_VALUE).add((Component)this.closeButton)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.scrollPane, -1, 494, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.closeButton).addContainerGap()));
        this.pack();
        try {
            this.iUrl = aUrl;
            if (this.iUrl != null) {
                try {
                    this.editorPane.setPage(this.iUrl);
                }
                catch (IOException e) {
                    this.editorPane.setText("The selected help file is not yet available.");
                }
            } else {
                this.editorPane.setText("The selected help file is not yet available.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.editorPane.setCaretPosition(0);
        this.setSize(550, 500);
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private void close() {
        this.dispose();
    }

    private void editorPaneHyperlinkUpdate(HyperlinkEvent evt) {
        if (evt.getEventType().toString().equalsIgnoreCase(HyperlinkEvent.EventType.ENTERED.toString())) {
            this.setCursor(new Cursor(12));
        } else if (evt.getEventType().toString().equalsIgnoreCase(HyperlinkEvent.EventType.EXITED.toString())) {
            this.setCursor(new Cursor(0));
        } else if (evt.getEventType().toString().equalsIgnoreCase(HyperlinkEvent.EventType.ACTIVATED.toString())) {
            if (evt.getDescription().startsWith("#")) {
                this.editorPane.scrollToReference(evt.getDescription());
            } else {
                this.setCursor(new Cursor(3));
                BareBonesBrowserLaunch.openURL(evt.getDescription());
                this.setCursor(new Cursor(0));
            }
        }
    }
}

