/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.protein;

import com.compomics.util.Util;
import com.compomics.util.preferences.UtilitiesUserPreferences;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class AdvancedProteinDatabaseDialog
extends JDialog {
    private File dbFolder;
    private JPanel backgroundPanel;
    private JButton browseDatabaseFolderButton;
    private JButton cancelButton;
    private JButton clearDatabaseFolderButton;
    private JTextField databasesFolderTxt;
    private JPanel folderPanel;
    private JButton okButton;

    public AdvancedProteinDatabaseDialog(Frame parent) {
        super(parent, true);
        this.initComponents();
        this.initGUI();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private void initGUI() {
        UtilitiesUserPreferences userPreferences = UtilitiesUserPreferences.loadUserPreferences();
        this.dbFolder = userPreferences.getProteinTreeFolder();
        this.updateText();
    }

    private void updateText() {
        if (this.dbFolder != null) {
            this.databasesFolderTxt.setText(this.dbFolder.getAbsolutePath());
        }
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.folderPanel = new JPanel();
        this.clearDatabaseFolderButton = new JButton();
        this.browseDatabaseFolderButton = new JButton();
        this.databasesFolderTxt = new JTextField();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Database Details");
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.folderPanel.setBorder(BorderFactory.createTitledBorder("Databases Folder"));
        this.folderPanel.setOpaque(false);
        this.clearDatabaseFolderButton.setText("Clear");
        this.clearDatabaseFolderButton.setPreferredSize(new Dimension(75, 25));
        this.clearDatabaseFolderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedProteinDatabaseDialog.this.clearDatabaseFolderButtonActionPerformed(evt);
            }
        });
        this.browseDatabaseFolderButton.setText("Browse");
        this.browseDatabaseFolderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedProteinDatabaseDialog.this.browseDatabaseFolderButtonActionPerformed(evt);
            }
        });
        this.databasesFolderTxt.setEditable(false);
        GroupLayout folderPanelLayout = new GroupLayout(this.folderPanel);
        this.folderPanel.setLayout(folderPanelLayout);
        folderPanelLayout.setHorizontalGroup(folderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, folderPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.databasesFolderTxt, -1, 432, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseDatabaseFolderButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearDatabaseFolderButton, -2, -1, -2).addContainerGap()));
        folderPanelLayout.linkSize(0, this.browseDatabaseFolderButton, this.clearDatabaseFolderButton);
        folderPanelLayout.setVerticalGroup(folderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(folderPanelLayout.createSequentialGroup().addContainerGap().addGroup(folderPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.clearDatabaseFolderButton, -2, -1, -2).addComponent(this.browseDatabaseFolderButton).addComponent(this.databasesFolderTxt, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        folderPanelLayout.linkSize(1, this.browseDatabaseFolderButton, this.clearDatabaseFolderButton);
        this.okButton.setText("OK");
        this.okButton.setPreferredSize(new Dimension(75, 25));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedProteinDatabaseDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.setPreferredSize(new Dimension(75, 25));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedProteinDatabaseDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.folderPanel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton, -2, -1, -2).addGap(8, 8, 8).addComponent(this.cancelButton, -2, -1, -2))).addContainerGap()));
        backgroundPanelLayout.linkSize(0, this.cancelButton, this.okButton);
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.folderPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton, -2, -1, -2).addComponent(this.cancelButton, -2, -1, -2)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        UtilitiesUserPreferences userPreferences = UtilitiesUserPreferences.loadUserPreferences();
        userPreferences.setProteinTreeFolder(this.dbFolder);
        UtilitiesUserPreferences.saveUserPreferences(userPreferences);
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void browseDatabaseFolderButtonActionPerformed(ActionEvent evt) {
        this.dbFolder = Util.getUserSelectedFolder(this, "Please select new folder", this.dbFolder.getAbsolutePath(), "Databases Folder", "OK", false);
        this.updateText();
    }

    private void clearDatabaseFolderButtonActionPerformed(ActionEvent evt) {
        int outcome = JOptionPane.showConfirmDialog(this, "This operation cannot be undone, continue?", "Warning", 2);
        if (outcome == 0) {
            ArrayList<String> notDeleted = new ArrayList<String>();
            for (File file : this.dbFolder.listFiles()) {
                boolean success = false;
                try {
                    success = Util.deleteDir(file);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (success) continue;
                notDeleted.add(file.getName());
            }
            if (!notDeleted.isEmpty()) {
                String report = "An error occurred when deleting ";
                boolean first = true;
                for (String name : notDeleted) {
                    if (first) {
                        first = false;
                    } else {
                        report = report + ", ";
                    }
                    report = report + name;
                }
                JOptionPane.showMessageDialog(this, report, "Error when emptying folder", 2);
            }
        }
    }
}

